<?php

/**
 * WritableDialerContact
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * WritableDialerContact Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class WritableDialerContact implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'WritableDialerContact';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'contactListId' => 'string',
        'data' => 'map[string,object]',
        'callable' => 'bool',
        'phoneNumberStatus' => 'map[string,\PureCloudSDK\PhoneNumberStatus]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'contactListId' => 'contactListId',
        'data' => 'data',
        'callable' => 'callable',
        'phoneNumberStatus' => 'phoneNumberStatus'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'contactListId' => 'setContactListId',
        'data' => 'setData',
        'callable' => 'setCallable',
        'phoneNumberStatus' => 'setPhoneNumberStatus'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'contactListId' => 'getContactListId',
        'data' => 'getData',
        'callable' => 'getCallable',
        'phoneNumberStatus' => 'getPhoneNumberStatus'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['contactListId'] = isset($data['contactListId']) ? $data['contactListId'] : null;
        $this->container['data'] = isset($data['data']) ? $data['data'] : null;
        $this->container['callable'] = isset($data['callable']) ? $data['callable'] : null;
        $this->container['phoneNumberStatus'] = isset($data['phoneNumberStatus']) ? $data['phoneNumberStatus'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['contactListId'] === null) {
            $invalid_properties[] = "'contactListId' can't be null";
        }
        if ($this->container['data'] === null) {
            $invalid_properties[] = "'data' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['contactListId'] === null) {
            return false;
        }
        if ($this->container['data'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets contactListId
     * @return string
     */
    public function getContactListId()
    {
        return $this->container['contactListId'];
    }

    /**
     * Sets contactListId
     * @param string $contactListId The identifier of the contact list containing this contact.
     * @return $this
     */
    public function setContactListId($contactListId)
    {
        $this->container['contactListId'] = $contactListId;

        return $this;
    }

    /**
     * Gets data
     * @return map[string,object]
     */
    public function getData()
    {
        return $this->container['data'];
    }

    /**
     * Sets data
     * @param map[string,object] $data An ordered map of the contact's columns and corresponding values.
     * @return $this
     */
    public function setData($data)
    {
        $this->container['data'] = $data;

        return $this;
    }

    /**
     * Gets callable
     * @return bool
     */
    public function getCallable()
    {
        return $this->container['callable'];
    }

    /**
     * Sets callable
     * @param bool $callable Indicates whether or not the contact can be called.
     * @return $this
     */
    public function setCallable($callable)
    {
        $this->container['callable'] = $callable;

        return $this;
    }

    /**
     * Gets phoneNumberStatus
     * @return map[string,\PureCloudSDK\PhoneNumberStatus]
     */
    public function getPhoneNumberStatus()
    {
        return $this->container['phoneNumberStatus'];
    }

    /**
     * Sets phoneNumberStatus
     * @param map[string,\PureCloudSDK\PhoneNumberStatus] $phoneNumberStatus A map of phone number columns to PhoneNumberStatuses, which indicate if the phone number is callable or not.
     * @return $this
     */
    public function setPhoneNumberStatus($phoneNumberStatus)
    {
        $this->container['phoneNumberStatus'] = $phoneNumberStatus;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


