<?php

/**
 * ActionOutput
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ActionOutput Class Doc Comment
 *
 * @category    Class */
 // @description Output definition of Action.
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ActionOutput implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ActionOutput';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'successSchema' => '\PureCloudSDK\JsonSchemaDocument',
        'successSchemaUri' => 'string',
        'errorSchema' => '\PureCloudSDK\JsonSchemaDocument',
        'errorSchemaUri' => 'string',
        'successSchemaFlattened' => '\PureCloudSDK\JsonSchemaDocument',
        'errorSchemaFlattened' => 'object'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'successSchema' => 'successSchema',
        'successSchemaUri' => 'successSchemaUri',
        'errorSchema' => 'errorSchema',
        'errorSchemaUri' => 'errorSchemaUri',
        'successSchemaFlattened' => 'successSchemaFlattened',
        'errorSchemaFlattened' => 'errorSchemaFlattened'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'successSchema' => 'setSuccessSchema',
        'successSchemaUri' => 'setSuccessSchemaUri',
        'errorSchema' => 'setErrorSchema',
        'errorSchemaUri' => 'setErrorSchemaUri',
        'successSchemaFlattened' => 'setSuccessSchemaFlattened',
        'errorSchemaFlattened' => 'setErrorSchemaFlattened'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'successSchema' => 'getSuccessSchema',
        'successSchemaUri' => 'getSuccessSchemaUri',
        'errorSchema' => 'getErrorSchema',
        'errorSchemaUri' => 'getErrorSchemaUri',
        'successSchemaFlattened' => 'getSuccessSchemaFlattened',
        'errorSchemaFlattened' => 'getErrorSchemaFlattened'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['successSchema'] = isset($data['successSchema']) ? $data['successSchema'] : null;
        $this->container['successSchemaUri'] = isset($data['successSchemaUri']) ? $data['successSchemaUri'] : null;
        $this->container['errorSchema'] = isset($data['errorSchema']) ? $data['errorSchema'] : null;
        $this->container['errorSchemaUri'] = isset($data['errorSchemaUri']) ? $data['errorSchemaUri'] : null;
        $this->container['successSchemaFlattened'] = isset($data['successSchemaFlattened']) ? $data['successSchemaFlattened'] : null;
        $this->container['errorSchemaFlattened'] = isset($data['errorSchemaFlattened']) ? $data['errorSchemaFlattened'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets successSchema
     * @return \PureCloudSDK\JsonSchemaDocument
     */
    public function getSuccessSchema()
    {
        return $this->container['successSchema'];
    }

    /**
     * Sets successSchema
     * @param \PureCloudSDK\JsonSchemaDocument $successSchema JSON schema that defines the transformed, successful result that will be sent back to the caller. If the 'flatten' query parameter is omitted or false, this field will be returned. Either successSchema or successSchemaFlattened will be returned, not both.
     * @return $this
     */
    public function setSuccessSchema($successSchema)
    {
        $this->container['successSchema'] = $successSchema;

        return $this;
    }

    /**
     * Gets successSchemaUri
     * @return string
     */
    public function getSuccessSchemaUri()
    {
        return $this->container['successSchemaUri'];
    }

    /**
     * Sets successSchemaUri
     * @param string $successSchemaUri URI to retrieve success schema
     * @return $this
     */
    public function setSuccessSchemaUri($successSchemaUri)
    {
        $this->container['successSchemaUri'] = $successSchemaUri;

        return $this;
    }

    /**
     * Gets errorSchema
     * @return \PureCloudSDK\JsonSchemaDocument
     */
    public function getErrorSchema()
    {
        return $this->container['errorSchema'];
    }

    /**
     * Sets errorSchema
     * @param \PureCloudSDK\JsonSchemaDocument $errorSchema JSON schema that defines the body of response when request is not successful. If the 'flatten' query parameter is omitted or false, this field will be returned. Either errorSchema or errorSchemaFlattened will be returned, not both.
     * @return $this
     */
    public function setErrorSchema($errorSchema)
    {
        $this->container['errorSchema'] = $errorSchema;

        return $this;
    }

    /**
     * Gets errorSchemaUri
     * @return string
     */
    public function getErrorSchemaUri()
    {
        return $this->container['errorSchemaUri'];
    }

    /**
     * Sets errorSchemaUri
     * @param string $errorSchemaUri URI to retrieve error schema
     * @return $this
     */
    public function setErrorSchemaUri($errorSchemaUri)
    {
        $this->container['errorSchemaUri'] = $errorSchemaUri;

        return $this;
    }

    /**
     * Gets successSchemaFlattened
     * @return \PureCloudSDK\JsonSchemaDocument
     */
    public function getSuccessSchemaFlattened()
    {
        return $this->container['successSchemaFlattened'];
    }

    /**
     * Sets successSchemaFlattened
     * @param \PureCloudSDK\JsonSchemaDocument $successSchemaFlattened JSON schema that defines the transformed, successful result that will be sent back to the caller. The schema is transformed based on Architect's flattened format. If the 'flatten' query parameter is supplied as true, this field will be returned. Either successSchema or successSchemaFlattened will be returned, not both.
     * @return $this
     */
    public function setSuccessSchemaFlattened($successSchemaFlattened)
    {
        $this->container['successSchemaFlattened'] = $successSchemaFlattened;

        return $this;
    }

    /**
     * Gets errorSchemaFlattened
     * @return object
     */
    public function getErrorSchemaFlattened()
    {
        return $this->container['errorSchemaFlattened'];
    }

    /**
     * Sets errorSchemaFlattened
     * @param object $errorSchemaFlattened JSON schema that defines the body of response when request is not successful. The schema is transformed based on Architect's flattened format. If the 'flatten' query parameter is supplied as true, this field will be returned. Either errorSchema or errorSchemaFlattened will be returned, not both.
     * @return $this
     */
    public function setErrorSchemaFlattened($errorSchemaFlattened)
    {
        $this->container['errorSchemaFlattened'] = $errorSchemaFlattened;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
