<?php

/**
 * CoachingAppointmentResponse
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * CoachingAppointmentResponse Class Doc Comment
 *
 * @category    Class */
 // @description Coaching appointment response
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CoachingAppointmentResponse implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CoachingAppointmentResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'description' => 'string',
        'dateStart' => '\DateTime',
        'lengthInMinutes' => 'int',
        'status' => 'string',
        'facilitator' => '\PureCloudSDK\UserReference',
        'attendees' => '\PureCloudSDK\UserReference[]',
        'createdBy' => '\PureCloudSDK\UserReference',
        'dateCreated' => '\DateTime',
        'modifiedBy' => '\PureCloudSDK\UserReference',
        'dateModified' => '\DateTime',
        'conversations' => '\PureCloudSDK\ConversationReference[]',
        'documents' => '\PureCloudSDK\DocumentReference[]',
        'isOverdue' => 'bool',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'description' => 'description',
        'dateStart' => 'dateStart',
        'lengthInMinutes' => 'lengthInMinutes',
        'status' => 'status',
        'facilitator' => 'facilitator',
        'attendees' => 'attendees',
        'createdBy' => 'createdBy',
        'dateCreated' => 'dateCreated',
        'modifiedBy' => 'modifiedBy',
        'dateModified' => 'dateModified',
        'conversations' => 'conversations',
        'documents' => 'documents',
        'isOverdue' => 'isOverdue',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'description' => 'setDescription',
        'dateStart' => 'setDateStart',
        'lengthInMinutes' => 'setLengthInMinutes',
        'status' => 'setStatus',
        'facilitator' => 'setFacilitator',
        'attendees' => 'setAttendees',
        'createdBy' => 'setCreatedBy',
        'dateCreated' => 'setDateCreated',
        'modifiedBy' => 'setModifiedBy',
        'dateModified' => 'setDateModified',
        'conversations' => 'setConversations',
        'documents' => 'setDocuments',
        'isOverdue' => 'setIsOverdue',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'description' => 'getDescription',
        'dateStart' => 'getDateStart',
        'lengthInMinutes' => 'getLengthInMinutes',
        'status' => 'getStatus',
        'facilitator' => 'getFacilitator',
        'attendees' => 'getAttendees',
        'createdBy' => 'getCreatedBy',
        'dateCreated' => 'getDateCreated',
        'modifiedBy' => 'getModifiedBy',
        'dateModified' => 'getDateModified',
        'conversations' => 'getConversations',
        'documents' => 'getDocuments',
        'isOverdue' => 'getIsOverdue',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const STATUS_SCHEDULED = 'Scheduled';
    public const STATUS_IN_PROGRESS = 'InProgress';
    public const STATUS_COMPLETED = 'Completed';
    public const STATUS_INVALID_SCHEDULE = 'InvalidSchedule';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_SCHEDULED,
            self::STATUS_IN_PROGRESS,
            self::STATUS_COMPLETED,
            self::STATUS_INVALID_SCHEDULE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['dateStart'] = isset($data['dateStart']) ? $data['dateStart'] : null;
        $this->container['lengthInMinutes'] = isset($data['lengthInMinutes']) ? $data['lengthInMinutes'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['facilitator'] = isset($data['facilitator']) ? $data['facilitator'] : null;
        $this->container['attendees'] = isset($data['attendees']) ? $data['attendees'] : null;
        $this->container['createdBy'] = isset($data['createdBy']) ? $data['createdBy'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['modifiedBy'] = isset($data['modifiedBy']) ? $data['modifiedBy'] : null;
        $this->container['dateModified'] = isset($data['dateModified']) ? $data['dateModified'] : null;
        $this->container['conversations'] = isset($data['conversations']) ? $data['conversations'] : null;
        $this->container['documents'] = isset($data['documents']) ? $data['documents'] : null;
        $this->container['isOverdue'] = isset($data['isOverdue']) ? $data['isOverdue'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("Scheduled", "InProgress", "Completed", "InvalidSchedule");
        if (!in_array($this->container['status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("Scheduled", "InProgress", "Completed", "InvalidSchedule");
        if (!in_array($this->container['status'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of coaching appointment
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description The description of coaching appointment
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets dateStart
     * @return \DateTime
     */
    public function getDateStart()
    {
        return $this->container['dateStart'];
    }

    /**
     * Sets dateStart
     * @param \DateTime $dateStart The date/time the coaching appointment starts. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateStart($dateStart)
    {
        $this->container['dateStart'] = $dateStart;

        return $this;
    }

    /**
     * Gets lengthInMinutes
     * @return int
     */
    public function getLengthInMinutes()
    {
        return $this->container['lengthInMinutes'];
    }

    /**
     * Sets lengthInMinutes
     * @param int $lengthInMinutes The duration of coaching appointment in minutes
     * @return $this
     */
    public function setLengthInMinutes($lengthInMinutes)
    {
        $this->container['lengthInMinutes'] = $lengthInMinutes;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status The status of coaching appointment
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = array('Scheduled', 'InProgress', 'Completed', 'InvalidSchedule');
        if (!in_array($status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'Scheduled', 'InProgress', 'Completed', 'InvalidSchedule'");
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets facilitator
     * @return \PureCloudSDK\UserReference
     */
    public function getFacilitator()
    {
        return $this->container['facilitator'];
    }

    /**
     * Sets facilitator
     * @param \PureCloudSDK\UserReference $facilitator The facilitator of coaching appointment
     * @return $this
     */
    public function setFacilitator($facilitator)
    {
        $this->container['facilitator'] = $facilitator;

        return $this;
    }

    /**
     * Gets attendees
     * @return \PureCloudSDK\UserReference[]
     */
    public function getAttendees()
    {
        return $this->container['attendees'];
    }

    /**
     * Sets attendees
     * @param \PureCloudSDK\UserReference[] $attendees The list of attendees attending the coaching
     * @return $this
     */
    public function setAttendees($attendees)
    {
        $this->container['attendees'] = $attendees;

        return $this;
    }

    /**
     * Gets createdBy
     * @return \PureCloudSDK\UserReference
     */
    public function getCreatedBy()
    {
        return $this->container['createdBy'];
    }

    /**
     * Sets createdBy
     * @param \PureCloudSDK\UserReference $createdBy The user who created the coaching appointment
     * @return $this
     */
    public function setCreatedBy($createdBy)
    {
        $this->container['createdBy'] = $createdBy;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated The date/time the coaching appointment was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets modifiedBy
     * @return \PureCloudSDK\UserReference
     */
    public function getModifiedBy()
    {
        return $this->container['modifiedBy'];
    }

    /**
     * Sets modifiedBy
     * @param \PureCloudSDK\UserReference $modifiedBy The last user to modify the coaching appointment
     * @return $this
     */
    public function setModifiedBy($modifiedBy)
    {
        $this->container['modifiedBy'] = $modifiedBy;

        return $this;
    }

    /**
     * Gets dateModified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['dateModified'];
    }

    /**
     * Sets dateModified
     * @param \DateTime $dateModified The date/time the coaching appointment was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($dateModified)
    {
        $this->container['dateModified'] = $dateModified;

        return $this;
    }

    /**
     * Gets conversations
     * @return \PureCloudSDK\ConversationReference[]
     */
    public function getConversations()
    {
        return $this->container['conversations'];
    }

    /**
     * Sets conversations
     * @param \PureCloudSDK\ConversationReference[] $conversations The list of conversations associated with coaching appointment.
     * @return $this
     */
    public function setConversations($conversations)
    {
        $this->container['conversations'] = $conversations;

        return $this;
    }

    /**
     * Gets documents
     * @return \PureCloudSDK\DocumentReference[]
     */
    public function getDocuments()
    {
        return $this->container['documents'];
    }

    /**
     * Sets documents
     * @param \PureCloudSDK\DocumentReference[] $documents The list of documents associated with coaching appointment.
     * @return $this
     */
    public function setDocuments($documents)
    {
        $this->container['documents'] = $documents;

        return $this;
    }

    /**
     * Gets isOverdue
     * @return bool
     */
    public function getIsOverdue()
    {
        return $this->container['isOverdue'];
    }

    /**
     * Sets isOverdue
     * @param bool $isOverdue Whether the appointment is overdue.
     * @return $this
     */
    public function setIsOverdue($isOverdue)
    {
        $this->container['isOverdue'] = $isOverdue;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
