<?php

/**
 * DevelopmentActivity
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * DevelopmentActivity Class Doc Comment
 *
 * @category    Class */
 // @description Development Activity object
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class DevelopmentActivity implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'DevelopmentActivity';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'dateCompleted' => '\DateTime',
        'createdBy' => '\PureCloudSDK\UserReference',
        'dateCreated' => '\DateTime',
        'selfUri' => 'string',
        'name' => 'string',
        'type' => 'string',
        'status' => 'string',
        'dateDue' => '\DateTime',
        'facilitator' => '\PureCloudSDK\UserReference',
        'attendees' => '\PureCloudSDK\UserReference[]',
        'isOverdue' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'dateCompleted' => 'dateCompleted',
        'createdBy' => 'createdBy',
        'dateCreated' => 'dateCreated',
        'selfUri' => 'selfUri',
        'name' => 'name',
        'type' => 'type',
        'status' => 'status',
        'dateDue' => 'dateDue',
        'facilitator' => 'facilitator',
        'attendees' => 'attendees',
        'isOverdue' => 'isOverdue'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'dateCompleted' => 'setDateCompleted',
        'createdBy' => 'setCreatedBy',
        'dateCreated' => 'setDateCreated',
        'selfUri' => 'setSelfUri',
        'name' => 'setName',
        'type' => 'setType',
        'status' => 'setStatus',
        'dateDue' => 'setDateDue',
        'facilitator' => 'setFacilitator',
        'attendees' => 'setAttendees',
        'isOverdue' => 'setIsOverdue'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'dateCompleted' => 'getDateCompleted',
        'createdBy' => 'getCreatedBy',
        'dateCreated' => 'getDateCreated',
        'selfUri' => 'getSelfUri',
        'name' => 'getName',
        'type' => 'getType',
        'status' => 'getStatus',
        'dateDue' => 'getDateDue',
        'facilitator' => 'getFacilitator',
        'attendees' => 'getAttendees',
        'isOverdue' => 'getIsOverdue'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const TYPE_INFORMATIONAL = 'Informational';
    public const TYPE_ASSESSED_CONTENT = 'AssessedContent';
    public const TYPE_QUESTIONNAIRE = 'Questionnaire';
    public const TYPE_COACHING = 'Coaching';
    public const STATUS_PLANNED = 'Planned';
    public const STATUS_IN_PROGRESS = 'InProgress';
    public const STATUS_COMPLETED = 'Completed';
    public const STATUS_INVALID_SCHEDULE = 'InvalidSchedule';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_INFORMATIONAL,
            self::TYPE_ASSESSED_CONTENT,
            self::TYPE_QUESTIONNAIRE,
            self::TYPE_COACHING,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_PLANNED,
            self::STATUS_IN_PROGRESS,
            self::STATUS_COMPLETED,
            self::STATUS_INVALID_SCHEDULE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['dateCompleted'] = isset($data['dateCompleted']) ? $data['dateCompleted'] : null;
        $this->container['createdBy'] = isset($data['createdBy']) ? $data['createdBy'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['dateDue'] = isset($data['dateDue']) ? $data['dateDue'] : null;
        $this->container['facilitator'] = isset($data['facilitator']) ? $data['facilitator'] : null;
        $this->container['attendees'] = isset($data['attendees']) ? $data['attendees'] : null;
        $this->container['isOverdue'] = isset($data['isOverdue']) ? $data['isOverdue'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("Informational", "AssessedContent", "Questionnaire", "Coaching");
        if (!in_array($this->container['type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'type', must be one of #{allowed_values}.";
        }

        $allowed_values = array("Planned", "InProgress", "Completed", "InvalidSchedule");
        if (!in_array($this->container['status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("Informational", "AssessedContent", "Questionnaire", "Coaching");
        if (!in_array($this->container['type'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("Planned", "InProgress", "Completed", "InvalidSchedule");
        if (!in_array($this->container['status'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets dateCompleted
     * @return \DateTime
     */
    public function getDateCompleted()
    {
        return $this->container['dateCompleted'];
    }

    /**
     * Sets dateCompleted
     * @param \DateTime $dateCompleted Date that activity was completed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCompleted($dateCompleted)
    {
        $this->container['dateCompleted'] = $dateCompleted;

        return $this;
    }

    /**
     * Gets createdBy
     * @return \PureCloudSDK\UserReference
     */
    public function getCreatedBy()
    {
        return $this->container['createdBy'];
    }

    /**
     * Sets createdBy
     * @param \PureCloudSDK\UserReference $createdBy User that created activity
     * @return $this
     */
    public function setCreatedBy($createdBy)
    {
        $this->container['createdBy'] = $createdBy;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated Date activity was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of the activity
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type The type of activity
     * @return $this
     */
    public function setType($type)
    {
        $allowed_values = array('Informational', 'AssessedContent', 'Questionnaire', 'Coaching');
        if (!in_array($type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'type', must be one of 'Informational', 'AssessedContent', 'Questionnaire', 'Coaching'");
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status The status of the activity
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = array('Planned', 'InProgress', 'Completed', 'InvalidSchedule');
        if (!in_array($status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'Planned', 'InProgress', 'Completed', 'InvalidSchedule'");
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets dateDue
     * @return \DateTime
     */
    public function getDateDue()
    {
        return $this->container['dateDue'];
    }

    /**
     * Sets dateDue
     * @param \DateTime $dateDue Due date for completion of the activity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateDue($dateDue)
    {
        $this->container['dateDue'] = $dateDue;

        return $this;
    }

    /**
     * Gets facilitator
     * @return \PureCloudSDK\UserReference
     */
    public function getFacilitator()
    {
        return $this->container['facilitator'];
    }

    /**
     * Sets facilitator
     * @param \PureCloudSDK\UserReference $facilitator Facilitator of the activity
     * @return $this
     */
    public function setFacilitator($facilitator)
    {
        $this->container['facilitator'] = $facilitator;

        return $this;
    }

    /**
     * Gets attendees
     * @return \PureCloudSDK\UserReference[]
     */
    public function getAttendees()
    {
        return $this->container['attendees'];
    }

    /**
     * Sets attendees
     * @param \PureCloudSDK\UserReference[] $attendees List of users attending the activity
     * @return $this
     */
    public function setAttendees($attendees)
    {
        $this->container['attendees'] = $attendees;

        return $this;
    }

    /**
     * Gets isOverdue
     * @return bool
     */
    public function getIsOverdue()
    {
        return $this->container['isOverdue'];
    }

    /**
     * Sets isOverdue
     * @param bool $isOverdue Indicates if the activity is overdue
     * @return $this
     */
    public function setIsOverdue($isOverdue)
    {
        $this->container['isOverdue'] = $isOverdue;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
