<?php

/**
 * DevelopmentActivityAggregateParam
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * DevelopmentActivityAggregateParam Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class DevelopmentActivityAggregateParam implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'DevelopmentActivityAggregateParam';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'interval' => 'string',
        'metrics' => 'string[]',
        'groupBy' => 'string[]',
        'filter' => '\PureCloudSDK\DevelopmentActivityAggregateQueryRequestFilter'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'interval' => 'interval',
        'metrics' => 'metrics',
        'groupBy' => 'groupBy',
        'filter' => 'filter'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'interval' => 'setInterval',
        'metrics' => 'setMetrics',
        'groupBy' => 'setGroupBy',
        'filter' => 'setFilter'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'interval' => 'getInterval',
        'metrics' => 'getMetrics',
        'groupBy' => 'getGroupBy',
        'filter' => 'getFilter'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const METRICS_N_ACTIVITIES = 'nActivities';
    public const METRICS_N_PLANNED_ACTIVITIES = 'nPlannedActivities';
    public const METRICS_N_IN_PROGRESS_ACTIVITIES = 'nInProgressActivities';
    public const METRICS_N_COMPLETE_ACTIVITIES = 'nCompleteActivities';
    public const METRICS_N_OVERDUE_ACTIVITIES = 'nOverdueActivities';
    public const METRICS_N_INVALID_SCHEDULE_ACTIVITIES = 'nInvalidScheduleActivities';
    public const GROUP_BY_ATTENDEE_ID = 'attendeeId';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMetricsAllowableValues()
    {
        return [
            self::METRICS_N_ACTIVITIES,
            self::METRICS_N_PLANNED_ACTIVITIES,
            self::METRICS_N_IN_PROGRESS_ACTIVITIES,
            self::METRICS_N_COMPLETE_ACTIVITIES,
            self::METRICS_N_OVERDUE_ACTIVITIES,
            self::METRICS_N_INVALID_SCHEDULE_ACTIVITIES,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getGroupByAllowableValues()
    {
        return [
            self::GROUP_BY_ATTENDEE_ID,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['interval'] = isset($data['interval']) ? $data['interval'] : null;
        $this->container['metrics'] = isset($data['metrics']) ? $data['metrics'] : null;
        $this->container['groupBy'] = isset($data['groupBy']) ? $data['groupBy'] : null;
        $this->container['filter'] = isset($data['filter']) ? $data['filter'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['interval'] === null) {
            $invalid_properties[] = "'interval' can't be null";
        }
        if ($this->container['filter'] === null) {
            $invalid_properties[] = "'filter' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['interval'] === null) {
            return false;
        }
        if ($this->container['filter'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets interval
     * @return string
     */
    public function getInterval()
    {
        return $this->container['interval'];
    }

    /**
     * Sets interval
     * @param string $interval Specifies the range of due dates to be used for filtering. Milliseconds will be truncated. A maximum of 365 days can be specified in the range. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss
     * @return $this
     */
    public function setInterval($interval)
    {
        $this->container['interval'] = $interval;

        return $this;
    }

    /**
     * Gets metrics
     * @return string[]
     */
    public function getMetrics()
    {
        return $this->container['metrics'];
    }

    /**
     * Sets metrics
     * @param string[] $metrics The list of metrics to be returned. If omitted, all metrics are returned.
     * @return $this
     */
    public function setMetrics($metrics)
    {
        $allowed_values = array('nActivities', 'nPlannedActivities', 'nInProgressActivities', 'nCompleteActivities', 'nOverdueActivities', 'nInvalidScheduleActivities');
        if (!in_array($metrics, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'metrics', must be one of 'nActivities', 'nPlannedActivities', 'nInProgressActivities', 'nCompleteActivities', 'nOverdueActivities', 'nInvalidScheduleActivities'");
        }
        $this->container['metrics'] = $metrics;

        return $this;
    }

    /**
     * Gets groupBy
     * @return string[]
     */
    public function getGroupBy()
    {
        return $this->container['groupBy'];
    }

    /**
     * Sets groupBy
     * @param string[] $groupBy Specifies if the aggregated data is combined into a single set of metrics (groupBy is empty or not specified), or contains an element per attendeeId (groupBy is \"attendeeId\")
     * @return $this
     */
    public function setGroupBy($groupBy)
    {
        $allowed_values = array('attendeeId');
        if (!in_array($groupBy, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'groupBy', must be one of 'attendeeId'");
        }
        $this->container['groupBy'] = $groupBy;

        return $this;
    }

    /**
     * Gets filter
     * @return \PureCloudSDK\DevelopmentActivityAggregateQueryRequestFilter
     */
    public function getFilter()
    {
        return $this->container['filter'];
    }

    /**
     * Sets filter
     * @param \PureCloudSDK\DevelopmentActivityAggregateQueryRequestFilter $filter The filter applied to the data. This is ANDed with the interval parameter.
     * @return $this
     */
    public function setFilter($filter)
    {
        $this->container['filter'] = $filter;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
