<?php

/**
 * FlowExecutionLaunchRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * FlowExecutionLaunchRequest Class Doc Comment
 *
 * @category    Class */
 // @description Parameters for launching a flow.
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class FlowExecutionLaunchRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'FlowExecutionLaunchRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'flowId' => 'string',
        'flowVersion' => 'string',
        'inputData' => 'map[string,object]',
        'name' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'flowId' => 'flowId',
        'flowVersion' => 'flowVersion',
        'inputData' => 'inputData',
        'name' => 'name'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'flowId' => 'setFlowId',
        'flowVersion' => 'setFlowVersion',
        'inputData' => 'setInputData',
        'name' => 'setName'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'flowId' => 'getFlowId',
        'flowVersion' => 'getFlowVersion',
        'inputData' => 'getInputData',
        'name' => 'getName'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['flowId'] = isset($data['flowId']) ? $data['flowId'] : null;
        $this->container['flowVersion'] = isset($data['flowVersion']) ? $data['flowVersion'] : null;
        $this->container['inputData'] = isset($data['inputData']) ? $data['inputData'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['flowId'] === null) {
            $invalid_properties[] = "'flowId' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['flowId'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets flowId
     * @return string
     */
    public function getFlowId()
    {
        return $this->container['flowId'];
    }

    /**
     * Sets flowId
     * @param string $flowId ID of the flow to launch.
     * @return $this
     */
    public function setFlowId($flowId)
    {
        $this->container['flowId'] = $flowId;

        return $this;
    }

    /**
     * Gets flowVersion
     * @return string
     */
    public function getFlowVersion()
    {
        return $this->container['flowVersion'];
    }

    /**
     * Sets flowVersion
     * @param string $flowVersion The version of the flow to launch. Omit this value (or supply null/empty) to use the latest published version.
     * @return $this
     */
    public function setFlowVersion($flowVersion)
    {
        $this->container['flowVersion'] = $flowVersion;

        return $this;
    }

    /**
     * Gets inputData
     * @return map[string,object]
     */
    public function getInputData()
    {
        return $this->container['inputData'];
    }

    /**
     * Sets inputData
     * @param map[string,object] $inputData Input values to the flow. Valid values are defined by a flow's input JSON schema.
     * @return $this
     */
    public function setInputData($inputData)
    {
        $this->container['inputData'] = $inputData;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name A displayable name to assign to the new flow execution
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
