<?php

/**
 * HistoricalAdherenceActuals
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * HistoricalAdherenceActuals Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class HistoricalAdherenceActuals implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'HistoricalAdherenceActuals';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'actualActivityCategory' => 'string',
        'startOffsetSeconds' => 'int',
        'endOffsetSeconds' => 'int'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'actualActivityCategory' => 'actualActivityCategory',
        'startOffsetSeconds' => 'startOffsetSeconds',
        'endOffsetSeconds' => 'endOffsetSeconds'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'actualActivityCategory' => 'setActualActivityCategory',
        'startOffsetSeconds' => 'setStartOffsetSeconds',
        'endOffsetSeconds' => 'setEndOffsetSeconds'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'actualActivityCategory' => 'getActualActivityCategory',
        'startOffsetSeconds' => 'getStartOffsetSeconds',
        'endOffsetSeconds' => 'getEndOffsetSeconds'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const ACTUAL_ACTIVITY_CATEGORY_ON_QUEUE_WORK = 'OnQueueWork';
    public const ACTUAL_ACTIVITY_CATEGORY_BREAK = 'Break';
    public const ACTUAL_ACTIVITY_CATEGORY_MEAL = 'Meal';
    public const ACTUAL_ACTIVITY_CATEGORY_MEETING = 'Meeting';
    public const ACTUAL_ACTIVITY_CATEGORY_OFF_QUEUE_WORK = 'OffQueueWork';
    public const ACTUAL_ACTIVITY_CATEGORY_TIME_OFF = 'TimeOff';
    public const ACTUAL_ACTIVITY_CATEGORY_TRAINING = 'Training';
    public const ACTUAL_ACTIVITY_CATEGORY_UNAVAILABLE = 'Unavailable';
    public const ACTUAL_ACTIVITY_CATEGORY_UNSCHEDULED = 'Unscheduled';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getActualActivityCategoryAllowableValues()
    {
        return [
            self::ACTUAL_ACTIVITY_CATEGORY_ON_QUEUE_WORK,
            self::ACTUAL_ACTIVITY_CATEGORY_BREAK,
            self::ACTUAL_ACTIVITY_CATEGORY_MEAL,
            self::ACTUAL_ACTIVITY_CATEGORY_MEETING,
            self::ACTUAL_ACTIVITY_CATEGORY_OFF_QUEUE_WORK,
            self::ACTUAL_ACTIVITY_CATEGORY_TIME_OFF,
            self::ACTUAL_ACTIVITY_CATEGORY_TRAINING,
            self::ACTUAL_ACTIVITY_CATEGORY_UNAVAILABLE,
            self::ACTUAL_ACTIVITY_CATEGORY_UNSCHEDULED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['actualActivityCategory'] = isset($data['actualActivityCategory']) ? $data['actualActivityCategory'] : null;
        $this->container['startOffsetSeconds'] = isset($data['startOffsetSeconds']) ? $data['startOffsetSeconds'] : null;
        $this->container['endOffsetSeconds'] = isset($data['endOffsetSeconds']) ? $data['endOffsetSeconds'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("OnQueueWork", "Break", "Meal", "Meeting", "OffQueueWork", "TimeOff", "Training", "Unavailable", "Unscheduled");
        if (!in_array($this->container['actualActivityCategory'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'actualActivityCategory', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("OnQueueWork", "Break", "Meal", "Meeting", "OffQueueWork", "TimeOff", "Training", "Unavailable", "Unscheduled");
        if (!in_array($this->container['actualActivityCategory'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets actualActivityCategory
     * @return string
     */
    public function getActualActivityCategory()
    {
        return $this->container['actualActivityCategory'];
    }

    /**
     * Sets actualActivityCategory
     * @param string $actualActivityCategory Activity in which the user is actually engaged
     * @return $this
     */
    public function setActualActivityCategory($actualActivityCategory)
    {
        $allowed_values = array('OnQueueWork', 'Break', 'Meal', 'Meeting', 'OffQueueWork', 'TimeOff', 'Training', 'Unavailable', 'Unscheduled');
        if (!in_array($actualActivityCategory, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'actualActivityCategory', must be one of 'OnQueueWork', 'Break', 'Meal', 'Meeting', 'OffQueueWork', 'TimeOff', 'Training', 'Unavailable', 'Unscheduled'");
        }
        $this->container['actualActivityCategory'] = $actualActivityCategory;

        return $this;
    }

    /**
     * Gets startOffsetSeconds
     * @return int
     */
    public function getStartOffsetSeconds()
    {
        return $this->container['startOffsetSeconds'];
    }

    /**
     * Sets startOffsetSeconds
     * @param int $startOffsetSeconds Actual start offset in seconds relative to query start time
     * @return $this
     */
    public function setStartOffsetSeconds($startOffsetSeconds)
    {
        $this->container['startOffsetSeconds'] = $startOffsetSeconds;

        return $this;
    }

    /**
     * Gets endOffsetSeconds
     * @return int
     */
    public function getEndOffsetSeconds()
    {
        return $this->container['endOffsetSeconds'];
    }

    /**
     * Sets endOffsetSeconds
     * @param int $endOffsetSeconds Actual end offset in seconds relative to query start time
     * @return $this
     */
    public function setEndOffsetSeconds($endOffsetSeconds)
    {
        $this->container['endOffsetSeconds'] = $endOffsetSeconds;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
