<?php

/**
 * LocationDefinition
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * LocationDefinition Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class LocationDefinition implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'LocationDefinition';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'contactUser' => '\PureCloudSDK\AddressableEntityRef',
        'emergencyNumber' => '\PureCloudSDK\LocationEmergencyNumber',
        'address' => '\PureCloudSDK\LocationAddress',
        'state' => 'string',
        'notes' => 'string',
        'version' => 'int',
        'path' => 'string[]',
        'profileImage' => '\PureCloudSDK\LocationImage[]',
        'floorplanImage' => '\PureCloudSDK\LocationImage[]',
        'addressVerificationDetails' => '\PureCloudSDK\LocationAddressVerificationDetails',
        'addressVerified' => 'bool',
        'addressStored' => 'bool',
        'images' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'contactUser' => 'contactUser',
        'emergencyNumber' => 'emergencyNumber',
        'address' => 'address',
        'state' => 'state',
        'notes' => 'notes',
        'version' => 'version',
        'path' => 'path',
        'profileImage' => 'profileImage',
        'floorplanImage' => 'floorplanImage',
        'addressVerificationDetails' => 'addressVerificationDetails',
        'addressVerified' => 'addressVerified',
        'addressStored' => 'addressStored',
        'images' => 'images',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'contactUser' => 'setContactUser',
        'emergencyNumber' => 'setEmergencyNumber',
        'address' => 'setAddress',
        'state' => 'setState',
        'notes' => 'setNotes',
        'version' => 'setVersion',
        'path' => 'setPath',
        'profileImage' => 'setProfileImage',
        'floorplanImage' => 'setFloorplanImage',
        'addressVerificationDetails' => 'setAddressVerificationDetails',
        'addressVerified' => 'setAddressVerified',
        'addressStored' => 'setAddressStored',
        'images' => 'setImages',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'contactUser' => 'getContactUser',
        'emergencyNumber' => 'getEmergencyNumber',
        'address' => 'getAddress',
        'state' => 'getState',
        'notes' => 'getNotes',
        'version' => 'getVersion',
        'path' => 'getPath',
        'profileImage' => 'getProfileImage',
        'floorplanImage' => 'getFloorplanImage',
        'addressVerificationDetails' => 'getAddressVerificationDetails',
        'addressVerified' => 'getAddressVerified',
        'addressStored' => 'getAddressStored',
        'images' => 'getImages',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const STATE_ACTIVE = 'active';
    public const STATE_DELETED = 'deleted';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ACTIVE,
            self::STATE_DELETED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['contactUser'] = isset($data['contactUser']) ? $data['contactUser'] : null;
        $this->container['emergencyNumber'] = isset($data['emergencyNumber']) ? $data['emergencyNumber'] : null;
        $this->container['address'] = isset($data['address']) ? $data['address'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['notes'] = isset($data['notes']) ? $data['notes'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['path'] = isset($data['path']) ? $data['path'] : null;
        $this->container['profileImage'] = isset($data['profileImage']) ? $data['profileImage'] : null;
        $this->container['floorplanImage'] = isset($data['floorplanImage']) ? $data['floorplanImage'] : null;
        $this->container['addressVerificationDetails'] = isset($data['addressVerificationDetails']) ? $data['addressVerificationDetails'] : null;
        $this->container['addressVerified'] = isset($data['addressVerified']) ? $data['addressVerified'] : null;
        $this->container['addressStored'] = isset($data['addressStored']) ? $data['addressStored'] : null;
        $this->container['images'] = isset($data['images']) ? $data['images'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("active", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("active", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets contactUser
     * @return \PureCloudSDK\AddressableEntityRef
     */
    public function getContactUser()
    {
        return $this->container['contactUser'];
    }

    /**
     * Sets contactUser
     * @param \PureCloudSDK\AddressableEntityRef $contactUser Site contact for the location entity
     * @return $this
     */
    public function setContactUser($contactUser)
    {
        $this->container['contactUser'] = $contactUser;

        return $this;
    }

    /**
     * Gets emergencyNumber
     * @return \PureCloudSDK\LocationEmergencyNumber
     */
    public function getEmergencyNumber()
    {
        return $this->container['emergencyNumber'];
    }

    /**
     * Sets emergencyNumber
     * @param \PureCloudSDK\LocationEmergencyNumber $emergencyNumber Emergency number for the location entity
     * @return $this
     */
    public function setEmergencyNumber($emergencyNumber)
    {
        $this->container['emergencyNumber'] = $emergencyNumber;

        return $this;
    }

    /**
     * Gets address
     * @return \PureCloudSDK\LocationAddress
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     * @param \PureCloudSDK\LocationAddress $address
     * @return $this
     */
    public function setAddress($address)
    {
        $this->container['address'] = $address;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state Current state of the location entity
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('active', 'deleted');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'active', 'deleted'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets notes
     * @return string
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     * @param string $notes Notes for the location entity
     * @return $this
     */
    public function setNotes($notes)
    {
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version Current version of the location entity, value to be supplied should be retrieved by a GET or on create/update response
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets path
     * @return string[]
     */
    public function getPath()
    {
        return $this->container['path'];
    }

    /**
     * Sets path
     * @param string[] $path A list of ancestor IDs in order
     * @return $this
     */
    public function setPath($path)
    {
        $this->container['path'] = $path;

        return $this;
    }

    /**
     * Gets profileImage
     * @return \PureCloudSDK\LocationImage[]
     */
    public function getProfileImage()
    {
        return $this->container['profileImage'];
    }

    /**
     * Sets profileImage
     * @param \PureCloudSDK\LocationImage[] $profileImage Profile image of the location entity, retrieved with ?expand=images query parameter
     * @return $this
     */
    public function setProfileImage($profileImage)
    {
        $this->container['profileImage'] = $profileImage;

        return $this;
    }

    /**
     * Gets floorplanImage
     * @return \PureCloudSDK\LocationImage[]
     */
    public function getFloorplanImage()
    {
        return $this->container['floorplanImage'];
    }

    /**
     * Sets floorplanImage
     * @param \PureCloudSDK\LocationImage[] $floorplanImage Floorplan images of the location entity, retrieved with ?expand=images query parameter
     * @return $this
     */
    public function setFloorplanImage($floorplanImage)
    {
        $this->container['floorplanImage'] = $floorplanImage;

        return $this;
    }

    /**
     * Gets addressVerificationDetails
     * @return \PureCloudSDK\LocationAddressVerificationDetails
     */
    public function getAddressVerificationDetails()
    {
        return $this->container['addressVerificationDetails'];
    }

    /**
     * Sets addressVerificationDetails
     * @param \PureCloudSDK\LocationAddressVerificationDetails $addressVerificationDetails Address verification information, retrieve dwith the ?expand=addressVerificationDetails query parameter
     * @return $this
     */
    public function setAddressVerificationDetails($addressVerificationDetails)
    {
        $this->container['addressVerificationDetails'] = $addressVerificationDetails;

        return $this;
    }

    /**
     * Gets addressVerified
     * @return bool
     */
    public function getAddressVerified()
    {
        return $this->container['addressVerified'];
    }

    /**
     * Sets addressVerified
     * @param bool $addressVerified Boolean field which states if the address has been verified as an actual address
     * @return $this
     */
    public function setAddressVerified($addressVerified)
    {
        $this->container['addressVerified'] = $addressVerified;

        return $this;
    }

    /**
     * Gets addressStored
     * @return bool
     */
    public function getAddressStored()
    {
        return $this->container['addressStored'];
    }

    /**
     * Sets addressStored
     * @param bool $addressStored Boolean field which states if the address has been stored for E911
     * @return $this
     */
    public function setAddressStored($addressStored)
    {
        $this->container['addressStored'] = $addressStored;

        return $this;
    }

    /**
     * Gets images
     * @return string
     */
    public function getImages()
    {
        return $this->container['images'];
    }

    /**
     * Sets images
     * @param string $images
     * @return $this
     */
    public function setImages($images)
    {
        $this->container['images'] = $images;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
