<?php

/**
 * MessagingSticker
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * MessagingSticker Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class MessagingSticker implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'MessagingSticker';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'providerStickerId' => 'int',
        'providerPackageId' => 'int',
        'packageName' => 'string',
        'messengerType' => 'string',
        'stickerType' => 'string',
        'providerVersion' => 'int',
        'uriLocation' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'providerStickerId' => 'providerStickerId',
        'providerPackageId' => 'providerPackageId',
        'packageName' => 'packageName',
        'messengerType' => 'messengerType',
        'stickerType' => 'stickerType',
        'providerVersion' => 'providerVersion',
        'uriLocation' => 'uriLocation',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'providerStickerId' => 'setProviderStickerId',
        'providerPackageId' => 'setProviderPackageId',
        'packageName' => 'setPackageName',
        'messengerType' => 'setMessengerType',
        'stickerType' => 'setStickerType',
        'providerVersion' => 'setProviderVersion',
        'uriLocation' => 'setUriLocation',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'providerStickerId' => 'getProviderStickerId',
        'providerPackageId' => 'getProviderPackageId',
        'packageName' => 'getPackageName',
        'messengerType' => 'getMessengerType',
        'stickerType' => 'getStickerType',
        'providerVersion' => 'getProviderVersion',
        'uriLocation' => 'getUriLocation',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const MESSENGER_TYPE_SMS = 'sms';
    public const MESSENGER_TYPE_FACEBOOK = 'facebook';
    public const MESSENGER_TYPE_TWITTER = 'twitter';
    public const MESSENGER_TYPE_LINE = 'line';
    public const MESSENGER_TYPE_WHATSAPP = 'whatsapp';
    public const MESSENGER_TYPE_WEBMESSAGING = 'webmessaging';
    public const STICKER_TYPE_STANDARD = 'standard';
    public const STICKER_TYPE_FREE = 'free';
    public const STICKER_TYPE_PAID = 'paid';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMessengerTypeAllowableValues()
    {
        return [
            self::MESSENGER_TYPE_SMS,
            self::MESSENGER_TYPE_FACEBOOK,
            self::MESSENGER_TYPE_TWITTER,
            self::MESSENGER_TYPE_LINE,
            self::MESSENGER_TYPE_WHATSAPP,
            self::MESSENGER_TYPE_WEBMESSAGING,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStickerTypeAllowableValues()
    {
        return [
            self::STICKER_TYPE_STANDARD,
            self::STICKER_TYPE_FREE,
            self::STICKER_TYPE_PAID,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['providerStickerId'] = isset($data['providerStickerId']) ? $data['providerStickerId'] : null;
        $this->container['providerPackageId'] = isset($data['providerPackageId']) ? $data['providerPackageId'] : null;
        $this->container['packageName'] = isset($data['packageName']) ? $data['packageName'] : null;
        $this->container['messengerType'] = isset($data['messengerType']) ? $data['messengerType'] : null;
        $this->container['stickerType'] = isset($data['stickerType']) ? $data['stickerType'] : null;
        $this->container['providerVersion'] = isset($data['providerVersion']) ? $data['providerVersion'] : null;
        $this->container['uriLocation'] = isset($data['uriLocation']) ? $data['uriLocation'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['providerStickerId'] === null) {
            $invalid_properties[] = "'providerStickerId' can't be null";
        }
        if ($this->container['messengerType'] === null) {
            $invalid_properties[] = "'messengerType' can't be null";
        }
        $allowed_values = array("sms", "facebook", "twitter", "line", "whatsapp", "webmessaging");
        if (!in_array($this->container['messengerType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'messengerType', must be one of #{allowed_values}.";
        }

        if ($this->container['stickerType'] === null) {
            $invalid_properties[] = "'stickerType' can't be null";
        }
        $allowed_values = array("standard", "free", "paid");
        if (!in_array($this->container['stickerType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'stickerType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['providerStickerId'] === null) {
            return false;
        }
        if ($this->container['messengerType'] === null) {
            return false;
        }
        $allowed_values = array("sms", "facebook", "twitter", "line", "whatsapp", "webmessaging");
        if (!in_array($this->container['messengerType'], $allowed_values)) {
            return false;
        }
        if ($this->container['stickerType'] === null) {
            return false;
        }
        $allowed_values = array("standard", "free", "paid");
        if (!in_array($this->container['stickerType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets providerStickerId
     * @return int
     */
    public function getProviderStickerId()
    {
        return $this->container['providerStickerId'];
    }

    /**
     * Sets providerStickerId
     * @param int $providerStickerId The sticker Id of the sticker, assigned by the sticker provider.
     * @return $this
     */
    public function setProviderStickerId($providerStickerId)
    {
        $this->container['providerStickerId'] = $providerStickerId;

        return $this;
    }

    /**
     * Gets providerPackageId
     * @return int
     */
    public function getProviderPackageId()
    {
        return $this->container['providerPackageId'];
    }

    /**
     * Sets providerPackageId
     * @param int $providerPackageId The package Id of the sticker, assigned by the sticker provider.
     * @return $this
     */
    public function setProviderPackageId($providerPackageId)
    {
        $this->container['providerPackageId'] = $providerPackageId;

        return $this;
    }

    /**
     * Gets packageName
     * @return string
     */
    public function getPackageName()
    {
        return $this->container['packageName'];
    }

    /**
     * Sets packageName
     * @param string $packageName The package name of the sticker, assigned by the sticker provider.
     * @return $this
     */
    public function setPackageName($packageName)
    {
        $this->container['packageName'] = $packageName;

        return $this;
    }

    /**
     * Gets messengerType
     * @return string
     */
    public function getMessengerType()
    {
        return $this->container['messengerType'];
    }

    /**
     * Sets messengerType
     * @param string $messengerType The type of the messenger provider.
     * @return $this
     */
    public function setMessengerType($messengerType)
    {
        $allowed_values = array('sms', 'facebook', 'twitter', 'line', 'whatsapp', 'webmessaging');
        if (!in_array($messengerType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'messengerType', must be one of 'sms', 'facebook', 'twitter', 'line', 'whatsapp', 'webmessaging'");
        }
        $this->container['messengerType'] = $messengerType;

        return $this;
    }

    /**
     * Gets stickerType
     * @return string
     */
    public function getStickerType()
    {
        return $this->container['stickerType'];
    }

    /**
     * Sets stickerType
     * @param string $stickerType The type of the sticker.
     * @return $this
     */
    public function setStickerType($stickerType)
    {
        $allowed_values = array('standard', 'free', 'paid');
        if (!in_array($stickerType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'stickerType', must be one of 'standard', 'free', 'paid'");
        }
        $this->container['stickerType'] = $stickerType;

        return $this;
    }

    /**
     * Gets providerVersion
     * @return int
     */
    public function getProviderVersion()
    {
        return $this->container['providerVersion'];
    }

    /**
     * Sets providerVersion
     * @param int $providerVersion The version of the sticker, assigned by the provider.
     * @return $this
     */
    public function setProviderVersion($providerVersion)
    {
        $this->container['providerVersion'] = $providerVersion;

        return $this;
    }

    /**
     * Gets uriLocation
     * @return string
     */
    public function getUriLocation()
    {
        return $this->container['uriLocation'];
    }

    /**
     * Sets uriLocation
     * @param string $uriLocation
     * @return $this
     */
    public function setUriLocation($uriLocation)
    {
        $this->container['uriLocation'] = $uriLocation;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
