<?php

/**
 * RecordingJobsQuery
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * RecordingJobsQuery Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class RecordingJobsQuery implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'RecordingJobsQuery';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'action' => 'string',
        'actionDate' => '\DateTime',
        'integrationId' => 'string',
        'includeScreenRecordings' => 'bool',
        'conversationQuery' => '\PureCloudSDK\AsyncConversationQuery'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'action' => 'action',
        'actionDate' => 'actionDate',
        'integrationId' => 'integrationId',
        'includeScreenRecordings' => 'includeScreenRecordings',
        'conversationQuery' => 'conversationQuery'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'action' => 'setAction',
        'actionDate' => 'setActionDate',
        'integrationId' => 'setIntegrationId',
        'includeScreenRecordings' => 'setIncludeScreenRecordings',
        'conversationQuery' => 'setConversationQuery'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'action' => 'getAction',
        'actionDate' => 'getActionDate',
        'integrationId' => 'getIntegrationId',
        'includeScreenRecordings' => 'getIncludeScreenRecordings',
        'conversationQuery' => 'getConversationQuery'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const ACTION_DELETE = 'DELETE';
    public const ACTION_EXPORT = 'EXPORT';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getActionAllowableValues()
    {
        return [
            self::ACTION_DELETE,
            self::ACTION_EXPORT,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['action'] = isset($data['action']) ? $data['action'] : null;
        $this->container['actionDate'] = isset($data['actionDate']) ? $data['actionDate'] : null;
        $this->container['integrationId'] = isset($data['integrationId']) ? $data['integrationId'] : null;
        $this->container['includeScreenRecordings'] = isset($data['includeScreenRecordings']) ? $data['includeScreenRecordings'] : null;
        $this->container['conversationQuery'] = isset($data['conversationQuery']) ? $data['conversationQuery'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['action'] === null) {
            $invalid_properties[] = "'action' can't be null";
        }
        $allowed_values = array("DELETE", "EXPORT");
        if (!in_array($this->container['action'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'action', must be one of #{allowed_values}.";
        }

        if ($this->container['actionDate'] === null) {
            $invalid_properties[] = "'actionDate' can't be null";
        }
        if ($this->container['conversationQuery'] === null) {
            $invalid_properties[] = "'conversationQuery' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['action'] === null) {
            return false;
        }
        $allowed_values = array("DELETE", "EXPORT");
        if (!in_array($this->container['action'], $allowed_values)) {
            return false;
        }
        if ($this->container['actionDate'] === null) {
            return false;
        }
        if ($this->container['conversationQuery'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets action
     * @return string
     */
    public function getAction()
    {
        return $this->container['action'];
    }

    /**
     * Sets action
     * @param string $action Operation to perform bulk task
     * @return $this
     */
    public function setAction($action)
    {
        $allowed_values = array('DELETE', 'EXPORT');
        if (!in_array($action, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'action', must be one of 'DELETE', 'EXPORT'");
        }
        $this->container['action'] = $action;

        return $this;
    }

    /**
     * Gets actionDate
     * @return \DateTime
     */
    public function getActionDate()
    {
        return $this->container['actionDate'];
    }

    /**
     * Sets actionDate
     * @param \DateTime $actionDate The date when the action will be performed. If the operation will cause the delete date of a recording to be older than the export date, the export date will be adjusted to the delete date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setActionDate($actionDate)
    {
        $this->container['actionDate'] = $actionDate;

        return $this;
    }

    /**
     * Gets integrationId
     * @return string
     */
    public function getIntegrationId()
    {
        return $this->container['integrationId'];
    }

    /**
     * Sets integrationId
     * @param string $integrationId IntegrationId to Access AWS S3 bucket for bulk recording exports. This field is required and used only for EXPORT action.
     * @return $this
     */
    public function setIntegrationId($integrationId)
    {
        $this->container['integrationId'] = $integrationId;

        return $this;
    }

    /**
     * Gets includeScreenRecordings
     * @return bool
     */
    public function getIncludeScreenRecordings()
    {
        return $this->container['includeScreenRecordings'];
    }

    /**
     * Sets includeScreenRecordings
     * @param bool $includeScreenRecordings Include Screen recordings for export action, default value = true
     * @return $this
     */
    public function setIncludeScreenRecordings($includeScreenRecordings)
    {
        $this->container['includeScreenRecordings'] = $includeScreenRecordings;

        return $this;
    }

    /**
     * Gets conversationQuery
     * @return \PureCloudSDK\AsyncConversationQuery
     */
    public function getConversationQuery()
    {
        return $this->container['conversationQuery'];
    }

    /**
     * Sets conversationQuery
     * @param \PureCloudSDK\AsyncConversationQuery $conversationQuery Conversation Query. Note: After the recording is created, it might take up to 48 hours for the recording to be included in the submitted job query.
     * @return $this
     */
    public function setConversationQuery($conversationQuery)
    {
        $this->container['conversationQuery'] = $conversationQuery;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
