<?php

/**
 * ReportingExportMetadataJobResponse
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ReportingExportMetadataJobResponse Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ReportingExportMetadataJobResponse implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ReportingExportMetadataJobResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'viewType' => 'string',
        'dateLimitations' => 'string',
        'requiredFilters' => 'string[]',
        'supportedFilters' => 'string[]',
        'requiredColumnIds' => 'string[]',
        'dependentColumnIds' => 'map[string,string[]]',
        'availableColumnIds' => 'string[]',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'viewType' => 'viewType',
        'dateLimitations' => 'dateLimitations',
        'requiredFilters' => 'requiredFilters',
        'supportedFilters' => 'supportedFilters',
        'requiredColumnIds' => 'requiredColumnIds',
        'dependentColumnIds' => 'dependentColumnIds',
        'availableColumnIds' => 'availableColumnIds',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'viewType' => 'setViewType',
        'dateLimitations' => 'setDateLimitations',
        'requiredFilters' => 'setRequiredFilters',
        'supportedFilters' => 'setSupportedFilters',
        'requiredColumnIds' => 'setRequiredColumnIds',
        'dependentColumnIds' => 'setDependentColumnIds',
        'availableColumnIds' => 'setAvailableColumnIds',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'viewType' => 'getViewType',
        'dateLimitations' => 'getDateLimitations',
        'requiredFilters' => 'getRequiredFilters',
        'supportedFilters' => 'getSupportedFilters',
        'requiredColumnIds' => 'getRequiredColumnIds',
        'dependentColumnIds' => 'getDependentColumnIds',
        'availableColumnIds' => 'getAvailableColumnIds',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const VIEW_TYPE_QUEUE_PERFORMANCE_SUMMARY_VIEW = 'QUEUE_PERFORMANCE_SUMMARY_VIEW';
    public const VIEW_TYPE_QUEUE_PERFORMANCE_DETAIL_VIEW = 'QUEUE_PERFORMANCE_DETAIL_VIEW';
    public const VIEW_TYPE_INTERACTION_SEARCH_VIEW = 'INTERACTION_SEARCH_VIEW';
    public const VIEW_TYPE_AGENT_PERFORMANCE_SUMMARY_VIEW = 'AGENT_PERFORMANCE_SUMMARY_VIEW';
    public const VIEW_TYPE_AGENT_PERFORMANCE_DETAIL_VIEW = 'AGENT_PERFORMANCE_DETAIL_VIEW';
    public const VIEW_TYPE_AGENT_STATUS_SUMMARY_VIEW = 'AGENT_STATUS_SUMMARY_VIEW';
    public const VIEW_TYPE_AGENT_STATUS_DETAIL_VIEW = 'AGENT_STATUS_DETAIL_VIEW';
    public const VIEW_TYPE_AGENT_EVALUATION_SUMMARY_VIEW = 'AGENT_EVALUATION_SUMMARY_VIEW';
    public const VIEW_TYPE_AGENT_EVALUATION_DETAIL_VIEW = 'AGENT_EVALUATION_DETAIL_VIEW';
    public const VIEW_TYPE_AGENT_QUEUE_DETAIL_VIEW = 'AGENT_QUEUE_DETAIL_VIEW';
    public const VIEW_TYPE_AGENT_INTERACTION_DETAIL_VIEW = 'AGENT_INTERACTION_DETAIL_VIEW';
    public const VIEW_TYPE_ABANDON_INSIGHTS_VIEW = 'ABANDON_INSIGHTS_VIEW';
    public const VIEW_TYPE_SKILLS_PERFORMANCE_VIEW = 'SKILLS_PERFORMANCE_VIEW';
    public const VIEW_TYPE_SURVEY_FORM_PERFORMANCE_SUMMARY_VIEW = 'SURVEY_FORM_PERFORMANCE_SUMMARY_VIEW';
    public const VIEW_TYPE_SURVEY_FORM_PERFORMANCE_DETAIL_VIEW = 'SURVEY_FORM_PERFORMANCE_DETAIL_VIEW';
    public const VIEW_TYPE_DNIS_PERFORMANCE_SUMMARY_VIEW = 'DNIS_PERFORMANCE_SUMMARY_VIEW';
    public const VIEW_TYPE_DNIS_PERFORMANCE_DETAIL_VIEW = 'DNIS_PERFORMANCE_DETAIL_VIEW';
    public const VIEW_TYPE_WRAP_UP_PERFORMANCE_SUMMARY_VIEW = 'WRAP_UP_PERFORMANCE_SUMMARY_VIEW';
    public const VIEW_TYPE_AGENT_WRAP_UP_PERFORMANCE_DETAIL_VIEW = 'AGENT_WRAP_UP_PERFORMANCE_DETAIL_VIEW';
    public const VIEW_TYPE_QUEUE_ACTIVITY_SUMMARY_VIEW = 'QUEUE_ACTIVITY_SUMMARY_VIEW';
    public const VIEW_TYPE_QUEUE_ACTIVITY_DETAIL_VIEW = 'QUEUE_ACTIVITY_DETAIL_VIEW';
    public const VIEW_TYPE_AGENT_QUEUE_ACTIVITY_SUMMARY_VIEW = 'AGENT_QUEUE_ACTIVITY_SUMMARY_VIEW';
    public const VIEW_TYPE_QUEUE_AGENT_DETAIL_VIEW = 'QUEUE_AGENT_DETAIL_VIEW';
    public const VIEW_TYPE_QUEUE_INTERACTION_DETAIL_VIEW = 'QUEUE_INTERACTION_DETAIL_VIEW';
    public const VIEW_TYPE_AGENT_SCHEDULE_DETAIL_VIEW = 'AGENT_SCHEDULE_DETAIL_VIEW';
    public const VIEW_TYPE_IVR_PERFORMANCE_SUMMARY_VIEW = 'IVR_PERFORMANCE_SUMMARY_VIEW';
    public const VIEW_TYPE_IVR_PERFORMANCE_DETAIL_VIEW = 'IVR_PERFORMANCE_DETAIL_VIEW';
    public const VIEW_TYPE_ANSWER_INSIGHTS_VIEW = 'ANSWER_INSIGHTS_VIEW';
    public const VIEW_TYPE_HANDLE_INSIGHTS_VIEW = 'HANDLE_INSIGHTS_VIEW';
    public const VIEW_TYPE_TALK_INSIGHTS_VIEW = 'TALK_INSIGHTS_VIEW';
    public const VIEW_TYPE_HOLD_INSIGHTS_VIEW = 'HOLD_INSIGHTS_VIEW';
    public const VIEW_TYPE_ACW_INSIGHTS_VIEW = 'ACW_INSIGHTS_VIEW';
    public const VIEW_TYPE_WAIT_INSIGHTS_VIEW = 'WAIT_INSIGHTS_VIEW';
    public const VIEW_TYPE_AGENT_WRAP_UP_PERFORMANCE_INTERVAL_DETAIL_VIEW = 'AGENT_WRAP_UP_PERFORMANCE_INTERVAL_DETAIL_VIEW';
    public const VIEW_TYPE_FLOW_OUTCOME_SUMMARY_VIEW = 'FLOW_OUTCOME_SUMMARY_VIEW';
    public const VIEW_TYPE_FLOW_OUTCOME_PERFORMANCE_DETAIL_VIEW = 'FLOW_OUTCOME_PERFORMANCE_DETAIL_VIEW';
    public const VIEW_TYPE_FLOW_OUTCOME_PERFORMANCE_INTERVAL_DETAIL_VIEW = 'FLOW_OUTCOME_PERFORMANCE_INTERVAL_DETAIL_VIEW';
    public const VIEW_TYPE_FLOW_DESTINATION_SUMMARY_VIEW = 'FLOW_DESTINATION_SUMMARY_VIEW';
    public const VIEW_TYPE_FLOW_DESTINATION_DETAIL_VIEW = 'FLOW_DESTINATION_DETAIL_VIEW';
    public const VIEW_TYPE_API_USAGE_VIEW = 'API_USAGE_VIEW';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getViewTypeAllowableValues()
    {
        return [
            self::VIEW_TYPE_QUEUE_PERFORMANCE_SUMMARY_VIEW,
            self::VIEW_TYPE_QUEUE_PERFORMANCE_DETAIL_VIEW,
            self::VIEW_TYPE_INTERACTION_SEARCH_VIEW,
            self::VIEW_TYPE_AGENT_PERFORMANCE_SUMMARY_VIEW,
            self::VIEW_TYPE_AGENT_PERFORMANCE_DETAIL_VIEW,
            self::VIEW_TYPE_AGENT_STATUS_SUMMARY_VIEW,
            self::VIEW_TYPE_AGENT_STATUS_DETAIL_VIEW,
            self::VIEW_TYPE_AGENT_EVALUATION_SUMMARY_VIEW,
            self::VIEW_TYPE_AGENT_EVALUATION_DETAIL_VIEW,
            self::VIEW_TYPE_AGENT_QUEUE_DETAIL_VIEW,
            self::VIEW_TYPE_AGENT_INTERACTION_DETAIL_VIEW,
            self::VIEW_TYPE_ABANDON_INSIGHTS_VIEW,
            self::VIEW_TYPE_SKILLS_PERFORMANCE_VIEW,
            self::VIEW_TYPE_SURVEY_FORM_PERFORMANCE_SUMMARY_VIEW,
            self::VIEW_TYPE_SURVEY_FORM_PERFORMANCE_DETAIL_VIEW,
            self::VIEW_TYPE_DNIS_PERFORMANCE_SUMMARY_VIEW,
            self::VIEW_TYPE_DNIS_PERFORMANCE_DETAIL_VIEW,
            self::VIEW_TYPE_WRAP_UP_PERFORMANCE_SUMMARY_VIEW,
            self::VIEW_TYPE_AGENT_WRAP_UP_PERFORMANCE_DETAIL_VIEW,
            self::VIEW_TYPE_QUEUE_ACTIVITY_SUMMARY_VIEW,
            self::VIEW_TYPE_QUEUE_ACTIVITY_DETAIL_VIEW,
            self::VIEW_TYPE_AGENT_QUEUE_ACTIVITY_SUMMARY_VIEW,
            self::VIEW_TYPE_QUEUE_AGENT_DETAIL_VIEW,
            self::VIEW_TYPE_QUEUE_INTERACTION_DETAIL_VIEW,
            self::VIEW_TYPE_AGENT_SCHEDULE_DETAIL_VIEW,
            self::VIEW_TYPE_IVR_PERFORMANCE_SUMMARY_VIEW,
            self::VIEW_TYPE_IVR_PERFORMANCE_DETAIL_VIEW,
            self::VIEW_TYPE_ANSWER_INSIGHTS_VIEW,
            self::VIEW_TYPE_HANDLE_INSIGHTS_VIEW,
            self::VIEW_TYPE_TALK_INSIGHTS_VIEW,
            self::VIEW_TYPE_HOLD_INSIGHTS_VIEW,
            self::VIEW_TYPE_ACW_INSIGHTS_VIEW,
            self::VIEW_TYPE_WAIT_INSIGHTS_VIEW,
            self::VIEW_TYPE_AGENT_WRAP_UP_PERFORMANCE_INTERVAL_DETAIL_VIEW,
            self::VIEW_TYPE_FLOW_OUTCOME_SUMMARY_VIEW,
            self::VIEW_TYPE_FLOW_OUTCOME_PERFORMANCE_DETAIL_VIEW,
            self::VIEW_TYPE_FLOW_OUTCOME_PERFORMANCE_INTERVAL_DETAIL_VIEW,
            self::VIEW_TYPE_FLOW_DESTINATION_SUMMARY_VIEW,
            self::VIEW_TYPE_FLOW_DESTINATION_DETAIL_VIEW,
            self::VIEW_TYPE_API_USAGE_VIEW,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['viewType'] = isset($data['viewType']) ? $data['viewType'] : null;
        $this->container['dateLimitations'] = isset($data['dateLimitations']) ? $data['dateLimitations'] : null;
        $this->container['requiredFilters'] = isset($data['requiredFilters']) ? $data['requiredFilters'] : null;
        $this->container['supportedFilters'] = isset($data['supportedFilters']) ? $data['supportedFilters'] : null;
        $this->container['requiredColumnIds'] = isset($data['requiredColumnIds']) ? $data['requiredColumnIds'] : null;
        $this->container['dependentColumnIds'] = isset($data['dependentColumnIds']) ? $data['dependentColumnIds'] : null;
        $this->container['availableColumnIds'] = isset($data['availableColumnIds']) ? $data['availableColumnIds'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("QUEUE_PERFORMANCE_SUMMARY_VIEW", "QUEUE_PERFORMANCE_DETAIL_VIEW", "INTERACTION_SEARCH_VIEW", "AGENT_PERFORMANCE_SUMMARY_VIEW", "AGENT_PERFORMANCE_DETAIL_VIEW", "AGENT_STATUS_SUMMARY_VIEW", "AGENT_STATUS_DETAIL_VIEW", "AGENT_EVALUATION_SUMMARY_VIEW", "AGENT_EVALUATION_DETAIL_VIEW", "AGENT_QUEUE_DETAIL_VIEW", "AGENT_INTERACTION_DETAIL_VIEW", "ABANDON_INSIGHTS_VIEW", "SKILLS_PERFORMANCE_VIEW", "SURVEY_FORM_PERFORMANCE_SUMMARY_VIEW", "SURVEY_FORM_PERFORMANCE_DETAIL_VIEW", "DNIS_PERFORMANCE_SUMMARY_VIEW", "DNIS_PERFORMANCE_DETAIL_VIEW", "WRAP_UP_PERFORMANCE_SUMMARY_VIEW", "AGENT_WRAP_UP_PERFORMANCE_DETAIL_VIEW", "QUEUE_ACTIVITY_SUMMARY_VIEW", "QUEUE_ACTIVITY_DETAIL_VIEW", "AGENT_QUEUE_ACTIVITY_SUMMARY_VIEW", "QUEUE_AGENT_DETAIL_VIEW", "QUEUE_INTERACTION_DETAIL_VIEW", "AGENT_SCHEDULE_DETAIL_VIEW", "IVR_PERFORMANCE_SUMMARY_VIEW", "IVR_PERFORMANCE_DETAIL_VIEW", "ANSWER_INSIGHTS_VIEW", "HANDLE_INSIGHTS_VIEW", "TALK_INSIGHTS_VIEW", "HOLD_INSIGHTS_VIEW", "ACW_INSIGHTS_VIEW", "WAIT_INSIGHTS_VIEW", "AGENT_WRAP_UP_PERFORMANCE_INTERVAL_DETAIL_VIEW", "FLOW_OUTCOME_SUMMARY_VIEW", "FLOW_OUTCOME_PERFORMANCE_DETAIL_VIEW", "FLOW_OUTCOME_PERFORMANCE_INTERVAL_DETAIL_VIEW", "FLOW_DESTINATION_SUMMARY_VIEW", "FLOW_DESTINATION_DETAIL_VIEW", "API_USAGE_VIEW");
        if (!in_array($this->container['viewType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'viewType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("QUEUE_PERFORMANCE_SUMMARY_VIEW", "QUEUE_PERFORMANCE_DETAIL_VIEW", "INTERACTION_SEARCH_VIEW", "AGENT_PERFORMANCE_SUMMARY_VIEW", "AGENT_PERFORMANCE_DETAIL_VIEW", "AGENT_STATUS_SUMMARY_VIEW", "AGENT_STATUS_DETAIL_VIEW", "AGENT_EVALUATION_SUMMARY_VIEW", "AGENT_EVALUATION_DETAIL_VIEW", "AGENT_QUEUE_DETAIL_VIEW", "AGENT_INTERACTION_DETAIL_VIEW", "ABANDON_INSIGHTS_VIEW", "SKILLS_PERFORMANCE_VIEW", "SURVEY_FORM_PERFORMANCE_SUMMARY_VIEW", "SURVEY_FORM_PERFORMANCE_DETAIL_VIEW", "DNIS_PERFORMANCE_SUMMARY_VIEW", "DNIS_PERFORMANCE_DETAIL_VIEW", "WRAP_UP_PERFORMANCE_SUMMARY_VIEW", "AGENT_WRAP_UP_PERFORMANCE_DETAIL_VIEW", "QUEUE_ACTIVITY_SUMMARY_VIEW", "QUEUE_ACTIVITY_DETAIL_VIEW", "AGENT_QUEUE_ACTIVITY_SUMMARY_VIEW", "QUEUE_AGENT_DETAIL_VIEW", "QUEUE_INTERACTION_DETAIL_VIEW", "AGENT_SCHEDULE_DETAIL_VIEW", "IVR_PERFORMANCE_SUMMARY_VIEW", "IVR_PERFORMANCE_DETAIL_VIEW", "ANSWER_INSIGHTS_VIEW", "HANDLE_INSIGHTS_VIEW", "TALK_INSIGHTS_VIEW", "HOLD_INSIGHTS_VIEW", "ACW_INSIGHTS_VIEW", "WAIT_INSIGHTS_VIEW", "AGENT_WRAP_UP_PERFORMANCE_INTERVAL_DETAIL_VIEW", "FLOW_OUTCOME_SUMMARY_VIEW", "FLOW_OUTCOME_PERFORMANCE_DETAIL_VIEW", "FLOW_OUTCOME_PERFORMANCE_INTERVAL_DETAIL_VIEW", "FLOW_DESTINATION_SUMMARY_VIEW", "FLOW_DESTINATION_DETAIL_VIEW", "API_USAGE_VIEW");
        if (!in_array($this->container['viewType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets viewType
     * @return string
     */
    public function getViewType()
    {
        return $this->container['viewType'];
    }

    /**
     * Sets viewType
     * @param string $viewType The view type of the export metadata
     * @return $this
     */
    public function setViewType($viewType)
    {
        $allowed_values = array('QUEUE_PERFORMANCE_SUMMARY_VIEW', 'QUEUE_PERFORMANCE_DETAIL_VIEW', 'INTERACTION_SEARCH_VIEW', 'AGENT_PERFORMANCE_SUMMARY_VIEW', 'AGENT_PERFORMANCE_DETAIL_VIEW', 'AGENT_STATUS_SUMMARY_VIEW', 'AGENT_STATUS_DETAIL_VIEW', 'AGENT_EVALUATION_SUMMARY_VIEW', 'AGENT_EVALUATION_DETAIL_VIEW', 'AGENT_QUEUE_DETAIL_VIEW', 'AGENT_INTERACTION_DETAIL_VIEW', 'ABANDON_INSIGHTS_VIEW', 'SKILLS_PERFORMANCE_VIEW', 'SURVEY_FORM_PERFORMANCE_SUMMARY_VIEW', 'SURVEY_FORM_PERFORMANCE_DETAIL_VIEW', 'DNIS_PERFORMANCE_SUMMARY_VIEW', 'DNIS_PERFORMANCE_DETAIL_VIEW', 'WRAP_UP_PERFORMANCE_SUMMARY_VIEW', 'AGENT_WRAP_UP_PERFORMANCE_DETAIL_VIEW', 'QUEUE_ACTIVITY_SUMMARY_VIEW', 'QUEUE_ACTIVITY_DETAIL_VIEW', 'AGENT_QUEUE_ACTIVITY_SUMMARY_VIEW', 'QUEUE_AGENT_DETAIL_VIEW', 'QUEUE_INTERACTION_DETAIL_VIEW', 'AGENT_SCHEDULE_DETAIL_VIEW', 'IVR_PERFORMANCE_SUMMARY_VIEW', 'IVR_PERFORMANCE_DETAIL_VIEW', 'ANSWER_INSIGHTS_VIEW', 'HANDLE_INSIGHTS_VIEW', 'TALK_INSIGHTS_VIEW', 'HOLD_INSIGHTS_VIEW', 'ACW_INSIGHTS_VIEW', 'WAIT_INSIGHTS_VIEW', 'AGENT_WRAP_UP_PERFORMANCE_INTERVAL_DETAIL_VIEW', 'FLOW_OUTCOME_SUMMARY_VIEW', 'FLOW_OUTCOME_PERFORMANCE_DETAIL_VIEW', 'FLOW_OUTCOME_PERFORMANCE_INTERVAL_DETAIL_VIEW', 'FLOW_DESTINATION_SUMMARY_VIEW', 'FLOW_DESTINATION_DETAIL_VIEW', 'API_USAGE_VIEW');
        if (!in_array($viewType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'viewType', must be one of 'QUEUE_PERFORMANCE_SUMMARY_VIEW', 'QUEUE_PERFORMANCE_DETAIL_VIEW', 'INTERACTION_SEARCH_VIEW', 'AGENT_PERFORMANCE_SUMMARY_VIEW', 'AGENT_PERFORMANCE_DETAIL_VIEW', 'AGENT_STATUS_SUMMARY_VIEW', 'AGENT_STATUS_DETAIL_VIEW', 'AGENT_EVALUATION_SUMMARY_VIEW', 'AGENT_EVALUATION_DETAIL_VIEW', 'AGENT_QUEUE_DETAIL_VIEW', 'AGENT_INTERACTION_DETAIL_VIEW', 'ABANDON_INSIGHTS_VIEW', 'SKILLS_PERFORMANCE_VIEW', 'SURVEY_FORM_PERFORMANCE_SUMMARY_VIEW', 'SURVEY_FORM_PERFORMANCE_DETAIL_VIEW', 'DNIS_PERFORMANCE_SUMMARY_VIEW', 'DNIS_PERFORMANCE_DETAIL_VIEW', 'WRAP_UP_PERFORMANCE_SUMMARY_VIEW', 'AGENT_WRAP_UP_PERFORMANCE_DETAIL_VIEW', 'QUEUE_ACTIVITY_SUMMARY_VIEW', 'QUEUE_ACTIVITY_DETAIL_VIEW', 'AGENT_QUEUE_ACTIVITY_SUMMARY_VIEW', 'QUEUE_AGENT_DETAIL_VIEW', 'QUEUE_INTERACTION_DETAIL_VIEW', 'AGENT_SCHEDULE_DETAIL_VIEW', 'IVR_PERFORMANCE_SUMMARY_VIEW', 'IVR_PERFORMANCE_DETAIL_VIEW', 'ANSWER_INSIGHTS_VIEW', 'HANDLE_INSIGHTS_VIEW', 'TALK_INSIGHTS_VIEW', 'HOLD_INSIGHTS_VIEW', 'ACW_INSIGHTS_VIEW', 'WAIT_INSIGHTS_VIEW', 'AGENT_WRAP_UP_PERFORMANCE_INTERVAL_DETAIL_VIEW', 'FLOW_OUTCOME_SUMMARY_VIEW', 'FLOW_OUTCOME_PERFORMANCE_DETAIL_VIEW', 'FLOW_OUTCOME_PERFORMANCE_INTERVAL_DETAIL_VIEW', 'FLOW_DESTINATION_SUMMARY_VIEW', 'FLOW_DESTINATION_DETAIL_VIEW', 'API_USAGE_VIEW'");
        }
        $this->container['viewType'] = $viewType;

        return $this;
    }

    /**
     * Gets dateLimitations
     * @return string
     */
    public function getDateLimitations()
    {
        return $this->container['dateLimitations'];
    }

    /**
     * Sets dateLimitations
     * @param string $dateLimitations The date limitations of the export metadata
     * @return $this
     */
    public function setDateLimitations($dateLimitations)
    {
        $this->container['dateLimitations'] = $dateLimitations;

        return $this;
    }

    /**
     * Gets requiredFilters
     * @return string[]
     */
    public function getRequiredFilters()
    {
        return $this->container['requiredFilters'];
    }

    /**
     * Sets requiredFilters
     * @param string[] $requiredFilters The list of required filters for the export metadata
     * @return $this
     */
    public function setRequiredFilters($requiredFilters)
    {
        $this->container['requiredFilters'] = $requiredFilters;

        return $this;
    }

    /**
     * Gets supportedFilters
     * @return string[]
     */
    public function getSupportedFilters()
    {
        return $this->container['supportedFilters'];
    }

    /**
     * Sets supportedFilters
     * @param string[] $supportedFilters The list of supported filters for the export metadata
     * @return $this
     */
    public function setSupportedFilters($supportedFilters)
    {
        $this->container['supportedFilters'] = $supportedFilters;

        return $this;
    }

    /**
     * Gets requiredColumnIds
     * @return string[]
     */
    public function getRequiredColumnIds()
    {
        return $this->container['requiredColumnIds'];
    }

    /**
     * Sets requiredColumnIds
     * @param string[] $requiredColumnIds The list of required column ids for the export metadata
     * @return $this
     */
    public function setRequiredColumnIds($requiredColumnIds)
    {
        $this->container['requiredColumnIds'] = $requiredColumnIds;

        return $this;
    }

    /**
     * Gets dependentColumnIds
     * @return map[string,string[]]
     */
    public function getDependentColumnIds()
    {
        return $this->container['dependentColumnIds'];
    }

    /**
     * Sets dependentColumnIds
     * @param map[string,string[]] $dependentColumnIds The list of dependent column ids for the export metadata
     * @return $this
     */
    public function setDependentColumnIds($dependentColumnIds)
    {
        $this->container['dependentColumnIds'] = $dependentColumnIds;

        return $this;
    }

    /**
     * Gets availableColumnIds
     * @return string[]
     */
    public function getAvailableColumnIds()
    {
        return $this->container['availableColumnIds'];
    }

    /**
     * Sets availableColumnIds
     * @param string[] $availableColumnIds The list of available column ids for the export metadata
     * @return $this
     */
    public function setAvailableColumnIds($availableColumnIds)
    {
        $this->container['availableColumnIds'] = $availableColumnIds;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
