<?php

/**
 * ReschedulingOptionsRunResponse
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ReschedulingOptionsRunResponse Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ReschedulingOptionsRunResponse implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ReschedulingOptionsRunResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'existingSchedule' => '\PureCloudSDK\BuScheduleReference',
        'startDate' => '\DateTime',
        'endDate' => '\DateTime',
        'managementUnits' => '\PureCloudSDK\ReschedulingManagementUnitResponse[]',
        'agentCount' => 'int',
        'activityCodeIds' => 'string[]',
        'doNotChangeWeeklyPaidTime' => 'bool',
        'doNotChangeDailyPaidTime' => 'bool',
        'doNotChangeShiftStartTimes' => 'bool',
        'doNotChangeManuallyEditedShifts' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'existingSchedule' => 'existingSchedule',
        'startDate' => 'startDate',
        'endDate' => 'endDate',
        'managementUnits' => 'managementUnits',
        'agentCount' => 'agentCount',
        'activityCodeIds' => 'activityCodeIds',
        'doNotChangeWeeklyPaidTime' => 'doNotChangeWeeklyPaidTime',
        'doNotChangeDailyPaidTime' => 'doNotChangeDailyPaidTime',
        'doNotChangeShiftStartTimes' => 'doNotChangeShiftStartTimes',
        'doNotChangeManuallyEditedShifts' => 'doNotChangeManuallyEditedShifts'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'existingSchedule' => 'setExistingSchedule',
        'startDate' => 'setStartDate',
        'endDate' => 'setEndDate',
        'managementUnits' => 'setManagementUnits',
        'agentCount' => 'setAgentCount',
        'activityCodeIds' => 'setActivityCodeIds',
        'doNotChangeWeeklyPaidTime' => 'setDoNotChangeWeeklyPaidTime',
        'doNotChangeDailyPaidTime' => 'setDoNotChangeDailyPaidTime',
        'doNotChangeShiftStartTimes' => 'setDoNotChangeShiftStartTimes',
        'doNotChangeManuallyEditedShifts' => 'setDoNotChangeManuallyEditedShifts'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'existingSchedule' => 'getExistingSchedule',
        'startDate' => 'getStartDate',
        'endDate' => 'getEndDate',
        'managementUnits' => 'getManagementUnits',
        'agentCount' => 'getAgentCount',
        'activityCodeIds' => 'getActivityCodeIds',
        'doNotChangeWeeklyPaidTime' => 'getDoNotChangeWeeklyPaidTime',
        'doNotChangeDailyPaidTime' => 'getDoNotChangeDailyPaidTime',
        'doNotChangeShiftStartTimes' => 'getDoNotChangeShiftStartTimes',
        'doNotChangeManuallyEditedShifts' => 'getDoNotChangeManuallyEditedShifts'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['existingSchedule'] = isset($data['existingSchedule']) ? $data['existingSchedule'] : null;
        $this->container['startDate'] = isset($data['startDate']) ? $data['startDate'] : null;
        $this->container['endDate'] = isset($data['endDate']) ? $data['endDate'] : null;
        $this->container['managementUnits'] = isset($data['managementUnits']) ? $data['managementUnits'] : null;
        $this->container['agentCount'] = isset($data['agentCount']) ? $data['agentCount'] : null;
        $this->container['activityCodeIds'] = isset($data['activityCodeIds']) ? $data['activityCodeIds'] : null;
        $this->container['doNotChangeWeeklyPaidTime'] = isset($data['doNotChangeWeeklyPaidTime']) ? $data['doNotChangeWeeklyPaidTime'] : null;
        $this->container['doNotChangeDailyPaidTime'] = isset($data['doNotChangeDailyPaidTime']) ? $data['doNotChangeDailyPaidTime'] : null;
        $this->container['doNotChangeShiftStartTimes'] = isset($data['doNotChangeShiftStartTimes']) ? $data['doNotChangeShiftStartTimes'] : null;
        $this->container['doNotChangeManuallyEditedShifts'] = isset($data['doNotChangeManuallyEditedShifts']) ? $data['doNotChangeManuallyEditedShifts'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets existingSchedule
     * @return \PureCloudSDK\BuScheduleReference
     */
    public function getExistingSchedule()
    {
        return $this->container['existingSchedule'];
    }

    /**
     * Sets existingSchedule
     * @param \PureCloudSDK\BuScheduleReference $existingSchedule The existing schedule to which this reschedule run applies
     * @return $this
     */
    public function setExistingSchedule($existingSchedule)
    {
        $this->container['existingSchedule'] = $existingSchedule;

        return $this;
    }

    /**
     * Gets startDate
     * @return \DateTime
     */
    public function getStartDate()
    {
        return $this->container['startDate'];
    }

    /**
     * Sets startDate
     * @param \DateTime $startDate The start date of the period to reschedule. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartDate($startDate)
    {
        $this->container['startDate'] = $startDate;

        return $this;
    }

    /**
     * Gets endDate
     * @return \DateTime
     */
    public function getEndDate()
    {
        return $this->container['endDate'];
    }

    /**
     * Sets endDate
     * @param \DateTime $endDate The end date of the period to reschedule. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setEndDate($endDate)
    {
        $this->container['endDate'] = $endDate;

        return $this;
    }

    /**
     * Gets managementUnits
     * @return \PureCloudSDK\ReschedulingManagementUnitResponse[]
     */
    public function getManagementUnits()
    {
        return $this->container['managementUnits'];
    }

    /**
     * Sets managementUnits
     * @param \PureCloudSDK\ReschedulingManagementUnitResponse[] $managementUnits Per-management unit rescheduling options
     * @return $this
     */
    public function setManagementUnits($managementUnits)
    {
        $this->container['managementUnits'] = $managementUnits;

        return $this;
    }

    /**
     * Gets agentCount
     * @return int
     */
    public function getAgentCount()
    {
        return $this->container['agentCount'];
    }

    /**
     * Sets agentCount
     * @param int $agentCount The number of agents to be considered in the reschedule
     * @return $this
     */
    public function setAgentCount($agentCount)
    {
        $this->container['agentCount'] = $agentCount;

        return $this;
    }

    /**
     * Gets activityCodeIds
     * @return string[]
     */
    public function getActivityCodeIds()
    {
        return $this->container['activityCodeIds'];
    }

    /**
     * Sets activityCodeIds
     * @param string[] $activityCodeIds The IDs of the activity codes being considered for reschedule
     * @return $this
     */
    public function setActivityCodeIds($activityCodeIds)
    {
        $this->container['activityCodeIds'] = $activityCodeIds;

        return $this;
    }

    /**
     * Gets doNotChangeWeeklyPaidTime
     * @return bool
     */
    public function getDoNotChangeWeeklyPaidTime()
    {
        return $this->container['doNotChangeWeeklyPaidTime'];
    }

    /**
     * Sets doNotChangeWeeklyPaidTime
     * @param bool $doNotChangeWeeklyPaidTime Whether weekly paid time is allowed to be changed
     * @return $this
     */
    public function setDoNotChangeWeeklyPaidTime($doNotChangeWeeklyPaidTime)
    {
        $this->container['doNotChangeWeeklyPaidTime'] = $doNotChangeWeeklyPaidTime;

        return $this;
    }

    /**
     * Gets doNotChangeDailyPaidTime
     * @return bool
     */
    public function getDoNotChangeDailyPaidTime()
    {
        return $this->container['doNotChangeDailyPaidTime'];
    }

    /**
     * Sets doNotChangeDailyPaidTime
     * @param bool $doNotChangeDailyPaidTime Whether daily paid time is allowed to be changed
     * @return $this
     */
    public function setDoNotChangeDailyPaidTime($doNotChangeDailyPaidTime)
    {
        $this->container['doNotChangeDailyPaidTime'] = $doNotChangeDailyPaidTime;

        return $this;
    }

    /**
     * Gets doNotChangeShiftStartTimes
     * @return bool
     */
    public function getDoNotChangeShiftStartTimes()
    {
        return $this->container['doNotChangeShiftStartTimes'];
    }

    /**
     * Sets doNotChangeShiftStartTimes
     * @param bool $doNotChangeShiftStartTimes Whether shift start times are allowed to be changed
     * @return $this
     */
    public function setDoNotChangeShiftStartTimes($doNotChangeShiftStartTimes)
    {
        $this->container['doNotChangeShiftStartTimes'] = $doNotChangeShiftStartTimes;

        return $this;
    }

    /**
     * Gets doNotChangeManuallyEditedShifts
     * @return bool
     */
    public function getDoNotChangeManuallyEditedShifts()
    {
        return $this->container['doNotChangeManuallyEditedShifts'];
    }

    /**
     * Sets doNotChangeManuallyEditedShifts
     * @param bool $doNotChangeManuallyEditedShifts Whether manually edited shifts are allowed to be changed
     * @return $this
     */
    public function setDoNotChangeManuallyEditedShifts($doNotChangeManuallyEditedShifts)
    {
        $this->container['doNotChangeManuallyEditedShifts'] = $doNotChangeManuallyEditedShifts;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
