<?php

/**
 * ScimV2User
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ScimV2User Class Doc Comment
 *
 * @category    Class */
 // @description Defines a SCIM user.
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ScimV2User implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ScimV2User';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'schemas' => 'string[]',
        'active' => 'bool',
        'userName' => 'string',
        'displayName' => 'string',
        'password' => 'string',
        'title' => 'string',
        'phoneNumbers' => '\PureCloudSDK\ScimPhoneNumber[]',
        'emails' => '\PureCloudSDK\ScimEmail[]',
        'externalId' => 'string',
        'groups' => '\PureCloudSDK\ScimV2GroupReference[]',
        'roles' => '\PureCloudSDK\ScimUserRole[]',
        'urnietfparamsscimschemasextensionenterprise20User' => '\PureCloudSDK\ScimV2EnterpriseUser',
        'urnietfparamsscimschemasextensiongenesyspurecloud20User' => '\PureCloudSDK\ScimUserExtensions',
        'meta' => '\PureCloudSDK\ScimMetadata'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'schemas' => 'schemas',
        'active' => 'active',
        'userName' => 'userName',
        'displayName' => 'displayName',
        'password' => 'password',
        'title' => 'title',
        'phoneNumbers' => 'phoneNumbers',
        'emails' => 'emails',
        'externalId' => 'externalId',
        'groups' => 'groups',
        'roles' => 'roles',
        'urnietfparamsscimschemasextensionenterprise20User' => 'urn:ietf:params:scim:schemas:extension:enterprise:2.0:User',
        'urnietfparamsscimschemasextensiongenesyspurecloud20User' => 'urn:ietf:params:scim:schemas:extension:genesys:purecloud:2.0:User',
        'meta' => 'meta'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'schemas' => 'setSchemas',
        'active' => 'setActive',
        'userName' => 'setUserName',
        'displayName' => 'setDisplayName',
        'password' => 'setPassword',
        'title' => 'setTitle',
        'phoneNumbers' => 'setPhoneNumbers',
        'emails' => 'setEmails',
        'externalId' => 'setExternalId',
        'groups' => 'setGroups',
        'roles' => 'setRoles',
        'urnietfparamsscimschemasextensionenterprise20User' => 'setUrnietfparamsscimschemasextensionenterprise20User',
        'urnietfparamsscimschemasextensiongenesyspurecloud20User' => 'setUrnietfparamsscimschemasextensiongenesyspurecloud20User',
        'meta' => 'setMeta'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'schemas' => 'getSchemas',
        'active' => 'getActive',
        'userName' => 'getUserName',
        'displayName' => 'getDisplayName',
        'password' => 'getPassword',
        'title' => 'getTitle',
        'phoneNumbers' => 'getPhoneNumbers',
        'emails' => 'getEmails',
        'externalId' => 'getExternalId',
        'groups' => 'getGroups',
        'roles' => 'getRoles',
        'urnietfparamsscimschemasextensionenterprise20User' => 'getUrnietfparamsscimschemasextensionenterprise20User',
        'urnietfparamsscimschemasextensiongenesyspurecloud20User' => 'getUrnietfparamsscimschemasextensiongenesyspurecloud20User',
        'meta' => 'getMeta'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['schemas'] = isset($data['schemas']) ? $data['schemas'] : null;
        $this->container['active'] = isset($data['active']) ? $data['active'] : null;
        $this->container['userName'] = isset($data['userName']) ? $data['userName'] : null;
        $this->container['displayName'] = isset($data['displayName']) ? $data['displayName'] : null;
        $this->container['password'] = isset($data['password']) ? $data['password'] : null;
        $this->container['title'] = isset($data['title']) ? $data['title'] : null;
        $this->container['phoneNumbers'] = isset($data['phoneNumbers']) ? $data['phoneNumbers'] : null;
        $this->container['emails'] = isset($data['emails']) ? $data['emails'] : null;
        $this->container['externalId'] = isset($data['externalId']) ? $data['externalId'] : null;
        $this->container['groups'] = isset($data['groups']) ? $data['groups'] : null;
        $this->container['roles'] = isset($data['roles']) ? $data['roles'] : null;
        $this->container['urnietfparamsscimschemasextensionenterprise20User'] = isset($data['urnietfparamsscimschemasextensionenterprise20User']) ? $data['urnietfparamsscimschemasextensionenterprise20User'] : null;
        $this->container['urnietfparamsscimschemasextensiongenesyspurecloud20User'] = isset($data['urnietfparamsscimschemasextensiongenesyspurecloud20User']) ? $data['urnietfparamsscimschemasextensiongenesyspurecloud20User'] : null;
        $this->container['meta'] = isset($data['meta']) ? $data['meta'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The ID of the SCIM resource. Set by the service provider. \"caseExact\" is set to \"true\". \"mutability\" is set to \"readOnly\". \"returned\" is set to \"always\".
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets schemas
     * @return string[]
     */
    public function getSchemas()
    {
        return $this->container['schemas'];
    }

    /**
     * Sets schemas
     * @param string[] $schemas The list of supported schemas.
     * @return $this
     */
    public function setSchemas($schemas)
    {
        $this->container['schemas'] = $schemas;

        return $this;
    }

    /**
     * Gets active
     * @return bool
     */
    public function getActive()
    {
        return $this->container['active'];
    }

    /**
     * Sets active
     * @param bool $active Indicates whether the user's administrative status is active.
     * @return $this
     */
    public function setActive($active)
    {
        $this->container['active'] = $active;

        return $this;
    }

    /**
     * Gets userName
     * @return string
     */
    public function getUserName()
    {
        return $this->container['userName'];
    }

    /**
     * Sets userName
     * @param string $userName The user's Genesys Cloud email address. Must be unique.
     * @return $this
     */
    public function setUserName($userName)
    {
        $this->container['userName'] = $userName;

        return $this;
    }

    /**
     * Gets displayName
     * @return string
     */
    public function getDisplayName()
    {
        return $this->container['displayName'];
    }

    /**
     * Sets displayName
     * @param string $displayName The display name of the user.
     * @return $this
     */
    public function setDisplayName($displayName)
    {
        $this->container['displayName'] = $displayName;

        return $this;
    }

    /**
     * Gets password
     * @return string
     */
    public function getPassword()
    {
        return $this->container['password'];
    }

    /**
     * Sets password
     * @param string $password The new password for the Genesys Cloud user. Does not return an existing password.
     * @return $this
     */
    public function setPassword($password)
    {
        $this->container['password'] = $password;

        return $this;
    }

    /**
     * Gets title
     * @return string
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     * @param string $title The user's title.
     * @return $this
     */
    public function setTitle($title)
    {
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets phoneNumbers
     * @return \PureCloudSDK\ScimPhoneNumber[]
     */
    public function getPhoneNumbers()
    {
        return $this->container['phoneNumbers'];
    }

    /**
     * Sets phoneNumbers
     * @param \PureCloudSDK\ScimPhoneNumber[] $phoneNumbers The list of the user's phone numbers.
     * @return $this
     */
    public function setPhoneNumbers($phoneNumbers)
    {
        $this->container['phoneNumbers'] = $phoneNumbers;

        return $this;
    }

    /**
     * Gets emails
     * @return \PureCloudSDK\ScimEmail[]
     */
    public function getEmails()
    {
        return $this->container['emails'];
    }

    /**
     * Sets emails
     * @param \PureCloudSDK\ScimEmail[] $emails The list of the user's email addresses.
     * @return $this
     */
    public function setEmails($emails)
    {
        $this->container['emails'] = $emails;

        return $this;
    }

    /**
     * Gets externalId
     * @return string
     */
    public function getExternalId()
    {
        return $this->container['externalId'];
    }

    /**
     * Sets externalId
     * @param string $externalId The external ID of the user. Set by the provisioning client. \"caseExact\" is set to \"true\". \"mutability\" is set to \"readWrite\".
     * @return $this
     */
    public function setExternalId($externalId)
    {
        $this->container['externalId'] = $externalId;

        return $this;
    }

    /**
     * Gets groups
     * @return \PureCloudSDK\ScimV2GroupReference[]
     */
    public function getGroups()
    {
        return $this->container['groups'];
    }

    /**
     * Sets groups
     * @param \PureCloudSDK\ScimV2GroupReference[] $groups The list of groups that the user is a member of.
     * @return $this
     */
    public function setGroups($groups)
    {
        $this->container['groups'] = $groups;

        return $this;
    }

    /**
     * Gets roles
     * @return \PureCloudSDK\ScimUserRole[]
     */
    public function getRoles()
    {
        return $this->container['roles'];
    }

    /**
     * Sets roles
     * @param \PureCloudSDK\ScimUserRole[] $roles The list of roles assigned to the user.
     * @return $this
     */
    public function setRoles($roles)
    {
        $this->container['roles'] = $roles;

        return $this;
    }

    /**
     * Gets urnietfparamsscimschemasextensionenterprise20User
     * @return \PureCloudSDK\ScimV2EnterpriseUser
     */
    public function getUrnietfparamsscimschemasextensionenterprise20User()
    {
        return $this->container['urnietfparamsscimschemasextensionenterprise20User'];
    }

    /**
     * Sets urnietfparamsscimschemasextensionenterprise20User
     * @param \PureCloudSDK\ScimV2EnterpriseUser $urnietfparamsscimschemasextensionenterprise20User The URI of the schema for the enterprise user.
     * @return $this
     */
    public function setUrnietfparamsscimschemasextensionenterprise20User($urnietfparamsscimschemasextensionenterprise20User)
    {
        $this->container['urnietfparamsscimschemasextensionenterprise20User'] = $urnietfparamsscimschemasextensionenterprise20User;

        return $this;
    }

    /**
     * Gets urnietfparamsscimschemasextensiongenesyspurecloud20User
     * @return \PureCloudSDK\ScimUserExtensions
     */
    public function getUrnietfparamsscimschemasextensiongenesyspurecloud20User()
    {
        return $this->container['urnietfparamsscimschemasextensiongenesyspurecloud20User'];
    }

    /**
     * Sets urnietfparamsscimschemasextensiongenesyspurecloud20User
     * @param \PureCloudSDK\ScimUserExtensions $urnietfparamsscimschemasextensiongenesyspurecloud20User The URI of the schema for the Genesys Cloud user.
     * @return $this
     */
    public function setUrnietfparamsscimschemasextensiongenesyspurecloud20User($urnietfparamsscimschemasextensiongenesyspurecloud20User)
    {
        $this->container['urnietfparamsscimschemasextensiongenesyspurecloud20User'] = $urnietfparamsscimschemasextensiongenesyspurecloud20User;

        return $this;
    }

    /**
     * Gets meta
     * @return \PureCloudSDK\ScimMetadata
     */
    public function getMeta()
    {
        return $this->container['meta'];
    }

    /**
     * Sets meta
     * @param \PureCloudSDK\ScimMetadata $meta The metadata of the SCIM resource.
     * @return $this
     */
    public function setMeta($meta)
    {
        $this->container['meta'] = $meta;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
