<?php

/**
 * UserAggregationQuery
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * UserAggregationQuery Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class UserAggregationQuery implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'UserAggregationQuery';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'interval' => 'string',
        'granularity' => 'string',
        'timeZone' => 'string',
        'groupBy' => 'string[]',
        'filter' => '\PureCloudSDK\UserAggregateQueryFilter',
        'metrics' => 'string[]',
        'flattenMultivaluedDimensions' => 'bool',
        'views' => '\PureCloudSDK\UserAggregationView[]',
        'alternateTimeDimension' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'interval' => 'interval',
        'granularity' => 'granularity',
        'timeZone' => 'timeZone',
        'groupBy' => 'groupBy',
        'filter' => 'filter',
        'metrics' => 'metrics',
        'flattenMultivaluedDimensions' => 'flattenMultivaluedDimensions',
        'views' => 'views',
        'alternateTimeDimension' => 'alternateTimeDimension'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'interval' => 'setInterval',
        'granularity' => 'setGranularity',
        'timeZone' => 'setTimeZone',
        'groupBy' => 'setGroupBy',
        'filter' => 'setFilter',
        'metrics' => 'setMetrics',
        'flattenMultivaluedDimensions' => 'setFlattenMultivaluedDimensions',
        'views' => 'setViews',
        'alternateTimeDimension' => 'setAlternateTimeDimension'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'interval' => 'getInterval',
        'granularity' => 'getGranularity',
        'timeZone' => 'getTimeZone',
        'groupBy' => 'getGroupBy',
        'filter' => 'getFilter',
        'metrics' => 'getMetrics',
        'flattenMultivaluedDimensions' => 'getFlattenMultivaluedDimensions',
        'views' => 'getViews',
        'alternateTimeDimension' => 'getAlternateTimeDimension'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const GROUP_BY_ORGANIZATION_PRESENCE_ID = 'organizationPresenceId';
    public const GROUP_BY_ROUTING_STATUS = 'routingStatus';
    public const GROUP_BY_SYSTEM_PRESENCE = 'systemPresence';
    public const GROUP_BY_USER_ID = 'userId';
    public const METRICS_T_AGENT_ROUTING_STATUS = 'tAgentRoutingStatus';
    public const METRICS_T_ORGANIZATION_PRESENCE = 'tOrganizationPresence';
    public const METRICS_T_SYSTEM_PRESENCE = 'tSystemPresence';
    public const ALTERNATE_TIME_DIMENSION_EVENT_TIME = 'eventTime';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getGroupByAllowableValues()
    {
        return [
            self::GROUP_BY_ORGANIZATION_PRESENCE_ID,
            self::GROUP_BY_ROUTING_STATUS,
            self::GROUP_BY_SYSTEM_PRESENCE,
            self::GROUP_BY_USER_ID,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMetricsAllowableValues()
    {
        return [
            self::METRICS_T_AGENT_ROUTING_STATUS,
            self::METRICS_T_ORGANIZATION_PRESENCE,
            self::METRICS_T_SYSTEM_PRESENCE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getAlternateTimeDimensionAllowableValues()
    {
        return [
            self::ALTERNATE_TIME_DIMENSION_EVENT_TIME,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['interval'] = isset($data['interval']) ? $data['interval'] : null;
        $this->container['granularity'] = isset($data['granularity']) ? $data['granularity'] : null;
        $this->container['timeZone'] = isset($data['timeZone']) ? $data['timeZone'] : null;
        $this->container['groupBy'] = isset($data['groupBy']) ? $data['groupBy'] : null;
        $this->container['filter'] = isset($data['filter']) ? $data['filter'] : null;
        $this->container['metrics'] = isset($data['metrics']) ? $data['metrics'] : null;
        $this->container['flattenMultivaluedDimensions'] = isset($data['flattenMultivaluedDimensions']) ? $data['flattenMultivaluedDimensions'] : null;
        $this->container['views'] = isset($data['views']) ? $data['views'] : null;
        $this->container['alternateTimeDimension'] = isset($data['alternateTimeDimension']) ? $data['alternateTimeDimension'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['interval'] === null) {
            $invalid_properties[] = "'interval' can't be null";
        }
        $allowed_values = array("eventTime");
        if (!in_array($this->container['alternateTimeDimension'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'alternateTimeDimension', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['interval'] === null) {
            return false;
        }
        $allowed_values = array("eventTime");
        if (!in_array($this->container['alternateTimeDimension'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets interval
     * @return string
     */
    public function getInterval()
    {
        return $this->container['interval'];
    }

    /**
     * Sets interval
     * @param string $interval Behaves like one clause in a SQL WHERE. Specifies the date and time range of data being queried. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss
     * @return $this
     */
    public function setInterval($interval)
    {
        $this->container['interval'] = $interval;

        return $this;
    }

    /**
     * Gets granularity
     * @return string
     */
    public function getGranularity()
    {
        return $this->container['granularity'];
    }

    /**
     * Sets granularity
     * @param string $granularity Granularity aggregates metrics into subpartitions within the time interval specified. The default granularity is the same duration as the interval. Periods are represented as an ISO-8601 string. For example: P1D or P1DT12H
     * @return $this
     */
    public function setGranularity($granularity)
    {
        $this->container['granularity'] = $granularity;

        return $this;
    }

    /**
     * Gets timeZone
     * @return string
     */
    public function getTimeZone()
    {
        return $this->container['timeZone'];
    }

    /**
     * Sets timeZone
     * @param string $timeZone Time zone context used to calculate response intervals (this allows resolving DST changes). The interval offset is used even when timeZone is specified. Default is UTC. Time zones are represented as a string of the zone name as found in the IANA time zone database. For example: UTC, Etc/UTC, or Europe/London
     * @return $this
     */
    public function setTimeZone($timeZone)
    {
        $this->container['timeZone'] = $timeZone;

        return $this;
    }

    /**
     * Gets groupBy
     * @return string[]
     */
    public function getGroupBy()
    {
        return $this->container['groupBy'];
    }

    /**
     * Sets groupBy
     * @param string[] $groupBy Behaves like a SQL GROUPBY. Allows for multiple levels of grouping as a list of dimensions. Partitions resulting aggregate computations into distinct named subgroups rather than across the entire result set as if it were one group.
     * @return $this
     */
    public function setGroupBy($groupBy)
    {
        $allowed_values = array('organizationPresenceId', 'routingStatus', 'systemPresence', 'userId');
        if (!in_array($groupBy, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'groupBy', must be one of 'organizationPresenceId', 'routingStatus', 'systemPresence', 'userId'");
        }
        $this->container['groupBy'] = $groupBy;

        return $this;
    }

    /**
     * Gets filter
     * @return \PureCloudSDK\UserAggregateQueryFilter
     */
    public function getFilter()
    {
        return $this->container['filter'];
    }

    /**
     * Sets filter
     * @param \PureCloudSDK\UserAggregateQueryFilter $filter Behaves like a SQL WHERE clause. This is ANDed with the interval parameter. Expresses boolean logical predicates as well as dimensional filters
     * @return $this
     */
    public function setFilter($filter)
    {
        $this->container['filter'] = $filter;

        return $this;
    }

    /**
     * Gets metrics
     * @return string[]
     */
    public function getMetrics()
    {
        return $this->container['metrics'];
    }

    /**
     * Sets metrics
     * @param string[] $metrics Behaves like a SQL SELECT clause. Enables retrieving only named metrics. If omitted, all metrics that are available will be returned (like SELECT *).
     * @return $this
     */
    public function setMetrics($metrics)
    {
        $allowed_values = array('tAgentRoutingStatus', 'tOrganizationPresence', 'tSystemPresence');
        if (!in_array($metrics, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'metrics', must be one of 'tAgentRoutingStatus', 'tOrganizationPresence', 'tSystemPresence'");
        }
        $this->container['metrics'] = $metrics;

        return $this;
    }

    /**
     * Gets flattenMultivaluedDimensions
     * @return bool
     */
    public function getFlattenMultivaluedDimensions()
    {
        return $this->container['flattenMultivaluedDimensions'];
    }

    /**
     * Sets flattenMultivaluedDimensions
     * @param bool $flattenMultivaluedDimensions Flattens any multivalued dimensions used in response groups (e.g. ['a','b','c']->'a,b,c')
     * @return $this
     */
    public function setFlattenMultivaluedDimensions($flattenMultivaluedDimensions)
    {
        $this->container['flattenMultivaluedDimensions'] = $flattenMultivaluedDimensions;

        return $this;
    }

    /**
     * Gets views
     * @return \PureCloudSDK\UserAggregationView[]
     */
    public function getViews()
    {
        return $this->container['views'];
    }

    /**
     * Sets views
     * @param \PureCloudSDK\UserAggregationView[] $views Custom derived metric views
     * @return $this
     */
    public function setViews($views)
    {
        $this->container['views'] = $views;

        return $this;
    }

    /**
     * Gets alternateTimeDimension
     * @return string
     */
    public function getAlternateTimeDimension()
    {
        return $this->container['alternateTimeDimension'];
    }

    /**
     * Sets alternateTimeDimension
     * @param string $alternateTimeDimension Dimension to use as the alternative timestamp for data in the aggregate.  Choosing \"eventTime\" uses the actual time of the data event.
     * @return $this
     */
    public function setAlternateTimeDimension($alternateTimeDimension)
    {
        $allowed_values = array('eventTime');
        if (!in_array($alternateTimeDimension, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'alternateTimeDimension', must be one of 'eventTime'");
        }
        $this->container['alternateTimeDimension'] = $alternateTimeDimension;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
