<?php

/**
 * UserStations
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * UserStations Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class UserStations implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'UserStations';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'associatedStation' => '\PureCloudSDK\UserStation',
        'effectiveStation' => '\PureCloudSDK\UserStation',
        'defaultStation' => '\PureCloudSDK\UserStation',
        'lastAssociatedStation' => '\PureCloudSDK\UserStation'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'associatedStation' => 'associatedStation',
        'effectiveStation' => 'effectiveStation',
        'defaultStation' => 'defaultStation',
        'lastAssociatedStation' => 'lastAssociatedStation'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'associatedStation' => 'setAssociatedStation',
        'effectiveStation' => 'setEffectiveStation',
        'defaultStation' => 'setDefaultStation',
        'lastAssociatedStation' => 'setLastAssociatedStation'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'associatedStation' => 'getAssociatedStation',
        'effectiveStation' => 'getEffectiveStation',
        'defaultStation' => 'getDefaultStation',
        'lastAssociatedStation' => 'getLastAssociatedStation'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['associatedStation'] = isset($data['associatedStation']) ? $data['associatedStation'] : null;
        $this->container['effectiveStation'] = isset($data['effectiveStation']) ? $data['effectiveStation'] : null;
        $this->container['defaultStation'] = isset($data['defaultStation']) ? $data['defaultStation'] : null;
        $this->container['lastAssociatedStation'] = isset($data['lastAssociatedStation']) ? $data['lastAssociatedStation'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets associatedStation
     * @return \PureCloudSDK\UserStation
     */
    public function getAssociatedStation()
    {
        return $this->container['associatedStation'];
    }

    /**
     * Sets associatedStation
     * @param \PureCloudSDK\UserStation $associatedStation Current associated station for this user.
     * @return $this
     */
    public function setAssociatedStation($associatedStation)
    {
        $this->container['associatedStation'] = $associatedStation;

        return $this;
    }

    /**
     * Gets effectiveStation
     * @return \PureCloudSDK\UserStation
     */
    public function getEffectiveStation()
    {
        return $this->container['effectiveStation'];
    }

    /**
     * Sets effectiveStation
     * @param \PureCloudSDK\UserStation $effectiveStation The station where the user can be reached based on their default and associated station.
     * @return $this
     */
    public function setEffectiveStation($effectiveStation)
    {
        $this->container['effectiveStation'] = $effectiveStation;

        return $this;
    }

    /**
     * Gets defaultStation
     * @return \PureCloudSDK\UserStation
     */
    public function getDefaultStation()
    {
        return $this->container['defaultStation'];
    }

    /**
     * Sets defaultStation
     * @param \PureCloudSDK\UserStation $defaultStation Default station to be used if not associated with a station.
     * @return $this
     */
    public function setDefaultStation($defaultStation)
    {
        $this->container['defaultStation'] = $defaultStation;

        return $this;
    }

    /**
     * Gets lastAssociatedStation
     * @return \PureCloudSDK\UserStation
     */
    public function getLastAssociatedStation()
    {
        return $this->container['lastAssociatedStation'];
    }

    /**
     * Sets lastAssociatedStation
     * @param \PureCloudSDK\UserStation $lastAssociatedStation Last associated station for this user.
     * @return $this
     */
    public function setLastAssociatedStation($lastAssociatedStation)
    {
        $this->container['lastAssociatedStation'] = $lastAssociatedStation;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
