<?php

/**
 * CalibrationCreate
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * CalibrationCreate Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CalibrationCreate implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CalibrationCreate';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'calibrator' => '\PureCloudSDK\User',
        'agent' => '\PureCloudSDK\User',
        'conversation' => '\PureCloudSDK\Conversation',
        'evaluationForm' => '\PureCloudSDK\EvaluationForm',
        'contextId' => 'string',
        'averageScore' => 'int',
        'highScore' => 'int',
        'lowScore' => 'int',
        'createdDate' => '\DateTime',
        'evaluations' => '\PureCloudSDK\Evaluation[]',
        'evaluators' => '\PureCloudSDK\User[]',
        'scoringIndex' => '\PureCloudSDK\Evaluation',
        'expertEvaluator' => '\PureCloudSDK\User',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'calibrator' => 'calibrator',
        'agent' => 'agent',
        'conversation' => 'conversation',
        'evaluationForm' => 'evaluationForm',
        'contextId' => 'contextId',
        'averageScore' => 'averageScore',
        'highScore' => 'highScore',
        'lowScore' => 'lowScore',
        'createdDate' => 'createdDate',
        'evaluations' => 'evaluations',
        'evaluators' => 'evaluators',
        'scoringIndex' => 'scoringIndex',
        'expertEvaluator' => 'expertEvaluator',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'calibrator' => 'setCalibrator',
        'agent' => 'setAgent',
        'conversation' => 'setConversation',
        'evaluationForm' => 'setEvaluationForm',
        'contextId' => 'setContextId',
        'averageScore' => 'setAverageScore',
        'highScore' => 'setHighScore',
        'lowScore' => 'setLowScore',
        'createdDate' => 'setCreatedDate',
        'evaluations' => 'setEvaluations',
        'evaluators' => 'setEvaluators',
        'scoringIndex' => 'setScoringIndex',
        'expertEvaluator' => 'setExpertEvaluator',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'calibrator' => 'getCalibrator',
        'agent' => 'getAgent',
        'conversation' => 'getConversation',
        'evaluationForm' => 'getEvaluationForm',
        'contextId' => 'getContextId',
        'averageScore' => 'getAverageScore',
        'highScore' => 'getHighScore',
        'lowScore' => 'getLowScore',
        'createdDate' => 'getCreatedDate',
        'evaluations' => 'getEvaluations',
        'evaluators' => 'getEvaluators',
        'scoringIndex' => 'getScoringIndex',
        'expertEvaluator' => 'getExpertEvaluator',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['calibrator'] = isset($data['calibrator']) ? $data['calibrator'] : null;
        $this->container['agent'] = isset($data['agent']) ? $data['agent'] : null;
        $this->container['conversation'] = isset($data['conversation']) ? $data['conversation'] : null;
        $this->container['evaluationForm'] = isset($data['evaluationForm']) ? $data['evaluationForm'] : null;
        $this->container['contextId'] = isset($data['contextId']) ? $data['contextId'] : null;
        $this->container['averageScore'] = isset($data['averageScore']) ? $data['averageScore'] : null;
        $this->container['highScore'] = isset($data['highScore']) ? $data['highScore'] : null;
        $this->container['lowScore'] = isset($data['lowScore']) ? $data['lowScore'] : null;
        $this->container['createdDate'] = isset($data['createdDate']) ? $data['createdDate'] : null;
        $this->container['evaluations'] = isset($data['evaluations']) ? $data['evaluations'] : null;
        $this->container['evaluators'] = isset($data['evaluators']) ? $data['evaluators'] : null;
        $this->container['scoringIndex'] = isset($data['scoringIndex']) ? $data['scoringIndex'] : null;
        $this->container['expertEvaluator'] = isset($data['expertEvaluator']) ? $data['expertEvaluator'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['conversation'] === null) {
            $invalid_properties[] = "'conversation' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['conversation'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets calibrator
     * @return \PureCloudSDK\User
     */
    public function getCalibrator()
    {
        return $this->container['calibrator'];
    }

    /**
     * Sets calibrator
     * @param \PureCloudSDK\User $calibrator
     * @return $this
     */
    public function setCalibrator($calibrator)
    {
        $this->container['calibrator'] = $calibrator;

        return $this;
    }

    /**
     * Gets agent
     * @return \PureCloudSDK\User
     */
    public function getAgent()
    {
        return $this->container['agent'];
    }

    /**
     * Sets agent
     * @param \PureCloudSDK\User $agent
     * @return $this
     */
    public function setAgent($agent)
    {
        $this->container['agent'] = $agent;

        return $this;
    }

    /**
     * Gets conversation
     * @return \PureCloudSDK\Conversation
     */
    public function getConversation()
    {
        return $this->container['conversation'];
    }

    /**
     * Sets conversation
     * @param \PureCloudSDK\Conversation $conversation The conversation to use for the calibration.
     * @return $this
     */
    public function setConversation($conversation)
    {
        $this->container['conversation'] = $conversation;

        return $this;
    }

    /**
     * Gets evaluationForm
     * @return \PureCloudSDK\EvaluationForm
     */
    public function getEvaluationForm()
    {
        return $this->container['evaluationForm'];
    }

    /**
     * Sets evaluationForm
     * @param \PureCloudSDK\EvaluationForm $evaluationForm
     * @return $this
     */
    public function setEvaluationForm($evaluationForm)
    {
        $this->container['evaluationForm'] = $evaluationForm;

        return $this;
    }

    /**
     * Gets contextId
     * @return string
     */
    public function getContextId()
    {
        return $this->container['contextId'];
    }

    /**
     * Sets contextId
     * @param string $contextId
     * @return $this
     */
    public function setContextId($contextId)
    {
        $this->container['contextId'] = $contextId;

        return $this;
    }

    /**
     * Gets averageScore
     * @return int
     */
    public function getAverageScore()
    {
        return $this->container['averageScore'];
    }

    /**
     * Sets averageScore
     * @param int $averageScore
     * @return $this
     */
    public function setAverageScore($averageScore)
    {
        $this->container['averageScore'] = $averageScore;

        return $this;
    }

    /**
     * Gets highScore
     * @return int
     */
    public function getHighScore()
    {
        return $this->container['highScore'];
    }

    /**
     * Sets highScore
     * @param int $highScore
     * @return $this
     */
    public function setHighScore($highScore)
    {
        $this->container['highScore'] = $highScore;

        return $this;
    }

    /**
     * Gets lowScore
     * @return int
     */
    public function getLowScore()
    {
        return $this->container['lowScore'];
    }

    /**
     * Sets lowScore
     * @param int $lowScore
     * @return $this
     */
    public function setLowScore($lowScore)
    {
        $this->container['lowScore'] = $lowScore;

        return $this;
    }

    /**
     * Gets createdDate
     * @return \DateTime
     */
    public function getCreatedDate()
    {
        return $this->container['createdDate'];
    }

    /**
     * Sets createdDate
     * @param \DateTime $createdDate Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCreatedDate($createdDate)
    {
        $this->container['createdDate'] = $createdDate;

        return $this;
    }

    /**
     * Gets evaluations
     * @return \PureCloudSDK\Evaluation[]
     */
    public function getEvaluations()
    {
        return $this->container['evaluations'];
    }

    /**
     * Sets evaluations
     * @param \PureCloudSDK\Evaluation[] $evaluations
     * @return $this
     */
    public function setEvaluations($evaluations)
    {
        $this->container['evaluations'] = $evaluations;

        return $this;
    }

    /**
     * Gets evaluators
     * @return \PureCloudSDK\User[]
     */
    public function getEvaluators()
    {
        return $this->container['evaluators'];
    }

    /**
     * Sets evaluators
     * @param \PureCloudSDK\User[] $evaluators
     * @return $this
     */
    public function setEvaluators($evaluators)
    {
        $this->container['evaluators'] = $evaluators;

        return $this;
    }

    /**
     * Gets scoringIndex
     * @return \PureCloudSDK\Evaluation
     */
    public function getScoringIndex()
    {
        return $this->container['scoringIndex'];
    }

    /**
     * Sets scoringIndex
     * @param \PureCloudSDK\Evaluation $scoringIndex
     * @return $this
     */
    public function setScoringIndex($scoringIndex)
    {
        $this->container['scoringIndex'] = $scoringIndex;

        return $this;
    }

    /**
     * Gets expertEvaluator
     * @return \PureCloudSDK\User
     */
    public function getExpertEvaluator()
    {
        return $this->container['expertEvaluator'];
    }

    /**
     * Sets expertEvaluator
     * @param \PureCloudSDK\User $expertEvaluator
     * @return $this
     */
    public function setExpertEvaluator($expertEvaluator)
    {
        $this->container['expertEvaluator'] = $expertEvaluator;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


