<?php

/**
 * FaxStatus
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * FaxStatus Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class FaxStatus implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'FaxStatus';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'direction' => 'string',
        'expectedPages' => 'int',
        'activePage' => 'int',
        'linesTransmitted' => 'int',
        'bytesTransmitted' => 'int',
        'baudRate' => 'int',
        'pageErrors' => 'int',
        'lineErrors' => 'int'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'direction' => 'direction',
        'expectedPages' => 'expectedPages',
        'activePage' => 'activePage',
        'linesTransmitted' => 'linesTransmitted',
        'bytesTransmitted' => 'bytesTransmitted',
        'baudRate' => 'baudRate',
        'pageErrors' => 'pageErrors',
        'lineErrors' => 'lineErrors'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'direction' => 'setDirection',
        'expectedPages' => 'setExpectedPages',
        'activePage' => 'setActivePage',
        'linesTransmitted' => 'setLinesTransmitted',
        'bytesTransmitted' => 'setBytesTransmitted',
        'baudRate' => 'setBaudRate',
        'pageErrors' => 'setPageErrors',
        'lineErrors' => 'setLineErrors'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'direction' => 'getDirection',
        'expectedPages' => 'getExpectedPages',
        'activePage' => 'getActivePage',
        'linesTransmitted' => 'getLinesTransmitted',
        'bytesTransmitted' => 'getBytesTransmitted',
        'baudRate' => 'getBaudRate',
        'pageErrors' => 'getPageErrors',
        'lineErrors' => 'getLineErrors'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['direction'] = isset($data['direction']) ? $data['direction'] : null;
        $this->container['expectedPages'] = isset($data['expectedPages']) ? $data['expectedPages'] : null;
        $this->container['activePage'] = isset($data['activePage']) ? $data['activePage'] : null;
        $this->container['linesTransmitted'] = isset($data['linesTransmitted']) ? $data['linesTransmitted'] : null;
        $this->container['bytesTransmitted'] = isset($data['bytesTransmitted']) ? $data['bytesTransmitted'] : null;
        $this->container['baudRate'] = isset($data['baudRate']) ? $data['baudRate'] : null;
        $this->container['pageErrors'] = isset($data['pageErrors']) ? $data['pageErrors'] : null;
        $this->container['lineErrors'] = isset($data['lineErrors']) ? $data['lineErrors'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets direction
     * @return string
     */
    public function getDirection()
    {
        return $this->container['direction'];
    }

    /**
     * Sets direction
     * @param string $direction The fax direction, either \"send\" or \"receive\".
     * @return $this
     */
    public function setDirection($direction)
    {
        $this->container['direction'] = $direction;

        return $this;
    }

    /**
     * Gets expectedPages
     * @return int
     */
    public function getExpectedPages()
    {
        return $this->container['expectedPages'];
    }

    /**
     * Sets expectedPages
     * @param int $expectedPages Total number of expected pages, if known.
     * @return $this
     */
    public function setExpectedPages($expectedPages)
    {
        $this->container['expectedPages'] = $expectedPages;

        return $this;
    }

    /**
     * Gets activePage
     * @return int
     */
    public function getActivePage()
    {
        return $this->container['activePage'];
    }

    /**
     * Sets activePage
     * @param int $activePage Active page of the transmission.
     * @return $this
     */
    public function setActivePage($activePage)
    {
        $this->container['activePage'] = $activePage;

        return $this;
    }

    /**
     * Gets linesTransmitted
     * @return int
     */
    public function getLinesTransmitted()
    {
        return $this->container['linesTransmitted'];
    }

    /**
     * Sets linesTransmitted
     * @param int $linesTransmitted Number of lines that have completed transmission.
     * @return $this
     */
    public function setLinesTransmitted($linesTransmitted)
    {
        $this->container['linesTransmitted'] = $linesTransmitted;

        return $this;
    }

    /**
     * Gets bytesTransmitted
     * @return int
     */
    public function getBytesTransmitted()
    {
        return $this->container['bytesTransmitted'];
    }

    /**
     * Sets bytesTransmitted
     * @param int $bytesTransmitted Number of bytes that have competed transmission.
     * @return $this
     */
    public function setBytesTransmitted($bytesTransmitted)
    {
        $this->container['bytesTransmitted'] = $bytesTransmitted;

        return $this;
    }

    /**
     * Gets baudRate
     * @return int
     */
    public function getBaudRate()
    {
        return $this->container['baudRate'];
    }

    /**
     * Sets baudRate
     * @param int $baudRate Current signaling rate of transmission, baud rate.
     * @return $this
     */
    public function setBaudRate($baudRate)
    {
        $this->container['baudRate'] = $baudRate;

        return $this;
    }

    /**
     * Gets pageErrors
     * @return int
     */
    public function getPageErrors()
    {
        return $this->container['pageErrors'];
    }

    /**
     * Sets pageErrors
     * @param int $pageErrors Number of page errors.
     * @return $this
     */
    public function setPageErrors($pageErrors)
    {
        $this->container['pageErrors'] = $pageErrors;

        return $this;
    }

    /**
     * Gets lineErrors
     * @return int
     */
    public function getLineErrors()
    {
        return $this->container['lineErrors'];
    }

    /**
     * Sets lineErrors
     * @param int $lineErrors Number of line errors.
     * @return $this
     */
    public function setLineErrors($lineErrors)
    {
        $this->container['lineErrors'] = $lineErrors;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


