<?php

/**
 * ManagementUnit
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ManagementUnit Class Doc Comment
 *
 * @category    Class */
 // @description Management Unit object for Workforce Management
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ManagementUnit implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ManagementUnit';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'division' => '\PureCloudSDK\Division',
        'startDayOfWeek' => 'string',
        'timeZone' => 'string',
        'settings' => '\PureCloudSDK\ManagementUnitSettings',
        'version' => 'int',
        'dateModified' => '\DateTime',
        'modifiedBy' => '\PureCloudSDK\UserReference',
        'metadata' => '\PureCloudSDK\WfmVersionedEntityMetadata',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'division' => 'division',
        'startDayOfWeek' => 'startDayOfWeek',
        'timeZone' => 'timeZone',
        'settings' => 'settings',
        'version' => 'version',
        'dateModified' => 'dateModified',
        'modifiedBy' => 'modifiedBy',
        'metadata' => 'metadata',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'division' => 'setDivision',
        'startDayOfWeek' => 'setStartDayOfWeek',
        'timeZone' => 'setTimeZone',
        'settings' => 'setSettings',
        'version' => 'setVersion',
        'dateModified' => 'setDateModified',
        'modifiedBy' => 'setModifiedBy',
        'metadata' => 'setMetadata',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'division' => 'getDivision',
        'startDayOfWeek' => 'getStartDayOfWeek',
        'timeZone' => 'getTimeZone',
        'settings' => 'getSettings',
        'version' => 'getVersion',
        'dateModified' => 'getDateModified',
        'modifiedBy' => 'getModifiedBy',
        'metadata' => 'getMetadata',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const START_DAY_OF_WEEK_SUNDAY = 'Sunday';
    public const START_DAY_OF_WEEK_MONDAY = 'Monday';
    public const START_DAY_OF_WEEK_TUESDAY = 'Tuesday';
    public const START_DAY_OF_WEEK_WEDNESDAY = 'Wednesday';
    public const START_DAY_OF_WEEK_THURSDAY = 'Thursday';
    public const START_DAY_OF_WEEK_FRIDAY = 'Friday';
    public const START_DAY_OF_WEEK_SATURDAY = 'Saturday';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStartDayOfWeekAllowableValues()
    {
        return [
            self::START_DAY_OF_WEEK_SUNDAY,
            self::START_DAY_OF_WEEK_MONDAY,
            self::START_DAY_OF_WEEK_TUESDAY,
            self::START_DAY_OF_WEEK_WEDNESDAY,
            self::START_DAY_OF_WEEK_THURSDAY,
            self::START_DAY_OF_WEEK_FRIDAY,
            self::START_DAY_OF_WEEK_SATURDAY,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['division'] = isset($data['division']) ? $data['division'] : null;
        $this->container['startDayOfWeek'] = isset($data['startDayOfWeek']) ? $data['startDayOfWeek'] : null;
        $this->container['timeZone'] = isset($data['timeZone']) ? $data['timeZone'] : null;
        $this->container['settings'] = isset($data['settings']) ? $data['settings'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['dateModified'] = isset($data['dateModified']) ? $data['dateModified'] : null;
        $this->container['modifiedBy'] = isset($data['modifiedBy']) ? $data['modifiedBy'] : null;
        $this->container['metadata'] = isset($data['metadata']) ? $data['metadata'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday");
        if (!in_array($this->container['startDayOfWeek'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'startDayOfWeek', must be one of #{allowed_values}.";
        }

        if ($this->container['version'] === null) {
            $invalid_properties[] = "'version' can't be null";
        }
        if ($this->container['metadata'] === null) {
            $invalid_properties[] = "'metadata' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday");
        if (!in_array($this->container['startDayOfWeek'], $allowed_values)) {
            return false;
        }
        if ($this->container['version'] === null) {
            return false;
        }
        if ($this->container['metadata'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets division
     * @return \PureCloudSDK\Division
     */
    public function getDivision()
    {
        return $this->container['division'];
    }

    /**
     * Sets division
     * @param \PureCloudSDK\Division $division The division to which this entity belongs.
     * @return $this
     */
    public function setDivision($division)
    {
        $this->container['division'] = $division;

        return $this;
    }

    /**
     * Gets startDayOfWeek
     * @return string
     */
    public function getStartDayOfWeek()
    {
        return $this->container['startDayOfWeek'];
    }

    /**
     * Sets startDayOfWeek
     * @param string $startDayOfWeek Start day of week for scheduling and forecasting purposes
     * @return $this
     */
    public function setStartDayOfWeek($startDayOfWeek)
    {
        $allowed_values = array('Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday');
        if (!in_array($startDayOfWeek, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'startDayOfWeek', must be one of 'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'");
        }
        $this->container['startDayOfWeek'] = $startDayOfWeek;

        return $this;
    }

    /**
     * Gets timeZone
     * @return string
     */
    public function getTimeZone()
    {
        return $this->container['timeZone'];
    }

    /**
     * Sets timeZone
     * @param string $timeZone The time zone for the management unit in standard Olson Format (See https://en.wikipedia.org/wiki/Tz_database)
     * @return $this
     */
    public function setTimeZone($timeZone)
    {
        $this->container['timeZone'] = $timeZone;

        return $this;
    }

    /**
     * Gets settings
     * @return \PureCloudSDK\ManagementUnitSettings
     */
    public function getSettings()
    {
        return $this->container['settings'];
    }

    /**
     * Sets settings
     * @param \PureCloudSDK\ManagementUnitSettings $settings The configuration settings for this management unit
     * @return $this
     */
    public function setSettings($settings)
    {
        $this->container['settings'] = $settings;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version The version of the underlying entity.  Deprecated, use metadata field instead
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets dateModified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['dateModified'];
    }

    /**
     * Sets dateModified
     * @param \DateTime $dateModified The date and time at which this entity was last modified.  Deprecated, use metadata field instead. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($dateModified)
    {
        $this->container['dateModified'] = $dateModified;

        return $this;
    }

    /**
     * Gets modifiedBy
     * @return \PureCloudSDK\UserReference
     */
    public function getModifiedBy()
    {
        return $this->container['modifiedBy'];
    }

    /**
     * Sets modifiedBy
     * @param \PureCloudSDK\UserReference $modifiedBy The user who last modified this entity.  Deprecated, use metadata field instead
     * @return $this
     */
    public function setModifiedBy($modifiedBy)
    {
        $this->container['modifiedBy'] = $modifiedBy;

        return $this;
    }

    /**
     * Gets metadata
     * @return \PureCloudSDK\WfmVersionedEntityMetadata
     */
    public function getMetadata()
    {
        return $this->container['metadata'];
    }

    /**
     * Sets metadata
     * @param \PureCloudSDK\WfmVersionedEntityMetadata $metadata Version info metadata for this management unit
     * @return $this
     */
    public function setMetadata($metadata)
    {
        $this->container['metadata'] = $metadata;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


