<?php

/**
 * UserListScheduleRequestBody
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * UserListScheduleRequestBody Class Doc Comment
 *
 * @category    Class */
 // @description Request body for fetching the schedule for a group of users over a given time range
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class UserListScheduleRequestBody implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'UserListScheduleRequestBody';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'userIds' => 'string[]',
        'startDate' => '\DateTime',
        'endDate' => '\DateTime',
        'loadFullWeeks' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'userIds' => 'userIds',
        'startDate' => 'startDate',
        'endDate' => 'endDate',
        'loadFullWeeks' => 'loadFullWeeks'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'userIds' => 'setUserIds',
        'startDate' => 'setStartDate',
        'endDate' => 'setEndDate',
        'loadFullWeeks' => 'setLoadFullWeeks'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'userIds' => 'getUserIds',
        'startDate' => 'getStartDate',
        'endDate' => 'getEndDate',
        'loadFullWeeks' => 'getLoadFullWeeks'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['userIds'] = isset($data['userIds']) ? $data['userIds'] : null;
        $this->container['startDate'] = isset($data['startDate']) ? $data['startDate'] : null;
        $this->container['endDate'] = isset($data['endDate']) ? $data['endDate'] : null;
        $this->container['loadFullWeeks'] = isset($data['loadFullWeeks']) ? $data['loadFullWeeks'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['userIds'] === null) {
            $invalid_properties[] = "'userIds' can't be null";
        }
        if ($this->container['startDate'] === null) {
            $invalid_properties[] = "'startDate' can't be null";
        }
        if ($this->container['endDate'] === null) {
            $invalid_properties[] = "'endDate' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['userIds'] === null) {
            return false;
        }
        if ($this->container['startDate'] === null) {
            return false;
        }
        if ($this->container['endDate'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets userIds
     * @return string[]
     */
    public function getUserIds()
    {
        return $this->container['userIds'];
    }

    /**
     * Sets userIds
     * @param string[] $userIds The user ids for which to fetch schedules
     * @return $this
     */
    public function setUserIds($userIds)
    {
        $this->container['userIds'] = $userIds;

        return $this;
    }

    /**
     * Gets startDate
     * @return \DateTime
     */
    public function getStartDate()
    {
        return $this->container['startDate'];
    }

    /**
     * Sets startDate
     * @param \DateTime $startDate Beginning of the range of schedules to fetch, in ISO-8601 format
     * @return $this
     */
    public function setStartDate($startDate)
    {
        $this->container['startDate'] = $startDate;

        return $this;
    }

    /**
     * Gets endDate
     * @return \DateTime
     */
    public function getEndDate()
    {
        return $this->container['endDate'];
    }

    /**
     * Sets endDate
     * @param \DateTime $endDate End of the range of schedules to fetch, in ISO-8601 format
     * @return $this
     */
    public function setEndDate($endDate)
    {
        $this->container['endDate'] = $endDate;

        return $this;
    }

    /**
     * Gets loadFullWeeks
     * @return bool
     */
    public function getLoadFullWeeks()
    {
        return $this->container['loadFullWeeks'];
    }

    /**
     * Sets loadFullWeeks
     * @param bool $loadFullWeeks Whether to load the full week's schedule (for the requested users) of any week overlapping the start/end date query parameters, defaults to false
     * @return $this
     */
    public function setLoadFullWeeks($loadFullWeeks)
    {
        $this->container['loadFullWeeks'] = $loadFullWeeks;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


