<?php
/**
 * ActivityCode
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ActivityCode Class Doc Comment
 *
 * @category    Class */
 // @description Activity code data
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ActivityCode implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ActivityCode';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'name' => 'string',
        'isActive' => 'bool',
        'isDefault' => 'bool',
        'category' => 'string',
        'lengthInMinutes' => 'int',
        'countsAsPaidTime' => 'bool',
        'countsAsWorkTime' => 'bool',
        'isAgentTimeOffSelectable' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'name' => 'name',
        'isActive' => 'isActive',
        'isDefault' => 'isDefault',
        'category' => 'category',
        'lengthInMinutes' => 'lengthInMinutes',
        'countsAsPaidTime' => 'countsAsPaidTime',
        'countsAsWorkTime' => 'countsAsWorkTime',
        'isAgentTimeOffSelectable' => 'isAgentTimeOffSelectable'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'name' => 'setName',
        'isActive' => 'setIsActive',
        'isDefault' => 'setIsDefault',
        'category' => 'setCategory',
        'lengthInMinutes' => 'setLengthInMinutes',
        'countsAsPaidTime' => 'setCountsAsPaidTime',
        'countsAsWorkTime' => 'setCountsAsWorkTime',
        'isAgentTimeOffSelectable' => 'setIsAgentTimeOffSelectable'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'name' => 'getName',
        'isActive' => 'getIsActive',
        'isDefault' => 'getIsDefault',
        'category' => 'getCategory',
        'lengthInMinutes' => 'getLengthInMinutes',
        'countsAsPaidTime' => 'getCountsAsPaidTime',
        'countsAsWorkTime' => 'getCountsAsWorkTime',
        'isAgentTimeOffSelectable' => 'getIsAgentTimeOffSelectable'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const CATEGORY_ON_QUEUE_WORK = 'OnQueueWork';
    const CATEGORY_BREAK = 'Break';
    const CATEGORY_MEAL = 'Meal';
    const CATEGORY_MEETING = 'Meeting';
    const CATEGORY_OFF_QUEUE_WORK = 'OffQueueWork';
    const CATEGORY_TIME_OFF = 'TimeOff';
    const CATEGORY_TRAINING = 'Training';
    const CATEGORY_UNAVAILABLE = 'Unavailable';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getCategoryAllowableValues()
    {
        return [
            self::CATEGORY_ON_QUEUE_WORK,
            self::CATEGORY_BREAK,
            self::CATEGORY_MEAL,
            self::CATEGORY_MEETING,
            self::CATEGORY_OFF_QUEUE_WORK,
            self::CATEGORY_TIME_OFF,
            self::CATEGORY_TRAINING,
            self::CATEGORY_UNAVAILABLE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['isActive'] = isset($data['isActive']) ? $data['isActive'] : null;
        $this->container['isDefault'] = isset($data['isDefault']) ? $data['isDefault'] : null;
        $this->container['category'] = isset($data['category']) ? $data['category'] : null;
        $this->container['lengthInMinutes'] = isset($data['lengthInMinutes']) ? $data['lengthInMinutes'] : null;
        $this->container['countsAsPaidTime'] = isset($data['countsAsPaidTime']) ? $data['countsAsPaidTime'] : null;
        $this->container['countsAsWorkTime'] = isset($data['countsAsWorkTime']) ? $data['countsAsWorkTime'] : null;
        $this->container['isAgentTimeOffSelectable'] = isset($data['isAgentTimeOffSelectable']) ? $data['isAgentTimeOffSelectable'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("OnQueueWork", "Break", "Meal", "Meeting", "OffQueueWork", "TimeOff", "Training", "Unavailable");
        if (!in_array($this->container['category'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'category', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("OnQueueWork", "Break", "Meal", "Meeting", "OffQueueWork", "TimeOff", "Training", "Unavailable");
        if (!in_array($this->container['category'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The activity code's name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets isActive
     * @return bool
     */
    public function getIsActive()
    {
        return $this->container['isActive'];
    }

    /**
     * Sets isActive
     * @param bool $isActive Whether this activity code is active or only used for historical schedules
     * @return $this
     */
    public function setIsActive($isActive)
    {
        $this->container['isActive'] = $isActive;

        return $this;
    }

    /**
     * Gets isDefault
     * @return bool
     */
    public function getIsDefault()
    {
        return $this->container['isDefault'];
    }

    /**
     * Sets isDefault
     * @param bool $isDefault Whether this is a default activity code
     * @return $this
     */
    public function setIsDefault($isDefault)
    {
        $this->container['isDefault'] = $isDefault;

        return $this;
    }

    /**
     * Gets category
     * @return string
     */
    public function getCategory()
    {
        return $this->container['category'];
    }

    /**
     * Sets category
     * @param string $category The activity code's category
     * @return $this
     */
    public function setCategory($category)
    {
        $allowed_values = array('OnQueueWork', 'Break', 'Meal', 'Meeting', 'OffQueueWork', 'TimeOff', 'Training', 'Unavailable');
        if (!in_array($category, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'category', must be one of 'OnQueueWork', 'Break', 'Meal', 'Meeting', 'OffQueueWork', 'TimeOff', 'Training', 'Unavailable'");
        }
        $this->container['category'] = $category;

        return $this;
    }

    /**
     * Gets lengthInMinutes
     * @return int
     */
    public function getLengthInMinutes()
    {
        return $this->container['lengthInMinutes'];
    }

    /**
     * Sets lengthInMinutes
     * @param int $lengthInMinutes The default length of the activity in minutes
     * @return $this
     */
    public function setLengthInMinutes($lengthInMinutes)
    {
        $this->container['lengthInMinutes'] = $lengthInMinutes;

        return $this;
    }

    /**
     * Gets countsAsPaidTime
     * @return bool
     */
    public function getCountsAsPaidTime()
    {
        return $this->container['countsAsPaidTime'];
    }

    /**
     * Sets countsAsPaidTime
     * @param bool $countsAsPaidTime Whether an agent is paid while performing this activity
     * @return $this
     */
    public function setCountsAsPaidTime($countsAsPaidTime)
    {
        $this->container['countsAsPaidTime'] = $countsAsPaidTime;

        return $this;
    }

    /**
     * Gets countsAsWorkTime
     * @return bool
     */
    public function getCountsAsWorkTime()
    {
        return $this->container['countsAsWorkTime'];
    }

    /**
     * Sets countsAsWorkTime
     * @param bool $countsAsWorkTime Indicates whether or not the activity should be counted as work time
     * @return $this
     */
    public function setCountsAsWorkTime($countsAsWorkTime)
    {
        $this->container['countsAsWorkTime'] = $countsAsWorkTime;

        return $this;
    }

    /**
     * Gets isAgentTimeOffSelectable
     * @return bool
     */
    public function getIsAgentTimeOffSelectable()
    {
        return $this->container['isAgentTimeOffSelectable'];
    }

    /**
     * Sets isAgentTimeOffSelectable
     * @param bool $isAgentTimeOffSelectable Whether an agent can select this activity code when creating or editing a time off request
     * @return $this
     */
    public function setIsAgentTimeOffSelectable($isAgentTimeOffSelectable)
    {
        $this->container['isAgentTimeOffSelectable'] = $isAgentTimeOffSelectable;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


