<?php
/**
 * FlowVersion
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * FlowVersion Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class FlowVersion implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'FlowVersion';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'commitVersion' => 'string',
        'configurationVersion' => 'string',
        'type' => 'string',
        'secure' => 'bool',
        'createdBy' => '\PureCloudSDK\UriReference',
        'configurationUri' => 'string',
        'dateCreated' => 'int',
        'generationId' => 'string',
        'publishResultUri' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'commitVersion' => 'commitVersion',
        'configurationVersion' => 'configurationVersion',
        'type' => 'type',
        'secure' => 'secure',
        'createdBy' => 'createdBy',
        'configurationUri' => 'configurationUri',
        'dateCreated' => 'dateCreated',
        'generationId' => 'generationId',
        'publishResultUri' => 'publishResultUri',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'commitVersion' => 'setCommitVersion',
        'configurationVersion' => 'setConfigurationVersion',
        'type' => 'setType',
        'secure' => 'setSecure',
        'createdBy' => 'setCreatedBy',
        'configurationUri' => 'setConfigurationUri',
        'dateCreated' => 'setDateCreated',
        'generationId' => 'setGenerationId',
        'publishResultUri' => 'setPublishResultUri',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'commitVersion' => 'getCommitVersion',
        'configurationVersion' => 'getConfigurationVersion',
        'type' => 'getType',
        'secure' => 'getSecure',
        'createdBy' => 'getCreatedBy',
        'configurationUri' => 'getConfigurationUri',
        'dateCreated' => 'getDateCreated',
        'generationId' => 'getGenerationId',
        'publishResultUri' => 'getPublishResultUri',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const TYPE_PUBLISH = 'PUBLISH';
    const TYPE_CHECKIN = 'CHECKIN';
    const TYPE_SAVE = 'SAVE';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_PUBLISH,
            self::TYPE_CHECKIN,
            self::TYPE_SAVE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['commitVersion'] = isset($data['commitVersion']) ? $data['commitVersion'] : null;
        $this->container['configurationVersion'] = isset($data['configurationVersion']) ? $data['configurationVersion'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['secure'] = isset($data['secure']) ? $data['secure'] : null;
        $this->container['createdBy'] = isset($data['createdBy']) ? $data['createdBy'] : null;
        $this->container['configurationUri'] = isset($data['configurationUri']) ? $data['configurationUri'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['generationId'] = isset($data['generationId']) ? $data['generationId'] : null;
        $this->container['publishResultUri'] = isset($data['publishResultUri']) ? $data['publishResultUri'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("PUBLISH", "CHECKIN", "SAVE");
        if (!in_array($this->container['type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("PUBLISH", "CHECKIN", "SAVE");
        if (!in_array($this->container['type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets commitVersion
     * @return string
     */
    public function getCommitVersion()
    {
        return $this->container['commitVersion'];
    }

    /**
     * Sets commitVersion
     * @param string $commitVersion
     * @return $this
     */
    public function setCommitVersion($commitVersion)
    {
        $this->container['commitVersion'] = $commitVersion;

        return $this;
    }

    /**
     * Gets configurationVersion
     * @return string
     */
    public function getConfigurationVersion()
    {
        return $this->container['configurationVersion'];
    }

    /**
     * Sets configurationVersion
     * @param string $configurationVersion
     * @return $this
     */
    public function setConfigurationVersion($configurationVersion)
    {
        $this->container['configurationVersion'] = $configurationVersion;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type
     * @return $this
     */
    public function setType($type)
    {
        $allowed_values = array('PUBLISH', 'CHECKIN', 'SAVE');
        if (!in_array($type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'type', must be one of 'PUBLISH', 'CHECKIN', 'SAVE'");
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets secure
     * @return bool
     */
    public function getSecure()
    {
        return $this->container['secure'];
    }

    /**
     * Sets secure
     * @param bool $secure
     * @return $this
     */
    public function setSecure($secure)
    {
        $this->container['secure'] = $secure;

        return $this;
    }

    /**
     * Gets createdBy
     * @return \PureCloudSDK\UriReference
     */
    public function getCreatedBy()
    {
        return $this->container['createdBy'];
    }

    /**
     * Sets createdBy
     * @param \PureCloudSDK\UriReference $createdBy
     * @return $this
     */
    public function setCreatedBy($createdBy)
    {
        $this->container['createdBy'] = $createdBy;

        return $this;
    }

    /**
     * Gets configurationUri
     * @return string
     */
    public function getConfigurationUri()
    {
        return $this->container['configurationUri'];
    }

    /**
     * Sets configurationUri
     * @param string $configurationUri
     * @return $this
     */
    public function setConfigurationUri($configurationUri)
    {
        $this->container['configurationUri'] = $configurationUri;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return int
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param int $dateCreated
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets generationId
     * @return string
     */
    public function getGenerationId()
    {
        return $this->container['generationId'];
    }

    /**
     * Sets generationId
     * @param string $generationId
     * @return $this
     */
    public function setGenerationId($generationId)
    {
        $this->container['generationId'] = $generationId;

        return $this;
    }

    /**
     * Gets publishResultUri
     * @return string
     */
    public function getPublishResultUri()
    {
        return $this->container['publishResultUri'];
    }

    /**
     * Sets publishResultUri
     * @param string $publishResultUri
     * @return $this
     */
    public function setPublishResultUri($publishResultUri)
    {
        $this->container['publishResultUri'] = $publishResultUri;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


