<?php
/**
 * Station
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Station Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Station implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Station';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'description' => 'string',
        'status' => 'string',
        'userId' => 'string',
        'webRtcUserId' => 'string',
        'primaryEdge' => '\PureCloudSDK\UriReference',
        'secondaryEdge' => '\PureCloudSDK\UriReference',
        'type' => 'string',
        'lineAppearanceId' => 'string',
        'webRtcMediaDscp' => 'int',
        'webRtcPersistentEnabled' => 'bool',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'description' => 'description',
        'status' => 'status',
        'userId' => 'userId',
        'webRtcUserId' => 'webRtcUserId',
        'primaryEdge' => 'primaryEdge',
        'secondaryEdge' => 'secondaryEdge',
        'type' => 'type',
        'lineAppearanceId' => 'lineAppearanceId',
        'webRtcMediaDscp' => 'webRtcMediaDscp',
        'webRtcPersistentEnabled' => 'webRtcPersistentEnabled',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'description' => 'setDescription',
        'status' => 'setStatus',
        'userId' => 'setUserId',
        'webRtcUserId' => 'setWebRtcUserId',
        'primaryEdge' => 'setPrimaryEdge',
        'secondaryEdge' => 'setSecondaryEdge',
        'type' => 'setType',
        'lineAppearanceId' => 'setLineAppearanceId',
        'webRtcMediaDscp' => 'setWebRtcMediaDscp',
        'webRtcPersistentEnabled' => 'setWebRtcPersistentEnabled',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'description' => 'getDescription',
        'status' => 'getStatus',
        'userId' => 'getUserId',
        'webRtcUserId' => 'getWebRtcUserId',
        'primaryEdge' => 'getPrimaryEdge',
        'secondaryEdge' => 'getSecondaryEdge',
        'type' => 'getType',
        'lineAppearanceId' => 'getLineAppearanceId',
        'webRtcMediaDscp' => 'getWebRtcMediaDscp',
        'webRtcPersistentEnabled' => 'getWebRtcPersistentEnabled',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATUS_AVAILABLE = 'AVAILABLE';
    const STATUS_ASSOCIATED = 'ASSOCIATED';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_AVAILABLE,
            self::STATUS_ASSOCIATED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['userId'] = isset($data['userId']) ? $data['userId'] : null;
        $this->container['webRtcUserId'] = isset($data['webRtcUserId']) ? $data['webRtcUserId'] : null;
        $this->container['primaryEdge'] = isset($data['primaryEdge']) ? $data['primaryEdge'] : null;
        $this->container['secondaryEdge'] = isset($data['secondaryEdge']) ? $data['secondaryEdge'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['lineAppearanceId'] = isset($data['lineAppearanceId']) ? $data['lineAppearanceId'] : null;
        $this->container['webRtcMediaDscp'] = isset($data['webRtcMediaDscp']) ? $data['webRtcMediaDscp'] : null;
        $this->container['webRtcPersistentEnabled'] = isset($data['webRtcPersistentEnabled']) ? $data['webRtcPersistentEnabled'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("AVAILABLE", "ASSOCIATED");
        if (!in_array($this->container['status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("AVAILABLE", "ASSOCIATED");
        if (!in_array($this->container['status'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = array('AVAILABLE', 'ASSOCIATED');
        if (!in_array($status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'AVAILABLE', 'ASSOCIATED'");
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets userId
     * @return string
     */
    public function getUserId()
    {
        return $this->container['userId'];
    }

    /**
     * Sets userId
     * @param string $userId The Id of the user currently logged in and associated with the station.
     * @return $this
     */
    public function setUserId($userId)
    {
        $this->container['userId'] = $userId;

        return $this;
    }

    /**
     * Gets webRtcUserId
     * @return string
     */
    public function getWebRtcUserId()
    {
        return $this->container['webRtcUserId'];
    }

    /**
     * Sets webRtcUserId
     * @param string $webRtcUserId The Id of the user configured for the station if it is of type inin_webrtc_softphone. Empty if station type is not inin_webrtc_softphone.
     * @return $this
     */
    public function setWebRtcUserId($webRtcUserId)
    {
        $this->container['webRtcUserId'] = $webRtcUserId;

        return $this;
    }

    /**
     * Gets primaryEdge
     * @return \PureCloudSDK\UriReference
     */
    public function getPrimaryEdge()
    {
        return $this->container['primaryEdge'];
    }

    /**
     * Sets primaryEdge
     * @param \PureCloudSDK\UriReference $primaryEdge
     * @return $this
     */
    public function setPrimaryEdge($primaryEdge)
    {
        $this->container['primaryEdge'] = $primaryEdge;

        return $this;
    }

    /**
     * Gets secondaryEdge
     * @return \PureCloudSDK\UriReference
     */
    public function getSecondaryEdge()
    {
        return $this->container['secondaryEdge'];
    }

    /**
     * Sets secondaryEdge
     * @param \PureCloudSDK\UriReference $secondaryEdge
     * @return $this
     */
    public function setSecondaryEdge($secondaryEdge)
    {
        $this->container['secondaryEdge'] = $secondaryEdge;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type
     * @return $this
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets lineAppearanceId
     * @return string
     */
    public function getLineAppearanceId()
    {
        return $this->container['lineAppearanceId'];
    }

    /**
     * Sets lineAppearanceId
     * @param string $lineAppearanceId
     * @return $this
     */
    public function setLineAppearanceId($lineAppearanceId)
    {
        $this->container['lineAppearanceId'] = $lineAppearanceId;

        return $this;
    }

    /**
     * Gets webRtcMediaDscp
     * @return int
     */
    public function getWebRtcMediaDscp()
    {
        return $this->container['webRtcMediaDscp'];
    }

    /**
     * Sets webRtcMediaDscp
     * @param int $webRtcMediaDscp The default or configured value of media dscp for the station. Empty if station type is not inin_webrtc_softphone.
     * @return $this
     */
    public function setWebRtcMediaDscp($webRtcMediaDscp)
    {
        $this->container['webRtcMediaDscp'] = $webRtcMediaDscp;

        return $this;
    }

    /**
     * Gets webRtcPersistentEnabled
     * @return bool
     */
    public function getWebRtcPersistentEnabled()
    {
        return $this->container['webRtcPersistentEnabled'];
    }

    /**
     * Sets webRtcPersistentEnabled
     * @param bool $webRtcPersistentEnabled The default or configured value of persistent connection setting for the station. Empty if station type is not inin_webrtc_softphone.
     * @return $this
     */
    public function setWebRtcPersistentEnabled($webRtcPersistentEnabled)
    {
        $this->container['webRtcPersistentEnabled'] = $webRtcPersistentEnabled;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


