# PureCloudSDK\ArchitectApi

All URIs are relative to *https://api.mypurecloud.ie*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteArchitectPrompts**](ArchitectApi.md#deleteArchitectPrompts) | **DELETE** /api/v2/architect/prompts | Batch-delete a list of prompts
[**deleteArchitectPromptsPromptId**](ArchitectApi.md#deleteArchitectPromptsPromptId) | **DELETE** /api/v2/architect/prompts/{promptId} | Delete specified user prompt
[**deleteArchitectPromptsPromptIdResourcesLanguagecode**](ArchitectApi.md#deleteArchitectPromptsPromptIdResourcesLanguagecode) | **DELETE** /api/v2/architect/prompts/{promptId}/resources/{languageCode} | Delete specified user prompt resource
[**deleteArchitectSystempromptsPromptIdResourcesLanguagecode**](ArchitectApi.md#deleteArchitectSystempromptsPromptIdResourcesLanguagecode) | **DELETE** /api/v2/architect/systemprompts/{promptId}/resources/{languageCode} | Delete a system prompt resource override.
[**deleteFlows**](ArchitectApi.md#deleteFlows) | **DELETE** /api/v2/flows | Batch-delete a list of flows
[**deleteFlowsFlowId**](ArchitectApi.md#deleteFlowsFlowId) | **DELETE** /api/v2/flows/{flowId} | Delete flow
[**getArchitectDependencytracking**](ArchitectApi.md#getArchitectDependencytracking) | **GET** /api/v2/architect/dependencytracking | Get Dependency Tracking objects that have a given display name
[**getArchitectDependencytrackingBuild**](ArchitectApi.md#getArchitectDependencytrackingBuild) | **GET** /api/v2/architect/dependencytracking/build | Get Dependency Tracking build status for an organization
[**getArchitectDependencytrackingConsumedresources**](ArchitectApi.md#getArchitectDependencytrackingConsumedresources) | **GET** /api/v2/architect/dependencytracking/consumedresources | Get resources that are consumed by a given Dependency Tracking object
[**getArchitectDependencytrackingConsumingresources**](ArchitectApi.md#getArchitectDependencytrackingConsumingresources) | **GET** /api/v2/architect/dependencytracking/consumingresources | Get resources that consume a given Dependency Tracking object
[**getArchitectDependencytrackingDeletedresourceconsumers**](ArchitectApi.md#getArchitectDependencytrackingDeletedresourceconsumers) | **GET** /api/v2/architect/dependencytracking/deletedresourceconsumers | Get Dependency Tracking objects that consume deleted resources
[**getArchitectDependencytrackingObject**](ArchitectApi.md#getArchitectDependencytrackingObject) | **GET** /api/v2/architect/dependencytracking/object | Get a Dependency Tracking object
[**getArchitectDependencytrackingTypes**](ArchitectApi.md#getArchitectDependencytrackingTypes) | **GET** /api/v2/architect/dependencytracking/types | Get Dependency Tracking types.
[**getArchitectDependencytrackingTypesTypeId**](ArchitectApi.md#getArchitectDependencytrackingTypesTypeId) | **GET** /api/v2/architect/dependencytracking/types/{typeId} | Get a Dependency Tracking type.
[**getArchitectDependencytrackingUpdatedresourceconsumers**](ArchitectApi.md#getArchitectDependencytrackingUpdatedresourceconsumers) | **GET** /api/v2/architect/dependencytracking/updatedresourceconsumers | Get Dependency Tracking objects that depend on updated resources
[**getArchitectPrompts**](ArchitectApi.md#getArchitectPrompts) | **GET** /api/v2/architect/prompts | Get a pageable list of user prompts
[**getArchitectPromptsPromptId**](ArchitectApi.md#getArchitectPromptsPromptId) | **GET** /api/v2/architect/prompts/{promptId} | Get specified user prompt
[**getArchitectPromptsPromptIdResources**](ArchitectApi.md#getArchitectPromptsPromptIdResources) | **GET** /api/v2/architect/prompts/{promptId}/resources | Get a pageable list of user prompt resources
[**getArchitectPromptsPromptIdResourcesLanguagecode**](ArchitectApi.md#getArchitectPromptsPromptIdResourcesLanguagecode) | **GET** /api/v2/architect/prompts/{promptId}/resources/{languageCode} | Get specified user prompt resource
[**getArchitectSystemprompts**](ArchitectApi.md#getArchitectSystemprompts) | **GET** /api/v2/architect/systemprompts | Get System Prompts
[**getArchitectSystempromptsPromptId**](ArchitectApi.md#getArchitectSystempromptsPromptId) | **GET** /api/v2/architect/systemprompts/{promptId} | Get a system prompt
[**getArchitectSystempromptsPromptIdResources**](ArchitectApi.md#getArchitectSystempromptsPromptIdResources) | **GET** /api/v2/architect/systemprompts/{promptId}/resources | Get system prompt resources.
[**getArchitectSystempromptsPromptIdResourcesLanguagecode**](ArchitectApi.md#getArchitectSystempromptsPromptIdResourcesLanguagecode) | **GET** /api/v2/architect/systemprompts/{promptId}/resources/{languageCode} | Get a system prompt resource.
[**getFlows**](ArchitectApi.md#getFlows) | **GET** /api/v2/flows | Get a pageable list of flows, filtered by query parameters
[**getFlowsFlowId**](ArchitectApi.md#getFlowsFlowId) | **GET** /api/v2/flows/{flowId} | Get flow
[**getFlowsFlowIdLatestconfiguration**](ArchitectApi.md#getFlowsFlowIdLatestconfiguration) | **GET** /api/v2/flows/{flowId}/latestconfiguration | Get the latest configuration for flow
[**getFlowsFlowIdVersions**](ArchitectApi.md#getFlowsFlowIdVersions) | **GET** /api/v2/flows/{flowId}/versions | Get flow version list
[**getFlowsFlowIdVersionsVersionId**](ArchitectApi.md#getFlowsFlowIdVersionsVersionId) | **GET** /api/v2/flows/{flowId}/versions/{versionId} | Get flow version
[**getFlowsFlowIdVersionsVersionIdConfiguration**](ArchitectApi.md#getFlowsFlowIdVersionsVersionIdConfiguration) | **GET** /api/v2/flows/{flowId}/versions/{versionId}/configuration | Create flow version configuration
[**postArchitectDependencytrackingBuild**](ArchitectApi.md#postArchitectDependencytrackingBuild) | **POST** /api/v2/architect/dependencytracking/build | Rebuild Dependency Tracking data for an organization
[**postArchitectPrompts**](ArchitectApi.md#postArchitectPrompts) | **POST** /api/v2/architect/prompts | Create a new user prompt
[**postArchitectPromptsPromptIdResources**](ArchitectApi.md#postArchitectPromptsPromptIdResources) | **POST** /api/v2/architect/prompts/{promptId}/resources | Create a new user prompt resource
[**postArchitectSystempromptsPromptIdResources**](ArchitectApi.md#postArchitectSystempromptsPromptIdResources) | **POST** /api/v2/architect/systemprompts/{promptId}/resources | Create system prompt resource override.
[**postFlows**](ArchitectApi.md#postFlows) | **POST** /api/v2/flows | Create flow
[**postFlowsActionsCheckin**](ArchitectApi.md#postFlowsActionsCheckin) | **POST** /api/v2/flows/actions/checkin | Check-in flow
[**postFlowsActionsCheckout**](ArchitectApi.md#postFlowsActionsCheckout) | **POST** /api/v2/flows/actions/checkout | Check-out flow
[**postFlowsActionsDeactivate**](ArchitectApi.md#postFlowsActionsDeactivate) | **POST** /api/v2/flows/actions/deactivate | Deactivate flow
[**postFlowsActionsPublish**](ArchitectApi.md#postFlowsActionsPublish) | **POST** /api/v2/flows/actions/publish | Publish flow
[**postFlowsActionsRevert**](ArchitectApi.md#postFlowsActionsRevert) | **POST** /api/v2/flows/actions/revert | Revert flow
[**postFlowsActionsUnlock**](ArchitectApi.md#postFlowsActionsUnlock) | **POST** /api/v2/flows/actions/unlock | Unlock flow
[**postFlowsFlowIdVersions**](ArchitectApi.md#postFlowsFlowIdVersions) | **POST** /api/v2/flows/{flowId}/versions | Create flow version
[**putArchitectPromptsPromptId**](ArchitectApi.md#putArchitectPromptsPromptId) | **PUT** /api/v2/architect/prompts/{promptId} | Update specified user prompt
[**putArchitectPromptsPromptIdResourcesLanguagecode**](ArchitectApi.md#putArchitectPromptsPromptIdResourcesLanguagecode) | **PUT** /api/v2/architect/prompts/{promptId}/resources/{languageCode} | Update specified user prompt resource
[**putArchitectSystempromptsPromptIdResourcesLanguagecode**](ArchitectApi.md#putArchitectSystempromptsPromptIdResourcesLanguagecode) | **PUT** /api/v2/architect/systemprompts/{promptId}/resources/{languageCode} | Updates a system prompt resource override.
[**putFlowsFlowId**](ArchitectApi.md#putFlowsFlowId) | **PUT** /api/v2/flows/{flowId} | Update flow


# **deleteArchitectPrompts**
> \PureCloudSDK\Operation deleteArchitectPrompts($id)

Batch-delete a list of prompts

Multiple IDs can be specified, in which case all specified prompts will be deleted.  Asynchronous.  Notification topic: v2.architect.prompts.{promptId}

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$id = array("id_example"); // string[] | List of Prompt IDs

try {
    $result = $api_instance->deleteArchitectPrompts($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->deleteArchitectPrompts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | [**string[]**](../Model/string.md)| List of Prompt IDs |

### Return type

[**\PureCloudSDK\Operation**](../Model/Operation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteArchitectPromptsPromptId**
> deleteArchitectPromptsPromptId($promptId, $allResources)

Delete specified user prompt



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID
$allResources = true; // bool | Whether or not to delete all the prompt resources

try {
    $api_instance->deleteArchitectPromptsPromptId($promptId, $allResources);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->deleteArchitectPromptsPromptId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |
 **allResources** | **bool**| Whether or not to delete all the prompt resources | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteArchitectPromptsPromptIdResourcesLanguagecode**
> deleteArchitectPromptsPromptIdResourcesLanguagecode($promptId, $languageCode)

Delete specified user prompt resource



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID
$languageCode = "languageCode_example"; // string | Language

try {
    $api_instance->deleteArchitectPromptsPromptIdResourcesLanguagecode($promptId, $languageCode);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->deleteArchitectPromptsPromptIdResourcesLanguagecode: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |
 **languageCode** | **string**| Language |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteArchitectSystempromptsPromptIdResourcesLanguagecode**
> deleteArchitectSystempromptsPromptIdResourcesLanguagecode($promptId, $languageCode)

Delete a system prompt resource override.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID
$languageCode = "languageCode_example"; // string | Language

try {
    $api_instance->deleteArchitectSystempromptsPromptIdResourcesLanguagecode($promptId, $languageCode);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->deleteArchitectSystempromptsPromptIdResourcesLanguagecode: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |
 **languageCode** | **string**| Language |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteFlows**
> \PureCloudSDK\Operation deleteFlows($id)

Batch-delete a list of flows

Multiple IDs can be specified, in which case all specified flows will be deleted.  Asynchronous.  Notification topic: v2.flows.{flowId}

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$id = array("id_example"); // string[] | List of Flow IDs

try {
    $result = $api_instance->deleteFlows($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->deleteFlows: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | [**string[]**](../Model/string.md)| List of Flow IDs |

### Return type

[**\PureCloudSDK\Operation**](../Model/Operation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteFlowsFlowId**
> deleteFlowsFlowId($flowId)

Delete flow



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$flowId = "flowId_example"; // string | Flow ID

try {
    $api_instance->deleteFlowsFlowId($flowId);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->deleteFlowsFlowId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **flowId** | **string**| Flow ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getArchitectDependencytracking**
> \PureCloudSDK\DependencyObjectEntityListing getArchitectDependencytracking($name, $pageNumber, $pageSize, $objectType, $consumedResources, $consumingResources, $consumedResourceType, $consumingResourceType)

Get Dependency Tracking objects that have a given display name



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$name = "name_example"; // string | Object name to search for
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size
$objectType = array("objectType_example"); // string[] | Object type(s) to search for
$consumedResources = true; // bool | Include resources each result item consumes
$consumingResources = true; // bool | Include resources that consume each result item
$consumedResourceType = array("consumedResourceType_example"); // string[] | Types of consumed resources to return, if consumed resources are requested
$consumingResourceType = array("consumingResourceType_example"); // string[] | Types of consuming resources to return, if consuming resources are requested

try {
    $result = $api_instance->getArchitectDependencytracking($name, $pageNumber, $pageSize, $objectType, $consumedResources, $consumingResources, $consumedResourceType, $consumingResourceType);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getArchitectDependencytracking: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **string**| Object name to search for |
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **objectType** | [**string[]**](../Model/string.md)| Object type(s) to search for | [optional]
 **consumedResources** | **bool**| Include resources each result item consumes | [optional]
 **consumingResources** | **bool**| Include resources that consume each result item | [optional]
 **consumedResourceType** | [**string[]**](../Model/string.md)| Types of consumed resources to return, if consumed resources are requested | [optional]
 **consumingResourceType** | [**string[]**](../Model/string.md)| Types of consuming resources to return, if consuming resources are requested | [optional]

### Return type

[**\PureCloudSDK\DependencyObjectEntityListing**](../Model/DependencyObjectEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getArchitectDependencytrackingBuild**
> \PureCloudSDK\DependencyStatus getArchitectDependencytrackingBuild()

Get Dependency Tracking build status for an organization



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();

try {
    $result = $api_instance->getArchitectDependencytrackingBuild();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getArchitectDependencytrackingBuild: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\DependencyStatus**](../Model/DependencyStatus.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getArchitectDependencytrackingConsumedresources**
> \PureCloudSDK\ConsumedResourcesEntityListing getArchitectDependencytrackingConsumedresources($id, $version, $objectType, $resourceType)

Get resources that are consumed by a given Dependency Tracking object



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$id = "id_example"; // string | Consuming object ID
$version = "version_example"; // string | Consuming object version
$objectType = "objectType_example"; // string | Consuming object type
$resourceType = array("resourceType_example"); // string[] | Types of consumed resources to show

try {
    $result = $api_instance->getArchitectDependencytrackingConsumedresources($id, $version, $objectType, $resourceType);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getArchitectDependencytrackingConsumedresources: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**| Consuming object ID |
 **version** | **string**| Consuming object version |
 **objectType** | **string**| Consuming object type |
 **resourceType** | [**string[]**](../Model/string.md)| Types of consumed resources to show | [optional]

### Return type

[**\PureCloudSDK\ConsumedResourcesEntityListing**](../Model/ConsumedResourcesEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getArchitectDependencytrackingConsumingresources**
> \PureCloudSDK\ConsumingResourcesEntityListing getArchitectDependencytrackingConsumingresources($id, $objectType, $resourceType)

Get resources that consume a given Dependency Tracking object



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$id = "id_example"; // string | Consumed object ID
$objectType = "objectType_example"; // string | Consumed object type (only versioned object types are valid)
$resourceType = array("resourceType_example"); // string[] | Types of consuming resources to show

try {
    $result = $api_instance->getArchitectDependencytrackingConsumingresources($id, $objectType, $resourceType);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getArchitectDependencytrackingConsumingresources: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**| Consumed object ID |
 **objectType** | **string**| Consumed object type (only versioned object types are valid) |
 **resourceType** | [**string[]**](../Model/string.md)| Types of consuming resources to show | [optional]

### Return type

[**\PureCloudSDK\ConsumingResourcesEntityListing**](../Model/ConsumingResourcesEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getArchitectDependencytrackingDeletedresourceconsumers**
> \PureCloudSDK\DependencyObjectEntityListing getArchitectDependencytrackingDeletedresourceconsumers($name, $objectType, $flowFilter, $consumedResources, $consumedResourceType, $pageNumber, $pageSize)

Get Dependency Tracking objects that consume deleted resources



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$name = "name_example"; // string | Name to search for
$objectType = array("objectType_example"); // string[] | Object type(s) to search for
$flowFilter = "flowFilter_example"; // string | Show only checkedIn or published flows
$consumedResources = false; // bool | Return consumed resources?
$consumedResourceType = array("consumedResourceType_example"); // string[] | Resource type(s) to return
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size

try {
    $result = $api_instance->getArchitectDependencytrackingDeletedresourceconsumers($name, $objectType, $flowFilter, $consumedResources, $consumedResourceType, $pageNumber, $pageSize);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getArchitectDependencytrackingDeletedresourceconsumers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **string**| Name to search for | [optional]
 **objectType** | [**string[]**](../Model/string.md)| Object type(s) to search for | [optional]
 **flowFilter** | **string**| Show only checkedIn or published flows | [optional]
 **consumedResources** | **bool**| Return consumed resources? | [optional] [default to false]
 **consumedResourceType** | [**string[]**](../Model/string.md)| Resource type(s) to return | [optional]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]

### Return type

[**\PureCloudSDK\DependencyObjectEntityListing**](../Model/DependencyObjectEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getArchitectDependencytrackingObject**
> \PureCloudSDK\DependencyObject getArchitectDependencytrackingObject($id, $version, $objectType, $consumedResources, $consumingResources, $consumedResourceType, $consumingResourceType)

Get a Dependency Tracking object



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$id = "id_example"; // string | Object ID
$version = "version_example"; // string | Object version
$objectType = "objectType_example"; // string | Object type
$consumedResources = true; // bool | Include resources this item consumes
$consumingResources = true; // bool | Include resources that consume this item
$consumedResourceType = array("consumedResourceType_example"); // string[] | Types of consumed resources to return, if consumed resources are requested
$consumingResourceType = array("consumingResourceType_example"); // string[] | Types of consuming resources to return, if consuming resources are requested

try {
    $result = $api_instance->getArchitectDependencytrackingObject($id, $version, $objectType, $consumedResources, $consumingResources, $consumedResourceType, $consumingResourceType);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getArchitectDependencytrackingObject: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**| Object ID |
 **version** | **string**| Object version | [optional]
 **objectType** | **string**| Object type | [optional]
 **consumedResources** | **bool**| Include resources this item consumes | [optional]
 **consumingResources** | **bool**| Include resources that consume this item | [optional]
 **consumedResourceType** | [**string[]**](../Model/string.md)| Types of consumed resources to return, if consumed resources are requested | [optional]
 **consumingResourceType** | [**string[]**](../Model/string.md)| Types of consuming resources to return, if consuming resources are requested | [optional]

### Return type

[**\PureCloudSDK\DependencyObject**](../Model/DependencyObject.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getArchitectDependencytrackingTypes**
> \PureCloudSDK\DependencyTypeEntityListing getArchitectDependencytrackingTypes($pageNumber, $pageSize)

Get Dependency Tracking types.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size

try {
    $result = $api_instance->getArchitectDependencytrackingTypes($pageNumber, $pageSize);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getArchitectDependencytrackingTypes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]

### Return type

[**\PureCloudSDK\DependencyTypeEntityListing**](../Model/DependencyTypeEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getArchitectDependencytrackingTypesTypeId**
> \PureCloudSDK\DependencyType getArchitectDependencytrackingTypesTypeId($typeId)

Get a Dependency Tracking type.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$typeId = "typeId_example"; // string | Type ID

try {
    $result = $api_instance->getArchitectDependencytrackingTypesTypeId($typeId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getArchitectDependencytrackingTypesTypeId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **typeId** | **string**| Type ID |

### Return type

[**\PureCloudSDK\DependencyType**](../Model/DependencyType.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getArchitectDependencytrackingUpdatedresourceconsumers**
> \PureCloudSDK\DependencyObjectEntityListing getArchitectDependencytrackingUpdatedresourceconsumers($name, $objectType, $consumedResources, $consumedResourceType, $pageNumber, $pageSize)

Get Dependency Tracking objects that depend on updated resources



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$name = "name_example"; // string | Name to search for
$objectType = array("objectType_example"); // string[] | Object type(s) to search for
$consumedResources = false; // bool | Return consumed resources?
$consumedResourceType = array("consumedResourceType_example"); // string[] | Resource type(s) to return
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size

try {
    $result = $api_instance->getArchitectDependencytrackingUpdatedresourceconsumers($name, $objectType, $consumedResources, $consumedResourceType, $pageNumber, $pageSize);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getArchitectDependencytrackingUpdatedresourceconsumers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **string**| Name to search for | [optional]
 **objectType** | [**string[]**](../Model/string.md)| Object type(s) to search for | [optional]
 **consumedResources** | **bool**| Return consumed resources? | [optional] [default to false]
 **consumedResourceType** | [**string[]**](../Model/string.md)| Resource type(s) to return | [optional]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]

### Return type

[**\PureCloudSDK\DependencyObjectEntityListing**](../Model/DependencyObjectEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getArchitectPrompts**
> \PureCloudSDK\PromptEntityListing getArchitectPrompts($pageNumber, $pageSize, $name, $description, $nameOrDescription)

Get a pageable list of user prompts

The returned list is pageable, and query parameters can be used for filtering.  Multiple names can be specified, in which case all matching prompts will be returned, and no other filters will be evaluated.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size
$name = "name_example"; // string | Name
$description = "description_example"; // string | Description
$nameOrDescription = "nameOrDescription_example"; // string | Name or description

try {
    $result = $api_instance->getArchitectPrompts($pageNumber, $pageSize, $name, $description, $nameOrDescription);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getArchitectPrompts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **name** | **string**| Name | [optional]
 **description** | **string**| Description | [optional]
 **nameOrDescription** | **string**| Name or description | [optional]

### Return type

[**\PureCloudSDK\PromptEntityListing**](../Model/PromptEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getArchitectPromptsPromptId**
> \PureCloudSDK\Prompt getArchitectPromptsPromptId($promptId)

Get specified user prompt



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID

try {
    $result = $api_instance->getArchitectPromptsPromptId($promptId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getArchitectPromptsPromptId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |

### Return type

[**\PureCloudSDK\Prompt**](../Model/Prompt.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getArchitectPromptsPromptIdResources**
> \PureCloudSDK\PromptAssetEntityListing getArchitectPromptsPromptIdResources($promptId, $pageNumber, $pageSize)

Get a pageable list of user prompt resources

The returned list is pageable, and query parameters can be used for filtering.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size

try {
    $result = $api_instance->getArchitectPromptsPromptIdResources($promptId, $pageNumber, $pageSize);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getArchitectPromptsPromptIdResources: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]

### Return type

[**\PureCloudSDK\PromptAssetEntityListing**](../Model/PromptAssetEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getArchitectPromptsPromptIdResourcesLanguagecode**
> \PureCloudSDK\PromptAsset getArchitectPromptsPromptIdResourcesLanguagecode($promptId, $languageCode)

Get specified user prompt resource



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID
$languageCode = "languageCode_example"; // string | Language

try {
    $result = $api_instance->getArchitectPromptsPromptIdResourcesLanguagecode($promptId, $languageCode);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getArchitectPromptsPromptIdResourcesLanguagecode: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |
 **languageCode** | **string**| Language |

### Return type

[**\PureCloudSDK\PromptAsset**](../Model/PromptAsset.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getArchitectSystemprompts**
> \PureCloudSDK\SystemPromptEntityListing getArchitectSystemprompts($pageNumber, $pageSize, $sortBy, $sortOrder, $name, $description, $nameOrDescription)

Get System Prompts



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size
$sortBy = "id"; // string | Sort by
$sortOrder = "asc"; // string | Sort order
$name = "name_example"; // string | Name
$description = "description_example"; // string | Description
$nameOrDescription = "nameOrDescription_example"; // string | Name or description

try {
    $result = $api_instance->getArchitectSystemprompts($pageNumber, $pageSize, $sortBy, $sortOrder, $name, $description, $nameOrDescription);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getArchitectSystemprompts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **sortBy** | **string**| Sort by | [optional] [default to id]
 **sortOrder** | **string**| Sort order | [optional] [default to asc]
 **name** | **string**| Name | [optional]
 **description** | **string**| Description | [optional]
 **nameOrDescription** | **string**| Name or description | [optional]

### Return type

[**\PureCloudSDK\SystemPromptEntityListing**](../Model/SystemPromptEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getArchitectSystempromptsPromptId**
> \PureCloudSDK\SystemPrompt getArchitectSystempromptsPromptId($promptId)

Get a system prompt



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | promptId

try {
    $result = $api_instance->getArchitectSystempromptsPromptId($promptId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getArchitectSystempromptsPromptId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| promptId |

### Return type

[**\PureCloudSDK\SystemPrompt**](../Model/SystemPrompt.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getArchitectSystempromptsPromptIdResources**
> \PureCloudSDK\SystemPromptAssetEntityListing getArchitectSystempromptsPromptIdResources($promptId, $pageNumber, $pageSize, $sortBy, $sortOrder)

Get system prompt resources.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size
$sortBy = "id"; // string | Sort by
$sortOrder = "asc"; // string | Sort order

try {
    $result = $api_instance->getArchitectSystempromptsPromptIdResources($promptId, $pageNumber, $pageSize, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getArchitectSystempromptsPromptIdResources: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **sortBy** | **string**| Sort by | [optional] [default to id]
 **sortOrder** | **string**| Sort order | [optional] [default to asc]

### Return type

[**\PureCloudSDK\SystemPromptAssetEntityListing**](../Model/SystemPromptAssetEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getArchitectSystempromptsPromptIdResourcesLanguagecode**
> \PureCloudSDK\SystemPromptAsset getArchitectSystempromptsPromptIdResourcesLanguagecode($promptId, $languageCode)

Get a system prompt resource.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID
$languageCode = "languageCode_example"; // string | Language

try {
    $result = $api_instance->getArchitectSystempromptsPromptIdResourcesLanguagecode($promptId, $languageCode);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getArchitectSystempromptsPromptIdResourcesLanguagecode: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |
 **languageCode** | **string**| Language |

### Return type

[**\PureCloudSDK\SystemPromptAsset**](../Model/SystemPromptAsset.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getFlows**
> \PureCloudSDK\FlowEntityListing getFlows($type, $pageNumber, $pageSize, $sortBy, $sortOrder, $id, $name, $description, $nameOrDescription, $publishVersionId, $editableBy, $lockedBy, $secure, $deleted, $includeSchemas)

Get a pageable list of flows, filtered by query parameters

Multiple IDs can be specified, in which case all matching flows will be returned, and no other parameters will be evaluated.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$type = "type_example"; // string | Type
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size
$sortBy = "id"; // string | Sort by
$sortOrder = "asc"; // string | Sort order
$id = array("id_example"); // string[] | ID
$name = "name_example"; // string | Name
$description = "description_example"; // string | Description
$nameOrDescription = "nameOrDescription_example"; // string | Name or description
$publishVersionId = "publishVersionId_example"; // string | Publish version ID
$editableBy = "editableBy_example"; // string | Editable by
$lockedBy = "lockedBy_example"; // string | Locked by
$secure = "secure_example"; // string | Secure
$deleted = false; // bool | Include deleted
$includeSchemas = false; // bool | Include variable schemas

try {
    $result = $api_instance->getFlows($type, $pageNumber, $pageSize, $sortBy, $sortOrder, $id, $name, $description, $nameOrDescription, $publishVersionId, $editableBy, $lockedBy, $secure, $deleted, $includeSchemas);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getFlows: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **type** | **string**| Type |
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **sortBy** | **string**| Sort by | [optional] [default to id]
 **sortOrder** | **string**| Sort order | [optional] [default to asc]
 **id** | [**string[]**](../Model/string.md)| ID | [optional]
 **name** | **string**| Name | [optional]
 **description** | **string**| Description | [optional]
 **nameOrDescription** | **string**| Name or description | [optional]
 **publishVersionId** | **string**| Publish version ID | [optional]
 **editableBy** | **string**| Editable by | [optional]
 **lockedBy** | **string**| Locked by | [optional]
 **secure** | **string**| Secure | [optional]
 **deleted** | **bool**| Include deleted | [optional] [default to false]
 **includeSchemas** | **bool**| Include variable schemas | [optional] [default to false]

### Return type

[**\PureCloudSDK\FlowEntityListing**](../Model/FlowEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getFlowsFlowId**
> \PureCloudSDK\Flow getFlowsFlowId($flowId, $deleted)

Get flow



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$flowId = "flowId_example"; // string | Flow ID
$deleted = false; // bool | Include deleted flows

try {
    $result = $api_instance->getFlowsFlowId($flowId, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getFlowsFlowId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **flowId** | **string**| Flow ID |
 **deleted** | **bool**| Include deleted flows | [optional] [default to false]

### Return type

[**\PureCloudSDK\Flow**](../Model/Flow.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getFlowsFlowIdLatestconfiguration**
> object getFlowsFlowIdLatestconfiguration($flowId, $deleted)

Get the latest configuration for flow



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$flowId = "flowId_example"; // string | Flow ID
$deleted = false; // bool | Include deleted flows

try {
    $result = $api_instance->getFlowsFlowIdLatestconfiguration($flowId, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getFlowsFlowIdLatestconfiguration: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **flowId** | **string**| Flow ID |
 **deleted** | **bool**| Include deleted flows | [optional] [default to false]

### Return type

**object**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getFlowsFlowIdVersions**
> \PureCloudSDK\FlowVersionEntityListing getFlowsFlowIdVersions($flowId, $pageNumber, $pageSize, $deleted)

Get flow version list



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$flowId = "flowId_example"; // string | Flow ID
$pageNumber = 1; // int | Page number
$pageSize = 25; // int | Page size
$deleted = true; // bool | Include deleted flows

try {
    $result = $api_instance->getFlowsFlowIdVersions($flowId, $pageNumber, $pageSize, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getFlowsFlowIdVersions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **flowId** | **string**| Flow ID |
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **deleted** | **bool**| Include deleted flows | [optional]

### Return type

[**\PureCloudSDK\FlowVersionEntityListing**](../Model/FlowVersionEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getFlowsFlowIdVersionsVersionId**
> \PureCloudSDK\FlowVersion getFlowsFlowIdVersionsVersionId($flowId, $versionId, $deleted)

Get flow version



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$flowId = "flowId_example"; // string | Flow ID
$versionId = "versionId_example"; // string | Version ID
$deleted = "deleted_example"; // string | Include deleted flows

try {
    $result = $api_instance->getFlowsFlowIdVersionsVersionId($flowId, $versionId, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getFlowsFlowIdVersionsVersionId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **flowId** | **string**| Flow ID |
 **versionId** | **string**| Version ID |
 **deleted** | **string**| Include deleted flows | [optional]

### Return type

[**\PureCloudSDK\FlowVersion**](../Model/FlowVersion.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getFlowsFlowIdVersionsVersionIdConfiguration**
> object getFlowsFlowIdVersionsVersionIdConfiguration($flowId, $versionId, $deleted)

Create flow version configuration



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$flowId = "flowId_example"; // string | Flow ID
$versionId = "versionId_example"; // string | Version ID
$deleted = "deleted_example"; // string | Include deleted flows

try {
    $result = $api_instance->getFlowsFlowIdVersionsVersionIdConfiguration($flowId, $versionId, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->getFlowsFlowIdVersionsVersionIdConfiguration: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **flowId** | **string**| Flow ID |
 **versionId** | **string**| Version ID |
 **deleted** | **string**| Include deleted flows | [optional]

### Return type

**object**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postArchitectDependencytrackingBuild**
> postArchitectDependencytrackingBuild()

Rebuild Dependency Tracking data for an organization

Asynchronous.  Notification topic: v2.architect.dependencytracking.build

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();

try {
    $api_instance->postArchitectDependencytrackingBuild();
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->postArchitectDependencytrackingBuild: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postArchitectPrompts**
> \PureCloudSDK\Prompt postArchitectPrompts($body)

Create a new user prompt



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$body = new \PureCloudSDK\Prompt(); // \PureCloudSDK\Prompt | 

try {
    $result = $api_instance->postArchitectPrompts($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->postArchitectPrompts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Prompt**](../Model/\PureCloudSDK\Prompt.md)|  | [optional]

### Return type

[**\PureCloudSDK\Prompt**](../Model/Prompt.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postArchitectPromptsPromptIdResources**
> \PureCloudSDK\PromptAsset postArchitectPromptsPromptIdResources($promptId, $body)

Create a new user prompt resource



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID
$body = new \PureCloudSDK\PromptAssetCreate(); // \PureCloudSDK\PromptAssetCreate | 

try {
    $result = $api_instance->postArchitectPromptsPromptIdResources($promptId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->postArchitectPromptsPromptIdResources: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |
 **body** | [**\PureCloudSDK\PromptAssetCreate**](../Model/\PureCloudSDK\PromptAssetCreate.md)|  | [optional]

### Return type

[**\PureCloudSDK\PromptAsset**](../Model/PromptAsset.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postArchitectSystempromptsPromptIdResources**
> \PureCloudSDK\SystemPromptAsset postArchitectSystempromptsPromptIdResources($promptId, $body)

Create system prompt resource override.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID
$body = new \PureCloudSDK\SystemPromptAsset(); // \PureCloudSDK\SystemPromptAsset | 

try {
    $result = $api_instance->postArchitectSystempromptsPromptIdResources($promptId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->postArchitectSystempromptsPromptIdResources: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |
 **body** | [**\PureCloudSDK\SystemPromptAsset**](../Model/\PureCloudSDK\SystemPromptAsset.md)|  | [optional]

### Return type

[**\PureCloudSDK\SystemPromptAsset**](../Model/SystemPromptAsset.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postFlows**
> \PureCloudSDK\Flow postFlows($body)

Create flow



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$body = new \PureCloudSDK\Flow(); // \PureCloudSDK\Flow | 

try {
    $result = $api_instance->postFlows($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->postFlows: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Flow**](../Model/\PureCloudSDK\Flow.md)|  | [optional]

### Return type

[**\PureCloudSDK\Flow**](../Model/Flow.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postFlowsActionsCheckin**
> \PureCloudSDK\Flow postFlowsActionsCheckin($flow)

Check-in flow

Asynchronous.  Notification topic: v2.flows.{flowId}

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$flow = "flow_example"; // string | Flow ID

try {
    $result = $api_instance->postFlowsActionsCheckin($flow);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->postFlowsActionsCheckin: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **flow** | **string**| Flow ID |

### Return type

[**\PureCloudSDK\Flow**](../Model/Flow.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postFlowsActionsCheckout**
> \PureCloudSDK\Flow postFlowsActionsCheckout($flow)

Check-out flow



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$flow = "flow_example"; // string | Flow ID

try {
    $result = $api_instance->postFlowsActionsCheckout($flow);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->postFlowsActionsCheckout: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **flow** | **string**| Flow ID |

### Return type

[**\PureCloudSDK\Flow**](../Model/Flow.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postFlowsActionsDeactivate**
> \PureCloudSDK\Flow postFlowsActionsDeactivate($flow)

Deactivate flow



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$flow = "flow_example"; // string | Flow ID

try {
    $result = $api_instance->postFlowsActionsDeactivate($flow);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->postFlowsActionsDeactivate: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **flow** | **string**| Flow ID |

### Return type

[**\PureCloudSDK\Flow**](../Model/Flow.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postFlowsActionsPublish**
> \PureCloudSDK\Operation postFlowsActionsPublish($flow, $version)

Publish flow

Asynchronous.  Notification topic: v2.flows.{flowId}

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$flow = "flow_example"; // string | Flow ID
$version = "version_example"; // string | version

try {
    $result = $api_instance->postFlowsActionsPublish($flow, $version);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->postFlowsActionsPublish: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **flow** | **string**| Flow ID |
 **version** | **string**| version | [optional]

### Return type

[**\PureCloudSDK\Operation**](../Model/Operation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postFlowsActionsRevert**
> \PureCloudSDK\Flow postFlowsActionsRevert($flow)

Revert flow



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$flow = "flow_example"; // string | Flow ID

try {
    $result = $api_instance->postFlowsActionsRevert($flow);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->postFlowsActionsRevert: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **flow** | **string**| Flow ID |

### Return type

[**\PureCloudSDK\Flow**](../Model/Flow.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postFlowsActionsUnlock**
> \PureCloudSDK\Flow postFlowsActionsUnlock($flow)

Unlock flow

Allows for unlocking a flow in the case where there is no flow configuration available, and thus a check-in will not unlock the flow. The user must have Architect Admin permissions to perform this action.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$flow = "flow_example"; // string | Flow ID

try {
    $result = $api_instance->postFlowsActionsUnlock($flow);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->postFlowsActionsUnlock: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **flow** | **string**| Flow ID |

### Return type

[**\PureCloudSDK\Flow**](../Model/Flow.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postFlowsFlowIdVersions**
> \PureCloudSDK\FlowVersion postFlowsFlowIdVersions($flowId, $body)

Create flow version



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$flowId = "flowId_example"; // string | Flow ID
$body = NULL; // object | 

try {
    $result = $api_instance->postFlowsFlowIdVersions($flowId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->postFlowsFlowIdVersions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **flowId** | **string**| Flow ID |
 **body** | **object**|  | [optional]

### Return type

[**\PureCloudSDK\FlowVersion**](../Model/FlowVersion.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putArchitectPromptsPromptId**
> \PureCloudSDK\Prompt putArchitectPromptsPromptId($promptId, $body)

Update specified user prompt



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID
$body = new \PureCloudSDK\Prompt(); // \PureCloudSDK\Prompt | 

try {
    $result = $api_instance->putArchitectPromptsPromptId($promptId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->putArchitectPromptsPromptId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |
 **body** | [**\PureCloudSDK\Prompt**](../Model/\PureCloudSDK\Prompt.md)|  | [optional]

### Return type

[**\PureCloudSDK\Prompt**](../Model/Prompt.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putArchitectPromptsPromptIdResourcesLanguagecode**
> \PureCloudSDK\PromptAsset putArchitectPromptsPromptIdResourcesLanguagecode($promptId, $languageCode, $body)

Update specified user prompt resource



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID
$languageCode = "languageCode_example"; // string | Language
$body = new \PureCloudSDK\PromptAsset(); // \PureCloudSDK\PromptAsset | 

try {
    $result = $api_instance->putArchitectPromptsPromptIdResourcesLanguagecode($promptId, $languageCode, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->putArchitectPromptsPromptIdResourcesLanguagecode: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |
 **languageCode** | **string**| Language |
 **body** | [**\PureCloudSDK\PromptAsset**](../Model/\PureCloudSDK\PromptAsset.md)|  | [optional]

### Return type

[**\PureCloudSDK\PromptAsset**](../Model/PromptAsset.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putArchitectSystempromptsPromptIdResourcesLanguagecode**
> \PureCloudSDK\SystemPromptAsset putArchitectSystempromptsPromptIdResourcesLanguagecode($promptId, $languageCode, $body)

Updates a system prompt resource override.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$promptId = "promptId_example"; // string | Prompt ID
$languageCode = "languageCode_example"; // string | Language
$body = new \PureCloudSDK\SystemPromptAsset(); // \PureCloudSDK\SystemPromptAsset | 

try {
    $result = $api_instance->putArchitectSystempromptsPromptIdResourcesLanguagecode($promptId, $languageCode, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->putArchitectSystempromptsPromptIdResourcesLanguagecode: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promptId** | **string**| Prompt ID |
 **languageCode** | **string**| Language |
 **body** | [**\PureCloudSDK\SystemPromptAsset**](../Model/\PureCloudSDK\SystemPromptAsset.md)|  | [optional]

### Return type

[**\PureCloudSDK\SystemPromptAsset**](../Model/SystemPromptAsset.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putFlowsFlowId**
> \PureCloudSDK\Flow putFlowsFlowId($flowId, $body)

Update flow



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ArchitectApi();
$flowId = "flowId_example"; // string | Flow ID
$body = new \PureCloudSDK\Flow(); // \PureCloudSDK\Flow | 

try {
    $result = $api_instance->putFlowsFlowId($flowId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ArchitectApi->putFlowsFlowId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **flowId** | **string**| Flow ID |
 **body** | [**\PureCloudSDK\Flow**](../Model/\PureCloudSDK\Flow.md)|  | [optional]

### Return type

[**\PureCloudSDK\Flow**](../Model/Flow.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

