# PureCloudSDK\FaxApi

All URIs are relative to *https://api.mypurecloud.ie*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteFaxDocumentsDocumentId**](FaxApi.md#deleteFaxDocumentsDocumentId) | **DELETE** /api/v2/fax/documents/{documentId} | Delete a fax document.
[**getFaxDocuments**](FaxApi.md#getFaxDocuments) | **GET** /api/v2/fax/documents | Get a list of fax documents.
[**getFaxDocumentsDocumentId**](FaxApi.md#getFaxDocumentsDocumentId) | **GET** /api/v2/fax/documents/{documentId} | Get a document.
[**getFaxDocumentsDocumentIdContent**](FaxApi.md#getFaxDocumentsDocumentIdContent) | **GET** /api/v2/fax/documents/{documentId}/content | Download a fax document.
[**getFaxSummary**](FaxApi.md#getFaxSummary) | **GET** /api/v2/fax/summary | Get fax summary
[**putFaxDocumentsDocumentId**](FaxApi.md#putFaxDocumentsDocumentId) | **PUT** /api/v2/fax/documents/{documentId} | Update a fax document.


# **deleteFaxDocumentsDocumentId**
> deleteFaxDocumentsDocumentId($documentId)

Delete a fax document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\FaxApi();
$documentId = "documentId_example"; // string | Document ID

try {
    $api_instance->deleteFaxDocumentsDocumentId($documentId);
} catch (Exception $e) {
    echo 'Exception when calling FaxApi->deleteFaxDocumentsDocumentId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **documentId** | **string**| Document ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getFaxDocuments**
> \PureCloudSDK\FaxDocumentEntityListing getFaxDocuments($pageSize, $pageNumber)

Get a list of fax documents.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\FaxApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getFaxDocuments($pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FaxApi->getFaxDocuments: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\FaxDocumentEntityListing**](../Model/FaxDocumentEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getFaxDocumentsDocumentId**
> \PureCloudSDK\FaxDocument getFaxDocumentsDocumentId($documentId)

Get a document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\FaxApi();
$documentId = "documentId_example"; // string | Document ID

try {
    $result = $api_instance->getFaxDocumentsDocumentId($documentId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FaxApi->getFaxDocumentsDocumentId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **documentId** | **string**| Document ID |

### Return type

[**\PureCloudSDK\FaxDocument**](../Model/FaxDocument.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getFaxDocumentsDocumentIdContent**
> \PureCloudSDK\DownloadResponse getFaxDocumentsDocumentIdContent($documentId)

Download a fax document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\FaxApi();
$documentId = "documentId_example"; // string | Document ID

try {
    $result = $api_instance->getFaxDocumentsDocumentIdContent($documentId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FaxApi->getFaxDocumentsDocumentIdContent: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **documentId** | **string**| Document ID |

### Return type

[**\PureCloudSDK\DownloadResponse**](../Model/DownloadResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getFaxSummary**
> \PureCloudSDK\FaxSummary getFaxSummary()

Get fax summary



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\FaxApi();

try {
    $result = $api_instance->getFaxSummary();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FaxApi->getFaxSummary: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\FaxSummary**](../Model/FaxSummary.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putFaxDocumentsDocumentId**
> \PureCloudSDK\FaxDocument putFaxDocumentsDocumentId($documentId, $body)

Update a fax document.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\FaxApi();
$documentId = "documentId_example"; // string | Document ID
$body = new \PureCloudSDK\FaxDocument(); // \PureCloudSDK\FaxDocument | Document

try {
    $result = $api_instance->putFaxDocumentsDocumentId($documentId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FaxApi->putFaxDocumentsDocumentId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **documentId** | **string**| Document ID |
 **body** | [**\PureCloudSDK\FaxDocument**](../Model/\PureCloudSDK\FaxDocument.md)| Document |

### Return type

[**\PureCloudSDK\FaxDocument**](../Model/FaxDocument.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

