# PureCloudSDK\SearchApi

All URIs are relative to *https://api.mypurecloud.ie*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getDocumentationSearch**](SearchApi.md#getDocumentationSearch) | **GET** /api/v2/documentation/search | Search documentation using the q64 value returned from a previous search
[**getGroupsSearch**](SearchApi.md#getGroupsSearch) | **GET** /api/v2/groups/search | Search groups using the q64 value returned from a previous search
[**getLocationsSearch**](SearchApi.md#getLocationsSearch) | **GET** /api/v2/locations/search | Search locations using the q64 value returned from a previous search
[**getSearch**](SearchApi.md#getSearch) | **GET** /api/v2/search | Search using the q64 value returned from a previous search.
[**getSearchSuggest**](SearchApi.md#getSearchSuggest) | **GET** /api/v2/search/suggest | Suggest resources using the q64 value returned from a previous suggest query.
[**getUsersSearch**](SearchApi.md#getUsersSearch) | **GET** /api/v2/users/search | Search users using the q64 value returned from a previous search
[**getVoicemailSearch**](SearchApi.md#getVoicemailSearch) | **GET** /api/v2/voicemail/search | Search voicemails using the q64 value returned from a previous search
[**postDocumentationSearch**](SearchApi.md#postDocumentationSearch) | **POST** /api/v2/documentation/search | Search documentation
[**postGroupsSearch**](SearchApi.md#postGroupsSearch) | **POST** /api/v2/groups/search | Search groups
[**postLocationsSearch**](SearchApi.md#postLocationsSearch) | **POST** /api/v2/locations/search | Search locations
[**postSearch**](SearchApi.md#postSearch) | **POST** /api/v2/search | Search resources.
[**postSearchSuggest**](SearchApi.md#postSearchSuggest) | **POST** /api/v2/search/suggest | Suggest resources.
[**postUsersSearch**](SearchApi.md#postUsersSearch) | **POST** /api/v2/users/search | Search users
[**postVoicemailSearch**](SearchApi.md#postVoicemailSearch) | **POST** /api/v2/voicemail/search | Search voicemails


# **getDocumentationSearch**
> \PureCloudSDK\DocumentationSearchResponse getDocumentationSearch($q64)

Search documentation using the q64 value returned from a previous search



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SearchApi();
$q64 = "q64_example"; // string | q64

try {
    $result = $api_instance->getDocumentationSearch($q64);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SearchApi->getDocumentationSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **q64** | **string**| q64 |

### Return type

[**\PureCloudSDK\DocumentationSearchResponse**](../Model/DocumentationSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getGroupsSearch**
> \PureCloudSDK\GroupsSearchResponse getGroupsSearch($q64, $expand)

Search groups using the q64 value returned from a previous search



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SearchApi();
$q64 = "q64_example"; // string | q64
$expand = array("expand_example"); // string[] | expand

try {
    $result = $api_instance->getGroupsSearch($q64, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SearchApi->getGroupsSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **q64** | **string**| q64 |
 **expand** | [**string[]**](../Model/string.md)| expand | [optional]

### Return type

[**\PureCloudSDK\GroupsSearchResponse**](../Model/GroupsSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getLocationsSearch**
> \PureCloudSDK\LocationsSearchResponse getLocationsSearch($q64, $expand)

Search locations using the q64 value returned from a previous search



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SearchApi();
$q64 = "q64_example"; // string | q64
$expand = array("expand_example"); // string[] | expand

try {
    $result = $api_instance->getLocationsSearch($q64, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SearchApi->getLocationsSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **q64** | **string**| q64 |
 **expand** | [**string[]**](../Model/string.md)| expand | [optional]

### Return type

[**\PureCloudSDK\LocationsSearchResponse**](../Model/LocationsSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSearch**
> \PureCloudSDK\JsonNodeSearchResponse getSearch($q64, $expand, $profile)

Search using the q64 value returned from a previous search.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SearchApi();
$q64 = "q64_example"; // string | q64
$expand = array("expand_example"); // string[] | Which fields, if any, to expand
$profile = true; // bool | profile

try {
    $result = $api_instance->getSearch($q64, $expand, $profile);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SearchApi->getSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **q64** | **string**| q64 |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]
 **profile** | **bool**| profile | [optional] [default to true]

### Return type

[**\PureCloudSDK\JsonNodeSearchResponse**](../Model/JsonNodeSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSearchSuggest**
> \PureCloudSDK\JsonNodeSearchResponse getSearchSuggest($q64, $expand, $profile)

Suggest resources using the q64 value returned from a previous suggest query.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SearchApi();
$q64 = "q64_example"; // string | q64
$expand = array("expand_example"); // string[] | Which fields, if any, to expand
$profile = true; // bool | profile

try {
    $result = $api_instance->getSearchSuggest($q64, $expand, $profile);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SearchApi->getSearchSuggest: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **q64** | **string**| q64 |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand | [optional]
 **profile** | **bool**| profile | [optional] [default to true]

### Return type

[**\PureCloudSDK\JsonNodeSearchResponse**](../Model/JsonNodeSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUsersSearch**
> \PureCloudSDK\UsersSearchResponse getUsersSearch($q64, $expand)

Search users using the q64 value returned from a previous search



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SearchApi();
$q64 = "q64_example"; // string | q64
$expand = array("expand_example"); // string[] | expand

try {
    $result = $api_instance->getUsersSearch($q64, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SearchApi->getUsersSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **q64** | **string**| q64 |
 **expand** | [**string[]**](../Model/string.md)| expand | [optional]

### Return type

[**\PureCloudSDK\UsersSearchResponse**](../Model/UsersSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getVoicemailSearch**
> \PureCloudSDK\VoicemailsSearchResponse getVoicemailSearch($q64, $expand)

Search voicemails using the q64 value returned from a previous search



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SearchApi();
$q64 = "q64_example"; // string | q64
$expand = array("expand_example"); // string[] | expand

try {
    $result = $api_instance->getVoicemailSearch($q64, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SearchApi->getVoicemailSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **q64** | **string**| q64 |
 **expand** | [**string[]**](../Model/string.md)| expand | [optional]

### Return type

[**\PureCloudSDK\VoicemailsSearchResponse**](../Model/VoicemailsSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postDocumentationSearch**
> \PureCloudSDK\DocumentationSearchResponse postDocumentationSearch($body)

Search documentation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SearchApi();
$body = new \PureCloudSDK\DocumentationSearchRequest(); // \PureCloudSDK\DocumentationSearchRequest | Search request options

try {
    $result = $api_instance->postDocumentationSearch($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SearchApi->postDocumentationSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\DocumentationSearchRequest**](../Model/\PureCloudSDK\DocumentationSearchRequest.md)| Search request options |

### Return type

[**\PureCloudSDK\DocumentationSearchResponse**](../Model/DocumentationSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postGroupsSearch**
> \PureCloudSDK\GroupsSearchResponse postGroupsSearch($body)

Search groups



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SearchApi();
$body = new \PureCloudSDK\GroupSearchRequest(); // \PureCloudSDK\GroupSearchRequest | Search request options

try {
    $result = $api_instance->postGroupsSearch($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SearchApi->postGroupsSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\GroupSearchRequest**](../Model/\PureCloudSDK\GroupSearchRequest.md)| Search request options |

### Return type

[**\PureCloudSDK\GroupsSearchResponse**](../Model/GroupsSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postLocationsSearch**
> \PureCloudSDK\LocationsSearchResponse postLocationsSearch($body)

Search locations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SearchApi();
$body = new \PureCloudSDK\LocationSearchRequest(); // \PureCloudSDK\LocationSearchRequest | Search request options

try {
    $result = $api_instance->postLocationsSearch($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SearchApi->postLocationsSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\LocationSearchRequest**](../Model/\PureCloudSDK\LocationSearchRequest.md)| Search request options |

### Return type

[**\PureCloudSDK\LocationsSearchResponse**](../Model/LocationsSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postSearch**
> \PureCloudSDK\JsonNodeSearchResponse postSearch($body, $profile)

Search resources.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SearchApi();
$body = new \PureCloudSDK\SearchRequest(); // \PureCloudSDK\SearchRequest | Search request options
$profile = true; // bool | profile

try {
    $result = $api_instance->postSearch($body, $profile);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SearchApi->postSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\SearchRequest**](../Model/\PureCloudSDK\SearchRequest.md)| Search request options |
 **profile** | **bool**| profile | [optional] [default to true]

### Return type

[**\PureCloudSDK\JsonNodeSearchResponse**](../Model/JsonNodeSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postSearchSuggest**
> \PureCloudSDK\JsonNodeSearchResponse postSearchSuggest($body, $profile)

Suggest resources.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SearchApi();
$body = new \PureCloudSDK\SuggestSearchRequest(); // \PureCloudSDK\SuggestSearchRequest | Search request options
$profile = true; // bool | profile

try {
    $result = $api_instance->postSearchSuggest($body, $profile);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SearchApi->postSearchSuggest: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\SuggestSearchRequest**](../Model/\PureCloudSDK\SuggestSearchRequest.md)| Search request options |
 **profile** | **bool**| profile | [optional] [default to true]

### Return type

[**\PureCloudSDK\JsonNodeSearchResponse**](../Model/JsonNodeSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postUsersSearch**
> \PureCloudSDK\UsersSearchResponse postUsersSearch($body)

Search users



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SearchApi();
$body = new \PureCloudSDK\UserSearchRequest(); // \PureCloudSDK\UserSearchRequest | Search request options

try {
    $result = $api_instance->postUsersSearch($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SearchApi->postUsersSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\UserSearchRequest**](../Model/\PureCloudSDK\UserSearchRequest.md)| Search request options |

### Return type

[**\PureCloudSDK\UsersSearchResponse**](../Model/UsersSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postVoicemailSearch**
> \PureCloudSDK\VoicemailsSearchResponse postVoicemailSearch($body)

Search voicemails



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\SearchApi();
$body = new \PureCloudSDK\VoicemailSearchRequest(); // \PureCloudSDK\VoicemailSearchRequest | Search request options

try {
    $result = $api_instance->postVoicemailSearch($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SearchApi->postVoicemailSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\VoicemailSearchRequest**](../Model/\PureCloudSDK\VoicemailSearchRequest.md)| Search request options |

### Return type

[**\PureCloudSDK\VoicemailsSearchResponse**](../Model/VoicemailsSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

