# TwitterExpression

## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **string** | The globally unique identifier for the object. | [optional] 
**name** | **string** |  | [optional] 
**dateCreated** | [**\DateTime**](\DateTime.md) | Creation date for the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**dateModified** | [**\DateTime**](\DateTime.md) | Date the entity was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**isDispositioned** | **bool** | True once the expression has been dispositioned by an agent through the ACD process | [optional] [default to false]
**isNoise** | **bool** | Indicates if a user/agent found this expression to be undesirable | [optional] [default to false]
**gistener** | [**\PureCloudSDK\Gistener**](Gistener.md) | The Gistener that generated this expression | 
**tweetId** | **string** | Twitter: the tweet&#39;s unique id | 
**text** | **string** | Twitter: the tweets full text | 
**tweetCreated** | [**\DateTime**](\DateTime.md) | Twitter: the date the tweet was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ | [optional] 
**isReply** | **bool** | Twitter: indicates this tweet as a reply to another tweet | [optional] [default to false]
**isRetweet** | **bool** | Twitter: indicates this tweet as a &#39;retweet&#39; of another tweet | [optional] [default to false]
**retweetParentId** | **string** | Twitter: when the expression is a retweet, this is Twitter&#39;s id of the original tweet | [optional] 
**retweetCount** | **int** | Twitter: the number of times the parent tweet was retweeted - at the time this expression was created | [optional] 
**isQuotedTweet** | **bool** | Twitter: indicates this expression as a quoted tweet (a tweet with an addendum as the primary text) | [optional] [default to false]
**quotedParentId** | **string** | Twitter: when the expression is a quoted tweet, this is Twitter&#39;s id of the original tweet (may not be immediately functional) | [optional] 
**userId** | **string** | Twitter: the expressing user&#39;s Twitter id | [optional] 
**userName** | **string** | Twitter: the user&#39;s account name for the core service | 
**userScreenName** | **string** | Twitter: the user&#39;s custom &#39;branding&#39; name (allowed to change over time) | [optional] 
**userTweetCount** | **int** | Twitter: the number of times this user has tweeted (includes all forms of expression replies/quotes/retweets) | [optional] 
**userFollowersCount** | **int** | Twitter: the number of followers this user has at the time of this expression | [optional] 
**groupTags** | [**\PureCloudSDK\GroupTag[]**](GroupTag.md) | The Group Tags applied by the generating Gistener | [optional] 
**routed** | **bool** |  | [optional] [default to false]
**selfUri** | **string** | The URI for this object | [optional] 

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


