<?php

/**
 * AnalyticsSession
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * AnalyticsSession Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AnalyticsSession implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AnalyticsSession';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'mediaType' => 'string',
        'sessionId' => 'string',
        'addressOther' => 'string',
        'addressSelf' => 'string',
        'addressFrom' => 'string',
        'addressTo' => 'string',
        'messageType' => 'string',
        'ani' => 'string',
        'direction' => 'string',
        'dnis' => 'string',
        'sessionDnis' => 'string',
        'outboundCampaignId' => 'string',
        'outboundContactId' => 'string',
        'outboundContactListId' => 'string',
        'dispositionAnalyzer' => 'string',
        'dispositionName' => 'string',
        'edgeId' => 'string',
        'remoteNameDisplayable' => 'string',
        'roomId' => 'string',
        'monitoredSessionId' => 'string',
        'monitoredParticipantId' => 'string',
        'callbackUserName' => 'string',
        'callbackNumbers' => 'string[]',
        'callbackScheduledTime' => '\DateTime',
        'scriptId' => 'string',
        'peerId' => 'string',
        'skipEnabled' => 'bool',
        'timeoutSeconds' => 'int',
        'cobrowseRole' => 'string',
        'cobrowseRoomId' => 'string',
        'mediaBridgeId' => 'string',
        'screenShareAddressSelf' => 'string',
        'sharingScreen' => 'bool',
        'screenShareRoomId' => 'string',
        'videoRoomId' => 'string',
        'videoAddressSelf' => 'string',
        'segments' => '\PureCloudSDK\AnalyticsConversationSegment[]',
        'metrics' => '\PureCloudSDK\AnalyticsSessionMetric[]',
        'flow' => '\PureCloudSDK\AnalyticsFlow',
        'mediaEndpointStats' => '\PureCloudSDK\AnalyticsMediaEndpointStat[]',
        'recording' => 'bool',
        'journeyCustomerId' => 'string',
        'journeyCustomerIdType' => 'string',
        'journeyCustomerSessionId' => 'string',
        'journeyCustomerSessionIdType' => 'string',
        'journeyActionId' => 'string',
        'journeyActionMapId' => 'string',
        'journeyActionMapVersion' => 'string',
        'protocolCallId' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'mediaType' => 'mediaType',
        'sessionId' => 'sessionId',
        'addressOther' => 'addressOther',
        'addressSelf' => 'addressSelf',
        'addressFrom' => 'addressFrom',
        'addressTo' => 'addressTo',
        'messageType' => 'messageType',
        'ani' => 'ani',
        'direction' => 'direction',
        'dnis' => 'dnis',
        'sessionDnis' => 'sessionDnis',
        'outboundCampaignId' => 'outboundCampaignId',
        'outboundContactId' => 'outboundContactId',
        'outboundContactListId' => 'outboundContactListId',
        'dispositionAnalyzer' => 'dispositionAnalyzer',
        'dispositionName' => 'dispositionName',
        'edgeId' => 'edgeId',
        'remoteNameDisplayable' => 'remoteNameDisplayable',
        'roomId' => 'roomId',
        'monitoredSessionId' => 'monitoredSessionId',
        'monitoredParticipantId' => 'monitoredParticipantId',
        'callbackUserName' => 'callbackUserName',
        'callbackNumbers' => 'callbackNumbers',
        'callbackScheduledTime' => 'callbackScheduledTime',
        'scriptId' => 'scriptId',
        'peerId' => 'peerId',
        'skipEnabled' => 'skipEnabled',
        'timeoutSeconds' => 'timeoutSeconds',
        'cobrowseRole' => 'cobrowseRole',
        'cobrowseRoomId' => 'cobrowseRoomId',
        'mediaBridgeId' => 'mediaBridgeId',
        'screenShareAddressSelf' => 'screenShareAddressSelf',
        'sharingScreen' => 'sharingScreen',
        'screenShareRoomId' => 'screenShareRoomId',
        'videoRoomId' => 'videoRoomId',
        'videoAddressSelf' => 'videoAddressSelf',
        'segments' => 'segments',
        'metrics' => 'metrics',
        'flow' => 'flow',
        'mediaEndpointStats' => 'mediaEndpointStats',
        'recording' => 'recording',
        'journeyCustomerId' => 'journeyCustomerId',
        'journeyCustomerIdType' => 'journeyCustomerIdType',
        'journeyCustomerSessionId' => 'journeyCustomerSessionId',
        'journeyCustomerSessionIdType' => 'journeyCustomerSessionIdType',
        'journeyActionId' => 'journeyActionId',
        'journeyActionMapId' => 'journeyActionMapId',
        'journeyActionMapVersion' => 'journeyActionMapVersion',
        'protocolCallId' => 'protocolCallId'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'mediaType' => 'setMediaType',
        'sessionId' => 'setSessionId',
        'addressOther' => 'setAddressOther',
        'addressSelf' => 'setAddressSelf',
        'addressFrom' => 'setAddressFrom',
        'addressTo' => 'setAddressTo',
        'messageType' => 'setMessageType',
        'ani' => 'setAni',
        'direction' => 'setDirection',
        'dnis' => 'setDnis',
        'sessionDnis' => 'setSessionDnis',
        'outboundCampaignId' => 'setOutboundCampaignId',
        'outboundContactId' => 'setOutboundContactId',
        'outboundContactListId' => 'setOutboundContactListId',
        'dispositionAnalyzer' => 'setDispositionAnalyzer',
        'dispositionName' => 'setDispositionName',
        'edgeId' => 'setEdgeId',
        'remoteNameDisplayable' => 'setRemoteNameDisplayable',
        'roomId' => 'setRoomId',
        'monitoredSessionId' => 'setMonitoredSessionId',
        'monitoredParticipantId' => 'setMonitoredParticipantId',
        'callbackUserName' => 'setCallbackUserName',
        'callbackNumbers' => 'setCallbackNumbers',
        'callbackScheduledTime' => 'setCallbackScheduledTime',
        'scriptId' => 'setScriptId',
        'peerId' => 'setPeerId',
        'skipEnabled' => 'setSkipEnabled',
        'timeoutSeconds' => 'setTimeoutSeconds',
        'cobrowseRole' => 'setCobrowseRole',
        'cobrowseRoomId' => 'setCobrowseRoomId',
        'mediaBridgeId' => 'setMediaBridgeId',
        'screenShareAddressSelf' => 'setScreenShareAddressSelf',
        'sharingScreen' => 'setSharingScreen',
        'screenShareRoomId' => 'setScreenShareRoomId',
        'videoRoomId' => 'setVideoRoomId',
        'videoAddressSelf' => 'setVideoAddressSelf',
        'segments' => 'setSegments',
        'metrics' => 'setMetrics',
        'flow' => 'setFlow',
        'mediaEndpointStats' => 'setMediaEndpointStats',
        'recording' => 'setRecording',
        'journeyCustomerId' => 'setJourneyCustomerId',
        'journeyCustomerIdType' => 'setJourneyCustomerIdType',
        'journeyCustomerSessionId' => 'setJourneyCustomerSessionId',
        'journeyCustomerSessionIdType' => 'setJourneyCustomerSessionIdType',
        'journeyActionId' => 'setJourneyActionId',
        'journeyActionMapId' => 'setJourneyActionMapId',
        'journeyActionMapVersion' => 'setJourneyActionMapVersion',
        'protocolCallId' => 'setProtocolCallId'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'mediaType' => 'getMediaType',
        'sessionId' => 'getSessionId',
        'addressOther' => 'getAddressOther',
        'addressSelf' => 'getAddressSelf',
        'addressFrom' => 'getAddressFrom',
        'addressTo' => 'getAddressTo',
        'messageType' => 'getMessageType',
        'ani' => 'getAni',
        'direction' => 'getDirection',
        'dnis' => 'getDnis',
        'sessionDnis' => 'getSessionDnis',
        'outboundCampaignId' => 'getOutboundCampaignId',
        'outboundContactId' => 'getOutboundContactId',
        'outboundContactListId' => 'getOutboundContactListId',
        'dispositionAnalyzer' => 'getDispositionAnalyzer',
        'dispositionName' => 'getDispositionName',
        'edgeId' => 'getEdgeId',
        'remoteNameDisplayable' => 'getRemoteNameDisplayable',
        'roomId' => 'getRoomId',
        'monitoredSessionId' => 'getMonitoredSessionId',
        'monitoredParticipantId' => 'getMonitoredParticipantId',
        'callbackUserName' => 'getCallbackUserName',
        'callbackNumbers' => 'getCallbackNumbers',
        'callbackScheduledTime' => 'getCallbackScheduledTime',
        'scriptId' => 'getScriptId',
        'peerId' => 'getPeerId',
        'skipEnabled' => 'getSkipEnabled',
        'timeoutSeconds' => 'getTimeoutSeconds',
        'cobrowseRole' => 'getCobrowseRole',
        'cobrowseRoomId' => 'getCobrowseRoomId',
        'mediaBridgeId' => 'getMediaBridgeId',
        'screenShareAddressSelf' => 'getScreenShareAddressSelf',
        'sharingScreen' => 'getSharingScreen',
        'screenShareRoomId' => 'getScreenShareRoomId',
        'videoRoomId' => 'getVideoRoomId',
        'videoAddressSelf' => 'getVideoAddressSelf',
        'segments' => 'getSegments',
        'metrics' => 'getMetrics',
        'flow' => 'getFlow',
        'mediaEndpointStats' => 'getMediaEndpointStats',
        'recording' => 'getRecording',
        'journeyCustomerId' => 'getJourneyCustomerId',
        'journeyCustomerIdType' => 'getJourneyCustomerIdType',
        'journeyCustomerSessionId' => 'getJourneyCustomerSessionId',
        'journeyCustomerSessionIdType' => 'getJourneyCustomerSessionIdType',
        'journeyActionId' => 'getJourneyActionId',
        'journeyActionMapId' => 'getJourneyActionMapId',
        'journeyActionMapVersion' => 'getJourneyActionMapVersion',
        'protocolCallId' => 'getProtocolCallId'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const MEDIA_TYPE_VOICE = 'voice';
    public const MEDIA_TYPE_CHAT = 'chat';
    public const MEDIA_TYPE_EMAIL = 'email';
    public const MEDIA_TYPE_CALLBACK = 'callback';
    public const MEDIA_TYPE_COBROWSE = 'cobrowse';
    public const MEDIA_TYPE_VIDEO = 'video';
    public const MEDIA_TYPE_SCREENSHARE = 'screenshare';
    public const MEDIA_TYPE_MESSAGE = 'message';
    public const MESSAGE_TYPE_SMS = 'sms';
    public const MESSAGE_TYPE_FACEBOOK = 'facebook';
    public const MESSAGE_TYPE_TWITTER = 'twitter';
    public const MESSAGE_TYPE_LINE = 'line';
    public const DIRECTION_INBOUND = 'inbound';
    public const DIRECTION_OUTBOUND = 'outbound';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMediaTypeAllowableValues()
    {
        return [
            self::MEDIA_TYPE_VOICE,
            self::MEDIA_TYPE_CHAT,
            self::MEDIA_TYPE_EMAIL,
            self::MEDIA_TYPE_CALLBACK,
            self::MEDIA_TYPE_COBROWSE,
            self::MEDIA_TYPE_VIDEO,
            self::MEDIA_TYPE_SCREENSHARE,
            self::MEDIA_TYPE_MESSAGE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMessageTypeAllowableValues()
    {
        return [
            self::MESSAGE_TYPE_SMS,
            self::MESSAGE_TYPE_FACEBOOK,
            self::MESSAGE_TYPE_TWITTER,
            self::MESSAGE_TYPE_LINE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDirectionAllowableValues()
    {
        return [
            self::DIRECTION_INBOUND,
            self::DIRECTION_OUTBOUND,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['mediaType'] = isset($data['mediaType']) ? $data['mediaType'] : null;
        $this->container['sessionId'] = isset($data['sessionId']) ? $data['sessionId'] : null;
        $this->container['addressOther'] = isset($data['addressOther']) ? $data['addressOther'] : null;
        $this->container['addressSelf'] = isset($data['addressSelf']) ? $data['addressSelf'] : null;
        $this->container['addressFrom'] = isset($data['addressFrom']) ? $data['addressFrom'] : null;
        $this->container['addressTo'] = isset($data['addressTo']) ? $data['addressTo'] : null;
        $this->container['messageType'] = isset($data['messageType']) ? $data['messageType'] : null;
        $this->container['ani'] = isset($data['ani']) ? $data['ani'] : null;
        $this->container['direction'] = isset($data['direction']) ? $data['direction'] : null;
        $this->container['dnis'] = isset($data['dnis']) ? $data['dnis'] : null;
        $this->container['sessionDnis'] = isset($data['sessionDnis']) ? $data['sessionDnis'] : null;
        $this->container['outboundCampaignId'] = isset($data['outboundCampaignId']) ? $data['outboundCampaignId'] : null;
        $this->container['outboundContactId'] = isset($data['outboundContactId']) ? $data['outboundContactId'] : null;
        $this->container['outboundContactListId'] = isset($data['outboundContactListId']) ? $data['outboundContactListId'] : null;
        $this->container['dispositionAnalyzer'] = isset($data['dispositionAnalyzer']) ? $data['dispositionAnalyzer'] : null;
        $this->container['dispositionName'] = isset($data['dispositionName']) ? $data['dispositionName'] : null;
        $this->container['edgeId'] = isset($data['edgeId']) ? $data['edgeId'] : null;
        $this->container['remoteNameDisplayable'] = isset($data['remoteNameDisplayable']) ? $data['remoteNameDisplayable'] : null;
        $this->container['roomId'] = isset($data['roomId']) ? $data['roomId'] : null;
        $this->container['monitoredSessionId'] = isset($data['monitoredSessionId']) ? $data['monitoredSessionId'] : null;
        $this->container['monitoredParticipantId'] = isset($data['monitoredParticipantId']) ? $data['monitoredParticipantId'] : null;
        $this->container['callbackUserName'] = isset($data['callbackUserName']) ? $data['callbackUserName'] : null;
        $this->container['callbackNumbers'] = isset($data['callbackNumbers']) ? $data['callbackNumbers'] : null;
        $this->container['callbackScheduledTime'] = isset($data['callbackScheduledTime']) ? $data['callbackScheduledTime'] : null;
        $this->container['scriptId'] = isset($data['scriptId']) ? $data['scriptId'] : null;
        $this->container['peerId'] = isset($data['peerId']) ? $data['peerId'] : null;
        $this->container['skipEnabled'] = isset($data['skipEnabled']) ? $data['skipEnabled'] : null;
        $this->container['timeoutSeconds'] = isset($data['timeoutSeconds']) ? $data['timeoutSeconds'] : null;
        $this->container['cobrowseRole'] = isset($data['cobrowseRole']) ? $data['cobrowseRole'] : null;
        $this->container['cobrowseRoomId'] = isset($data['cobrowseRoomId']) ? $data['cobrowseRoomId'] : null;
        $this->container['mediaBridgeId'] = isset($data['mediaBridgeId']) ? $data['mediaBridgeId'] : null;
        $this->container['screenShareAddressSelf'] = isset($data['screenShareAddressSelf']) ? $data['screenShareAddressSelf'] : null;
        $this->container['sharingScreen'] = isset($data['sharingScreen']) ? $data['sharingScreen'] : null;
        $this->container['screenShareRoomId'] = isset($data['screenShareRoomId']) ? $data['screenShareRoomId'] : null;
        $this->container['videoRoomId'] = isset($data['videoRoomId']) ? $data['videoRoomId'] : null;
        $this->container['videoAddressSelf'] = isset($data['videoAddressSelf']) ? $data['videoAddressSelf'] : null;
        $this->container['segments'] = isset($data['segments']) ? $data['segments'] : null;
        $this->container['metrics'] = isset($data['metrics']) ? $data['metrics'] : null;
        $this->container['flow'] = isset($data['flow']) ? $data['flow'] : null;
        $this->container['mediaEndpointStats'] = isset($data['mediaEndpointStats']) ? $data['mediaEndpointStats'] : null;
        $this->container['recording'] = isset($data['recording']) ? $data['recording'] : null;
        $this->container['journeyCustomerId'] = isset($data['journeyCustomerId']) ? $data['journeyCustomerId'] : null;
        $this->container['journeyCustomerIdType'] = isset($data['journeyCustomerIdType']) ? $data['journeyCustomerIdType'] : null;
        $this->container['journeyCustomerSessionId'] = isset($data['journeyCustomerSessionId']) ? $data['journeyCustomerSessionId'] : null;
        $this->container['journeyCustomerSessionIdType'] = isset($data['journeyCustomerSessionIdType']) ? $data['journeyCustomerSessionIdType'] : null;
        $this->container['journeyActionId'] = isset($data['journeyActionId']) ? $data['journeyActionId'] : null;
        $this->container['journeyActionMapId'] = isset($data['journeyActionMapId']) ? $data['journeyActionMapId'] : null;
        $this->container['journeyActionMapVersion'] = isset($data['journeyActionMapVersion']) ? $data['journeyActionMapVersion'] : null;
        $this->container['protocolCallId'] = isset($data['protocolCallId']) ? $data['protocolCallId'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("voice", "chat", "email", "callback", "cobrowse", "video", "screenshare", "message");
        if (!in_array($this->container['mediaType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'mediaType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("sms", "facebook", "twitter", "line");
        if (!in_array($this->container['messageType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'messageType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'direction', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("voice", "chat", "email", "callback", "cobrowse", "video", "screenshare", "message");
        if (!in_array($this->container['mediaType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("sms", "facebook", "twitter", "line");
        if (!in_array($this->container['messageType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets mediaType
     * @return string
     */
    public function getMediaType()
    {
        return $this->container['mediaType'];
    }

    /**
     * Sets mediaType
     * @param string $mediaType The session media type
     * @return $this
     */
    public function setMediaType($mediaType)
    {
        $allowed_values = array('voice', 'chat', 'email', 'callback', 'cobrowse', 'video', 'screenshare', 'message');
        if (!in_array($mediaType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'mediaType', must be one of 'voice', 'chat', 'email', 'callback', 'cobrowse', 'video', 'screenshare', 'message'");
        }
        $this->container['mediaType'] = $mediaType;

        return $this;
    }

    /**
     * Gets sessionId
     * @return string
     */
    public function getSessionId()
    {
        return $this->container['sessionId'];
    }

    /**
     * Sets sessionId
     * @param string $sessionId The unique identifier of this session
     * @return $this
     */
    public function setSessionId($sessionId)
    {
        $this->container['sessionId'] = $sessionId;

        return $this;
    }

    /**
     * Gets addressOther
     * @return string
     */
    public function getAddressOther()
    {
        return $this->container['addressOther'];
    }

    /**
     * Sets addressOther
     * @param string $addressOther
     * @return $this
     */
    public function setAddressOther($addressOther)
    {
        $this->container['addressOther'] = $addressOther;

        return $this;
    }

    /**
     * Gets addressSelf
     * @return string
     */
    public function getAddressSelf()
    {
        return $this->container['addressSelf'];
    }

    /**
     * Sets addressSelf
     * @param string $addressSelf
     * @return $this
     */
    public function setAddressSelf($addressSelf)
    {
        $this->container['addressSelf'] = $addressSelf;

        return $this;
    }

    /**
     * Gets addressFrom
     * @return string
     */
    public function getAddressFrom()
    {
        return $this->container['addressFrom'];
    }

    /**
     * Sets addressFrom
     * @param string $addressFrom
     * @return $this
     */
    public function setAddressFrom($addressFrom)
    {
        $this->container['addressFrom'] = $addressFrom;

        return $this;
    }

    /**
     * Gets addressTo
     * @return string
     */
    public function getAddressTo()
    {
        return $this->container['addressTo'];
    }

    /**
     * Sets addressTo
     * @param string $addressTo
     * @return $this
     */
    public function setAddressTo($addressTo)
    {
        $this->container['addressTo'] = $addressTo;

        return $this;
    }

    /**
     * Gets messageType
     * @return string
     */
    public function getMessageType()
    {
        return $this->container['messageType'];
    }

    /**
     * Sets messageType
     * @param string $messageType Message type for messaging services such as sms
     * @return $this
     */
    public function setMessageType($messageType)
    {
        $allowed_values = array('sms', 'facebook', 'twitter', 'line');
        if (!in_array($messageType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'messageType', must be one of 'sms', 'facebook', 'twitter', 'line'");
        }
        $this->container['messageType'] = $messageType;

        return $this;
    }

    /**
     * Gets ani
     * @return string
     */
    public function getAni()
    {
        return $this->container['ani'];
    }

    /**
     * Sets ani
     * @param string $ani Automatic Number Identification (caller's number)
     * @return $this
     */
    public function setAni($ani)
    {
        $this->container['ani'] = $ani;

        return $this;
    }

    /**
     * Gets direction
     * @return string
     */
    public function getDirection()
    {
        return $this->container['direction'];
    }

    /**
     * Sets direction
     * @param string $direction Direction
     * @return $this
     */
    public function setDirection($direction)
    {
        $allowed_values = array('inbound', 'outbound');
        if (!in_array($direction, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'direction', must be one of 'inbound', 'outbound'");
        }
        $this->container['direction'] = $direction;

        return $this;
    }

    /**
     * Gets dnis
     * @return string
     */
    public function getDnis()
    {
        return $this->container['dnis'];
    }

    /**
     * Sets dnis
     * @param string $dnis Dialed number identification service (number dialed by the calling party)
     * @return $this
     */
    public function setDnis($dnis)
    {
        $this->container['dnis'] = $dnis;

        return $this;
    }

    /**
     * Gets sessionDnis
     * @return string
     */
    public function getSessionDnis()
    {
        return $this->container['sessionDnis'];
    }

    /**
     * Sets sessionDnis
     * @param string $sessionDnis Dialed number for the current session; this can be different from dnis, e.g. if the call was transferred
     * @return $this
     */
    public function setSessionDnis($sessionDnis)
    {
        $this->container['sessionDnis'] = $sessionDnis;

        return $this;
    }

    /**
     * Gets outboundCampaignId
     * @return string
     */
    public function getOutboundCampaignId()
    {
        return $this->container['outboundCampaignId'];
    }

    /**
     * Sets outboundCampaignId
     * @param string $outboundCampaignId (Dialer) Unique identifier of the outbound campaign
     * @return $this
     */
    public function setOutboundCampaignId($outboundCampaignId)
    {
        $this->container['outboundCampaignId'] = $outboundCampaignId;

        return $this;
    }

    /**
     * Gets outboundContactId
     * @return string
     */
    public function getOutboundContactId()
    {
        return $this->container['outboundContactId'];
    }

    /**
     * Sets outboundContactId
     * @param string $outboundContactId (Dialer) Unique identifier of the contact
     * @return $this
     */
    public function setOutboundContactId($outboundContactId)
    {
        $this->container['outboundContactId'] = $outboundContactId;

        return $this;
    }

    /**
     * Gets outboundContactListId
     * @return string
     */
    public function getOutboundContactListId()
    {
        return $this->container['outboundContactListId'];
    }

    /**
     * Sets outboundContactListId
     * @param string $outboundContactListId (Dialer) Unique identifier of the contact list that this contact belongs to
     * @return $this
     */
    public function setOutboundContactListId($outboundContactListId)
    {
        $this->container['outboundContactListId'] = $outboundContactListId;

        return $this;
    }

    /**
     * Gets dispositionAnalyzer
     * @return string
     */
    public function getDispositionAnalyzer()
    {
        return $this->container['dispositionAnalyzer'];
    }

    /**
     * Sets dispositionAnalyzer
     * @param string $dispositionAnalyzer (Dialer) Unique identifier of the contact list that this contact belongs to
     * @return $this
     */
    public function setDispositionAnalyzer($dispositionAnalyzer)
    {
        $this->container['dispositionAnalyzer'] = $dispositionAnalyzer;

        return $this;
    }

    /**
     * Gets dispositionName
     * @return string
     */
    public function getDispositionName()
    {
        return $this->container['dispositionName'];
    }

    /**
     * Sets dispositionName
     * @param string $dispositionName (Dialer) Result of the analysis
     * @return $this
     */
    public function setDispositionName($dispositionName)
    {
        $this->container['dispositionName'] = $dispositionName;

        return $this;
    }

    /**
     * Gets edgeId
     * @return string
     */
    public function getEdgeId()
    {
        return $this->container['edgeId'];
    }

    /**
     * Sets edgeId
     * @param string $edgeId Unique identifier of the edge device
     * @return $this
     */
    public function setEdgeId($edgeId)
    {
        $this->container['edgeId'] = $edgeId;

        return $this;
    }

    /**
     * Gets remoteNameDisplayable
     * @return string
     */
    public function getRemoteNameDisplayable()
    {
        return $this->container['remoteNameDisplayable'];
    }

    /**
     * Sets remoteNameDisplayable
     * @param string $remoteNameDisplayable
     * @return $this
     */
    public function setRemoteNameDisplayable($remoteNameDisplayable)
    {
        $this->container['remoteNameDisplayable'] = $remoteNameDisplayable;

        return $this;
    }

    /**
     * Gets roomId
     * @return string
     */
    public function getRoomId()
    {
        return $this->container['roomId'];
    }

    /**
     * Sets roomId
     * @param string $roomId Unique identifier for the room
     * @return $this
     */
    public function setRoomId($roomId)
    {
        $this->container['roomId'] = $roomId;

        return $this;
    }

    /**
     * Gets monitoredSessionId
     * @return string
     */
    public function getMonitoredSessionId()
    {
        return $this->container['monitoredSessionId'];
    }

    /**
     * Sets monitoredSessionId
     * @param string $monitoredSessionId The sessionID being monitored
     * @return $this
     */
    public function setMonitoredSessionId($monitoredSessionId)
    {
        $this->container['monitoredSessionId'] = $monitoredSessionId;

        return $this;
    }

    /**
     * Gets monitoredParticipantId
     * @return string
     */
    public function getMonitoredParticipantId()
    {
        return $this->container['monitoredParticipantId'];
    }

    /**
     * Sets monitoredParticipantId
     * @param string $monitoredParticipantId
     * @return $this
     */
    public function setMonitoredParticipantId($monitoredParticipantId)
    {
        $this->container['monitoredParticipantId'] = $monitoredParticipantId;

        return $this;
    }

    /**
     * Gets callbackUserName
     * @return string
     */
    public function getCallbackUserName()
    {
        return $this->container['callbackUserName'];
    }

    /**
     * Sets callbackUserName
     * @param string $callbackUserName The name of the user requesting a call back
     * @return $this
     */
    public function setCallbackUserName($callbackUserName)
    {
        $this->container['callbackUserName'] = $callbackUserName;

        return $this;
    }

    /**
     * Gets callbackNumbers
     * @return string[]
     */
    public function getCallbackNumbers()
    {
        return $this->container['callbackNumbers'];
    }

    /**
     * Sets callbackNumbers
     * @param string[] $callbackNumbers List of numbers to callback
     * @return $this
     */
    public function setCallbackNumbers($callbackNumbers)
    {
        $this->container['callbackNumbers'] = $callbackNumbers;

        return $this;
    }

    /**
     * Gets callbackScheduledTime
     * @return \DateTime
     */
    public function getCallbackScheduledTime()
    {
        return $this->container['callbackScheduledTime'];
    }

    /**
     * Sets callbackScheduledTime
     * @param \DateTime $callbackScheduledTime Scheduled callback date/time. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCallbackScheduledTime($callbackScheduledTime)
    {
        $this->container['callbackScheduledTime'] = $callbackScheduledTime;

        return $this;
    }

    /**
     * Gets scriptId
     * @return string
     */
    public function getScriptId()
    {
        return $this->container['scriptId'];
    }

    /**
     * Sets scriptId
     * @param string $scriptId A unique identifier for a script
     * @return $this
     */
    public function setScriptId($scriptId)
    {
        $this->container['scriptId'] = $scriptId;

        return $this;
    }

    /**
     * Gets peerId
     * @return string
     */
    public function getPeerId()
    {
        return $this->container['peerId'];
    }

    /**
     * Sets peerId
     * @param string $peerId A unique identifier for a peer
     * @return $this
     */
    public function setPeerId($peerId)
    {
        $this->container['peerId'] = $peerId;

        return $this;
    }

    /**
     * Gets skipEnabled
     * @return bool
     */
    public function getSkipEnabled()
    {
        return $this->container['skipEnabled'];
    }

    /**
     * Sets skipEnabled
     * @param bool $skipEnabled (Dialer) Whether the agent can skip the dialer contact
     * @return $this
     */
    public function setSkipEnabled($skipEnabled)
    {
        $this->container['skipEnabled'] = $skipEnabled;

        return $this;
    }

    /**
     * Gets timeoutSeconds
     * @return int
     */
    public function getTimeoutSeconds()
    {
        return $this->container['timeoutSeconds'];
    }

    /**
     * Sets timeoutSeconds
     * @param int $timeoutSeconds The number of seconds before PureCloud begins the call for a call back. 0 disables automatic calling
     * @return $this
     */
    public function setTimeoutSeconds($timeoutSeconds)
    {
        $this->container['timeoutSeconds'] = $timeoutSeconds;

        return $this;
    }

    /**
     * Gets cobrowseRole
     * @return string
     */
    public function getCobrowseRole()
    {
        return $this->container['cobrowseRole'];
    }

    /**
     * Sets cobrowseRole
     * @param string $cobrowseRole Describe side of the cobrowse (sharer or viewer)
     * @return $this
     */
    public function setCobrowseRole($cobrowseRole)
    {
        $this->container['cobrowseRole'] = $cobrowseRole;

        return $this;
    }

    /**
     * Gets cobrowseRoomId
     * @return string
     */
    public function getCobrowseRoomId()
    {
        return $this->container['cobrowseRoomId'];
    }

    /**
     * Sets cobrowseRoomId
     * @param string $cobrowseRoomId A unique identifier for a PureCloud Cobrowse room.
     * @return $this
     */
    public function setCobrowseRoomId($cobrowseRoomId)
    {
        $this->container['cobrowseRoomId'] = $cobrowseRoomId;

        return $this;
    }

    /**
     * Gets mediaBridgeId
     * @return string
     */
    public function getMediaBridgeId()
    {
        return $this->container['mediaBridgeId'];
    }

    /**
     * Sets mediaBridgeId
     * @param string $mediaBridgeId
     * @return $this
     */
    public function setMediaBridgeId($mediaBridgeId)
    {
        $this->container['mediaBridgeId'] = $mediaBridgeId;

        return $this;
    }

    /**
     * Gets screenShareAddressSelf
     * @return string
     */
    public function getScreenShareAddressSelf()
    {
        return $this->container['screenShareAddressSelf'];
    }

    /**
     * Sets screenShareAddressSelf
     * @param string $screenShareAddressSelf Direct ScreenShare address
     * @return $this
     */
    public function setScreenShareAddressSelf($screenShareAddressSelf)
    {
        $this->container['screenShareAddressSelf'] = $screenShareAddressSelf;

        return $this;
    }

    /**
     * Gets sharingScreen
     * @return bool
     */
    public function getSharingScreen()
    {
        return $this->container['sharingScreen'];
    }

    /**
     * Sets sharingScreen
     * @param bool $sharingScreen Flag determining if screenShare is started or not (true/false)
     * @return $this
     */
    public function setSharingScreen($sharingScreen)
    {
        $this->container['sharingScreen'] = $sharingScreen;

        return $this;
    }

    /**
     * Gets screenShareRoomId
     * @return string
     */
    public function getScreenShareRoomId()
    {
        return $this->container['screenShareRoomId'];
    }

    /**
     * Sets screenShareRoomId
     * @param string $screenShareRoomId A unique identifier for a PureCloud ScreenShare room.
     * @return $this
     */
    public function setScreenShareRoomId($screenShareRoomId)
    {
        $this->container['screenShareRoomId'] = $screenShareRoomId;

        return $this;
    }

    /**
     * Gets videoRoomId
     * @return string
     */
    public function getVideoRoomId()
    {
        return $this->container['videoRoomId'];
    }

    /**
     * Sets videoRoomId
     * @param string $videoRoomId A unique identifier for a PureCloud video room.
     * @return $this
     */
    public function setVideoRoomId($videoRoomId)
    {
        $this->container['videoRoomId'] = $videoRoomId;

        return $this;
    }

    /**
     * Gets videoAddressSelf
     * @return string
     */
    public function getVideoAddressSelf()
    {
        return $this->container['videoAddressSelf'];
    }

    /**
     * Sets videoAddressSelf
     * @param string $videoAddressSelf Direct Video address
     * @return $this
     */
    public function setVideoAddressSelf($videoAddressSelf)
    {
        $this->container['videoAddressSelf'] = $videoAddressSelf;

        return $this;
    }

    /**
     * Gets segments
     * @return \PureCloudSDK\AnalyticsConversationSegment[]
     */
    public function getSegments()
    {
        return $this->container['segments'];
    }

    /**
     * Sets segments
     * @param \PureCloudSDK\AnalyticsConversationSegment[] $segments List of segments for this session
     * @return $this
     */
    public function setSegments($segments)
    {
        $this->container['segments'] = $segments;

        return $this;
    }

    /**
     * Gets metrics
     * @return \PureCloudSDK\AnalyticsSessionMetric[]
     */
    public function getMetrics()
    {
        return $this->container['metrics'];
    }

    /**
     * Sets metrics
     * @param \PureCloudSDK\AnalyticsSessionMetric[] $metrics List of metrics for this session
     * @return $this
     */
    public function setMetrics($metrics)
    {
        $this->container['metrics'] = $metrics;

        return $this;
    }

    /**
     * Gets flow
     * @return \PureCloudSDK\AnalyticsFlow
     */
    public function getFlow()
    {
        return $this->container['flow'];
    }

    /**
     * Sets flow
     * @param \PureCloudSDK\AnalyticsFlow $flow IVR flow execution associated with this session
     * @return $this
     */
    public function setFlow($flow)
    {
        $this->container['flow'] = $flow;

        return $this;
    }

    /**
     * Gets mediaEndpointStats
     * @return \PureCloudSDK\AnalyticsMediaEndpointStat[]
     */
    public function getMediaEndpointStats()
    {
        return $this->container['mediaEndpointStats'];
    }

    /**
     * Sets mediaEndpointStats
     * @param \PureCloudSDK\AnalyticsMediaEndpointStat[] $mediaEndpointStats Media endpoint stats associated with this session
     * @return $this
     */
    public function setMediaEndpointStats($mediaEndpointStats)
    {
        $this->container['mediaEndpointStats'] = $mediaEndpointStats;

        return $this;
    }

    /**
     * Gets recording
     * @return bool
     */
    public function getRecording()
    {
        return $this->container['recording'];
    }

    /**
     * Sets recording
     * @param bool $recording Flag determining if an audio recording was started or not
     * @return $this
     */
    public function setRecording($recording)
    {
        $this->container['recording'] = $recording;

        return $this;
    }

    /**
     * Gets journeyCustomerId
     * @return string
     */
    public function getJourneyCustomerId()
    {
        return $this->container['journeyCustomerId'];
    }

    /**
     * Sets journeyCustomerId
     * @param string $journeyCustomerId ID of the journey customer
     * @return $this
     */
    public function setJourneyCustomerId($journeyCustomerId)
    {
        $this->container['journeyCustomerId'] = $journeyCustomerId;

        return $this;
    }

    /**
     * Gets journeyCustomerIdType
     * @return string
     */
    public function getJourneyCustomerIdType()
    {
        return $this->container['journeyCustomerIdType'];
    }

    /**
     * Sets journeyCustomerIdType
     * @param string $journeyCustomerIdType Type of the journey customer ID
     * @return $this
     */
    public function setJourneyCustomerIdType($journeyCustomerIdType)
    {
        $this->container['journeyCustomerIdType'] = $journeyCustomerIdType;

        return $this;
    }

    /**
     * Gets journeyCustomerSessionId
     * @return string
     */
    public function getJourneyCustomerSessionId()
    {
        return $this->container['journeyCustomerSessionId'];
    }

    /**
     * Sets journeyCustomerSessionId
     * @param string $journeyCustomerSessionId ID of the journey customer session
     * @return $this
     */
    public function setJourneyCustomerSessionId($journeyCustomerSessionId)
    {
        $this->container['journeyCustomerSessionId'] = $journeyCustomerSessionId;

        return $this;
    }

    /**
     * Gets journeyCustomerSessionIdType
     * @return string
     */
    public function getJourneyCustomerSessionIdType()
    {
        return $this->container['journeyCustomerSessionIdType'];
    }

    /**
     * Sets journeyCustomerSessionIdType
     * @param string $journeyCustomerSessionIdType Type of the journey customer session ID
     * @return $this
     */
    public function setJourneyCustomerSessionIdType($journeyCustomerSessionIdType)
    {
        $this->container['journeyCustomerSessionIdType'] = $journeyCustomerSessionIdType;

        return $this;
    }

    /**
     * Gets journeyActionId
     * @return string
     */
    public function getJourneyActionId()
    {
        return $this->container['journeyActionId'];
    }

    /**
     * Sets journeyActionId
     * @param string $journeyActionId Journey action ID
     * @return $this
     */
    public function setJourneyActionId($journeyActionId)
    {
        $this->container['journeyActionId'] = $journeyActionId;

        return $this;
    }

    /**
     * Gets journeyActionMapId
     * @return string
     */
    public function getJourneyActionMapId()
    {
        return $this->container['journeyActionMapId'];
    }

    /**
     * Sets journeyActionMapId
     * @param string $journeyActionMapId Journey action map ID
     * @return $this
     */
    public function setJourneyActionMapId($journeyActionMapId)
    {
        $this->container['journeyActionMapId'] = $journeyActionMapId;

        return $this;
    }

    /**
     * Gets journeyActionMapVersion
     * @return string
     */
    public function getJourneyActionMapVersion()
    {
        return $this->container['journeyActionMapVersion'];
    }

    /**
     * Sets journeyActionMapVersion
     * @param string $journeyActionMapVersion Journey action map version
     * @return $this
     */
    public function setJourneyActionMapVersion($journeyActionMapVersion)
    {
        $this->container['journeyActionMapVersion'] = $journeyActionMapVersion;

        return $this;
    }

    /**
     * Gets protocolCallId
     * @return string
     */
    public function getProtocolCallId()
    {
        return $this->container['protocolCallId'];
    }

    /**
     * Sets protocolCallId
     * @param string $protocolCallId The original voice protocol call ID, e.g. a SIP call ID
     * @return $this
     */
    public function setProtocolCallId($protocolCallId)
    {
        $this->container['protocolCallId'] = $protocolCallId;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


