<?php

/**
 * ConsumedResourcesEntityListing
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ConsumedResourcesEntityListing Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ConsumedResourcesEntityListing implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ConsumedResourcesEntityListing';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'entities' => '\PureCloudSDK\Dependency[]',
        'pageSize' => 'int',
        'pageNumber' => 'int',
        'total' => 'int',
        'firstUri' => 'string',
        'selfUri' => 'string',
        'lastUri' => 'string',
        'previousUri' => 'string',
        'nextUri' => 'string',
        'pageCount' => 'int'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'entities' => 'entities',
        'pageSize' => 'pageSize',
        'pageNumber' => 'pageNumber',
        'total' => 'total',
        'firstUri' => 'firstUri',
        'selfUri' => 'selfUri',
        'lastUri' => 'lastUri',
        'previousUri' => 'previousUri',
        'nextUri' => 'nextUri',
        'pageCount' => 'pageCount'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'entities' => 'setEntities',
        'pageSize' => 'setPageSize',
        'pageNumber' => 'setPageNumber',
        'total' => 'setTotal',
        'firstUri' => 'setFirstUri',
        'selfUri' => 'setSelfUri',
        'lastUri' => 'setLastUri',
        'previousUri' => 'setPreviousUri',
        'nextUri' => 'setNextUri',
        'pageCount' => 'setPageCount'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'entities' => 'getEntities',
        'pageSize' => 'getPageSize',
        'pageNumber' => 'getPageNumber',
        'total' => 'getTotal',
        'firstUri' => 'getFirstUri',
        'selfUri' => 'getSelfUri',
        'lastUri' => 'getLastUri',
        'previousUri' => 'getPreviousUri',
        'nextUri' => 'getNextUri',
        'pageCount' => 'getPageCount'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['entities'] = isset($data['entities']) ? $data['entities'] : null;
        $this->container['pageSize'] = isset($data['pageSize']) ? $data['pageSize'] : null;
        $this->container['pageNumber'] = isset($data['pageNumber']) ? $data['pageNumber'] : null;
        $this->container['total'] = isset($data['total']) ? $data['total'] : null;
        $this->container['firstUri'] = isset($data['firstUri']) ? $data['firstUri'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
        $this->container['lastUri'] = isset($data['lastUri']) ? $data['lastUri'] : null;
        $this->container['previousUri'] = isset($data['previousUri']) ? $data['previousUri'] : null;
        $this->container['nextUri'] = isset($data['nextUri']) ? $data['nextUri'] : null;
        $this->container['pageCount'] = isset($data['pageCount']) ? $data['pageCount'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets entities
     * @return \PureCloudSDK\Dependency[]
     */
    public function getEntities()
    {
        return $this->container['entities'];
    }

    /**
     * Sets entities
     * @param \PureCloudSDK\Dependency[] $entities
     * @return $this
     */
    public function setEntities($entities)
    {
        $this->container['entities'] = $entities;

        return $this;
    }

    /**
     * Gets pageSize
     * @return int
     */
    public function getPageSize()
    {
        return $this->container['pageSize'];
    }

    /**
     * Sets pageSize
     * @param int $pageSize
     * @return $this
     */
    public function setPageSize($pageSize)
    {
        $this->container['pageSize'] = $pageSize;

        return $this;
    }

    /**
     * Gets pageNumber
     * @return int
     */
    public function getPageNumber()
    {
        return $this->container['pageNumber'];
    }

    /**
     * Sets pageNumber
     * @param int $pageNumber
     * @return $this
     */
    public function setPageNumber($pageNumber)
    {
        $this->container['pageNumber'] = $pageNumber;

        return $this;
    }

    /**
     * Gets total
     * @return int
     */
    public function getTotal()
    {
        return $this->container['total'];
    }

    /**
     * Sets total
     * @param int $total
     * @return $this
     */
    public function setTotal($total)
    {
        $this->container['total'] = $total;

        return $this;
    }

    /**
     * Gets firstUri
     * @return string
     */
    public function getFirstUri()
    {
        return $this->container['firstUri'];
    }

    /**
     * Sets firstUri
     * @param string $firstUri
     * @return $this
     */
    public function setFirstUri($firstUri)
    {
        $this->container['firstUri'] = $firstUri;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }

    /**
     * Gets lastUri
     * @return string
     */
    public function getLastUri()
    {
        return $this->container['lastUri'];
    }

    /**
     * Sets lastUri
     * @param string $lastUri
     * @return $this
     */
    public function setLastUri($lastUri)
    {
        $this->container['lastUri'] = $lastUri;

        return $this;
    }

    /**
     * Gets previousUri
     * @return string
     */
    public function getPreviousUri()
    {
        return $this->container['previousUri'];
    }

    /**
     * Sets previousUri
     * @param string $previousUri
     * @return $this
     */
    public function setPreviousUri($previousUri)
    {
        $this->container['previousUri'] = $previousUri;

        return $this;
    }

    /**
     * Gets nextUri
     * @return string
     */
    public function getNextUri()
    {
        return $this->container['nextUri'];
    }

    /**
     * Sets nextUri
     * @param string $nextUri
     * @return $this
     */
    public function setNextUri($nextUri)
    {
        $this->container['nextUri'] = $nextUri;

        return $this;
    }

    /**
     * Gets pageCount
     * @return int
     */
    public function getPageCount()
    {
        return $this->container['pageCount'];
    }

    /**
     * Sets pageCount
     * @param int $pageCount
     * @return $this
     */
    public function setPageCount($pageCount)
    {
        $this->container['pageCount'] = $pageCount;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


