<?php

/**
 * GDPRSubject
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * GDPRSubject Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class GDPRSubject implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'GDPRSubject';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'name' => 'string',
        'userId' => 'string',
        'externalContactId' => 'string',
        'dialerContactId' => '\PureCloudSDK\DialerContactId',
        'journeyCustomer' => '\PureCloudSDK\GDPRJourneyCustomer',
        'socialHandle' => '\PureCloudSDK\SocialHandle',
        'addresses' => 'string[]',
        'phoneNumbers' => 'string[]',
        'emailAddresses' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'name' => 'name',
        'userId' => 'userId',
        'externalContactId' => 'externalContactId',
        'dialerContactId' => 'dialerContactId',
        'journeyCustomer' => 'journeyCustomer',
        'socialHandle' => 'socialHandle',
        'addresses' => 'addresses',
        'phoneNumbers' => 'phoneNumbers',
        'emailAddresses' => 'emailAddresses'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'name' => 'setName',
        'userId' => 'setUserId',
        'externalContactId' => 'setExternalContactId',
        'dialerContactId' => 'setDialerContactId',
        'journeyCustomer' => 'setJourneyCustomer',
        'socialHandle' => 'setSocialHandle',
        'addresses' => 'setAddresses',
        'phoneNumbers' => 'setPhoneNumbers',
        'emailAddresses' => 'setEmailAddresses'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'name' => 'getName',
        'userId' => 'getUserId',
        'externalContactId' => 'getExternalContactId',
        'dialerContactId' => 'getDialerContactId',
        'journeyCustomer' => 'getJourneyCustomer',
        'socialHandle' => 'getSocialHandle',
        'addresses' => 'getAddresses',
        'phoneNumbers' => 'getPhoneNumbers',
        'emailAddresses' => 'getEmailAddresses'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['userId'] = isset($data['userId']) ? $data['userId'] : null;
        $this->container['externalContactId'] = isset($data['externalContactId']) ? $data['externalContactId'] : null;
        $this->container['dialerContactId'] = isset($data['dialerContactId']) ? $data['dialerContactId'] : null;
        $this->container['journeyCustomer'] = isset($data['journeyCustomer']) ? $data['journeyCustomer'] : null;
        $this->container['socialHandle'] = isset($data['socialHandle']) ? $data['socialHandle'] : null;
        $this->container['addresses'] = isset($data['addresses']) ? $data['addresses'] : null;
        $this->container['phoneNumbers'] = isset($data['phoneNumbers']) ? $data['phoneNumbers'] : null;
        $this->container['emailAddresses'] = isset($data['emailAddresses']) ? $data['emailAddresses'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets userId
     * @return string
     */
    public function getUserId()
    {
        return $this->container['userId'];
    }

    /**
     * Sets userId
     * @param string $userId
     * @return $this
     */
    public function setUserId($userId)
    {
        $this->container['userId'] = $userId;

        return $this;
    }

    /**
     * Gets externalContactId
     * @return string
     */
    public function getExternalContactId()
    {
        return $this->container['externalContactId'];
    }

    /**
     * Sets externalContactId
     * @param string $externalContactId
     * @return $this
     */
    public function setExternalContactId($externalContactId)
    {
        $this->container['externalContactId'] = $externalContactId;

        return $this;
    }

    /**
     * Gets dialerContactId
     * @return \PureCloudSDK\DialerContactId
     */
    public function getDialerContactId()
    {
        return $this->container['dialerContactId'];
    }

    /**
     * Sets dialerContactId
     * @param \PureCloudSDK\DialerContactId $dialerContactId
     * @return $this
     */
    public function setDialerContactId($dialerContactId)
    {
        $this->container['dialerContactId'] = $dialerContactId;

        return $this;
    }

    /**
     * Gets journeyCustomer
     * @return \PureCloudSDK\GDPRJourneyCustomer
     */
    public function getJourneyCustomer()
    {
        return $this->container['journeyCustomer'];
    }

    /**
     * Sets journeyCustomer
     * @param \PureCloudSDK\GDPRJourneyCustomer $journeyCustomer
     * @return $this
     */
    public function setJourneyCustomer($journeyCustomer)
    {
        $this->container['journeyCustomer'] = $journeyCustomer;

        return $this;
    }

    /**
     * Gets socialHandle
     * @return \PureCloudSDK\SocialHandle
     */
    public function getSocialHandle()
    {
        return $this->container['socialHandle'];
    }

    /**
     * Sets socialHandle
     * @param \PureCloudSDK\SocialHandle $socialHandle
     * @return $this
     */
    public function setSocialHandle($socialHandle)
    {
        $this->container['socialHandle'] = $socialHandle;

        return $this;
    }

    /**
     * Gets addresses
     * @return string[]
     */
    public function getAddresses()
    {
        return $this->container['addresses'];
    }

    /**
     * Sets addresses
     * @param string[] $addresses
     * @return $this
     */
    public function setAddresses($addresses)
    {
        $this->container['addresses'] = $addresses;

        return $this;
    }

    /**
     * Gets phoneNumbers
     * @return string[]
     */
    public function getPhoneNumbers()
    {
        return $this->container['phoneNumbers'];
    }

    /**
     * Sets phoneNumbers
     * @param string[] $phoneNumbers
     * @return $this
     */
    public function setPhoneNumbers($phoneNumbers)
    {
        $this->container['phoneNumbers'] = $phoneNumbers;

        return $this;
    }

    /**
     * Gets emailAddresses
     * @return string[]
     */
    public function getEmailAddresses()
    {
        return $this->container['emailAddresses'];
    }

    /**
     * Sets emailAddresses
     * @param string[] $emailAddresses
     * @return $this
     */
    public function setEmailAddresses($emailAddresses)
    {
        $this->container['emailAddresses'] = $emailAddresses;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


