<?php

/**
 * ObservationQuery
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ObservationQuery Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ObservationQuery implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ObservationQuery';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'filter' => '\PureCloudSDK\AnalyticsQueryFilter',
        'metrics' => 'string[]',
        'detailMetrics' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'filter' => 'filter',
        'metrics' => 'metrics',
        'detailMetrics' => 'detailMetrics'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'filter' => 'setFilter',
        'metrics' => 'setMetrics',
        'detailMetrics' => 'setDetailMetrics'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'filter' => 'getFilter',
        'metrics' => 'getMetrics',
        'detailMetrics' => 'getDetailMetrics'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const METRICS_T_SEGMENT_DURATION = 'tSegmentDuration';
    public const METRICS_T_CONVERSATION_DURATION = 'tConversationDuration';
    public const METRICS_O_TOTAL_CRITICAL_SCORE = 'oTotalCriticalScore';
    public const METRICS_O_TOTAL_SCORE = 'oTotalScore';
    public const METRICS_N_EVALUATIONS = 'nEvaluations';
    public const METRICS_T_ABANDON = 'tAbandon';
    public const METRICS_T_IVR = 'tIvr';
    public const METRICS_T_ANSWERED = 'tAnswered';
    public const METRICS_T_FLOW_OUT = 'tFlowOut';
    public const METRICS_T_ACD = 'tAcd';
    public const METRICS_T_TALK = 'tTalk';
    public const METRICS_T_HELD = 'tHeld';
    public const METRICS_T_TALK_COMPLETE = 'tTalkComplete';
    public const METRICS_T_HELD_COMPLETE = 'tHeldComplete';
    public const METRICS_T_ACW = 'tAcw';
    public const METRICS_T_HANDLE = 'tHandle';
    public const METRICS_T_CONTACTING = 'tContacting';
    public const METRICS_T_DIALING = 'tDialing';
    public const METRICS_T_WAIT = 'tWait';
    public const METRICS_T_AGENT_ROUTING_STATUS = 'tAgentRoutingStatus';
    public const METRICS_T_ORGANIZATION_PRESENCE = 'tOrganizationPresence';
    public const METRICS_T_SYSTEM_PRESENCE = 'tSystemPresence';
    public const METRICS_T_USER_RESPONSE_TIME = 'tUserResponseTime';
    public const METRICS_T_AGENT_RESPONSE_TIME = 'tAgentResponseTime';
    public const METRICS_T_VOICEMAIL = 'tVoicemail';
    public const METRICS_N_STATE_TRANSITION_ERROR = 'nStateTransitionError';
    public const METRICS_N_OFFERED = 'nOffered';
    public const METRICS_N_OVER_SLA = 'nOverSla';
    public const METRICS_N_TRANSFERRED = 'nTransferred';
    public const METRICS_N_BLIND_TRANSFERRED = 'nBlindTransferred';
    public const METRICS_N_CONSULT_TRANSFERRED = 'nConsultTransferred';
    public const METRICS_N_CONSULT = 'nConsult';
    public const METRICS_N_CONNECTED = 'nConnected';
    public const METRICS_T_ALERT = 'tAlert';
    public const METRICS_T_NOT_RESPONDING = 'tNotResponding';
    public const METRICS_N_OUTBOUND = 'nOutbound';
    public const METRICS_N_OUTBOUND_ATTEMPTED = 'nOutboundAttempted';
    public const METRICS_N_OUTBOUND_CONNECTED = 'nOutboundConnected';
    public const METRICS_N_OUTBOUND_ABANDONED = 'nOutboundAbandoned';
    public const METRICS_N_ERROR = 'nError';
    public const METRICS_O_SERVICE_TARGET = 'oServiceTarget';
    public const METRICS_O_SERVICE_LEVEL = 'oServiceLevel';
    public const METRICS_T_ACTIVE = 'tActive';
    public const METRICS_T_INACTIVE = 'tInactive';
    public const METRICS_O_ACTIVE_USERS = 'oActiveUsers';
    public const METRICS_O_MEMBER_USERS = 'oMemberUsers';
    public const METRICS_O_ACTIVE_QUEUES = 'oActiveQueues';
    public const METRICS_O_MEMBER_QUEUES = 'oMemberQueues';
    public const METRICS_O_INTERACTING = 'oInteracting';
    public const METRICS_O_WAITING = 'oWaiting';
    public const METRICS_O_ON_QUEUE_USERS = 'oOnQueueUsers';
    public const METRICS_O_OFF_QUEUE_USERS = 'oOffQueueUsers';
    public const METRICS_O_USER_PRESENCES = 'oUserPresences';
    public const METRICS_O_USER_ROUTING_STATUSES = 'oUserRoutingStatuses';
    public const METRICS_N_SURVEYS_SENT = 'nSurveysSent';
    public const METRICS_N_SURVEYS_STARTED = 'nSurveysStarted';
    public const METRICS_N_SURVEYS_ABANDONED = 'nSurveysAbandoned';
    public const METRICS_N_SURVEYS_EXPIRED = 'nSurveysExpired';
    public const METRICS_N_SURVEY_ERRORS = 'nSurveyErrors';
    public const METRICS_N_SURVEY_RESPONSES = 'nSurveyResponses';
    public const METRICS_N_SURVEY_ANSWER_RESPONSES = 'nSurveyAnswerResponses';
    public const METRICS_O_SURVEY_TOTAL_SCORE = 'oSurveyTotalScore';
    public const METRICS_O_SURVEY_QUESTION_GROUP_SCORE = 'oSurveyQuestionGroupScore';
    public const METRICS_N_SURVEY_QUESTION_GROUP_RESPONSES = 'nSurveyQuestionGroupResponses';
    public const METRICS_O_SURVEY_QUESTION_SCORE = 'oSurveyQuestionScore';
    public const METRICS_N_SURVEY_QUESTION_RESPONSES = 'nSurveyQuestionResponses';
    public const METRICS_N_SURVEY_NPS_RESPONSES = 'nSurveyNpsResponses';
    public const METRICS_N_SURVEY_NPS_PROMOTERS = 'nSurveyNpsPromoters';
    public const METRICS_N_SURVEY_NPS_DETRACTORS = 'nSurveyNpsDetractors';
    public const METRICS_N_FLOW = 'nFlow';
    public const METRICS_T_FLOW_DISCONNECT = 'tFlowDisconnect';
    public const METRICS_T_FLOW_EXIT = 'tFlowExit';
    public const METRICS_T_FLOW = 'tFlow';
    public const METRICS_O_FLOW = 'oFlow';
    public const METRICS_T_FLOW_OUTCOME = 'tFlowOutcome';
    public const METRICS_N_FLOW_OUTCOME = 'nFlowOutcome';
    public const METRICS_N_FLOW_OUTCOME_FAILED = 'nFlowOutcomeFailed';
    public const DETAIL_METRICS_T_SEGMENT_DURATION = 'tSegmentDuration';
    public const DETAIL_METRICS_T_CONVERSATION_DURATION = 'tConversationDuration';
    public const DETAIL_METRICS_O_TOTAL_CRITICAL_SCORE = 'oTotalCriticalScore';
    public const DETAIL_METRICS_O_TOTAL_SCORE = 'oTotalScore';
    public const DETAIL_METRICS_N_EVALUATIONS = 'nEvaluations';
    public const DETAIL_METRICS_T_ABANDON = 'tAbandon';
    public const DETAIL_METRICS_T_IVR = 'tIvr';
    public const DETAIL_METRICS_T_ANSWERED = 'tAnswered';
    public const DETAIL_METRICS_T_FLOW_OUT = 'tFlowOut';
    public const DETAIL_METRICS_T_ACD = 'tAcd';
    public const DETAIL_METRICS_T_TALK = 'tTalk';
    public const DETAIL_METRICS_T_HELD = 'tHeld';
    public const DETAIL_METRICS_T_TALK_COMPLETE = 'tTalkComplete';
    public const DETAIL_METRICS_T_HELD_COMPLETE = 'tHeldComplete';
    public const DETAIL_METRICS_T_ACW = 'tAcw';
    public const DETAIL_METRICS_T_HANDLE = 'tHandle';
    public const DETAIL_METRICS_T_CONTACTING = 'tContacting';
    public const DETAIL_METRICS_T_DIALING = 'tDialing';
    public const DETAIL_METRICS_T_WAIT = 'tWait';
    public const DETAIL_METRICS_T_AGENT_ROUTING_STATUS = 'tAgentRoutingStatus';
    public const DETAIL_METRICS_T_ORGANIZATION_PRESENCE = 'tOrganizationPresence';
    public const DETAIL_METRICS_T_SYSTEM_PRESENCE = 'tSystemPresence';
    public const DETAIL_METRICS_T_USER_RESPONSE_TIME = 'tUserResponseTime';
    public const DETAIL_METRICS_T_AGENT_RESPONSE_TIME = 'tAgentResponseTime';
    public const DETAIL_METRICS_T_VOICEMAIL = 'tVoicemail';
    public const DETAIL_METRICS_N_STATE_TRANSITION_ERROR = 'nStateTransitionError';
    public const DETAIL_METRICS_N_OFFERED = 'nOffered';
    public const DETAIL_METRICS_N_OVER_SLA = 'nOverSla';
    public const DETAIL_METRICS_N_TRANSFERRED = 'nTransferred';
    public const DETAIL_METRICS_N_BLIND_TRANSFERRED = 'nBlindTransferred';
    public const DETAIL_METRICS_N_CONSULT_TRANSFERRED = 'nConsultTransferred';
    public const DETAIL_METRICS_N_CONSULT = 'nConsult';
    public const DETAIL_METRICS_N_CONNECTED = 'nConnected';
    public const DETAIL_METRICS_T_ALERT = 'tAlert';
    public const DETAIL_METRICS_T_NOT_RESPONDING = 'tNotResponding';
    public const DETAIL_METRICS_N_OUTBOUND = 'nOutbound';
    public const DETAIL_METRICS_N_OUTBOUND_ATTEMPTED = 'nOutboundAttempted';
    public const DETAIL_METRICS_N_OUTBOUND_CONNECTED = 'nOutboundConnected';
    public const DETAIL_METRICS_N_OUTBOUND_ABANDONED = 'nOutboundAbandoned';
    public const DETAIL_METRICS_N_ERROR = 'nError';
    public const DETAIL_METRICS_O_SERVICE_TARGET = 'oServiceTarget';
    public const DETAIL_METRICS_O_SERVICE_LEVEL = 'oServiceLevel';
    public const DETAIL_METRICS_T_ACTIVE = 'tActive';
    public const DETAIL_METRICS_T_INACTIVE = 'tInactive';
    public const DETAIL_METRICS_O_ACTIVE_USERS = 'oActiveUsers';
    public const DETAIL_METRICS_O_MEMBER_USERS = 'oMemberUsers';
    public const DETAIL_METRICS_O_ACTIVE_QUEUES = 'oActiveQueues';
    public const DETAIL_METRICS_O_MEMBER_QUEUES = 'oMemberQueues';
    public const DETAIL_METRICS_O_INTERACTING = 'oInteracting';
    public const DETAIL_METRICS_O_WAITING = 'oWaiting';
    public const DETAIL_METRICS_O_ON_QUEUE_USERS = 'oOnQueueUsers';
    public const DETAIL_METRICS_O_OFF_QUEUE_USERS = 'oOffQueueUsers';
    public const DETAIL_METRICS_O_USER_PRESENCES = 'oUserPresences';
    public const DETAIL_METRICS_O_USER_ROUTING_STATUSES = 'oUserRoutingStatuses';
    public const DETAIL_METRICS_N_SURVEYS_SENT = 'nSurveysSent';
    public const DETAIL_METRICS_N_SURVEYS_STARTED = 'nSurveysStarted';
    public const DETAIL_METRICS_N_SURVEYS_ABANDONED = 'nSurveysAbandoned';
    public const DETAIL_METRICS_N_SURVEYS_EXPIRED = 'nSurveysExpired';
    public const DETAIL_METRICS_N_SURVEY_ERRORS = 'nSurveyErrors';
    public const DETAIL_METRICS_N_SURVEY_RESPONSES = 'nSurveyResponses';
    public const DETAIL_METRICS_N_SURVEY_ANSWER_RESPONSES = 'nSurveyAnswerResponses';
    public const DETAIL_METRICS_O_SURVEY_TOTAL_SCORE = 'oSurveyTotalScore';
    public const DETAIL_METRICS_O_SURVEY_QUESTION_GROUP_SCORE = 'oSurveyQuestionGroupScore';
    public const DETAIL_METRICS_N_SURVEY_QUESTION_GROUP_RESPONSES = 'nSurveyQuestionGroupResponses';
    public const DETAIL_METRICS_O_SURVEY_QUESTION_SCORE = 'oSurveyQuestionScore';
    public const DETAIL_METRICS_N_SURVEY_QUESTION_RESPONSES = 'nSurveyQuestionResponses';
    public const DETAIL_METRICS_N_SURVEY_NPS_RESPONSES = 'nSurveyNpsResponses';
    public const DETAIL_METRICS_N_SURVEY_NPS_PROMOTERS = 'nSurveyNpsPromoters';
    public const DETAIL_METRICS_N_SURVEY_NPS_DETRACTORS = 'nSurveyNpsDetractors';
    public const DETAIL_METRICS_N_FLOW = 'nFlow';
    public const DETAIL_METRICS_T_FLOW_DISCONNECT = 'tFlowDisconnect';
    public const DETAIL_METRICS_T_FLOW_EXIT = 'tFlowExit';
    public const DETAIL_METRICS_T_FLOW = 'tFlow';
    public const DETAIL_METRICS_O_FLOW = 'oFlow';
    public const DETAIL_METRICS_T_FLOW_OUTCOME = 'tFlowOutcome';
    public const DETAIL_METRICS_N_FLOW_OUTCOME = 'nFlowOutcome';
    public const DETAIL_METRICS_N_FLOW_OUTCOME_FAILED = 'nFlowOutcomeFailed';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMetricsAllowableValues()
    {
        return [
            self::METRICS_T_SEGMENT_DURATION,
            self::METRICS_T_CONVERSATION_DURATION,
            self::METRICS_O_TOTAL_CRITICAL_SCORE,
            self::METRICS_O_TOTAL_SCORE,
            self::METRICS_N_EVALUATIONS,
            self::METRICS_T_ABANDON,
            self::METRICS_T_IVR,
            self::METRICS_T_ANSWERED,
            self::METRICS_T_FLOW_OUT,
            self::METRICS_T_ACD,
            self::METRICS_T_TALK,
            self::METRICS_T_HELD,
            self::METRICS_T_TALK_COMPLETE,
            self::METRICS_T_HELD_COMPLETE,
            self::METRICS_T_ACW,
            self::METRICS_T_HANDLE,
            self::METRICS_T_CONTACTING,
            self::METRICS_T_DIALING,
            self::METRICS_T_WAIT,
            self::METRICS_T_AGENT_ROUTING_STATUS,
            self::METRICS_T_ORGANIZATION_PRESENCE,
            self::METRICS_T_SYSTEM_PRESENCE,
            self::METRICS_T_USER_RESPONSE_TIME,
            self::METRICS_T_AGENT_RESPONSE_TIME,
            self::METRICS_T_VOICEMAIL,
            self::METRICS_N_STATE_TRANSITION_ERROR,
            self::METRICS_N_OFFERED,
            self::METRICS_N_OVER_SLA,
            self::METRICS_N_TRANSFERRED,
            self::METRICS_N_BLIND_TRANSFERRED,
            self::METRICS_N_CONSULT_TRANSFERRED,
            self::METRICS_N_CONSULT,
            self::METRICS_N_CONNECTED,
            self::METRICS_T_ALERT,
            self::METRICS_T_NOT_RESPONDING,
            self::METRICS_N_OUTBOUND,
            self::METRICS_N_OUTBOUND_ATTEMPTED,
            self::METRICS_N_OUTBOUND_CONNECTED,
            self::METRICS_N_OUTBOUND_ABANDONED,
            self::METRICS_N_ERROR,
            self::METRICS_O_SERVICE_TARGET,
            self::METRICS_O_SERVICE_LEVEL,
            self::METRICS_T_ACTIVE,
            self::METRICS_T_INACTIVE,
            self::METRICS_O_ACTIVE_USERS,
            self::METRICS_O_MEMBER_USERS,
            self::METRICS_O_ACTIVE_QUEUES,
            self::METRICS_O_MEMBER_QUEUES,
            self::METRICS_O_INTERACTING,
            self::METRICS_O_WAITING,
            self::METRICS_O_ON_QUEUE_USERS,
            self::METRICS_O_OFF_QUEUE_USERS,
            self::METRICS_O_USER_PRESENCES,
            self::METRICS_O_USER_ROUTING_STATUSES,
            self::METRICS_N_SURVEYS_SENT,
            self::METRICS_N_SURVEYS_STARTED,
            self::METRICS_N_SURVEYS_ABANDONED,
            self::METRICS_N_SURVEYS_EXPIRED,
            self::METRICS_N_SURVEY_ERRORS,
            self::METRICS_N_SURVEY_RESPONSES,
            self::METRICS_N_SURVEY_ANSWER_RESPONSES,
            self::METRICS_O_SURVEY_TOTAL_SCORE,
            self::METRICS_O_SURVEY_QUESTION_GROUP_SCORE,
            self::METRICS_N_SURVEY_QUESTION_GROUP_RESPONSES,
            self::METRICS_O_SURVEY_QUESTION_SCORE,
            self::METRICS_N_SURVEY_QUESTION_RESPONSES,
            self::METRICS_N_SURVEY_NPS_RESPONSES,
            self::METRICS_N_SURVEY_NPS_PROMOTERS,
            self::METRICS_N_SURVEY_NPS_DETRACTORS,
            self::METRICS_N_FLOW,
            self::METRICS_T_FLOW_DISCONNECT,
            self::METRICS_T_FLOW_EXIT,
            self::METRICS_T_FLOW,
            self::METRICS_O_FLOW,
            self::METRICS_T_FLOW_OUTCOME,
            self::METRICS_N_FLOW_OUTCOME,
            self::METRICS_N_FLOW_OUTCOME_FAILED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDetailMetricsAllowableValues()
    {
        return [
            self::DETAIL_METRICS_T_SEGMENT_DURATION,
            self::DETAIL_METRICS_T_CONVERSATION_DURATION,
            self::DETAIL_METRICS_O_TOTAL_CRITICAL_SCORE,
            self::DETAIL_METRICS_O_TOTAL_SCORE,
            self::DETAIL_METRICS_N_EVALUATIONS,
            self::DETAIL_METRICS_T_ABANDON,
            self::DETAIL_METRICS_T_IVR,
            self::DETAIL_METRICS_T_ANSWERED,
            self::DETAIL_METRICS_T_FLOW_OUT,
            self::DETAIL_METRICS_T_ACD,
            self::DETAIL_METRICS_T_TALK,
            self::DETAIL_METRICS_T_HELD,
            self::DETAIL_METRICS_T_TALK_COMPLETE,
            self::DETAIL_METRICS_T_HELD_COMPLETE,
            self::DETAIL_METRICS_T_ACW,
            self::DETAIL_METRICS_T_HANDLE,
            self::DETAIL_METRICS_T_CONTACTING,
            self::DETAIL_METRICS_T_DIALING,
            self::DETAIL_METRICS_T_WAIT,
            self::DETAIL_METRICS_T_AGENT_ROUTING_STATUS,
            self::DETAIL_METRICS_T_ORGANIZATION_PRESENCE,
            self::DETAIL_METRICS_T_SYSTEM_PRESENCE,
            self::DETAIL_METRICS_T_USER_RESPONSE_TIME,
            self::DETAIL_METRICS_T_AGENT_RESPONSE_TIME,
            self::DETAIL_METRICS_T_VOICEMAIL,
            self::DETAIL_METRICS_N_STATE_TRANSITION_ERROR,
            self::DETAIL_METRICS_N_OFFERED,
            self::DETAIL_METRICS_N_OVER_SLA,
            self::DETAIL_METRICS_N_TRANSFERRED,
            self::DETAIL_METRICS_N_BLIND_TRANSFERRED,
            self::DETAIL_METRICS_N_CONSULT_TRANSFERRED,
            self::DETAIL_METRICS_N_CONSULT,
            self::DETAIL_METRICS_N_CONNECTED,
            self::DETAIL_METRICS_T_ALERT,
            self::DETAIL_METRICS_T_NOT_RESPONDING,
            self::DETAIL_METRICS_N_OUTBOUND,
            self::DETAIL_METRICS_N_OUTBOUND_ATTEMPTED,
            self::DETAIL_METRICS_N_OUTBOUND_CONNECTED,
            self::DETAIL_METRICS_N_OUTBOUND_ABANDONED,
            self::DETAIL_METRICS_N_ERROR,
            self::DETAIL_METRICS_O_SERVICE_TARGET,
            self::DETAIL_METRICS_O_SERVICE_LEVEL,
            self::DETAIL_METRICS_T_ACTIVE,
            self::DETAIL_METRICS_T_INACTIVE,
            self::DETAIL_METRICS_O_ACTIVE_USERS,
            self::DETAIL_METRICS_O_MEMBER_USERS,
            self::DETAIL_METRICS_O_ACTIVE_QUEUES,
            self::DETAIL_METRICS_O_MEMBER_QUEUES,
            self::DETAIL_METRICS_O_INTERACTING,
            self::DETAIL_METRICS_O_WAITING,
            self::DETAIL_METRICS_O_ON_QUEUE_USERS,
            self::DETAIL_METRICS_O_OFF_QUEUE_USERS,
            self::DETAIL_METRICS_O_USER_PRESENCES,
            self::DETAIL_METRICS_O_USER_ROUTING_STATUSES,
            self::DETAIL_METRICS_N_SURVEYS_SENT,
            self::DETAIL_METRICS_N_SURVEYS_STARTED,
            self::DETAIL_METRICS_N_SURVEYS_ABANDONED,
            self::DETAIL_METRICS_N_SURVEYS_EXPIRED,
            self::DETAIL_METRICS_N_SURVEY_ERRORS,
            self::DETAIL_METRICS_N_SURVEY_RESPONSES,
            self::DETAIL_METRICS_N_SURVEY_ANSWER_RESPONSES,
            self::DETAIL_METRICS_O_SURVEY_TOTAL_SCORE,
            self::DETAIL_METRICS_O_SURVEY_QUESTION_GROUP_SCORE,
            self::DETAIL_METRICS_N_SURVEY_QUESTION_GROUP_RESPONSES,
            self::DETAIL_METRICS_O_SURVEY_QUESTION_SCORE,
            self::DETAIL_METRICS_N_SURVEY_QUESTION_RESPONSES,
            self::DETAIL_METRICS_N_SURVEY_NPS_RESPONSES,
            self::DETAIL_METRICS_N_SURVEY_NPS_PROMOTERS,
            self::DETAIL_METRICS_N_SURVEY_NPS_DETRACTORS,
            self::DETAIL_METRICS_N_FLOW,
            self::DETAIL_METRICS_T_FLOW_DISCONNECT,
            self::DETAIL_METRICS_T_FLOW_EXIT,
            self::DETAIL_METRICS_T_FLOW,
            self::DETAIL_METRICS_O_FLOW,
            self::DETAIL_METRICS_T_FLOW_OUTCOME,
            self::DETAIL_METRICS_N_FLOW_OUTCOME,
            self::DETAIL_METRICS_N_FLOW_OUTCOME_FAILED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['filter'] = isset($data['filter']) ? $data['filter'] : null;
        $this->container['metrics'] = isset($data['metrics']) ? $data['metrics'] : null;
        $this->container['detailMetrics'] = isset($data['detailMetrics']) ? $data['detailMetrics'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['filter'] === null) {
            $invalid_properties[] = "'filter' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['filter'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets filter
     * @return \PureCloudSDK\AnalyticsQueryFilter
     */
    public function getFilter()
    {
        return $this->container['filter'];
    }

    /**
     * Sets filter
     * @param \PureCloudSDK\AnalyticsQueryFilter $filter Filter to return a subset of observations. Expresses boolean logical predicates as well as dimensional filters
     * @return $this
     */
    public function setFilter($filter)
    {
        $this->container['filter'] = $filter;

        return $this;
    }

    /**
     * Gets metrics
     * @return string[]
     */
    public function getMetrics()
    {
        return $this->container['metrics'];
    }

    /**
     * Sets metrics
     * @param string[] $metrics Behaves like a SQL SELECT clause. Enables retrieving only named metrics. If omitted, all metrics that are available will be returned (like SELECT *).
     * @return $this
     */
    public function setMetrics($metrics)
    {
        $allowed_values = array('tSegmentDuration', 'tConversationDuration', 'oTotalCriticalScore', 'oTotalScore', 'nEvaluations', 'tAbandon', 'tIvr', 'tAnswered', 'tFlowOut', 'tAcd', 'tTalk', 'tHeld', 'tTalkComplete', 'tHeldComplete', 'tAcw', 'tHandle', 'tContacting', 'tDialing', 'tWait', 'tAgentRoutingStatus', 'tOrganizationPresence', 'tSystemPresence', 'tUserResponseTime', 'tAgentResponseTime', 'tVoicemail', 'nStateTransitionError', 'nOffered', 'nOverSla', 'nTransferred', 'nBlindTransferred', 'nConsultTransferred', 'nConsult', 'nConnected', 'tAlert', 'tNotResponding', 'nOutbound', 'nOutboundAttempted', 'nOutboundConnected', 'nOutboundAbandoned', 'nError', 'oServiceTarget', 'oServiceLevel', 'tActive', 'tInactive', 'oActiveUsers', 'oMemberUsers', 'oActiveQueues', 'oMemberQueues', 'oInteracting', 'oWaiting', 'oOnQueueUsers', 'oOffQueueUsers', 'oUserPresences', 'oUserRoutingStatuses', 'nSurveysSent', 'nSurveysStarted', 'nSurveysAbandoned', 'nSurveysExpired', 'nSurveyErrors', 'nSurveyResponses', 'nSurveyAnswerResponses', 'oSurveyTotalScore', 'oSurveyQuestionGroupScore', 'nSurveyQuestionGroupResponses', 'oSurveyQuestionScore', 'nSurveyQuestionResponses', 'nSurveyNpsResponses', 'nSurveyNpsPromoters', 'nSurveyNpsDetractors', 'nFlow', 'tFlowDisconnect', 'tFlowExit', 'tFlow', 'oFlow', 'tFlowOutcome', 'nFlowOutcome', 'nFlowOutcomeFailed');
        if (!in_array($metrics, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'metrics', must be one of 'tSegmentDuration', 'tConversationDuration', 'oTotalCriticalScore', 'oTotalScore', 'nEvaluations', 'tAbandon', 'tIvr', 'tAnswered', 'tFlowOut', 'tAcd', 'tTalk', 'tHeld', 'tTalkComplete', 'tHeldComplete', 'tAcw', 'tHandle', 'tContacting', 'tDialing', 'tWait', 'tAgentRoutingStatus', 'tOrganizationPresence', 'tSystemPresence', 'tUserResponseTime', 'tAgentResponseTime', 'tVoicemail', 'nStateTransitionError', 'nOffered', 'nOverSla', 'nTransferred', 'nBlindTransferred', 'nConsultTransferred', 'nConsult', 'nConnected', 'tAlert', 'tNotResponding', 'nOutbound', 'nOutboundAttempted', 'nOutboundConnected', 'nOutboundAbandoned', 'nError', 'oServiceTarget', 'oServiceLevel', 'tActive', 'tInactive', 'oActiveUsers', 'oMemberUsers', 'oActiveQueues', 'oMemberQueues', 'oInteracting', 'oWaiting', 'oOnQueueUsers', 'oOffQueueUsers', 'oUserPresences', 'oUserRoutingStatuses', 'nSurveysSent', 'nSurveysStarted', 'nSurveysAbandoned', 'nSurveysExpired', 'nSurveyErrors', 'nSurveyResponses', 'nSurveyAnswerResponses', 'oSurveyTotalScore', 'oSurveyQuestionGroupScore', 'nSurveyQuestionGroupResponses', 'oSurveyQuestionScore', 'nSurveyQuestionResponses', 'nSurveyNpsResponses', 'nSurveyNpsPromoters', 'nSurveyNpsDetractors', 'nFlow', 'tFlowDisconnect', 'tFlowExit', 'tFlow', 'oFlow', 'tFlowOutcome', 'nFlowOutcome', 'nFlowOutcomeFailed'");
        }
        $this->container['metrics'] = $metrics;

        return $this;
    }

    /**
     * Gets detailMetrics
     * @return string[]
     */
    public function getDetailMetrics()
    {
        return $this->container['detailMetrics'];
    }

    /**
     * Sets detailMetrics
     * @param string[] $detailMetrics Metrics for which to include additional detailed observations
     * @return $this
     */
    public function setDetailMetrics($detailMetrics)
    {
        $allowed_values = array('tSegmentDuration', 'tConversationDuration', 'oTotalCriticalScore', 'oTotalScore', 'nEvaluations', 'tAbandon', 'tIvr', 'tAnswered', 'tFlowOut', 'tAcd', 'tTalk', 'tHeld', 'tTalkComplete', 'tHeldComplete', 'tAcw', 'tHandle', 'tContacting', 'tDialing', 'tWait', 'tAgentRoutingStatus', 'tOrganizationPresence', 'tSystemPresence', 'tUserResponseTime', 'tAgentResponseTime', 'tVoicemail', 'nStateTransitionError', 'nOffered', 'nOverSla', 'nTransferred', 'nBlindTransferred', 'nConsultTransferred', 'nConsult', 'nConnected', 'tAlert', 'tNotResponding', 'nOutbound', 'nOutboundAttempted', 'nOutboundConnected', 'nOutboundAbandoned', 'nError', 'oServiceTarget', 'oServiceLevel', 'tActive', 'tInactive', 'oActiveUsers', 'oMemberUsers', 'oActiveQueues', 'oMemberQueues', 'oInteracting', 'oWaiting', 'oOnQueueUsers', 'oOffQueueUsers', 'oUserPresences', 'oUserRoutingStatuses', 'nSurveysSent', 'nSurveysStarted', 'nSurveysAbandoned', 'nSurveysExpired', 'nSurveyErrors', 'nSurveyResponses', 'nSurveyAnswerResponses', 'oSurveyTotalScore', 'oSurveyQuestionGroupScore', 'nSurveyQuestionGroupResponses', 'oSurveyQuestionScore', 'nSurveyQuestionResponses', 'nSurveyNpsResponses', 'nSurveyNpsPromoters', 'nSurveyNpsDetractors', 'nFlow', 'tFlowDisconnect', 'tFlowExit', 'tFlow', 'oFlow', 'tFlowOutcome', 'nFlowOutcome', 'nFlowOutcomeFailed');
        if (!in_array($detailMetrics, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'detailMetrics', must be one of 'tSegmentDuration', 'tConversationDuration', 'oTotalCriticalScore', 'oTotalScore', 'nEvaluations', 'tAbandon', 'tIvr', 'tAnswered', 'tFlowOut', 'tAcd', 'tTalk', 'tHeld', 'tTalkComplete', 'tHeldComplete', 'tAcw', 'tHandle', 'tContacting', 'tDialing', 'tWait', 'tAgentRoutingStatus', 'tOrganizationPresence', 'tSystemPresence', 'tUserResponseTime', 'tAgentResponseTime', 'tVoicemail', 'nStateTransitionError', 'nOffered', 'nOverSla', 'nTransferred', 'nBlindTransferred', 'nConsultTransferred', 'nConsult', 'nConnected', 'tAlert', 'tNotResponding', 'nOutbound', 'nOutboundAttempted', 'nOutboundConnected', 'nOutboundAbandoned', 'nError', 'oServiceTarget', 'oServiceLevel', 'tActive', 'tInactive', 'oActiveUsers', 'oMemberUsers', 'oActiveQueues', 'oMemberQueues', 'oInteracting', 'oWaiting', 'oOnQueueUsers', 'oOffQueueUsers', 'oUserPresences', 'oUserRoutingStatuses', 'nSurveysSent', 'nSurveysStarted', 'nSurveysAbandoned', 'nSurveysExpired', 'nSurveyErrors', 'nSurveyResponses', 'nSurveyAnswerResponses', 'oSurveyTotalScore', 'oSurveyQuestionGroupScore', 'nSurveyQuestionGroupResponses', 'oSurveyQuestionScore', 'nSurveyQuestionResponses', 'nSurveyNpsResponses', 'nSurveyNpsPromoters', 'nSurveyNpsDetractors', 'nFlow', 'tFlowDisconnect', 'tFlowExit', 'tFlow', 'oFlow', 'tFlowOutcome', 'nFlowOutcome', 'nFlowOutcomeFailed'");
        }
        $this->container['detailMetrics'] = $detailMetrics;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


