<?php

/**
 * QueueUtilizationDiagnostic
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * QueueUtilizationDiagnostic Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class QueueUtilizationDiagnostic implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'QueueUtilizationDiagnostic';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'queue' => '\PureCloudSDK\UriReference',
        'usersInQueue' => 'int',
        'activeUsersInQueue' => 'int',
        'usersOnQueue' => 'int',
        'usersNotUtilized' => 'int',
        'usersOnQueueWithStation' => 'int',
        'usersOnACampaignCall' => 'int',
        'usersOnDifferentEdgeGroup' => 'int',
        'usersOnANonCampaignCall' => 'int'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'queue' => 'queue',
        'usersInQueue' => 'usersInQueue',
        'activeUsersInQueue' => 'activeUsersInQueue',
        'usersOnQueue' => 'usersOnQueue',
        'usersNotUtilized' => 'usersNotUtilized',
        'usersOnQueueWithStation' => 'usersOnQueueWithStation',
        'usersOnACampaignCall' => 'usersOnACampaignCall',
        'usersOnDifferentEdgeGroup' => 'usersOnDifferentEdgeGroup',
        'usersOnANonCampaignCall' => 'usersOnANonCampaignCall'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'queue' => 'setQueue',
        'usersInQueue' => 'setUsersInQueue',
        'activeUsersInQueue' => 'setActiveUsersInQueue',
        'usersOnQueue' => 'setUsersOnQueue',
        'usersNotUtilized' => 'setUsersNotUtilized',
        'usersOnQueueWithStation' => 'setUsersOnQueueWithStation',
        'usersOnACampaignCall' => 'setUsersOnACampaignCall',
        'usersOnDifferentEdgeGroup' => 'setUsersOnDifferentEdgeGroup',
        'usersOnANonCampaignCall' => 'setUsersOnANonCampaignCall'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'queue' => 'getQueue',
        'usersInQueue' => 'getUsersInQueue',
        'activeUsersInQueue' => 'getActiveUsersInQueue',
        'usersOnQueue' => 'getUsersOnQueue',
        'usersNotUtilized' => 'getUsersNotUtilized',
        'usersOnQueueWithStation' => 'getUsersOnQueueWithStation',
        'usersOnACampaignCall' => 'getUsersOnACampaignCall',
        'usersOnDifferentEdgeGroup' => 'getUsersOnDifferentEdgeGroup',
        'usersOnANonCampaignCall' => 'getUsersOnANonCampaignCall'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['queue'] = isset($data['queue']) ? $data['queue'] : null;
        $this->container['usersInQueue'] = isset($data['usersInQueue']) ? $data['usersInQueue'] : null;
        $this->container['activeUsersInQueue'] = isset($data['activeUsersInQueue']) ? $data['activeUsersInQueue'] : null;
        $this->container['usersOnQueue'] = isset($data['usersOnQueue']) ? $data['usersOnQueue'] : null;
        $this->container['usersNotUtilized'] = isset($data['usersNotUtilized']) ? $data['usersNotUtilized'] : null;
        $this->container['usersOnQueueWithStation'] = isset($data['usersOnQueueWithStation']) ? $data['usersOnQueueWithStation'] : null;
        $this->container['usersOnACampaignCall'] = isset($data['usersOnACampaignCall']) ? $data['usersOnACampaignCall'] : null;
        $this->container['usersOnDifferentEdgeGroup'] = isset($data['usersOnDifferentEdgeGroup']) ? $data['usersOnDifferentEdgeGroup'] : null;
        $this->container['usersOnANonCampaignCall'] = isset($data['usersOnANonCampaignCall']) ? $data['usersOnANonCampaignCall'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets queue
     * @return \PureCloudSDK\UriReference
     */
    public function getQueue()
    {
        return $this->container['queue'];
    }

    /**
     * Sets queue
     * @param \PureCloudSDK\UriReference $queue Identifier of the queue
     * @return $this
     */
    public function setQueue($queue)
    {
        $this->container['queue'] = $queue;

        return $this;
    }

    /**
     * Gets usersInQueue
     * @return int
     */
    public function getUsersInQueue()
    {
        return $this->container['usersInQueue'];
    }

    /**
     * Sets usersInQueue
     * @param int $usersInQueue The number of users joined to the queue
     * @return $this
     */
    public function setUsersInQueue($usersInQueue)
    {
        $this->container['usersInQueue'] = $usersInQueue;

        return $this;
    }

    /**
     * Gets activeUsersInQueue
     * @return int
     */
    public function getActiveUsersInQueue()
    {
        return $this->container['activeUsersInQueue'];
    }

    /**
     * Sets activeUsersInQueue
     * @param int $activeUsersInQueue The number of users active on the queue
     * @return $this
     */
    public function setActiveUsersInQueue($activeUsersInQueue)
    {
        $this->container['activeUsersInQueue'] = $activeUsersInQueue;

        return $this;
    }

    /**
     * Gets usersOnQueue
     * @return int
     */
    public function getUsersOnQueue()
    {
        return $this->container['usersOnQueue'];
    }

    /**
     * Sets usersOnQueue
     * @param int $usersOnQueue The number of users with a status of on-queue
     * @return $this
     */
    public function setUsersOnQueue($usersOnQueue)
    {
        $this->container['usersOnQueue'] = $usersOnQueue;

        return $this;
    }

    /**
     * Gets usersNotUtilized
     * @return int
     */
    public function getUsersNotUtilized()
    {
        return $this->container['usersNotUtilized'];
    }

    /**
     * Sets usersNotUtilized
     * @param int $usersNotUtilized The number of users in the queue currently not engaged
     * @return $this
     */
    public function setUsersNotUtilized($usersNotUtilized)
    {
        $this->container['usersNotUtilized'] = $usersNotUtilized;

        return $this;
    }

    /**
     * Gets usersOnQueueWithStation
     * @return int
     */
    public function getUsersOnQueueWithStation()
    {
        return $this->container['usersOnQueueWithStation'];
    }

    /**
     * Sets usersOnQueueWithStation
     * @param int $usersOnQueueWithStation The number of users in the queue with a station
     * @return $this
     */
    public function setUsersOnQueueWithStation($usersOnQueueWithStation)
    {
        $this->container['usersOnQueueWithStation'] = $usersOnQueueWithStation;

        return $this;
    }

    /**
     * Gets usersOnACampaignCall
     * @return int
     */
    public function getUsersOnACampaignCall()
    {
        return $this->container['usersOnACampaignCall'];
    }

    /**
     * Sets usersOnACampaignCall
     * @param int $usersOnACampaignCall The number of users currently engaged in a campaign call
     * @return $this
     */
    public function setUsersOnACampaignCall($usersOnACampaignCall)
    {
        $this->container['usersOnACampaignCall'] = $usersOnACampaignCall;

        return $this;
    }

    /**
     * Gets usersOnDifferentEdgeGroup
     * @return int
     */
    public function getUsersOnDifferentEdgeGroup()
    {
        return $this->container['usersOnDifferentEdgeGroup'];
    }

    /**
     * Sets usersOnDifferentEdgeGroup
     * @param int $usersOnDifferentEdgeGroup The number of users whose station is homed to an edge different from the campaign
     * @return $this
     */
    public function setUsersOnDifferentEdgeGroup($usersOnDifferentEdgeGroup)
    {
        $this->container['usersOnDifferentEdgeGroup'] = $usersOnDifferentEdgeGroup;

        return $this;
    }

    /**
     * Gets usersOnANonCampaignCall
     * @return int
     */
    public function getUsersOnANonCampaignCall()
    {
        return $this->container['usersOnANonCampaignCall'];
    }

    /**
     * Sets usersOnANonCampaignCall
     * @param int $usersOnANonCampaignCall The number of users currently engaged in a communication that is not part of the campaign
     * @return $this
     */
    public function setUsersOnANonCampaignCall($usersOnANonCampaignCall)
    {
        $this->container['usersOnANonCampaignCall'] = $usersOnANonCampaignCall;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


