<?php

/**
 * ResourceConditionNode
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ResourceConditionNode Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ResourceConditionNode implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ResourceConditionNode';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'variableName' => 'string',
        'conjunction' => 'string',
        'operator' => 'string',
        'operands' => '\PureCloudSDK\ResourceConditionValue[]',
        'terms' => '\PureCloudSDK\ResourceConditionNode[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'variableName' => 'variableName',
        'conjunction' => 'conjunction',
        'operator' => 'operator',
        'operands' => 'operands',
        'terms' => 'terms'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'variableName' => 'setVariableName',
        'conjunction' => 'setConjunction',
        'operator' => 'setOperator',
        'operands' => 'setOperands',
        'terms' => 'setTerms'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'variableName' => 'getVariableName',
        'conjunction' => 'getConjunction',
        'operator' => 'getOperator',
        'operands' => 'getOperands',
        'terms' => 'getTerms'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const CONJUNCTION_AND = 'AND';
    public const CONJUNCTION_OR = 'OR';
    public const OPERATOR_EQ = 'EQ';
    public const OPERATOR_IN = 'IN';
    public const OPERATOR_GE = 'GE';
    public const OPERATOR_GT = 'GT';
    public const OPERATOR_LE = 'LE';
    public const OPERATOR_LT = 'LT';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getConjunctionAllowableValues()
    {
        return [
            self::CONJUNCTION_AND,
            self::CONJUNCTION_OR,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOperatorAllowableValues()
    {
        return [
            self::OPERATOR_EQ,
            self::OPERATOR_IN,
            self::OPERATOR_GE,
            self::OPERATOR_GT,
            self::OPERATOR_LE,
            self::OPERATOR_LT,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['variableName'] = isset($data['variableName']) ? $data['variableName'] : null;
        $this->container['conjunction'] = isset($data['conjunction']) ? $data['conjunction'] : null;
        $this->container['operator'] = isset($data['operator']) ? $data['operator'] : null;
        $this->container['operands'] = isset($data['operands']) ? $data['operands'] : null;
        $this->container['terms'] = isset($data['terms']) ? $data['terms'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("AND", "OR");
        if (!in_array($this->container['conjunction'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'conjunction', must be one of #{allowed_values}.";
        }

        $allowed_values = array("EQ", "IN", "GE", "GT", "LE", "LT");
        if (!in_array($this->container['operator'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'operator', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("AND", "OR");
        if (!in_array($this->container['conjunction'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("EQ", "IN", "GE", "GT", "LE", "LT");
        if (!in_array($this->container['operator'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets variableName
     * @return string
     */
    public function getVariableName()
    {
        return $this->container['variableName'];
    }

    /**
     * Sets variableName
     * @param string $variableName
     * @return $this
     */
    public function setVariableName($variableName)
    {
        $this->container['variableName'] = $variableName;

        return $this;
    }

    /**
     * Gets conjunction
     * @return string
     */
    public function getConjunction()
    {
        return $this->container['conjunction'];
    }

    /**
     * Sets conjunction
     * @param string $conjunction
     * @return $this
     */
    public function setConjunction($conjunction)
    {
        $allowed_values = array('AND', 'OR');
        if (!in_array($conjunction, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'conjunction', must be one of 'AND', 'OR'");
        }
        $this->container['conjunction'] = $conjunction;

        return $this;
    }

    /**
     * Gets operator
     * @return string
     */
    public function getOperator()
    {
        return $this->container['operator'];
    }

    /**
     * Sets operator
     * @param string $operator
     * @return $this
     */
    public function setOperator($operator)
    {
        $allowed_values = array('EQ', 'IN', 'GE', 'GT', 'LE', 'LT');
        if (!in_array($operator, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'operator', must be one of 'EQ', 'IN', 'GE', 'GT', 'LE', 'LT'");
        }
        $this->container['operator'] = $operator;

        return $this;
    }

    /**
     * Gets operands
     * @return \PureCloudSDK\ResourceConditionValue[]
     */
    public function getOperands()
    {
        return $this->container['operands'];
    }

    /**
     * Sets operands
     * @param \PureCloudSDK\ResourceConditionValue[] $operands
     * @return $this
     */
    public function setOperands($operands)
    {
        $this->container['operands'] = $operands;

        return $this;
    }

    /**
     * Gets terms
     * @return \PureCloudSDK\ResourceConditionNode[]
     */
    public function getTerms()
    {
        return $this->container['terms'];
    }

    /**
     * Sets terms
     * @param \PureCloudSDK\ResourceConditionNode[] $terms
     * @return $this
     */
    public function setTerms($terms)
    {
        $this->container['terms'] = $terms;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


