<?php

/**
 * ResourcePermissionPolicy
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ResourcePermissionPolicy Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ResourcePermissionPolicy implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ResourcePermissionPolicy';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'domain' => 'string',
        'entityName' => 'string',
        'policyName' => 'string',
        'policyDescription' => 'string',
        'actionSetKey' => 'string',
        'allowConditions' => 'bool',
        'resourceConditionNode' => '\PureCloudSDK\ResourceConditionNode',
        'namedResources' => 'string[]',
        'resourceCondition' => 'string',
        'actionSet' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'domain' => 'domain',
        'entityName' => 'entityName',
        'policyName' => 'policyName',
        'policyDescription' => 'policyDescription',
        'actionSetKey' => 'actionSetKey',
        'allowConditions' => 'allowConditions',
        'resourceConditionNode' => 'resourceConditionNode',
        'namedResources' => 'namedResources',
        'resourceCondition' => 'resourceCondition',
        'actionSet' => 'actionSet'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'domain' => 'setDomain',
        'entityName' => 'setEntityName',
        'policyName' => 'setPolicyName',
        'policyDescription' => 'setPolicyDescription',
        'actionSetKey' => 'setActionSetKey',
        'allowConditions' => 'setAllowConditions',
        'resourceConditionNode' => 'setResourceConditionNode',
        'namedResources' => 'setNamedResources',
        'resourceCondition' => 'setResourceCondition',
        'actionSet' => 'setActionSet'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'domain' => 'getDomain',
        'entityName' => 'getEntityName',
        'policyName' => 'getPolicyName',
        'policyDescription' => 'getPolicyDescription',
        'actionSetKey' => 'getActionSetKey',
        'allowConditions' => 'getAllowConditions',
        'resourceConditionNode' => 'getResourceConditionNode',
        'namedResources' => 'getNamedResources',
        'resourceCondition' => 'getResourceCondition',
        'actionSet' => 'getActionSet'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['domain'] = isset($data['domain']) ? $data['domain'] : null;
        $this->container['entityName'] = isset($data['entityName']) ? $data['entityName'] : null;
        $this->container['policyName'] = isset($data['policyName']) ? $data['policyName'] : null;
        $this->container['policyDescription'] = isset($data['policyDescription']) ? $data['policyDescription'] : null;
        $this->container['actionSetKey'] = isset($data['actionSetKey']) ? $data['actionSetKey'] : null;
        $this->container['allowConditions'] = isset($data['allowConditions']) ? $data['allowConditions'] : null;
        $this->container['resourceConditionNode'] = isset($data['resourceConditionNode']) ? $data['resourceConditionNode'] : null;
        $this->container['namedResources'] = isset($data['namedResources']) ? $data['namedResources'] : null;
        $this->container['resourceCondition'] = isset($data['resourceCondition']) ? $data['resourceCondition'] : null;
        $this->container['actionSet'] = isset($data['actionSet']) ? $data['actionSet'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets domain
     * @return string
     */
    public function getDomain()
    {
        return $this->container['domain'];
    }

    /**
     * Sets domain
     * @param string $domain
     * @return $this
     */
    public function setDomain($domain)
    {
        $this->container['domain'] = $domain;

        return $this;
    }

    /**
     * Gets entityName
     * @return string
     */
    public function getEntityName()
    {
        return $this->container['entityName'];
    }

    /**
     * Sets entityName
     * @param string $entityName
     * @return $this
     */
    public function setEntityName($entityName)
    {
        $this->container['entityName'] = $entityName;

        return $this;
    }

    /**
     * Gets policyName
     * @return string
     */
    public function getPolicyName()
    {
        return $this->container['policyName'];
    }

    /**
     * Sets policyName
     * @param string $policyName
     * @return $this
     */
    public function setPolicyName($policyName)
    {
        $this->container['policyName'] = $policyName;

        return $this;
    }

    /**
     * Gets policyDescription
     * @return string
     */
    public function getPolicyDescription()
    {
        return $this->container['policyDescription'];
    }

    /**
     * Sets policyDescription
     * @param string $policyDescription
     * @return $this
     */
    public function setPolicyDescription($policyDescription)
    {
        $this->container['policyDescription'] = $policyDescription;

        return $this;
    }

    /**
     * Gets actionSetKey
     * @return string
     */
    public function getActionSetKey()
    {
        return $this->container['actionSetKey'];
    }

    /**
     * Sets actionSetKey
     * @param string $actionSetKey
     * @return $this
     */
    public function setActionSetKey($actionSetKey)
    {
        $this->container['actionSetKey'] = $actionSetKey;

        return $this;
    }

    /**
     * Gets allowConditions
     * @return bool
     */
    public function getAllowConditions()
    {
        return $this->container['allowConditions'];
    }

    /**
     * Sets allowConditions
     * @param bool $allowConditions
     * @return $this
     */
    public function setAllowConditions($allowConditions)
    {
        $this->container['allowConditions'] = $allowConditions;

        return $this;
    }

    /**
     * Gets resourceConditionNode
     * @return \PureCloudSDK\ResourceConditionNode
     */
    public function getResourceConditionNode()
    {
        return $this->container['resourceConditionNode'];
    }

    /**
     * Sets resourceConditionNode
     * @param \PureCloudSDK\ResourceConditionNode $resourceConditionNode
     * @return $this
     */
    public function setResourceConditionNode($resourceConditionNode)
    {
        $this->container['resourceConditionNode'] = $resourceConditionNode;

        return $this;
    }

    /**
     * Gets namedResources
     * @return string[]
     */
    public function getNamedResources()
    {
        return $this->container['namedResources'];
    }

    /**
     * Sets namedResources
     * @param string[] $namedResources
     * @return $this
     */
    public function setNamedResources($namedResources)
    {
        $this->container['namedResources'] = $namedResources;

        return $this;
    }

    /**
     * Gets resourceCondition
     * @return string
     */
    public function getResourceCondition()
    {
        return $this->container['resourceCondition'];
    }

    /**
     * Sets resourceCondition
     * @param string $resourceCondition
     * @return $this
     */
    public function setResourceCondition($resourceCondition)
    {
        $this->container['resourceCondition'] = $resourceCondition;

        return $this;
    }

    /**
     * Gets actionSet
     * @return string[]
     */
    public function getActionSet()
    {
        return $this->container['actionSet'];
    }

    /**
     * Sets actionSet
     * @param string[] $actionSet
     * @return $this
     */
    public function setActionSet($actionSet)
    {
        $this->container['actionSet'] = $actionSet;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


