<?php

/**
 * UserSchedule
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * UserSchedule Class Doc Comment
 *
 * @category    Class */
 // @description A schedule for a single user over a given time range
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class UserSchedule implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'UserSchedule';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'shifts' => '\PureCloudSDK\UserScheduleShift[]',
        'fullDayTimeOffMarkers' => '\PureCloudSDK\UserScheduleFullDayTimeOffMarker[]',
        'delete' => 'bool',
        'metadata' => '\PureCloudSDK\WfmVersionedEntityMetadata',
        'workPlanId' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'shifts' => 'shifts',
        'fullDayTimeOffMarkers' => 'fullDayTimeOffMarkers',
        'delete' => 'delete',
        'metadata' => 'metadata',
        'workPlanId' => 'workPlanId'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'shifts' => 'setShifts',
        'fullDayTimeOffMarkers' => 'setFullDayTimeOffMarkers',
        'delete' => 'setDelete',
        'metadata' => 'setMetadata',
        'workPlanId' => 'setWorkPlanId'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'shifts' => 'getShifts',
        'fullDayTimeOffMarkers' => 'getFullDayTimeOffMarkers',
        'delete' => 'getDelete',
        'metadata' => 'getMetadata',
        'workPlanId' => 'getWorkPlanId'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['shifts'] = isset($data['shifts']) ? $data['shifts'] : null;
        $this->container['fullDayTimeOffMarkers'] = isset($data['fullDayTimeOffMarkers']) ? $data['fullDayTimeOffMarkers'] : null;
        $this->container['delete'] = isset($data['delete']) ? $data['delete'] : null;
        $this->container['metadata'] = isset($data['metadata']) ? $data['metadata'] : null;
        $this->container['workPlanId'] = isset($data['workPlanId']) ? $data['workPlanId'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['metadata'] === null) {
            $invalid_properties[] = "'metadata' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['metadata'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets shifts
     * @return \PureCloudSDK\UserScheduleShift[]
     */
    public function getShifts()
    {
        return $this->container['shifts'];
    }

    /**
     * Sets shifts
     * @param \PureCloudSDK\UserScheduleShift[] $shifts The shifts that belong to this schedule
     * @return $this
     */
    public function setShifts($shifts)
    {
        $this->container['shifts'] = $shifts;

        return $this;
    }

    /**
     * Gets fullDayTimeOffMarkers
     * @return \PureCloudSDK\UserScheduleFullDayTimeOffMarker[]
     */
    public function getFullDayTimeOffMarkers()
    {
        return $this->container['fullDayTimeOffMarkers'];
    }

    /**
     * Sets fullDayTimeOffMarkers
     * @param \PureCloudSDK\UserScheduleFullDayTimeOffMarker[] $fullDayTimeOffMarkers Markers to indicate a full day time off request, relative to the management unit time zone
     * @return $this
     */
    public function setFullDayTimeOffMarkers($fullDayTimeOffMarkers)
    {
        $this->container['fullDayTimeOffMarkers'] = $fullDayTimeOffMarkers;

        return $this;
    }

    /**
     * Gets delete
     * @return bool
     */
    public function getDelete()
    {
        return $this->container['delete'];
    }

    /**
     * Sets delete
     * @param bool $delete If marked true for updating an existing user schedule, it will be deleted
     * @return $this
     */
    public function setDelete($delete)
    {
        $this->container['delete'] = $delete;

        return $this;
    }

    /**
     * Gets metadata
     * @return \PureCloudSDK\WfmVersionedEntityMetadata
     */
    public function getMetadata()
    {
        return $this->container['metadata'];
    }

    /**
     * Sets metadata
     * @param \PureCloudSDK\WfmVersionedEntityMetadata $metadata Version metadata for this schedule
     * @return $this
     */
    public function setMetadata($metadata)
    {
        $this->container['metadata'] = $metadata;

        return $this;
    }

    /**
     * Gets workPlanId
     * @return string
     */
    public function getWorkPlanId()
    {
        return $this->container['workPlanId'];
    }

    /**
     * Sets workPlanId
     * @param string $workPlanId ID of the work plan associated with the user during schedule creation
     * @return $this
     */
    public function setWorkPlanId($workPlanId)
    {
        $this->container['workPlanId'] = $workPlanId;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


