<?php

/**
 * AsyncConversationQuery
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * AsyncConversationQuery Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AsyncConversationQuery implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AsyncConversationQuery';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'conversationFilters' => '\PureCloudSDK\ConversationDetailQueryFilter[]',
        'segmentFilters' => '\PureCloudSDK\SegmentDetailQueryFilter[]',
        'evaluationFilters' => '\PureCloudSDK\EvaluationDetailQueryFilter[]',
        'mediaEndpointStatFilters' => '\PureCloudSDK\MediaEndpointStatDetailQueryFilter[]',
        'surveyFilters' => '\PureCloudSDK\SurveyDetailQueryFilter[]',
        'order' => 'string',
        'orderBy' => 'string',
        'interval' => 'string',
        'limit' => 'int',
        'startOfDayIntervalMatching' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'conversationFilters' => 'conversationFilters',
        'segmentFilters' => 'segmentFilters',
        'evaluationFilters' => 'evaluationFilters',
        'mediaEndpointStatFilters' => 'mediaEndpointStatFilters',
        'surveyFilters' => 'surveyFilters',
        'order' => 'order',
        'orderBy' => 'orderBy',
        'interval' => 'interval',
        'limit' => 'limit',
        'startOfDayIntervalMatching' => 'startOfDayIntervalMatching'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'conversationFilters' => 'setConversationFilters',
        'segmentFilters' => 'setSegmentFilters',
        'evaluationFilters' => 'setEvaluationFilters',
        'mediaEndpointStatFilters' => 'setMediaEndpointStatFilters',
        'surveyFilters' => 'setSurveyFilters',
        'order' => 'setOrder',
        'orderBy' => 'setOrderBy',
        'interval' => 'setInterval',
        'limit' => 'setLimit',
        'startOfDayIntervalMatching' => 'setStartOfDayIntervalMatching'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'conversationFilters' => 'getConversationFilters',
        'segmentFilters' => 'getSegmentFilters',
        'evaluationFilters' => 'getEvaluationFilters',
        'mediaEndpointStatFilters' => 'getMediaEndpointStatFilters',
        'surveyFilters' => 'getSurveyFilters',
        'order' => 'getOrder',
        'orderBy' => 'getOrderBy',
        'interval' => 'getInterval',
        'limit' => 'getLimit',
        'startOfDayIntervalMatching' => 'getStartOfDayIntervalMatching'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const ORDER_ASC = 'asc';
    public const ORDER_DESC = 'desc';
    public const ORDER_BY_CONVERSATION_START = 'conversationStart';
    public const ORDER_BY_CONVERSATION_END = 'conversationEnd';
    public const ORDER_BY_SEGMENT_START = 'segmentStart';
    public const ORDER_BY_SEGMENT_END = 'segmentEnd';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOrderAllowableValues()
    {
        return [
            self::ORDER_ASC,
            self::ORDER_DESC,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOrderByAllowableValues()
    {
        return [
            self::ORDER_BY_CONVERSATION_START,
            self::ORDER_BY_CONVERSATION_END,
            self::ORDER_BY_SEGMENT_START,
            self::ORDER_BY_SEGMENT_END,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['conversationFilters'] = isset($data['conversationFilters']) ? $data['conversationFilters'] : null;
        $this->container['segmentFilters'] = isset($data['segmentFilters']) ? $data['segmentFilters'] : null;
        $this->container['evaluationFilters'] = isset($data['evaluationFilters']) ? $data['evaluationFilters'] : null;
        $this->container['mediaEndpointStatFilters'] = isset($data['mediaEndpointStatFilters']) ? $data['mediaEndpointStatFilters'] : null;
        $this->container['surveyFilters'] = isset($data['surveyFilters']) ? $data['surveyFilters'] : null;
        $this->container['order'] = isset($data['order']) ? $data['order'] : null;
        $this->container['orderBy'] = isset($data['orderBy']) ? $data['orderBy'] : null;
        $this->container['interval'] = isset($data['interval']) ? $data['interval'] : null;
        $this->container['limit'] = isset($data['limit']) ? $data['limit'] : null;
        $this->container['startOfDayIntervalMatching'] = isset($data['startOfDayIntervalMatching']) ? $data['startOfDayIntervalMatching'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("asc", "desc");
        if (!in_array($this->container['order'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'order', must be one of #{allowed_values}.";
        }

        $allowed_values = array("conversationStart", "conversationEnd", "segmentStart", "segmentEnd");
        if (!in_array($this->container['orderBy'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'orderBy', must be one of #{allowed_values}.";
        }

        if ($this->container['interval'] === null) {
            $invalid_properties[] = "'interval' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("asc", "desc");
        if (!in_array($this->container['order'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("conversationStart", "conversationEnd", "segmentStart", "segmentEnd");
        if (!in_array($this->container['orderBy'], $allowed_values)) {
            return false;
        }
        if ($this->container['interval'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets conversationFilters
     * @return \PureCloudSDK\ConversationDetailQueryFilter[]
     */
    public function getConversationFilters()
    {
        return $this->container['conversationFilters'];
    }

    /**
     * Sets conversationFilters
     * @param \PureCloudSDK\ConversationDetailQueryFilter[] $conversationFilters Filters that target conversation-level data
     * @return $this
     */
    public function setConversationFilters($conversationFilters)
    {
        $this->container['conversationFilters'] = $conversationFilters;

        return $this;
    }

    /**
     * Gets segmentFilters
     * @return \PureCloudSDK\SegmentDetailQueryFilter[]
     */
    public function getSegmentFilters()
    {
        return $this->container['segmentFilters'];
    }

    /**
     * Sets segmentFilters
     * @param \PureCloudSDK\SegmentDetailQueryFilter[] $segmentFilters Filters that target individual segments within a conversation
     * @return $this
     */
    public function setSegmentFilters($segmentFilters)
    {
        $this->container['segmentFilters'] = $segmentFilters;

        return $this;
    }

    /**
     * Gets evaluationFilters
     * @return \PureCloudSDK\EvaluationDetailQueryFilter[]
     */
    public function getEvaluationFilters()
    {
        return $this->container['evaluationFilters'];
    }

    /**
     * Sets evaluationFilters
     * @param \PureCloudSDK\EvaluationDetailQueryFilter[] $evaluationFilters Filters that target evaluations
     * @return $this
     */
    public function setEvaluationFilters($evaluationFilters)
    {
        $this->container['evaluationFilters'] = $evaluationFilters;

        return $this;
    }

    /**
     * Gets mediaEndpointStatFilters
     * @return \PureCloudSDK\MediaEndpointStatDetailQueryFilter[]
     */
    public function getMediaEndpointStatFilters()
    {
        return $this->container['mediaEndpointStatFilters'];
    }

    /**
     * Sets mediaEndpointStatFilters
     * @param \PureCloudSDK\MediaEndpointStatDetailQueryFilter[] $mediaEndpointStatFilters Filters that target mediaEndpointStats
     * @return $this
     */
    public function setMediaEndpointStatFilters($mediaEndpointStatFilters)
    {
        $this->container['mediaEndpointStatFilters'] = $mediaEndpointStatFilters;

        return $this;
    }

    /**
     * Gets surveyFilters
     * @return \PureCloudSDK\SurveyDetailQueryFilter[]
     */
    public function getSurveyFilters()
    {
        return $this->container['surveyFilters'];
    }

    /**
     * Sets surveyFilters
     * @param \PureCloudSDK\SurveyDetailQueryFilter[] $surveyFilters Filters that target surveys
     * @return $this
     */
    public function setSurveyFilters($surveyFilters)
    {
        $this->container['surveyFilters'] = $surveyFilters;

        return $this;
    }

    /**
     * Gets order
     * @return string
     */
    public function getOrder()
    {
        return $this->container['order'];
    }

    /**
     * Sets order
     * @param string $order Sort the result set in ascending/descending order. Default is ascending
     * @return $this
     */
    public function setOrder($order)
    {
        $allowed_values = array('asc', 'desc');
        if (!in_array($order, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'order', must be one of 'asc', 'desc'");
        }
        $this->container['order'] = $order;

        return $this;
    }

    /**
     * Gets orderBy
     * @return string
     */
    public function getOrderBy()
    {
        return $this->container['orderBy'];
    }

    /**
     * Sets orderBy
     * @param string $orderBy Specify which data element within the result set to use for sorting. The options  to use as a basis for sorting the results: conversationStart, segmentStart, and segmentEnd. If not specified, the default is conversationStart
     * @return $this
     */
    public function setOrderBy($orderBy)
    {
        $allowed_values = array('conversationStart', 'conversationEnd', 'segmentStart', 'segmentEnd');
        if (!in_array($orderBy, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'orderBy', must be one of 'conversationStart', 'conversationEnd', 'segmentStart', 'segmentEnd'");
        }
        $this->container['orderBy'] = $orderBy;

        return $this;
    }

    /**
     * Gets interval
     * @return string
     */
    public function getInterval()
    {
        return $this->container['interval'];
    }

    /**
     * Sets interval
     * @param string $interval Specifies the date and time range of data being queried. Results will include all conversations that had activity during the interval. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss
     * @return $this
     */
    public function setInterval($interval)
    {
        $this->container['interval'] = $interval;

        return $this;
    }

    /**
     * Gets limit
     * @return int
     */
    public function getLimit()
    {
        return $this->container['limit'];
    }

    /**
     * Sets limit
     * @param int $limit Specify number of results to be returned
     * @return $this
     */
    public function setLimit($limit)
    {
        $this->container['limit'] = $limit;

        return $this;
    }

    /**
     * Gets startOfDayIntervalMatching
     * @return bool
     */
    public function getStartOfDayIntervalMatching()
    {
        return $this->container['startOfDayIntervalMatching'];
    }

    /**
     * Sets startOfDayIntervalMatching
     * @param bool $startOfDayIntervalMatching Add a filter to only include conversations that started after the beginning of the interval start date (UTC)
     * @return $this
     */
    public function setStartOfDayIntervalMatching($startOfDayIntervalMatching)
    {
        $this->container['startOfDayIntervalMatching'] = $startOfDayIntervalMatching;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
