<?php

/**
 * CreateCoachingAppointmentRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * CreateCoachingAppointmentRequest Class Doc Comment
 *
 * @category    Class */
 // @description Create coaching appointment request
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CreateCoachingAppointmentRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CreateCoachingAppointmentRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'name' => 'string',
        'description' => 'string',
        'dateStart' => '\DateTime',
        'lengthInMinutes' => 'int',
        'facilitatorId' => 'string',
        'attendeeIds' => 'string[]',
        'conversationIds' => 'string[]',
        'documentIds' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'name' => 'name',
        'description' => 'description',
        'dateStart' => 'dateStart',
        'lengthInMinutes' => 'lengthInMinutes',
        'facilitatorId' => 'facilitatorId',
        'attendeeIds' => 'attendeeIds',
        'conversationIds' => 'conversationIds',
        'documentIds' => 'documentIds'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'name' => 'setName',
        'description' => 'setDescription',
        'dateStart' => 'setDateStart',
        'lengthInMinutes' => 'setLengthInMinutes',
        'facilitatorId' => 'setFacilitatorId',
        'attendeeIds' => 'setAttendeeIds',
        'conversationIds' => 'setConversationIds',
        'documentIds' => 'setDocumentIds'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'name' => 'getName',
        'description' => 'getDescription',
        'dateStart' => 'getDateStart',
        'lengthInMinutes' => 'getLengthInMinutes',
        'facilitatorId' => 'getFacilitatorId',
        'attendeeIds' => 'getAttendeeIds',
        'conversationIds' => 'getConversationIds',
        'documentIds' => 'getDocumentIds'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['dateStart'] = isset($data['dateStart']) ? $data['dateStart'] : null;
        $this->container['lengthInMinutes'] = isset($data['lengthInMinutes']) ? $data['lengthInMinutes'] : null;
        $this->container['facilitatorId'] = isset($data['facilitatorId']) ? $data['facilitatorId'] : null;
        $this->container['attendeeIds'] = isset($data['attendeeIds']) ? $data['attendeeIds'] : null;
        $this->container['conversationIds'] = isset($data['conversationIds']) ? $data['conversationIds'] : null;
        $this->container['documentIds'] = isset($data['documentIds']) ? $data['documentIds'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        if ($this->container['description'] === null) {
            $invalid_properties[] = "'description' can't be null";
        }
        if ($this->container['dateStart'] === null) {
            $invalid_properties[] = "'dateStart' can't be null";
        }
        if ($this->container['lengthInMinutes'] === null) {
            $invalid_properties[] = "'lengthInMinutes' can't be null";
        }
        if ($this->container['attendeeIds'] === null) {
            $invalid_properties[] = "'attendeeIds' can't be null";
        }
        if ($this->container['conversationIds'] === null) {
            $invalid_properties[] = "'conversationIds' can't be null";
        }
        if ($this->container['documentIds'] === null) {
            $invalid_properties[] = "'documentIds' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        if ($this->container['description'] === null) {
            return false;
        }
        if ($this->container['dateStart'] === null) {
            return false;
        }
        if ($this->container['lengthInMinutes'] === null) {
            return false;
        }
        if ($this->container['attendeeIds'] === null) {
            return false;
        }
        if ($this->container['conversationIds'] === null) {
            return false;
        }
        if ($this->container['documentIds'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of coaching appointment.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description The description of coaching appointment.
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets dateStart
     * @return \DateTime
     */
    public function getDateStart()
    {
        return $this->container['dateStart'];
    }

    /**
     * Sets dateStart
     * @param \DateTime $dateStart The date/time the coaching appointment starts. Times will be rounded down to the minute. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateStart($dateStart)
    {
        $this->container['dateStart'] = $dateStart;

        return $this;
    }

    /**
     * Gets lengthInMinutes
     * @return int
     */
    public function getLengthInMinutes()
    {
        return $this->container['lengthInMinutes'];
    }

    /**
     * Sets lengthInMinutes
     * @param int $lengthInMinutes The duration of coaching appointment in minutes.
     * @return $this
     */
    public function setLengthInMinutes($lengthInMinutes)
    {
        $this->container['lengthInMinutes'] = $lengthInMinutes;

        return $this;
    }

    /**
     * Gets facilitatorId
     * @return string
     */
    public function getFacilitatorId()
    {
        return $this->container['facilitatorId'];
    }

    /**
     * Sets facilitatorId
     * @param string $facilitatorId The facilitator ID of coaching appointment.
     * @return $this
     */
    public function setFacilitatorId($facilitatorId)
    {
        $this->container['facilitatorId'] = $facilitatorId;

        return $this;
    }

    /**
     * Gets attendeeIds
     * @return string[]
     */
    public function getAttendeeIds()
    {
        return $this->container['attendeeIds'];
    }

    /**
     * Sets attendeeIds
     * @param string[] $attendeeIds IDs of attendees in the coaching appointment.
     * @return $this
     */
    public function setAttendeeIds($attendeeIds)
    {
        $this->container['attendeeIds'] = $attendeeIds;

        return $this;
    }

    /**
     * Gets conversationIds
     * @return string[]
     */
    public function getConversationIds()
    {
        return $this->container['conversationIds'];
    }

    /**
     * Sets conversationIds
     * @param string[] $conversationIds IDs of conversations associated with this coaching appointment.
     * @return $this
     */
    public function setConversationIds($conversationIds)
    {
        $this->container['conversationIds'] = $conversationIds;

        return $this;
    }

    /**
     * Gets documentIds
     * @return string[]
     */
    public function getDocumentIds()
    {
        return $this->container['documentIds'];
    }

    /**
     * Sets documentIds
     * @param string[] $documentIds IDs of documents associated with this coaching appointment.
     * @return $this
     */
    public function setDocumentIds($documentIds)
    {
        $this->container['documentIds'] = $documentIds;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
