<?php

/**
 * HistoricalAdherenceExceptionInfo
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * HistoricalAdherenceExceptionInfo Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class HistoricalAdherenceExceptionInfo implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'HistoricalAdherenceExceptionInfo';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'startOffsetSeconds' => 'int',
        'endOffsetSeconds' => 'int',
        'scheduledActivityCodeId' => 'string',
        'scheduledActivityCategory' => 'string',
        'actualActivityCategory' => 'string',
        'systemPresence' => 'string',
        'routingStatus' => '\PureCloudSDK\RoutingStatus',
        'impact' => 'string',
        'secondaryPresenceLookupId' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'startOffsetSeconds' => 'startOffsetSeconds',
        'endOffsetSeconds' => 'endOffsetSeconds',
        'scheduledActivityCodeId' => 'scheduledActivityCodeId',
        'scheduledActivityCategory' => 'scheduledActivityCategory',
        'actualActivityCategory' => 'actualActivityCategory',
        'systemPresence' => 'systemPresence',
        'routingStatus' => 'routingStatus',
        'impact' => 'impact',
        'secondaryPresenceLookupId' => 'secondaryPresenceLookupId'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'startOffsetSeconds' => 'setStartOffsetSeconds',
        'endOffsetSeconds' => 'setEndOffsetSeconds',
        'scheduledActivityCodeId' => 'setScheduledActivityCodeId',
        'scheduledActivityCategory' => 'setScheduledActivityCategory',
        'actualActivityCategory' => 'setActualActivityCategory',
        'systemPresence' => 'setSystemPresence',
        'routingStatus' => 'setRoutingStatus',
        'impact' => 'setImpact',
        'secondaryPresenceLookupId' => 'setSecondaryPresenceLookupId'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'startOffsetSeconds' => 'getStartOffsetSeconds',
        'endOffsetSeconds' => 'getEndOffsetSeconds',
        'scheduledActivityCodeId' => 'getScheduledActivityCodeId',
        'scheduledActivityCategory' => 'getScheduledActivityCategory',
        'actualActivityCategory' => 'getActualActivityCategory',
        'systemPresence' => 'getSystemPresence',
        'routingStatus' => 'getRoutingStatus',
        'impact' => 'getImpact',
        'secondaryPresenceLookupId' => 'getSecondaryPresenceLookupId'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const SCHEDULED_ACTIVITY_CATEGORY_ON_QUEUE_WORK = 'OnQueueWork';
    public const SCHEDULED_ACTIVITY_CATEGORY_BREAK = 'Break';
    public const SCHEDULED_ACTIVITY_CATEGORY_MEAL = 'Meal';
    public const SCHEDULED_ACTIVITY_CATEGORY_MEETING = 'Meeting';
    public const SCHEDULED_ACTIVITY_CATEGORY_OFF_QUEUE_WORK = 'OffQueueWork';
    public const SCHEDULED_ACTIVITY_CATEGORY_TIME_OFF = 'TimeOff';
    public const SCHEDULED_ACTIVITY_CATEGORY_TRAINING = 'Training';
    public const SCHEDULED_ACTIVITY_CATEGORY_UNAVAILABLE = 'Unavailable';
    public const SCHEDULED_ACTIVITY_CATEGORY_UNSCHEDULED = 'Unscheduled';
    public const ACTUAL_ACTIVITY_CATEGORY_ON_QUEUE_WORK = 'OnQueueWork';
    public const ACTUAL_ACTIVITY_CATEGORY_BREAK = 'Break';
    public const ACTUAL_ACTIVITY_CATEGORY_MEAL = 'Meal';
    public const ACTUAL_ACTIVITY_CATEGORY_MEETING = 'Meeting';
    public const ACTUAL_ACTIVITY_CATEGORY_OFF_QUEUE_WORK = 'OffQueueWork';
    public const ACTUAL_ACTIVITY_CATEGORY_TIME_OFF = 'TimeOff';
    public const ACTUAL_ACTIVITY_CATEGORY_TRAINING = 'Training';
    public const ACTUAL_ACTIVITY_CATEGORY_UNAVAILABLE = 'Unavailable';
    public const ACTUAL_ACTIVITY_CATEGORY_UNSCHEDULED = 'Unscheduled';
    public const SYSTEM_PRESENCE_AVAILABLE = 'Available';
    public const SYSTEM_PRESENCE_AWAY = 'Away';
    public const SYSTEM_PRESENCE_BUSY = 'Busy';
    public const SYSTEM_PRESENCE_OFFLINE = 'Offline';
    public const SYSTEM_PRESENCE_IDLE = 'Idle';
    public const SYSTEM_PRESENCE_ON_QUEUE = 'OnQueue';
    public const SYSTEM_PRESENCE_MEAL = 'Meal';
    public const SYSTEM_PRESENCE_TRAINING = 'Training';
    public const SYSTEM_PRESENCE_MEETING = 'Meeting';
    public const SYSTEM_PRESENCE_BREAK = 'Break';
    public const IMPACT_POSITIVE = 'Positive';
    public const IMPACT_NEGATIVE = 'Negative';
    public const IMPACT_NEUTRAL = 'Neutral';
    public const IMPACT_UNKNOWN = 'Unknown';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getScheduledActivityCategoryAllowableValues()
    {
        return [
            self::SCHEDULED_ACTIVITY_CATEGORY_ON_QUEUE_WORK,
            self::SCHEDULED_ACTIVITY_CATEGORY_BREAK,
            self::SCHEDULED_ACTIVITY_CATEGORY_MEAL,
            self::SCHEDULED_ACTIVITY_CATEGORY_MEETING,
            self::SCHEDULED_ACTIVITY_CATEGORY_OFF_QUEUE_WORK,
            self::SCHEDULED_ACTIVITY_CATEGORY_TIME_OFF,
            self::SCHEDULED_ACTIVITY_CATEGORY_TRAINING,
            self::SCHEDULED_ACTIVITY_CATEGORY_UNAVAILABLE,
            self::SCHEDULED_ACTIVITY_CATEGORY_UNSCHEDULED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getActualActivityCategoryAllowableValues()
    {
        return [
            self::ACTUAL_ACTIVITY_CATEGORY_ON_QUEUE_WORK,
            self::ACTUAL_ACTIVITY_CATEGORY_BREAK,
            self::ACTUAL_ACTIVITY_CATEGORY_MEAL,
            self::ACTUAL_ACTIVITY_CATEGORY_MEETING,
            self::ACTUAL_ACTIVITY_CATEGORY_OFF_QUEUE_WORK,
            self::ACTUAL_ACTIVITY_CATEGORY_TIME_OFF,
            self::ACTUAL_ACTIVITY_CATEGORY_TRAINING,
            self::ACTUAL_ACTIVITY_CATEGORY_UNAVAILABLE,
            self::ACTUAL_ACTIVITY_CATEGORY_UNSCHEDULED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getSystemPresenceAllowableValues()
    {
        return [
            self::SYSTEM_PRESENCE_AVAILABLE,
            self::SYSTEM_PRESENCE_AWAY,
            self::SYSTEM_PRESENCE_BUSY,
            self::SYSTEM_PRESENCE_OFFLINE,
            self::SYSTEM_PRESENCE_IDLE,
            self::SYSTEM_PRESENCE_ON_QUEUE,
            self::SYSTEM_PRESENCE_MEAL,
            self::SYSTEM_PRESENCE_TRAINING,
            self::SYSTEM_PRESENCE_MEETING,
            self::SYSTEM_PRESENCE_BREAK,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getImpactAllowableValues()
    {
        return [
            self::IMPACT_POSITIVE,
            self::IMPACT_NEGATIVE,
            self::IMPACT_NEUTRAL,
            self::IMPACT_UNKNOWN,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['startOffsetSeconds'] = isset($data['startOffsetSeconds']) ? $data['startOffsetSeconds'] : null;
        $this->container['endOffsetSeconds'] = isset($data['endOffsetSeconds']) ? $data['endOffsetSeconds'] : null;
        $this->container['scheduledActivityCodeId'] = isset($data['scheduledActivityCodeId']) ? $data['scheduledActivityCodeId'] : null;
        $this->container['scheduledActivityCategory'] = isset($data['scheduledActivityCategory']) ? $data['scheduledActivityCategory'] : null;
        $this->container['actualActivityCategory'] = isset($data['actualActivityCategory']) ? $data['actualActivityCategory'] : null;
        $this->container['systemPresence'] = isset($data['systemPresence']) ? $data['systemPresence'] : null;
        $this->container['routingStatus'] = isset($data['routingStatus']) ? $data['routingStatus'] : null;
        $this->container['impact'] = isset($data['impact']) ? $data['impact'] : null;
        $this->container['secondaryPresenceLookupId'] = isset($data['secondaryPresenceLookupId']) ? $data['secondaryPresenceLookupId'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("OnQueueWork", "Break", "Meal", "Meeting", "OffQueueWork", "TimeOff", "Training", "Unavailable", "Unscheduled");
        if (!in_array($this->container['scheduledActivityCategory'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'scheduledActivityCategory', must be one of #{allowed_values}.";
        }

        $allowed_values = array("OnQueueWork", "Break", "Meal", "Meeting", "OffQueueWork", "TimeOff", "Training", "Unavailable", "Unscheduled");
        if (!in_array($this->container['actualActivityCategory'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'actualActivityCategory', must be one of #{allowed_values}.";
        }

        $allowed_values = array("Available", "Away", "Busy", "Offline", "Idle", "OnQueue", "Meal", "Training", "Meeting", "Break");
        if (!in_array($this->container['systemPresence'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'systemPresence', must be one of #{allowed_values}.";
        }

        $allowed_values = array("Positive", "Negative", "Neutral", "Unknown");
        if (!in_array($this->container['impact'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'impact', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("OnQueueWork", "Break", "Meal", "Meeting", "OffQueueWork", "TimeOff", "Training", "Unavailable", "Unscheduled");
        if (!in_array($this->container['scheduledActivityCategory'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("OnQueueWork", "Break", "Meal", "Meeting", "OffQueueWork", "TimeOff", "Training", "Unavailable", "Unscheduled");
        if (!in_array($this->container['actualActivityCategory'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("Available", "Away", "Busy", "Offline", "Idle", "OnQueue", "Meal", "Training", "Meeting", "Break");
        if (!in_array($this->container['systemPresence'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("Positive", "Negative", "Neutral", "Unknown");
        if (!in_array($this->container['impact'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets startOffsetSeconds
     * @return int
     */
    public function getStartOffsetSeconds()
    {
        return $this->container['startOffsetSeconds'];
    }

    /**
     * Sets startOffsetSeconds
     * @param int $startOffsetSeconds Exception start offset in seconds relative to query start time
     * @return $this
     */
    public function setStartOffsetSeconds($startOffsetSeconds)
    {
        $this->container['startOffsetSeconds'] = $startOffsetSeconds;

        return $this;
    }

    /**
     * Gets endOffsetSeconds
     * @return int
     */
    public function getEndOffsetSeconds()
    {
        return $this->container['endOffsetSeconds'];
    }

    /**
     * Sets endOffsetSeconds
     * @param int $endOffsetSeconds Exception end offset in seconds relative to query start time
     * @return $this
     */
    public function setEndOffsetSeconds($endOffsetSeconds)
    {
        $this->container['endOffsetSeconds'] = $endOffsetSeconds;

        return $this;
    }

    /**
     * Gets scheduledActivityCodeId
     * @return string
     */
    public function getScheduledActivityCodeId()
    {
        return $this->container['scheduledActivityCodeId'];
    }

    /**
     * Sets scheduledActivityCodeId
     * @param string $scheduledActivityCodeId The ID of the scheduled activity for this user
     * @return $this
     */
    public function setScheduledActivityCodeId($scheduledActivityCodeId)
    {
        $this->container['scheduledActivityCodeId'] = $scheduledActivityCodeId;

        return $this;
    }

    /**
     * Gets scheduledActivityCategory
     * @return string
     */
    public function getScheduledActivityCategory()
    {
        return $this->container['scheduledActivityCategory'];
    }

    /**
     * Sets scheduledActivityCategory
     * @param string $scheduledActivityCategory Activity for which the user is scheduled
     * @return $this
     */
    public function setScheduledActivityCategory($scheduledActivityCategory)
    {
        $allowed_values = array('OnQueueWork', 'Break', 'Meal', 'Meeting', 'OffQueueWork', 'TimeOff', 'Training', 'Unavailable', 'Unscheduled');
        if (!in_array($scheduledActivityCategory, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'scheduledActivityCategory', must be one of 'OnQueueWork', 'Break', 'Meal', 'Meeting', 'OffQueueWork', 'TimeOff', 'Training', 'Unavailable', 'Unscheduled'");
        }
        $this->container['scheduledActivityCategory'] = $scheduledActivityCategory;

        return $this;
    }

    /**
     * Gets actualActivityCategory
     * @return string
     */
    public function getActualActivityCategory()
    {
        return $this->container['actualActivityCategory'];
    }

    /**
     * Sets actualActivityCategory
     * @param string $actualActivityCategory Activity for which the user is actually engaged
     * @return $this
     */
    public function setActualActivityCategory($actualActivityCategory)
    {
        $allowed_values = array('OnQueueWork', 'Break', 'Meal', 'Meeting', 'OffQueueWork', 'TimeOff', 'Training', 'Unavailable', 'Unscheduled');
        if (!in_array($actualActivityCategory, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'actualActivityCategory', must be one of 'OnQueueWork', 'Break', 'Meal', 'Meeting', 'OffQueueWork', 'TimeOff', 'Training', 'Unavailable', 'Unscheduled'");
        }
        $this->container['actualActivityCategory'] = $actualActivityCategory;

        return $this;
    }

    /**
     * Gets systemPresence
     * @return string
     */
    public function getSystemPresence()
    {
        return $this->container['systemPresence'];
    }

    /**
     * Sets systemPresence
     * @param string $systemPresence Actual underlying system presence value
     * @return $this
     */
    public function setSystemPresence($systemPresence)
    {
        $allowed_values = array('Available', 'Away', 'Busy', 'Offline', 'Idle', 'OnQueue', 'Meal', 'Training', 'Meeting', 'Break');
        if (!in_array($systemPresence, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'systemPresence', must be one of 'Available', 'Away', 'Busy', 'Offline', 'Idle', 'OnQueue', 'Meal', 'Training', 'Meeting', 'Break'");
        }
        $this->container['systemPresence'] = $systemPresence;

        return $this;
    }

    /**
     * Gets routingStatus
     * @return \PureCloudSDK\RoutingStatus
     */
    public function getRoutingStatus()
    {
        return $this->container['routingStatus'];
    }

    /**
     * Sets routingStatus
     * @param \PureCloudSDK\RoutingStatus $routingStatus Actual underlying routing status, used to determine whether a user is actually in adherence when OnQueue
     * @return $this
     */
    public function setRoutingStatus($routingStatus)
    {
        $this->container['routingStatus'] = $routingStatus;

        return $this;
    }

    /**
     * Gets impact
     * @return string
     */
    public function getImpact()
    {
        return $this->container['impact'];
    }

    /**
     * Sets impact
     * @param string $impact The impact of the current adherence state for this user
     * @return $this
     */
    public function setImpact($impact)
    {
        $allowed_values = array('Positive', 'Negative', 'Neutral', 'Unknown');
        if (!in_array($impact, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'impact', must be one of 'Positive', 'Negative', 'Neutral', 'Unknown'");
        }
        $this->container['impact'] = $impact;

        return $this;
    }

    /**
     * Gets secondaryPresenceLookupId
     * @return string
     */
    public function getSecondaryPresenceLookupId()
    {
        return $this->container['secondaryPresenceLookupId'];
    }

    /**
     * Sets secondaryPresenceLookupId
     * @param string $secondaryPresenceLookupId The lookup ID used to retrieve secondary status from map of lookup ID to corresponding secondary presence ID
     * @return $this
     */
    public function setSecondaryPresenceLookupId($secondaryPresenceLookupId)
    {
        $this->container['secondaryPresenceLookupId'] = $secondaryPresenceLookupId;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
