<?php

/**
 * MeteredEvaluationAssignment
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * MeteredEvaluationAssignment Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class MeteredEvaluationAssignment implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'MeteredEvaluationAssignment';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'evaluationContextId' => 'string',
        'evaluators' => '\PureCloudSDK\User[]',
        'maxNumberEvaluations' => 'int',
        'evaluationForm' => '\PureCloudSDK\EvaluationForm',
        'assignToActiveUser' => 'bool',
        'timeInterval' => '\PureCloudSDK\TimeInterval'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'evaluationContextId' => 'evaluationContextId',
        'evaluators' => 'evaluators',
        'maxNumberEvaluations' => 'maxNumberEvaluations',
        'evaluationForm' => 'evaluationForm',
        'assignToActiveUser' => 'assignToActiveUser',
        'timeInterval' => 'timeInterval'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'evaluationContextId' => 'setEvaluationContextId',
        'evaluators' => 'setEvaluators',
        'maxNumberEvaluations' => 'setMaxNumberEvaluations',
        'evaluationForm' => 'setEvaluationForm',
        'assignToActiveUser' => 'setAssignToActiveUser',
        'timeInterval' => 'setTimeInterval'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'evaluationContextId' => 'getEvaluationContextId',
        'evaluators' => 'getEvaluators',
        'maxNumberEvaluations' => 'getMaxNumberEvaluations',
        'evaluationForm' => 'getEvaluationForm',
        'assignToActiveUser' => 'getAssignToActiveUser',
        'timeInterval' => 'getTimeInterval'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['evaluationContextId'] = isset($data['evaluationContextId']) ? $data['evaluationContextId'] : null;
        $this->container['evaluators'] = isset($data['evaluators']) ? $data['evaluators'] : null;
        $this->container['maxNumberEvaluations'] = isset($data['maxNumberEvaluations']) ? $data['maxNumberEvaluations'] : null;
        $this->container['evaluationForm'] = isset($data['evaluationForm']) ? $data['evaluationForm'] : null;
        $this->container['assignToActiveUser'] = isset($data['assignToActiveUser']) ? $data['assignToActiveUser'] : null;
        $this->container['timeInterval'] = isset($data['timeInterval']) ? $data['timeInterval'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets evaluationContextId
     * @return string
     */
    public function getEvaluationContextId()
    {
        return $this->container['evaluationContextId'];
    }

    /**
     * Sets evaluationContextId
     * @param string $evaluationContextId
     * @return $this
     */
    public function setEvaluationContextId($evaluationContextId)
    {
        $this->container['evaluationContextId'] = $evaluationContextId;

        return $this;
    }

    /**
     * Gets evaluators
     * @return \PureCloudSDK\User[]
     */
    public function getEvaluators()
    {
        return $this->container['evaluators'];
    }

    /**
     * Sets evaluators
     * @param \PureCloudSDK\User[] $evaluators
     * @return $this
     */
    public function setEvaluators($evaluators)
    {
        $this->container['evaluators'] = $evaluators;

        return $this;
    }

    /**
     * Gets maxNumberEvaluations
     * @return int
     */
    public function getMaxNumberEvaluations()
    {
        return $this->container['maxNumberEvaluations'];
    }

    /**
     * Sets maxNumberEvaluations
     * @param int $maxNumberEvaluations
     * @return $this
     */
    public function setMaxNumberEvaluations($maxNumberEvaluations)
    {
        $this->container['maxNumberEvaluations'] = $maxNumberEvaluations;

        return $this;
    }

    /**
     * Gets evaluationForm
     * @return \PureCloudSDK\EvaluationForm
     */
    public function getEvaluationForm()
    {
        return $this->container['evaluationForm'];
    }

    /**
     * Sets evaluationForm
     * @param \PureCloudSDK\EvaluationForm $evaluationForm
     * @return $this
     */
    public function setEvaluationForm($evaluationForm)
    {
        $this->container['evaluationForm'] = $evaluationForm;

        return $this;
    }

    /**
     * Gets assignToActiveUser
     * @return bool
     */
    public function getAssignToActiveUser()
    {
        return $this->container['assignToActiveUser'];
    }

    /**
     * Sets assignToActiveUser
     * @param bool $assignToActiveUser
     * @return $this
     */
    public function setAssignToActiveUser($assignToActiveUser)
    {
        $this->container['assignToActiveUser'] = $assignToActiveUser;

        return $this;
    }

    /**
     * Gets timeInterval
     * @return \PureCloudSDK\TimeInterval
     */
    public function getTimeInterval()
    {
        return $this->container['timeInterval'];
    }

    /**
     * Sets timeInterval
     * @param \PureCloudSDK\TimeInterval $timeInterval
     * @return $this
     */
    public function setTimeInterval($timeInterval)
    {
        $this->container['timeInterval'] = $timeInterval;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
