<?php

/**
 * OrphanRecording
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * OrphanRecording Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class OrphanRecording implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'OrphanRecording';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'createdTime' => '\DateTime',
        'recoveredTime' => '\DateTime',
        'providerType' => 'string',
        'mediaSizeBytes' => 'int',
        'mediaType' => 'string',
        'fileState' => 'string',
        'providerEndpoint' => '\PureCloudSDK\Endpoint',
        'recording' => '\PureCloudSDK\Recording',
        'orphanStatus' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'createdTime' => 'createdTime',
        'recoveredTime' => 'recoveredTime',
        'providerType' => 'providerType',
        'mediaSizeBytes' => 'mediaSizeBytes',
        'mediaType' => 'mediaType',
        'fileState' => 'fileState',
        'providerEndpoint' => 'providerEndpoint',
        'recording' => 'recording',
        'orphanStatus' => 'orphanStatus',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'createdTime' => 'setCreatedTime',
        'recoveredTime' => 'setRecoveredTime',
        'providerType' => 'setProviderType',
        'mediaSizeBytes' => 'setMediaSizeBytes',
        'mediaType' => 'setMediaType',
        'fileState' => 'setFileState',
        'providerEndpoint' => 'setProviderEndpoint',
        'recording' => 'setRecording',
        'orphanStatus' => 'setOrphanStatus',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'createdTime' => 'getCreatedTime',
        'recoveredTime' => 'getRecoveredTime',
        'providerType' => 'getProviderType',
        'mediaSizeBytes' => 'getMediaSizeBytes',
        'mediaType' => 'getMediaType',
        'fileState' => 'getFileState',
        'providerEndpoint' => 'getProviderEndpoint',
        'recording' => 'getRecording',
        'orphanStatus' => 'getOrphanStatus',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const PROVIDER_TYPE_EDGE = 'EDGE';
    public const PROVIDER_TYPE_CHAT = 'CHAT';
    public const PROVIDER_TYPE_EMAIL = 'EMAIL';
    public const PROVIDER_TYPE_SCREEN_RECORDING = 'SCREEN_RECORDING';
    public const MEDIA_TYPE_CALL = 'CALL';
    public const MEDIA_TYPE_CHAT = 'CHAT';
    public const MEDIA_TYPE_EMAIL = 'EMAIL';
    public const MEDIA_TYPE_SCREEN = 'SCREEN';
    public const FILE_STATE_ARCHIVED = 'ARCHIVED';
    public const FILE_STATE_AVAILABLE = 'AVAILABLE';
    public const FILE_STATE_DELETED = 'DELETED';
    public const FILE_STATE_RESTORED = 'RESTORED';
    public const FILE_STATE_RESTORING = 'RESTORING';
    public const FILE_STATE_UPLOADING = 'UPLOADING';
    public const ORPHAN_STATUS_NO_CONVERSATION = 'NO_CONVERSATION';
    public const ORPHAN_STATUS_UNKNOWN_CONVERSATION = 'UNKNOWN_CONVERSATION';
    public const ORPHAN_STATUS_CONVERSATION_NOT_COMPLETE = 'CONVERSATION_NOT_COMPLETE';
    public const ORPHAN_STATUS_CONVERSATION_NOT_EVALUATED = 'CONVERSATION_NOT_EVALUATED';
    public const ORPHAN_STATUS_EVALUATED = 'EVALUATED';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getProviderTypeAllowableValues()
    {
        return [
            self::PROVIDER_TYPE_EDGE,
            self::PROVIDER_TYPE_CHAT,
            self::PROVIDER_TYPE_EMAIL,
            self::PROVIDER_TYPE_SCREEN_RECORDING,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMediaTypeAllowableValues()
    {
        return [
            self::MEDIA_TYPE_CALL,
            self::MEDIA_TYPE_CHAT,
            self::MEDIA_TYPE_EMAIL,
            self::MEDIA_TYPE_SCREEN,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getFileStateAllowableValues()
    {
        return [
            self::FILE_STATE_ARCHIVED,
            self::FILE_STATE_AVAILABLE,
            self::FILE_STATE_DELETED,
            self::FILE_STATE_RESTORED,
            self::FILE_STATE_RESTORING,
            self::FILE_STATE_UPLOADING,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOrphanStatusAllowableValues()
    {
        return [
            self::ORPHAN_STATUS_NO_CONVERSATION,
            self::ORPHAN_STATUS_UNKNOWN_CONVERSATION,
            self::ORPHAN_STATUS_CONVERSATION_NOT_COMPLETE,
            self::ORPHAN_STATUS_CONVERSATION_NOT_EVALUATED,
            self::ORPHAN_STATUS_EVALUATED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['createdTime'] = isset($data['createdTime']) ? $data['createdTime'] : null;
        $this->container['recoveredTime'] = isset($data['recoveredTime']) ? $data['recoveredTime'] : null;
        $this->container['providerType'] = isset($data['providerType']) ? $data['providerType'] : null;
        $this->container['mediaSizeBytes'] = isset($data['mediaSizeBytes']) ? $data['mediaSizeBytes'] : null;
        $this->container['mediaType'] = isset($data['mediaType']) ? $data['mediaType'] : null;
        $this->container['fileState'] = isset($data['fileState']) ? $data['fileState'] : null;
        $this->container['providerEndpoint'] = isset($data['providerEndpoint']) ? $data['providerEndpoint'] : null;
        $this->container['recording'] = isset($data['recording']) ? $data['recording'] : null;
        $this->container['orphanStatus'] = isset($data['orphanStatus']) ? $data['orphanStatus'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("EDGE", "CHAT", "EMAIL", "SCREEN_RECORDING");
        if (!in_array($this->container['providerType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'providerType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("CALL", "CHAT", "EMAIL", "SCREEN");
        if (!in_array($this->container['mediaType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'mediaType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("ARCHIVED", "AVAILABLE", "DELETED", "RESTORED", "RESTORING", "UPLOADING");
        if (!in_array($this->container['fileState'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'fileState', must be one of #{allowed_values}.";
        }

        $allowed_values = array("NO_CONVERSATION", "UNKNOWN_CONVERSATION", "CONVERSATION_NOT_COMPLETE", "CONVERSATION_NOT_EVALUATED", "EVALUATED");
        if (!in_array($this->container['orphanStatus'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'orphanStatus', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("EDGE", "CHAT", "EMAIL", "SCREEN_RECORDING");
        if (!in_array($this->container['providerType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("CALL", "CHAT", "EMAIL", "SCREEN");
        if (!in_array($this->container['mediaType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("ARCHIVED", "AVAILABLE", "DELETED", "RESTORED", "RESTORING", "UPLOADING");
        if (!in_array($this->container['fileState'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("NO_CONVERSATION", "UNKNOWN_CONVERSATION", "CONVERSATION_NOT_COMPLETE", "CONVERSATION_NOT_EVALUATED", "EVALUATED");
        if (!in_array($this->container['orphanStatus'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets createdTime
     * @return \DateTime
     */
    public function getCreatedTime()
    {
        return $this->container['createdTime'];
    }

    /**
     * Sets createdTime
     * @param \DateTime $createdTime Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCreatedTime($createdTime)
    {
        $this->container['createdTime'] = $createdTime;

        return $this;
    }

    /**
     * Gets recoveredTime
     * @return \DateTime
     */
    public function getRecoveredTime()
    {
        return $this->container['recoveredTime'];
    }

    /**
     * Sets recoveredTime
     * @param \DateTime $recoveredTime Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setRecoveredTime($recoveredTime)
    {
        $this->container['recoveredTime'] = $recoveredTime;

        return $this;
    }

    /**
     * Gets providerType
     * @return string
     */
    public function getProviderType()
    {
        return $this->container['providerType'];
    }

    /**
     * Sets providerType
     * @param string $providerType
     * @return $this
     */
    public function setProviderType($providerType)
    {
        $allowed_values = array('EDGE', 'CHAT', 'EMAIL', 'SCREEN_RECORDING');
        if (!in_array($providerType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'providerType', must be one of 'EDGE', 'CHAT', 'EMAIL', 'SCREEN_RECORDING'");
        }
        $this->container['providerType'] = $providerType;

        return $this;
    }

    /**
     * Gets mediaSizeBytes
     * @return int
     */
    public function getMediaSizeBytes()
    {
        return $this->container['mediaSizeBytes'];
    }

    /**
     * Sets mediaSizeBytes
     * @param int $mediaSizeBytes
     * @return $this
     */
    public function setMediaSizeBytes($mediaSizeBytes)
    {
        $this->container['mediaSizeBytes'] = $mediaSizeBytes;

        return $this;
    }

    /**
     * Gets mediaType
     * @return string
     */
    public function getMediaType()
    {
        return $this->container['mediaType'];
    }

    /**
     * Sets mediaType
     * @param string $mediaType
     * @return $this
     */
    public function setMediaType($mediaType)
    {
        $allowed_values = array('CALL', 'CHAT', 'EMAIL', 'SCREEN');
        if (!in_array($mediaType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'mediaType', must be one of 'CALL', 'CHAT', 'EMAIL', 'SCREEN'");
        }
        $this->container['mediaType'] = $mediaType;

        return $this;
    }

    /**
     * Gets fileState
     * @return string
     */
    public function getFileState()
    {
        return $this->container['fileState'];
    }

    /**
     * Sets fileState
     * @param string $fileState
     * @return $this
     */
    public function setFileState($fileState)
    {
        $allowed_values = array('ARCHIVED', 'AVAILABLE', 'DELETED', 'RESTORED', 'RESTORING', 'UPLOADING');
        if (!in_array($fileState, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'fileState', must be one of 'ARCHIVED', 'AVAILABLE', 'DELETED', 'RESTORED', 'RESTORING', 'UPLOADING'");
        }
        $this->container['fileState'] = $fileState;

        return $this;
    }

    /**
     * Gets providerEndpoint
     * @return \PureCloudSDK\Endpoint
     */
    public function getProviderEndpoint()
    {
        return $this->container['providerEndpoint'];
    }

    /**
     * Sets providerEndpoint
     * @param \PureCloudSDK\Endpoint $providerEndpoint
     * @return $this
     */
    public function setProviderEndpoint($providerEndpoint)
    {
        $this->container['providerEndpoint'] = $providerEndpoint;

        return $this;
    }

    /**
     * Gets recording
     * @return \PureCloudSDK\Recording
     */
    public function getRecording()
    {
        return $this->container['recording'];
    }

    /**
     * Sets recording
     * @param \PureCloudSDK\Recording $recording
     * @return $this
     */
    public function setRecording($recording)
    {
        $this->container['recording'] = $recording;

        return $this;
    }

    /**
     * Gets orphanStatus
     * @return string
     */
    public function getOrphanStatus()
    {
        return $this->container['orphanStatus'];
    }

    /**
     * Sets orphanStatus
     * @param string $orphanStatus The status of the orphaned recording's conversation.
     * @return $this
     */
    public function setOrphanStatus($orphanStatus)
    {
        $allowed_values = array('NO_CONVERSATION', 'UNKNOWN_CONVERSATION', 'CONVERSATION_NOT_COMPLETE', 'CONVERSATION_NOT_EVALUATED', 'EVALUATED');
        if (!in_array($orphanStatus, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'orphanStatus', must be one of 'NO_CONVERSATION', 'UNKNOWN_CONVERSATION', 'CONVERSATION_NOT_COMPLETE', 'CONVERSATION_NOT_EVALUATED', 'EVALUATED'");
        }
        $this->container['orphanStatus'] = $orphanStatus;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
