<?php

/**
 * ScimError
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ScimError Class Doc Comment
 *
 * @category    Class */
 // @description Defines a SCIM error.
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ScimError implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ScimError';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'status' => 'string',
        'scimType' => 'string',
        'detail' => 'string',
        'schemas' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'status' => 'status',
        'scimType' => 'scimType',
        'detail' => 'detail',
        'schemas' => 'schemas'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'status' => 'setStatus',
        'scimType' => 'setScimType',
        'detail' => 'setDetail',
        'schemas' => 'setSchemas'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'status' => 'getStatus',
        'scimType' => 'getScimType',
        'detail' => 'getDetail',
        'schemas' => 'getSchemas'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const SCIM_TYPE_INVALID_FILTER = 'invalidFilter';
    public const SCIM_TYPE_TOO_MANY = 'tooMany';
    public const SCIM_TYPE_UNIQUENESS = 'uniqueness';
    public const SCIM_TYPE_MUTABILITY = 'mutability';
    public const SCIM_TYPE_INVALID_SYNTAX = 'invalidSyntax';
    public const SCIM_TYPE_INVALID_PATH = 'invalidPath';
    public const SCIM_TYPE_NO_TARGET = 'noTarget';
    public const SCIM_TYPE_INVALID_VALUE = 'invalidValue';
    public const SCIM_TYPE_INVALID_VERS = 'invalidVers';
    public const SCIM_TYPE_SENSITIVE = 'sensitive';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getScimTypeAllowableValues()
    {
        return [
            self::SCIM_TYPE_INVALID_FILTER,
            self::SCIM_TYPE_TOO_MANY,
            self::SCIM_TYPE_UNIQUENESS,
            self::SCIM_TYPE_MUTABILITY,
            self::SCIM_TYPE_INVALID_SYNTAX,
            self::SCIM_TYPE_INVALID_PATH,
            self::SCIM_TYPE_NO_TARGET,
            self::SCIM_TYPE_INVALID_VALUE,
            self::SCIM_TYPE_INVALID_VERS,
            self::SCIM_TYPE_SENSITIVE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['scimType'] = isset($data['scimType']) ? $data['scimType'] : null;
        $this->container['detail'] = isset($data['detail']) ? $data['detail'] : null;
        $this->container['schemas'] = isset($data['schemas']) ? $data['schemas'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("invalidFilter", "tooMany", "uniqueness", "mutability", "invalidSyntax", "invalidPath", "noTarget", "invalidValue", "invalidVers", "sensitive");
        if (!in_array($this->container['scimType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'scimType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("invalidFilter", "tooMany", "uniqueness", "mutability", "invalidSyntax", "invalidPath", "noTarget", "invalidValue", "invalidVers", "sensitive");
        if (!in_array($this->container['scimType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status The HTTP status code returned for the SCIM error.
     * @return $this
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets scimType
     * @return string
     */
    public function getScimType()
    {
        return $this->container['scimType'];
    }

    /**
     * Sets scimType
     * @param string $scimType The type of SCIM error when httpStatus is a \"400\" error.
     * @return $this
     */
    public function setScimType($scimType)
    {
        $allowed_values = array('invalidFilter', 'tooMany', 'uniqueness', 'mutability', 'invalidSyntax', 'invalidPath', 'noTarget', 'invalidValue', 'invalidVers', 'sensitive');
        if (!in_array($scimType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'scimType', must be one of 'invalidFilter', 'tooMany', 'uniqueness', 'mutability', 'invalidSyntax', 'invalidPath', 'noTarget', 'invalidValue', 'invalidVers', 'sensitive'");
        }
        $this->container['scimType'] = $scimType;

        return $this;
    }

    /**
     * Gets detail
     * @return string
     */
    public function getDetail()
    {
        return $this->container['detail'];
    }

    /**
     * Sets detail
     * @param string $detail The detailed description of the SCIM error.
     * @return $this
     */
    public function setDetail($detail)
    {
        $this->container['detail'] = $detail;

        return $this;
    }

    /**
     * Gets schemas
     * @return string[]
     */
    public function getSchemas()
    {
        return $this->container['schemas'];
    }

    /**
     * Sets schemas
     * @param string[] $schemas The list of schemas for the SCIM error.
     * @return $this
     */
    public function setSchemas($schemas)
    {
        $this->container['schemas'] = $schemas;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
