<?php

/**
 * ShiftTradeMatchReviewUserResponse
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ShiftTradeMatchReviewUserResponse Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ShiftTradeMatchReviewUserResponse implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ShiftTradeMatchReviewUserResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'weeklyMinimumPaidMinutes' => 'int',
        'weeklyMaximumPaidMinutes' => 'int',
        'preTradeSchedulePaidMinutes' => 'int',
        'postTradeSchedulePaidMinutes' => 'int',
        'postTradeNewShift' => '\PureCloudSDK\ShiftTradePreviewResponse'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'weeklyMinimumPaidMinutes' => 'weeklyMinimumPaidMinutes',
        'weeklyMaximumPaidMinutes' => 'weeklyMaximumPaidMinutes',
        'preTradeSchedulePaidMinutes' => 'preTradeSchedulePaidMinutes',
        'postTradeSchedulePaidMinutes' => 'postTradeSchedulePaidMinutes',
        'postTradeNewShift' => 'postTradeNewShift'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'weeklyMinimumPaidMinutes' => 'setWeeklyMinimumPaidMinutes',
        'weeklyMaximumPaidMinutes' => 'setWeeklyMaximumPaidMinutes',
        'preTradeSchedulePaidMinutes' => 'setPreTradeSchedulePaidMinutes',
        'postTradeSchedulePaidMinutes' => 'setPostTradeSchedulePaidMinutes',
        'postTradeNewShift' => 'setPostTradeNewShift'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'weeklyMinimumPaidMinutes' => 'getWeeklyMinimumPaidMinutes',
        'weeklyMaximumPaidMinutes' => 'getWeeklyMaximumPaidMinutes',
        'preTradeSchedulePaidMinutes' => 'getPreTradeSchedulePaidMinutes',
        'postTradeSchedulePaidMinutes' => 'getPostTradeSchedulePaidMinutes',
        'postTradeNewShift' => 'getPostTradeNewShift'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['weeklyMinimumPaidMinutes'] = isset($data['weeklyMinimumPaidMinutes']) ? $data['weeklyMinimumPaidMinutes'] : null;
        $this->container['weeklyMaximumPaidMinutes'] = isset($data['weeklyMaximumPaidMinutes']) ? $data['weeklyMaximumPaidMinutes'] : null;
        $this->container['preTradeSchedulePaidMinutes'] = isset($data['preTradeSchedulePaidMinutes']) ? $data['preTradeSchedulePaidMinutes'] : null;
        $this->container['postTradeSchedulePaidMinutes'] = isset($data['postTradeSchedulePaidMinutes']) ? $data['postTradeSchedulePaidMinutes'] : null;
        $this->container['postTradeNewShift'] = isset($data['postTradeNewShift']) ? $data['postTradeNewShift'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets weeklyMinimumPaidMinutes
     * @return int
     */
    public function getWeeklyMinimumPaidMinutes()
    {
        return $this->container['weeklyMinimumPaidMinutes'];
    }

    /**
     * Sets weeklyMinimumPaidMinutes
     * @param int $weeklyMinimumPaidMinutes The minimum weekly paid minutes for this user per the work plan tied to the agent schedule
     * @return $this
     */
    public function setWeeklyMinimumPaidMinutes($weeklyMinimumPaidMinutes)
    {
        $this->container['weeklyMinimumPaidMinutes'] = $weeklyMinimumPaidMinutes;

        return $this;
    }

    /**
     * Gets weeklyMaximumPaidMinutes
     * @return int
     */
    public function getWeeklyMaximumPaidMinutes()
    {
        return $this->container['weeklyMaximumPaidMinutes'];
    }

    /**
     * Sets weeklyMaximumPaidMinutes
     * @param int $weeklyMaximumPaidMinutes The maximum weekly paid minutes for this user per the work plan tied to the agent schedule
     * @return $this
     */
    public function setWeeklyMaximumPaidMinutes($weeklyMaximumPaidMinutes)
    {
        $this->container['weeklyMaximumPaidMinutes'] = $weeklyMaximumPaidMinutes;

        return $this;
    }

    /**
     * Gets preTradeSchedulePaidMinutes
     * @return int
     */
    public function getPreTradeSchedulePaidMinutes()
    {
        return $this->container['preTradeSchedulePaidMinutes'];
    }

    /**
     * Sets preTradeSchedulePaidMinutes
     * @param int $preTradeSchedulePaidMinutes The paid minutes on the week schedule for this user prior to the shift trade
     * @return $this
     */
    public function setPreTradeSchedulePaidMinutes($preTradeSchedulePaidMinutes)
    {
        $this->container['preTradeSchedulePaidMinutes'] = $preTradeSchedulePaidMinutes;

        return $this;
    }

    /**
     * Gets postTradeSchedulePaidMinutes
     * @return int
     */
    public function getPostTradeSchedulePaidMinutes()
    {
        return $this->container['postTradeSchedulePaidMinutes'];
    }

    /**
     * Sets postTradeSchedulePaidMinutes
     * @param int $postTradeSchedulePaidMinutes The paid minutes on the week schedule for this user if the shift trade is approved
     * @return $this
     */
    public function setPostTradeSchedulePaidMinutes($postTradeSchedulePaidMinutes)
    {
        $this->container['postTradeSchedulePaidMinutes'] = $postTradeSchedulePaidMinutes;

        return $this;
    }

    /**
     * Gets postTradeNewShift
     * @return \PureCloudSDK\ShiftTradePreviewResponse
     */
    public function getPostTradeNewShift()
    {
        return $this->container['postTradeNewShift'];
    }

    /**
     * Sets postTradeNewShift
     * @param \PureCloudSDK\ShiftTradePreviewResponse $postTradeNewShift Preview of what the shift will look like for the opposite side of this trade after the match is approved
     * @return $this
     */
    public function setPostTradeNewShift($postTradeNewShift)
    {
        $this->container['postTradeNewShift'] = $postTradeNewShift;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
