<?php

/**
 * TimeOffRequestResponse
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * TimeOffRequestResponse Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class TimeOffRequestResponse implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'TimeOffRequestResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'user' => '\PureCloudSDK\UserReference',
        'isFullDayRequest' => 'bool',
        'markedAsRead' => 'bool',
        'activityCodeId' => 'string',
        'status' => 'string',
        'partialDayStartDateTimes' => '\DateTime[]',
        'fullDayManagementUnitDates' => 'string[]',
        'dailyDurationMinutes' => 'int',
        'notes' => 'string',
        'submittedBy' => '\PureCloudSDK\UserReference',
        'submittedDate' => '\DateTime',
        'reviewedBy' => '\PureCloudSDK\UserReference',
        'reviewedDate' => '\DateTime',
        'modifiedBy' => '\PureCloudSDK\UserReference',
        'modifiedDate' => '\DateTime',
        'metadata' => '\PureCloudSDK\WfmVersionedEntityMetadata',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'user' => 'user',
        'isFullDayRequest' => 'isFullDayRequest',
        'markedAsRead' => 'markedAsRead',
        'activityCodeId' => 'activityCodeId',
        'status' => 'status',
        'partialDayStartDateTimes' => 'partialDayStartDateTimes',
        'fullDayManagementUnitDates' => 'fullDayManagementUnitDates',
        'dailyDurationMinutes' => 'dailyDurationMinutes',
        'notes' => 'notes',
        'submittedBy' => 'submittedBy',
        'submittedDate' => 'submittedDate',
        'reviewedBy' => 'reviewedBy',
        'reviewedDate' => 'reviewedDate',
        'modifiedBy' => 'modifiedBy',
        'modifiedDate' => 'modifiedDate',
        'metadata' => 'metadata',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'user' => 'setUser',
        'isFullDayRequest' => 'setIsFullDayRequest',
        'markedAsRead' => 'setMarkedAsRead',
        'activityCodeId' => 'setActivityCodeId',
        'status' => 'setStatus',
        'partialDayStartDateTimes' => 'setPartialDayStartDateTimes',
        'fullDayManagementUnitDates' => 'setFullDayManagementUnitDates',
        'dailyDurationMinutes' => 'setDailyDurationMinutes',
        'notes' => 'setNotes',
        'submittedBy' => 'setSubmittedBy',
        'submittedDate' => 'setSubmittedDate',
        'reviewedBy' => 'setReviewedBy',
        'reviewedDate' => 'setReviewedDate',
        'modifiedBy' => 'setModifiedBy',
        'modifiedDate' => 'setModifiedDate',
        'metadata' => 'setMetadata',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'user' => 'getUser',
        'isFullDayRequest' => 'getIsFullDayRequest',
        'markedAsRead' => 'getMarkedAsRead',
        'activityCodeId' => 'getActivityCodeId',
        'status' => 'getStatus',
        'partialDayStartDateTimes' => 'getPartialDayStartDateTimes',
        'fullDayManagementUnitDates' => 'getFullDayManagementUnitDates',
        'dailyDurationMinutes' => 'getDailyDurationMinutes',
        'notes' => 'getNotes',
        'submittedBy' => 'getSubmittedBy',
        'submittedDate' => 'getSubmittedDate',
        'reviewedBy' => 'getReviewedBy',
        'reviewedDate' => 'getReviewedDate',
        'modifiedBy' => 'getModifiedBy',
        'modifiedDate' => 'getModifiedDate',
        'metadata' => 'getMetadata',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const STATUS_PENDING = 'PENDING';
    public const STATUS_APPROVED = 'APPROVED';
    public const STATUS_DENIED = 'DENIED';
    public const STATUS_CANCELED = 'CANCELED';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_PENDING,
            self::STATUS_APPROVED,
            self::STATUS_DENIED,
            self::STATUS_CANCELED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['user'] = isset($data['user']) ? $data['user'] : null;
        $this->container['isFullDayRequest'] = isset($data['isFullDayRequest']) ? $data['isFullDayRequest'] : null;
        $this->container['markedAsRead'] = isset($data['markedAsRead']) ? $data['markedAsRead'] : null;
        $this->container['activityCodeId'] = isset($data['activityCodeId']) ? $data['activityCodeId'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['partialDayStartDateTimes'] = isset($data['partialDayStartDateTimes']) ? $data['partialDayStartDateTimes'] : null;
        $this->container['fullDayManagementUnitDates'] = isset($data['fullDayManagementUnitDates']) ? $data['fullDayManagementUnitDates'] : null;
        $this->container['dailyDurationMinutes'] = isset($data['dailyDurationMinutes']) ? $data['dailyDurationMinutes'] : null;
        $this->container['notes'] = isset($data['notes']) ? $data['notes'] : null;
        $this->container['submittedBy'] = isset($data['submittedBy']) ? $data['submittedBy'] : null;
        $this->container['submittedDate'] = isset($data['submittedDate']) ? $data['submittedDate'] : null;
        $this->container['reviewedBy'] = isset($data['reviewedBy']) ? $data['reviewedBy'] : null;
        $this->container['reviewedDate'] = isset($data['reviewedDate']) ? $data['reviewedDate'] : null;
        $this->container['modifiedBy'] = isset($data['modifiedBy']) ? $data['modifiedBy'] : null;
        $this->container['modifiedDate'] = isset($data['modifiedDate']) ? $data['modifiedDate'] : null;
        $this->container['metadata'] = isset($data['metadata']) ? $data['metadata'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("PENDING", "APPROVED", "DENIED", "CANCELED");
        if (!in_array($this->container['status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("PENDING", "APPROVED", "DENIED", "CANCELED");
        if (!in_array($this->container['status'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets user
     * @return \PureCloudSDK\UserReference
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     * @param \PureCloudSDK\UserReference $user The user associated with this time off request
     * @return $this
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }

    /**
     * Gets isFullDayRequest
     * @return bool
     */
    public function getIsFullDayRequest()
    {
        return $this->container['isFullDayRequest'];
    }

    /**
     * Sets isFullDayRequest
     * @param bool $isFullDayRequest Whether this is a full day request (false means partial day)
     * @return $this
     */
    public function setIsFullDayRequest($isFullDayRequest)
    {
        $this->container['isFullDayRequest'] = $isFullDayRequest;

        return $this;
    }

    /**
     * Gets markedAsRead
     * @return bool
     */
    public function getMarkedAsRead()
    {
        return $this->container['markedAsRead'];
    }

    /**
     * Sets markedAsRead
     * @param bool $markedAsRead Whether this request has been marked as read by the agent
     * @return $this
     */
    public function setMarkedAsRead($markedAsRead)
    {
        $this->container['markedAsRead'] = $markedAsRead;

        return $this;
    }

    /**
     * Gets activityCodeId
     * @return string
     */
    public function getActivityCodeId()
    {
        return $this->container['activityCodeId'];
    }

    /**
     * Sets activityCodeId
     * @param string $activityCodeId The ID of the activity code associated with this time off request. Activity code must be of the TimeOff category
     * @return $this
     */
    public function setActivityCodeId($activityCodeId)
    {
        $this->container['activityCodeId'] = $activityCodeId;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status The status of this time off request
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = array('PENDING', 'APPROVED', 'DENIED', 'CANCELED');
        if (!in_array($status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'PENDING', 'APPROVED', 'DENIED', 'CANCELED'");
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets partialDayStartDateTimes
     * @return \DateTime[]
     */
    public function getPartialDayStartDateTimes()
    {
        return $this->container['partialDayStartDateTimes'];
    }

    /**
     * Sets partialDayStartDateTimes
     * @param \DateTime[] $partialDayStartDateTimes A set of start date-times in ISO-8601 format for partial day requests.  Will be not empty if isFullDayRequest == false
     * @return $this
     */
    public function setPartialDayStartDateTimes($partialDayStartDateTimes)
    {
        $this->container['partialDayStartDateTimes'] = $partialDayStartDateTimes;

        return $this;
    }

    /**
     * Gets fullDayManagementUnitDates
     * @return string[]
     */
    public function getFullDayManagementUnitDates()
    {
        return $this->container['fullDayManagementUnitDates'];
    }

    /**
     * Sets fullDayManagementUnitDates
     * @param string[] $fullDayManagementUnitDates A set of dates in yyyy-MM-dd format.  Should be interpreted in the management unit's configured time zone.  Will be not empty if isFullDayRequest == true
     * @return $this
     */
    public function setFullDayManagementUnitDates($fullDayManagementUnitDates)
    {
        $this->container['fullDayManagementUnitDates'] = $fullDayManagementUnitDates;

        return $this;
    }

    /**
     * Gets dailyDurationMinutes
     * @return int
     */
    public function getDailyDurationMinutes()
    {
        return $this->container['dailyDurationMinutes'];
    }

    /**
     * Sets dailyDurationMinutes
     * @param int $dailyDurationMinutes The daily duration of this time off request in minutes
     * @return $this
     */
    public function setDailyDurationMinutes($dailyDurationMinutes)
    {
        $this->container['dailyDurationMinutes'] = $dailyDurationMinutes;

        return $this;
    }

    /**
     * Gets notes
     * @return string
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     * @param string $notes Notes about the time off request
     * @return $this
     */
    public function setNotes($notes)
    {
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets submittedBy
     * @return \PureCloudSDK\UserReference
     */
    public function getSubmittedBy()
    {
        return $this->container['submittedBy'];
    }

    /**
     * Sets submittedBy
     * @param \PureCloudSDK\UserReference $submittedBy The user who submitted this time off request
     * @return $this
     */
    public function setSubmittedBy($submittedBy)
    {
        $this->container['submittedBy'] = $submittedBy;

        return $this;
    }

    /**
     * Gets submittedDate
     * @return \DateTime
     */
    public function getSubmittedDate()
    {
        return $this->container['submittedDate'];
    }

    /**
     * Sets submittedDate
     * @param \DateTime $submittedDate The timestamp when this request was submitted. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setSubmittedDate($submittedDate)
    {
        $this->container['submittedDate'] = $submittedDate;

        return $this;
    }

    /**
     * Gets reviewedBy
     * @return \PureCloudSDK\UserReference
     */
    public function getReviewedBy()
    {
        return $this->container['reviewedBy'];
    }

    /**
     * Sets reviewedBy
     * @param \PureCloudSDK\UserReference $reviewedBy The user who reviewed this time off request
     * @return $this
     */
    public function setReviewedBy($reviewedBy)
    {
        $this->container['reviewedBy'] = $reviewedBy;

        return $this;
    }

    /**
     * Gets reviewedDate
     * @return \DateTime
     */
    public function getReviewedDate()
    {
        return $this->container['reviewedDate'];
    }

    /**
     * Sets reviewedDate
     * @param \DateTime $reviewedDate The timestamp when this request was reviewed. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setReviewedDate($reviewedDate)
    {
        $this->container['reviewedDate'] = $reviewedDate;

        return $this;
    }

    /**
     * Gets modifiedBy
     * @return \PureCloudSDK\UserReference
     */
    public function getModifiedBy()
    {
        return $this->container['modifiedBy'];
    }

    /**
     * Sets modifiedBy
     * @param \PureCloudSDK\UserReference $modifiedBy The user who last modified this TimeOffRequestResponse
     * @return $this
     */
    public function setModifiedBy($modifiedBy)
    {
        $this->container['modifiedBy'] = $modifiedBy;

        return $this;
    }

    /**
     * Gets modifiedDate
     * @return \DateTime
     */
    public function getModifiedDate()
    {
        return $this->container['modifiedDate'];
    }

    /**
     * Sets modifiedDate
     * @param \DateTime $modifiedDate The timestamp when this request was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setModifiedDate($modifiedDate)
    {
        $this->container['modifiedDate'] = $modifiedDate;

        return $this;
    }

    /**
     * Gets metadata
     * @return \PureCloudSDK\WfmVersionedEntityMetadata
     */
    public function getMetadata()
    {
        return $this->container['metadata'];
    }

    /**
     * Sets metadata
     * @param \PureCloudSDK\WfmVersionedEntityMetadata $metadata The version metadata of the time off request
     * @return $this
     */
    public function setMetadata($metadata)
    {
        $this->container['metadata'] = $metadata;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
