<?php

/**
 * WfmForecastModificationAttributes
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * WfmForecastModificationAttributes Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class WfmForecastModificationAttributes implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'WfmForecastModificationAttributes';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'queues' => '\PureCloudSDK\QueueReference[]',
        'mediaTypes' => 'string[]',
        'languages' => '\PureCloudSDK\LanguageReference[]',
        'skillSets' => '\PureCloudSDK\RoutingSkillReference[][]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'queues' => 'queues',
        'mediaTypes' => 'mediaTypes',
        'languages' => 'languages',
        'skillSets' => 'skillSets'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'queues' => 'setQueues',
        'mediaTypes' => 'setMediaTypes',
        'languages' => 'setLanguages',
        'skillSets' => 'setSkillSets'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'queues' => 'getQueues',
        'mediaTypes' => 'getMediaTypes',
        'languages' => 'getLanguages',
        'skillSets' => 'getSkillSets'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const MEDIA_TYPES_VOICE = 'Voice';
    public const MEDIA_TYPES_CHAT = 'Chat';
    public const MEDIA_TYPES_EMAIL = 'Email';
    public const MEDIA_TYPES_CALLBACK = 'Callback';
    public const MEDIA_TYPES_MESSAGE = 'Message';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMediaTypesAllowableValues()
    {
        return [
            self::MEDIA_TYPES_VOICE,
            self::MEDIA_TYPES_CHAT,
            self::MEDIA_TYPES_EMAIL,
            self::MEDIA_TYPES_CALLBACK,
            self::MEDIA_TYPES_MESSAGE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['queues'] = isset($data['queues']) ? $data['queues'] : null;
        $this->container['mediaTypes'] = isset($data['mediaTypes']) ? $data['mediaTypes'] : null;
        $this->container['languages'] = isset($data['languages']) ? $data['languages'] : null;
        $this->container['skillSets'] = isset($data['skillSets']) ? $data['skillSets'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets queues
     * @return \PureCloudSDK\QueueReference[]
     */
    public function getQueues()
    {
        return $this->container['queues'];
    }

    /**
     * Sets queues
     * @param \PureCloudSDK\QueueReference[] $queues The queues to which to apply a modification
     * @return $this
     */
    public function setQueues($queues)
    {
        $this->container['queues'] = $queues;

        return $this;
    }

    /**
     * Gets mediaTypes
     * @return string[]
     */
    public function getMediaTypes()
    {
        return $this->container['mediaTypes'];
    }

    /**
     * Sets mediaTypes
     * @param string[] $mediaTypes The media types to which to apply a modification
     * @return $this
     */
    public function setMediaTypes($mediaTypes)
    {
        $allowed_values = array('Voice', 'Chat', 'Email', 'Callback', 'Message');
        if (!in_array($mediaTypes, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'mediaTypes', must be one of 'Voice', 'Chat', 'Email', 'Callback', 'Message'");
        }
        $this->container['mediaTypes'] = $mediaTypes;

        return $this;
    }

    /**
     * Gets languages
     * @return \PureCloudSDK\LanguageReference[]
     */
    public function getLanguages()
    {
        return $this->container['languages'];
    }

    /**
     * Sets languages
     * @param \PureCloudSDK\LanguageReference[] $languages The languages to which to apply a modification
     * @return $this
     */
    public function setLanguages($languages)
    {
        $this->container['languages'] = $languages;

        return $this;
    }

    /**
     * Gets skillSets
     * @return \PureCloudSDK\RoutingSkillReference[][]
     */
    public function getSkillSets()
    {
        return $this->container['skillSets'];
    }

    /**
     * Sets skillSets
     * @param \PureCloudSDK\RoutingSkillReference[][] $skillSets The skill sets to which to apply a modification
     * @return $this
     */
    public function setSkillSets($skillSets)
    {
        $this->container['skillSets'] = $skillSets;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
