<?php

/**
 * WhatsAppIntegration
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * WhatsAppIntegration Class Doc Comment
 *
 * @category    Class */
/**
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class WhatsAppIntegration implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'WhatsAppIntegration';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'phoneNumber' => 'string',
        'status' => 'string',
        'recipient' => '\PureCloudSDK\DomainEntityRef',
        'dateCreated' => '\DateTime',
        'dateModified' => '\DateTime',
        'createdBy' => '\PureCloudSDK\DomainEntityRef',
        'modifiedBy' => '\PureCloudSDK\DomainEntityRef',
        'version' => 'int',
        'activationStatusCode' => 'string',
        'activationErrorInfo' => '\PureCloudSDK\ErrorBody',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'phoneNumber' => 'phoneNumber',
        'status' => 'status',
        'recipient' => 'recipient',
        'dateCreated' => 'dateCreated',
        'dateModified' => 'dateModified',
        'createdBy' => 'createdBy',
        'modifiedBy' => 'modifiedBy',
        'version' => 'version',
        'activationStatusCode' => 'activationStatusCode',
        'activationErrorInfo' => 'activationErrorInfo',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'phoneNumber' => 'setPhoneNumber',
        'status' => 'setStatus',
        'recipient' => 'setRecipient',
        'dateCreated' => 'setDateCreated',
        'dateModified' => 'setDateModified',
        'createdBy' => 'setCreatedBy',
        'modifiedBy' => 'setModifiedBy',
        'version' => 'setVersion',
        'activationStatusCode' => 'setActivationStatusCode',
        'activationErrorInfo' => 'setActivationErrorInfo',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'phoneNumber' => 'getPhoneNumber',
        'status' => 'getStatus',
        'recipient' => 'getRecipient',
        'dateCreated' => 'getDateCreated',
        'dateModified' => 'getDateModified',
        'createdBy' => 'getCreatedBy',
        'modifiedBy' => 'getModifiedBy',
        'version' => 'getVersion',
        'activationStatusCode' => 'getActivationStatusCode',
        'activationErrorInfo' => 'getActivationErrorInfo',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const STATUS_ACTIVE = 'Active';
    public const STATUS_INACTIVE = 'Inactive';
    public const STATUS_ERROR = 'Error';
    public const STATUS_STARTING = 'Starting';
    public const STATUS_INCOMPLETE = 'Incomplete';
    public const STATUS_DELETING = 'Deleting';
    public const STATUS_DELETION_FAILED = 'DeletionFailed';
    public const ACTIVATION_STATUS_CODE_CODE_SENT = 'CodeSent';
    public const ACTIVATION_STATUS_CODE_WAIT_REQUIRED = 'WaitRequired';
    public const ACTIVATION_STATUS_CODE_ACTIVATION_FAILED = 'ActivationFailed';
    public const ACTIVATION_STATUS_CODE_CODE_CONFIRMED = 'CodeConfirmed';
    public const ACTIVATION_STATUS_CODE_CONFIRMATION_FAILED = 'ConfirmationFailed';
    public const ACTIVATION_STATUS_CODE_RESEND_CODE = 'ResendCode';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_ACTIVE,
            self::STATUS_INACTIVE,
            self::STATUS_ERROR,
            self::STATUS_STARTING,
            self::STATUS_INCOMPLETE,
            self::STATUS_DELETING,
            self::STATUS_DELETION_FAILED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getActivationStatusCodeAllowableValues()
    {
        return [
            self::ACTIVATION_STATUS_CODE_CODE_SENT,
            self::ACTIVATION_STATUS_CODE_WAIT_REQUIRED,
            self::ACTIVATION_STATUS_CODE_ACTIVATION_FAILED,
            self::ACTIVATION_STATUS_CODE_CODE_CONFIRMED,
            self::ACTIVATION_STATUS_CODE_CONFIRMATION_FAILED,
            self::ACTIVATION_STATUS_CODE_RESEND_CODE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['phoneNumber'] = isset($data['phoneNumber']) ? $data['phoneNumber'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['recipient'] = isset($data['recipient']) ? $data['recipient'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['dateModified'] = isset($data['dateModified']) ? $data['dateModified'] : null;
        $this->container['createdBy'] = isset($data['createdBy']) ? $data['createdBy'] : null;
        $this->container['modifiedBy'] = isset($data['modifiedBy']) ? $data['modifiedBy'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['activationStatusCode'] = isset($data['activationStatusCode']) ? $data['activationStatusCode'] : null;
        $this->container['activationErrorInfo'] = isset($data['activationErrorInfo']) ? $data['activationErrorInfo'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['id'] === null) {
            $invalid_properties[] = "'id' can't be null";
        }
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        if ($this->container['phoneNumber'] === null) {
            $invalid_properties[] = "'phoneNumber' can't be null";
        }
        $allowed_values = array("Active", "Inactive", "Error", "Starting", "Incomplete", "Deleting", "DeletionFailed");
        if (!in_array($this->container['status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status', must be one of #{allowed_values}.";
        }

        if ($this->container['version'] === null) {
            $invalid_properties[] = "'version' can't be null";
        }
        $allowed_values = array("CodeSent", "WaitRequired", "ActivationFailed", "CodeConfirmed", "ConfirmationFailed", "ResendCode");
        if (!in_array($this->container['activationStatusCode'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'activationStatusCode', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['id'] === null) {
            return false;
        }
        if ($this->container['name'] === null) {
            return false;
        }
        if ($this->container['phoneNumber'] === null) {
            return false;
        }
        $allowed_values = array("Active", "Inactive", "Error", "Starting", "Incomplete", "Deleting", "DeletionFailed");
        if (!in_array($this->container['status'], $allowed_values)) {
            return false;
        }
        if ($this->container['version'] === null) {
            return false;
        }
        $allowed_values = array("CodeSent", "WaitRequired", "ActivationFailed", "CodeConfirmed", "ConfirmationFailed", "ResendCode");
        if (!in_array($this->container['activationStatusCode'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id A unique Integration Id.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of the WhatsApp integration.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets phoneNumber
     * @return string
     */
    public function getPhoneNumber()
    {
        return $this->container['phoneNumber'];
    }

    /**
     * Sets phoneNumber
     * @param string $phoneNumber The phone number associated to the whatsApp integration.
     * @return $this
     */
    public function setPhoneNumber($phoneNumber)
    {
        $this->container['phoneNumber'] = $phoneNumber;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status The status of the WhatsApp Integration
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = array('Active', 'Inactive', 'Error', 'Starting', 'Incomplete', 'Deleting', 'DeletionFailed');
        if (!in_array($status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'Active', 'Inactive', 'Error', 'Starting', 'Incomplete', 'Deleting', 'DeletionFailed'");
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets recipient
     * @return \PureCloudSDK\DomainEntityRef
     */
    public function getRecipient()
    {
        return $this->container['recipient'];
    }

    /**
     * Sets recipient
     * @param \PureCloudSDK\DomainEntityRef $recipient The recipient associated to the WhatsApp Integration. This recipient is used to associate a flow to an integration
     * @return $this
     */
    public function setRecipient($recipient)
    {
        $this->container['recipient'] = $recipient;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated Date this Integration was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets dateModified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['dateModified'];
    }

    /**
     * Sets dateModified
     * @param \DateTime $dateModified Date this Integration was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($dateModified)
    {
        $this->container['dateModified'] = $dateModified;

        return $this;
    }

    /**
     * Gets createdBy
     * @return \PureCloudSDK\DomainEntityRef
     */
    public function getCreatedBy()
    {
        return $this->container['createdBy'];
    }

    /**
     * Sets createdBy
     * @param \PureCloudSDK\DomainEntityRef $createdBy User reference that created this Integration
     * @return $this
     */
    public function setCreatedBy($createdBy)
    {
        $this->container['createdBy'] = $createdBy;

        return $this;
    }

    /**
     * Gets modifiedBy
     * @return \PureCloudSDK\DomainEntityRef
     */
    public function getModifiedBy()
    {
        return $this->container['modifiedBy'];
    }

    /**
     * Sets modifiedBy
     * @param \PureCloudSDK\DomainEntityRef $modifiedBy User reference that last modified this Integration
     * @return $this
     */
    public function setModifiedBy($modifiedBy)
    {
        $this->container['modifiedBy'] = $modifiedBy;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version Version number required for updates.
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets activationStatusCode
     * @return string
     */
    public function getActivationStatusCode()
    {
        return $this->container['activationStatusCode'];
    }

    /**
     * Sets activationStatusCode
     * @param string $activationStatusCode The status code of WhatsApp Integration activation process
     * @return $this
     */
    public function setActivationStatusCode($activationStatusCode)
    {
        $allowed_values = array('CodeSent', 'WaitRequired', 'ActivationFailed', 'CodeConfirmed', 'ConfirmationFailed', 'ResendCode');
        if (!in_array($activationStatusCode, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'activationStatusCode', must be one of 'CodeSent', 'WaitRequired', 'ActivationFailed', 'CodeConfirmed', 'ConfirmationFailed', 'ResendCode'");
        }
        $this->container['activationStatusCode'] = $activationStatusCode;

        return $this;
    }

    /**
     * Gets activationErrorInfo
     * @return \PureCloudSDK\ErrorBody
     */
    public function getActivationErrorInfo()
    {
        return $this->container['activationErrorInfo'];
    }

    /**
     * Sets activationErrorInfo
     * @param \PureCloudSDK\ErrorBody $activationErrorInfo The error information of WhatsApp Integration activation process
     * @return $this
     */
    public function setActivationErrorInfo($activationErrorInfo)
    {
        $this->container['activationErrorInfo'] = $activationErrorInfo;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}
