<?php

/**
 * DocumentationSearchCriteria
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * DocumentationSearchCriteria Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class DocumentationSearchCriteria implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'DocumentationSearchCriteria';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'endValue' => 'string',
        'values' => 'string[]',
        'startValue' => 'string',
        'fields' => 'string[]',
        'value' => 'string',
        'operator' => 'string',
        'group' => '\PureCloudSDK\DocumentationSearchCriteria[]',
        'type' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'endValue' => 'endValue',
        'values' => 'values',
        'startValue' => 'startValue',
        'fields' => 'fields',
        'value' => 'value',
        'operator' => 'operator',
        'group' => 'group',
        'type' => 'type'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'endValue' => 'setEndValue',
        'values' => 'setValues',
        'startValue' => 'setStartValue',
        'fields' => 'setFields',
        'value' => 'setValue',
        'operator' => 'setOperator',
        'group' => 'setGroup',
        'type' => 'setType'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'endValue' => 'getEndValue',
        'values' => 'getValues',
        'startValue' => 'getStartValue',
        'fields' => 'getFields',
        'value' => 'getValue',
        'operator' => 'getOperator',
        'group' => 'getGroup',
        'type' => 'getType'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const OPERATOR_AND = 'AND';
    public const OPERATOR_OR = 'OR';
    public const OPERATOR_NOT = 'NOT';
    public const TYPE_EXACT = 'EXACT';
    public const TYPE_STARTS_WITH = 'STARTS_WITH';
    public const TYPE_CONTAINS = 'CONTAINS';
    public const TYPE_TERM = 'TERM';
    public const TYPE_TERMS = 'TERMS';
    public const TYPE_MATCH_ALL = 'MATCH_ALL';
    public const TYPE_SIMPLE = 'SIMPLE';
    public const TYPE_QUERY_STRING = 'QUERY_STRING';
    public const TYPE_MULTI_MATCH = 'MULTI_MATCH';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOperatorAllowableValues()
    {
        return [
            self::OPERATOR_AND,
            self::OPERATOR_OR,
            self::OPERATOR_NOT,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_EXACT,
            self::TYPE_STARTS_WITH,
            self::TYPE_CONTAINS,
            self::TYPE_TERM,
            self::TYPE_TERMS,
            self::TYPE_MATCH_ALL,
            self::TYPE_SIMPLE,
            self::TYPE_QUERY_STRING,
            self::TYPE_MULTI_MATCH,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['endValue'] = isset($data['endValue']) ? $data['endValue'] : null;
        $this->container['values'] = isset($data['values']) ? $data['values'] : null;
        $this->container['startValue'] = isset($data['startValue']) ? $data['startValue'] : null;
        $this->container['fields'] = isset($data['fields']) ? $data['fields'] : null;
        $this->container['value'] = isset($data['value']) ? $data['value'] : null;
        $this->container['operator'] = isset($data['operator']) ? $data['operator'] : null;
        $this->container['group'] = isset($data['group']) ? $data['group'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("AND", "OR", "NOT");
        if (!in_array($this->container['operator'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'operator', must be one of #{allowed_values}.";
        }

        if ($this->container['type'] === null) {
            $invalid_properties[] = "'type' can't be null";
        }
        $allowed_values = array("EXACT", "STARTS_WITH", "CONTAINS", "TERM", "TERMS", "MATCH_ALL", "SIMPLE", "QUERY_STRING", "MULTI_MATCH");
        if (!in_array($this->container['type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("AND", "OR", "NOT");
        if (!in_array($this->container['operator'], $allowed_values)) {
            return false;
        }
        if ($this->container['type'] === null) {
            return false;
        }
        $allowed_values = array("EXACT", "STARTS_WITH", "CONTAINS", "TERM", "TERMS", "MATCH_ALL", "SIMPLE", "QUERY_STRING", "MULTI_MATCH");
        if (!in_array($this->container['type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets endValue
     * @return string
     */
    public function getEndValue()
    {
        return $this->container['endValue'];
    }

    /**
     * Sets endValue
     * @param string $endValue The end value of the range. This field is used for range search types.
     * @return $this
     */
    public function setEndValue($endValue)
    {
        $this->container['endValue'] = $endValue;

        return $this;
    }

    /**
     * Gets values
     * @return string[]
     */
    public function getValues()
    {
        return $this->container['values'];
    }

    /**
     * Sets values
     * @param string[] $values A list of values for the search to match against
     * @return $this
     */
    public function setValues($values)
    {
        $this->container['values'] = $values;

        return $this;
    }

    /**
     * Gets startValue
     * @return string
     */
    public function getStartValue()
    {
        return $this->container['startValue'];
    }

    /**
     * Sets startValue
     * @param string $startValue The start value of the range. This field is used for range search types.
     * @return $this
     */
    public function setStartValue($startValue)
    {
        $this->container['startValue'] = $startValue;

        return $this;
    }

    /**
     * Gets fields
     * @return string[]
     */
    public function getFields()
    {
        return $this->container['fields'];
    }

    /**
     * Sets fields
     * @param string[] $fields Field names to search against
     * @return $this
     */
    public function setFields($fields)
    {
        $this->container['fields'] = $fields;

        return $this;
    }

    /**
     * Gets value
     * @return string
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     * @param string $value A value for the search to match against
     * @return $this
     */
    public function setValue($value)
    {
        $this->container['value'] = $value;

        return $this;
    }

    /**
     * Gets operator
     * @return string
     */
    public function getOperator()
    {
        return $this->container['operator'];
    }

    /**
     * Sets operator
     * @param string $operator How to apply this search criteria against other criteria
     * @return $this
     */
    public function setOperator($operator)
    {
        $allowed_values = array('AND', 'OR', 'NOT');
        if (!in_array($operator, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'operator', must be one of 'AND', 'OR', 'NOT'");
        }
        $this->container['operator'] = $operator;

        return $this;
    }

    /**
     * Gets group
     * @return \PureCloudSDK\DocumentationSearchCriteria[]
     */
    public function getGroup()
    {
        return $this->container['group'];
    }

    /**
     * Sets group
     * @param \PureCloudSDK\DocumentationSearchCriteria[] $group Groups multiple conditions
     * @return $this
     */
    public function setGroup($group)
    {
        $this->container['group'] = $group;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type Search Type
     * @return $this
     */
    public function setType($type)
    {
        $allowed_values = array('EXACT', 'STARTS_WITH', 'CONTAINS', 'TERM', 'TERMS', 'MATCH_ALL', 'SIMPLE', 'QUERY_STRING', 'MULTI_MATCH');
        if (!in_array($type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'type', must be one of 'EXACT', 'STARTS_WITH', 'CONTAINS', 'TERM', 'TERMS', 'MATCH_ALL', 'SIMPLE', 'QUERY_STRING', 'MULTI_MATCH'");
        }
        $this->container['type'] = $type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


