<?php

/**
 * EdgeMetrics
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * EdgeMetrics Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class EdgeMetrics implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'EdgeMetrics';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'edge' => '\PureCloudSDK\UriReference',
        'eventTime' => '\DateTime',
        'upTimeMsec' => 'int',
        'processors' => '\PureCloudSDK\EdgeMetricsProcessor[]',
        'memory' => '\PureCloudSDK\EdgeMetricsMemory[]',
        'disks' => '\PureCloudSDK\EdgeMetricsDisk[]',
        'subsystems' => '\PureCloudSDK\EdgeMetricsSubsystem[]',
        'networks' => '\PureCloudSDK\EdgeMetricsNetwork[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'edge' => 'edge',
        'eventTime' => 'eventTime',
        'upTimeMsec' => 'upTimeMsec',
        'processors' => 'processors',
        'memory' => 'memory',
        'disks' => 'disks',
        'subsystems' => 'subsystems',
        'networks' => 'networks'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'edge' => 'setEdge',
        'eventTime' => 'setEventTime',
        'upTimeMsec' => 'setUpTimeMsec',
        'processors' => 'setProcessors',
        'memory' => 'setMemory',
        'disks' => 'setDisks',
        'subsystems' => 'setSubsystems',
        'networks' => 'setNetworks'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'edge' => 'getEdge',
        'eventTime' => 'getEventTime',
        'upTimeMsec' => 'getUpTimeMsec',
        'processors' => 'getProcessors',
        'memory' => 'getMemory',
        'disks' => 'getDisks',
        'subsystems' => 'getSubsystems',
        'networks' => 'getNetworks'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['edge'] = isset($data['edge']) ? $data['edge'] : null;
        $this->container['eventTime'] = isset($data['eventTime']) ? $data['eventTime'] : null;
        $this->container['upTimeMsec'] = isset($data['upTimeMsec']) ? $data['upTimeMsec'] : null;
        $this->container['processors'] = isset($data['processors']) ? $data['processors'] : null;
        $this->container['memory'] = isset($data['memory']) ? $data['memory'] : null;
        $this->container['disks'] = isset($data['disks']) ? $data['disks'] : null;
        $this->container['subsystems'] = isset($data['subsystems']) ? $data['subsystems'] : null;
        $this->container['networks'] = isset($data['networks']) ? $data['networks'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets edge
     * @return \PureCloudSDK\UriReference
     */
    public function getEdge()
    {
        return $this->container['edge'];
    }

    /**
     * Sets edge
     * @param \PureCloudSDK\UriReference $edge
     * @return $this
     */
    public function setEdge($edge)
    {
        $this->container['edge'] = $edge;

        return $this;
    }

    /**
     * Gets eventTime
     * @return \DateTime
     */
    public function getEventTime()
    {
        return $this->container['eventTime'];
    }

    /**
     * Sets eventTime
     * @param \DateTime $eventTime Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setEventTime($eventTime)
    {
        $this->container['eventTime'] = $eventTime;

        return $this;
    }

    /**
     * Gets upTimeMsec
     * @return int
     */
    public function getUpTimeMsec()
    {
        return $this->container['upTimeMsec'];
    }

    /**
     * Sets upTimeMsec
     * @param int $upTimeMsec
     * @return $this
     */
    public function setUpTimeMsec($upTimeMsec)
    {
        $this->container['upTimeMsec'] = $upTimeMsec;

        return $this;
    }

    /**
     * Gets processors
     * @return \PureCloudSDK\EdgeMetricsProcessor[]
     */
    public function getProcessors()
    {
        return $this->container['processors'];
    }

    /**
     * Sets processors
     * @param \PureCloudSDK\EdgeMetricsProcessor[] $processors
     * @return $this
     */
    public function setProcessors($processors)
    {
        $this->container['processors'] = $processors;

        return $this;
    }

    /**
     * Gets memory
     * @return \PureCloudSDK\EdgeMetricsMemory[]
     */
    public function getMemory()
    {
        return $this->container['memory'];
    }

    /**
     * Sets memory
     * @param \PureCloudSDK\EdgeMetricsMemory[] $memory
     * @return $this
     */
    public function setMemory($memory)
    {
        $this->container['memory'] = $memory;

        return $this;
    }

    /**
     * Gets disks
     * @return \PureCloudSDK\EdgeMetricsDisk[]
     */
    public function getDisks()
    {
        return $this->container['disks'];
    }

    /**
     * Sets disks
     * @param \PureCloudSDK\EdgeMetricsDisk[] $disks
     * @return $this
     */
    public function setDisks($disks)
    {
        $this->container['disks'] = $disks;

        return $this;
    }

    /**
     * Gets subsystems
     * @return \PureCloudSDK\EdgeMetricsSubsystem[]
     */
    public function getSubsystems()
    {
        return $this->container['subsystems'];
    }

    /**
     * Sets subsystems
     * @param \PureCloudSDK\EdgeMetricsSubsystem[] $subsystems
     * @return $this
     */
    public function setSubsystems($subsystems)
    {
        $this->container['subsystems'] = $subsystems;

        return $this;
    }

    /**
     * Gets networks
     * @return \PureCloudSDK\EdgeMetricsNetwork[]
     */
    public function getNetworks()
    {
        return $this->container['networks'];
    }

    /**
     * Sets networks
     * @param \PureCloudSDK\EdgeMetricsNetwork[] $networks
     * @return $this
     */
    public function setNetworks($networks)
    {
        $this->container['networks'] = $networks;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


