<?php

/**
 * TrusteeBillingOverview
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * TrusteeBillingOverview Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class TrusteeBillingOverview implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'TrusteeBillingOverview';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'organization' => '\PureCloudSDK\Entity',
        'currency' => 'string',
        'enabledProducts' => 'string[]',
        'subscriptionType' => 'string',
        'rampPeriodStartDate' => '\DateTime',
        'rampPeriodEndDate' => '\DateTime',
        'billingPeriodStartDate' => '\DateTime',
        'billingPeriodEndDate' => '\DateTime',
        'usages' => '\PureCloudSDK\SubscriptionOverviewUsage[]',
        'contractAmendmentDate' => '\DateTime',
        'contractEffectiveDate' => '\DateTime',
        'contractEndDate' => '\DateTime',
        'inRampPeriod' => 'bool',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'organization' => 'organization',
        'currency' => 'currency',
        'enabledProducts' => 'enabledProducts',
        'subscriptionType' => 'subscriptionType',
        'rampPeriodStartDate' => 'rampPeriodStartDate',
        'rampPeriodEndDate' => 'rampPeriodEndDate',
        'billingPeriodStartDate' => 'billingPeriodStartDate',
        'billingPeriodEndDate' => 'billingPeriodEndDate',
        'usages' => 'usages',
        'contractAmendmentDate' => 'contractAmendmentDate',
        'contractEffectiveDate' => 'contractEffectiveDate',
        'contractEndDate' => 'contractEndDate',
        'inRampPeriod' => 'inRampPeriod',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'organization' => 'setOrganization',
        'currency' => 'setCurrency',
        'enabledProducts' => 'setEnabledProducts',
        'subscriptionType' => 'setSubscriptionType',
        'rampPeriodStartDate' => 'setRampPeriodStartDate',
        'rampPeriodEndDate' => 'setRampPeriodEndDate',
        'billingPeriodStartDate' => 'setBillingPeriodStartDate',
        'billingPeriodEndDate' => 'setBillingPeriodEndDate',
        'usages' => 'setUsages',
        'contractAmendmentDate' => 'setContractAmendmentDate',
        'contractEffectiveDate' => 'setContractEffectiveDate',
        'contractEndDate' => 'setContractEndDate',
        'inRampPeriod' => 'setInRampPeriod',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'organization' => 'getOrganization',
        'currency' => 'getCurrency',
        'enabledProducts' => 'getEnabledProducts',
        'subscriptionType' => 'getSubscriptionType',
        'rampPeriodStartDate' => 'getRampPeriodStartDate',
        'rampPeriodEndDate' => 'getRampPeriodEndDate',
        'billingPeriodStartDate' => 'getBillingPeriodStartDate',
        'billingPeriodEndDate' => 'getBillingPeriodEndDate',
        'usages' => 'getUsages',
        'contractAmendmentDate' => 'getContractAmendmentDate',
        'contractEffectiveDate' => 'getContractEffectiveDate',
        'contractEndDate' => 'getContractEndDate',
        'inRampPeriod' => 'getInRampPeriod',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const SUBSCRIPTION_TYPE_ININ = 'ININ';
    public const SUBSCRIPTION_TYPE_MONTH_TO_MONTH = 'MONTH_TO_MONTH';
    public const SUBSCRIPTION_TYPE_FREE_TRIAL_MONTH_TO_MONTH = 'FREE_TRIAL_MONTH_TO_MONTH';
    public const SUBSCRIPTION_TYPE_PREPAY_MONTHLY_COMMITMENT = 'PREPAY_MONTHLY_COMMITMENT';
    public const SUBSCRIPTION_TYPE_PREPAY = 'PREPAY';
    public const SUBSCRIPTION_TYPE_DEV_ORG_PREPAY_MONTHLY_COMMITMENT = 'DEV_ORG_PREPAY_MONTHLY_COMMITMENT';
    public const SUBSCRIPTION_TYPE_DEV_ORG_PREPAY = 'DEV_ORG_PREPAY';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getSubscriptionTypeAllowableValues()
    {
        return [
            self::SUBSCRIPTION_TYPE_ININ,
            self::SUBSCRIPTION_TYPE_MONTH_TO_MONTH,
            self::SUBSCRIPTION_TYPE_FREE_TRIAL_MONTH_TO_MONTH,
            self::SUBSCRIPTION_TYPE_PREPAY_MONTHLY_COMMITMENT,
            self::SUBSCRIPTION_TYPE_PREPAY,
            self::SUBSCRIPTION_TYPE_DEV_ORG_PREPAY_MONTHLY_COMMITMENT,
            self::SUBSCRIPTION_TYPE_DEV_ORG_PREPAY,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['organization'] = isset($data['organization']) ? $data['organization'] : null;
        $this->container['currency'] = isset($data['currency']) ? $data['currency'] : null;
        $this->container['enabledProducts'] = isset($data['enabledProducts']) ? $data['enabledProducts'] : null;
        $this->container['subscriptionType'] = isset($data['subscriptionType']) ? $data['subscriptionType'] : null;
        $this->container['rampPeriodStartDate'] = isset($data['rampPeriodStartDate']) ? $data['rampPeriodStartDate'] : null;
        $this->container['rampPeriodEndDate'] = isset($data['rampPeriodEndDate']) ? $data['rampPeriodEndDate'] : null;
        $this->container['billingPeriodStartDate'] = isset($data['billingPeriodStartDate']) ? $data['billingPeriodStartDate'] : null;
        $this->container['billingPeriodEndDate'] = isset($data['billingPeriodEndDate']) ? $data['billingPeriodEndDate'] : null;
        $this->container['usages'] = isset($data['usages']) ? $data['usages'] : null;
        $this->container['contractAmendmentDate'] = isset($data['contractAmendmentDate']) ? $data['contractAmendmentDate'] : null;
        $this->container['contractEffectiveDate'] = isset($data['contractEffectiveDate']) ? $data['contractEffectiveDate'] : null;
        $this->container['contractEndDate'] = isset($data['contractEndDate']) ? $data['contractEndDate'] : null;
        $this->container['inRampPeriod'] = isset($data['inRampPeriod']) ? $data['inRampPeriod'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['organization'] === null) {
            $invalid_properties[] = "'organization' can't be null";
        }
        if ($this->container['currency'] === null) {
            $invalid_properties[] = "'currency' can't be null";
        }
        if ($this->container['enabledProducts'] === null) {
            $invalid_properties[] = "'enabledProducts' can't be null";
        }
        if ($this->container['subscriptionType'] === null) {
            $invalid_properties[] = "'subscriptionType' can't be null";
        }
        $allowed_values = array("ININ", "MONTH_TO_MONTH", "FREE_TRIAL_MONTH_TO_MONTH", "PREPAY_MONTHLY_COMMITMENT", "PREPAY", "DEV_ORG_PREPAY_MONTHLY_COMMITMENT", "DEV_ORG_PREPAY");
        if (!in_array($this->container['subscriptionType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'subscriptionType', must be one of #{allowed_values}.";
        }

        if ($this->container['usages'] === null) {
            $invalid_properties[] = "'usages' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['organization'] === null) {
            return false;
        }
        if ($this->container['currency'] === null) {
            return false;
        }
        if ($this->container['enabledProducts'] === null) {
            return false;
        }
        if ($this->container['subscriptionType'] === null) {
            return false;
        }
        $allowed_values = array("ININ", "MONTH_TO_MONTH", "FREE_TRIAL_MONTH_TO_MONTH", "PREPAY_MONTHLY_COMMITMENT", "PREPAY", "DEV_ORG_PREPAY_MONTHLY_COMMITMENT", "DEV_ORG_PREPAY");
        if (!in_array($this->container['subscriptionType'], $allowed_values)) {
            return false;
        }
        if ($this->container['usages'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets organization
     * @return \PureCloudSDK\Entity
     */
    public function getOrganization()
    {
        return $this->container['organization'];
    }

    /**
     * Sets organization
     * @param \PureCloudSDK\Entity $organization Organization
     * @return $this
     */
    public function setOrganization($organization)
    {
        $this->container['organization'] = $organization;

        return $this;
    }

    /**
     * Gets currency
     * @return string
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     * @param string $currency The currency type.
     * @return $this
     */
    public function setCurrency($currency)
    {
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets enabledProducts
     * @return string[]
     */
    public function getEnabledProducts()
    {
        return $this->container['enabledProducts'];
    }

    /**
     * Sets enabledProducts
     * @param string[] $enabledProducts The charge short names for products enabled during the specified period.
     * @return $this
     */
    public function setEnabledProducts($enabledProducts)
    {
        $this->container['enabledProducts'] = $enabledProducts;

        return $this;
    }

    /**
     * Gets subscriptionType
     * @return string
     */
    public function getSubscriptionType()
    {
        return $this->container['subscriptionType'];
    }

    /**
     * Sets subscriptionType
     * @param string $subscriptionType The subscription type.
     * @return $this
     */
    public function setSubscriptionType($subscriptionType)
    {
        $allowed_values = array('ININ', 'MONTH_TO_MONTH', 'FREE_TRIAL_MONTH_TO_MONTH', 'PREPAY_MONTHLY_COMMITMENT', 'PREPAY', 'DEV_ORG_PREPAY_MONTHLY_COMMITMENT', 'DEV_ORG_PREPAY');
        if (!in_array($subscriptionType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'subscriptionType', must be one of 'ININ', 'MONTH_TO_MONTH', 'FREE_TRIAL_MONTH_TO_MONTH', 'PREPAY_MONTHLY_COMMITMENT', 'PREPAY', 'DEV_ORG_PREPAY_MONTHLY_COMMITMENT', 'DEV_ORG_PREPAY'");
        }
        $this->container['subscriptionType'] = $subscriptionType;

        return $this;
    }

    /**
     * Gets rampPeriodStartDate
     * @return \DateTime
     */
    public function getRampPeriodStartDate()
    {
        return $this->container['rampPeriodStartDate'];
    }

    /**
     * Sets rampPeriodStartDate
     * @param \DateTime $rampPeriodStartDate Date-time the ramp period starts. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setRampPeriodStartDate($rampPeriodStartDate)
    {
        $this->container['rampPeriodStartDate'] = $rampPeriodStartDate;

        return $this;
    }

    /**
     * Gets rampPeriodEndDate
     * @return \DateTime
     */
    public function getRampPeriodEndDate()
    {
        return $this->container['rampPeriodEndDate'];
    }

    /**
     * Sets rampPeriodEndDate
     * @param \DateTime $rampPeriodEndDate Date-time the ramp period ends. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setRampPeriodEndDate($rampPeriodEndDate)
    {
        $this->container['rampPeriodEndDate'] = $rampPeriodEndDate;

        return $this;
    }

    /**
     * Gets billingPeriodStartDate
     * @return \DateTime
     */
    public function getBillingPeriodStartDate()
    {
        return $this->container['billingPeriodStartDate'];
    }

    /**
     * Sets billingPeriodStartDate
     * @param \DateTime $billingPeriodStartDate Date-time the billing period started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setBillingPeriodStartDate($billingPeriodStartDate)
    {
        $this->container['billingPeriodStartDate'] = $billingPeriodStartDate;

        return $this;
    }

    /**
     * Gets billingPeriodEndDate
     * @return \DateTime
     */
    public function getBillingPeriodEndDate()
    {
        return $this->container['billingPeriodEndDate'];
    }

    /**
     * Sets billingPeriodEndDate
     * @param \DateTime $billingPeriodEndDate Date-time the billing period ended. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setBillingPeriodEndDate($billingPeriodEndDate)
    {
        $this->container['billingPeriodEndDate'] = $billingPeriodEndDate;

        return $this;
    }

    /**
     * Gets usages
     * @return \PureCloudSDK\SubscriptionOverviewUsage[]
     */
    public function getUsages()
    {
        return $this->container['usages'];
    }

    /**
     * Sets usages
     * @param \PureCloudSDK\SubscriptionOverviewUsage[] $usages Usages for the specified period.
     * @return $this
     */
    public function setUsages($usages)
    {
        $this->container['usages'] = $usages;

        return $this;
    }

    /**
     * Gets contractAmendmentDate
     * @return \DateTime
     */
    public function getContractAmendmentDate()
    {
        return $this->container['contractAmendmentDate'];
    }

    /**
     * Sets contractAmendmentDate
     * @param \DateTime $contractAmendmentDate Date-time the contract was last amended. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setContractAmendmentDate($contractAmendmentDate)
    {
        $this->container['contractAmendmentDate'] = $contractAmendmentDate;

        return $this;
    }

    /**
     * Gets contractEffectiveDate
     * @return \DateTime
     */
    public function getContractEffectiveDate()
    {
        return $this->container['contractEffectiveDate'];
    }

    /**
     * Sets contractEffectiveDate
     * @param \DateTime $contractEffectiveDate Date-time the contract became effective. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setContractEffectiveDate($contractEffectiveDate)
    {
        $this->container['contractEffectiveDate'] = $contractEffectiveDate;

        return $this;
    }

    /**
     * Gets contractEndDate
     * @return \DateTime
     */
    public function getContractEndDate()
    {
        return $this->container['contractEndDate'];
    }

    /**
     * Sets contractEndDate
     * @param \DateTime $contractEndDate Date-time the contract ends. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setContractEndDate($contractEndDate)
    {
        $this->container['contractEndDate'] = $contractEndDate;

        return $this;
    }

    /**
     * Gets inRampPeriod
     * @return bool
     */
    public function getInRampPeriod()
    {
        return $this->container['inRampPeriod'];
    }

    /**
     * Sets inRampPeriod
     * @param bool $inRampPeriod
     * @return $this
     */
    public function setInRampPeriod($inRampPeriod)
    {
        $this->container['inRampPeriod'] = $inRampPeriod;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


