<?php

/**
 * ViewFilter
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use ArrayAccess;

/**
 * ViewFilter Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ViewFilter implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ViewFilter';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'mediaTypes' => 'string[]',
        'queueIds' => 'string[]',
        'skillIds' => 'string[]',
        'skillGroups' => 'string[]',
        'languageIds' => 'string[]',
        'languageGroups' => 'string[]',
        'directions' => 'string[]',
        'originatingDirections' => 'string[]',
        'wrapUpCodes' => 'string[]',
        'dnisList' => 'string[]',
        'sessionDnisList' => 'string[]',
        'filterQueuesByUserIds' => 'string[]',
        'filterUsersByQueueIds' => 'string[]',
        'userIds' => 'string[]',
        'addressTos' => 'string[]',
        'addressFroms' => 'string[]',
        'outboundCampaignIds' => 'string[]',
        'outboundContactListIds' => 'string[]',
        'contactIds' => 'string[]',
        'aniList' => 'string[]',
        'durationsMilliseconds' => '\PureCloudSDK\NumericRange[]',
        'evaluationScore' => '\PureCloudSDK\NumericRange',
        'evaluationCriticalScore' => '\PureCloudSDK\NumericRange',
        'evaluationFormIds' => 'string[]',
        'evaluatedAgentIds' => 'string[]',
        'evaluatorIds' => 'string[]',
        'transferred' => 'bool',
        'abandoned' => 'bool',
        'messageTypes' => 'string[]',
        'divisionIds' => 'string[]',
        'surveyFormIds' => 'string[]',
        'surveyTotalScore' => '\PureCloudSDK\NumericRange',
        'surveyNpsScore' => '\PureCloudSDK\NumericRange',
        'showSecondaryStatus' => 'bool',
        'agentDurationSortOrder' => 'string',
        'waitingDurationSortOrder' => 'string',
        'interactingDurationSortOrder' => 'string',
        'agentName' => 'string',
        'skillsList' => 'string[]',
        'languageList' => 'string[]',
        'mos' => '\PureCloudSDK\NumericRange',
        'surveyQuestionGroupScore' => '\PureCloudSDK\NumericRange',
        'surveyPromoterScore' => '\PureCloudSDK\NumericRange',
        'surveyFormContextIds' => 'string[]',
        'conversationIds' => 'string[]',
        'sipCallIds' => 'string[]',
        'isEnded' => 'bool',
        'isSurveyed' => 'bool',
        'surveyScores' => '\PureCloudSDK\NumericRange[]',
        'promoterScores' => '\PureCloudSDK\NumericRange[]',
        'isCampaign' => 'bool',
        'surveyStatuses' => 'string[]',
        'conversationProperties' => '\PureCloudSDK\ConversationProperties',
        'isBlindTransferred' => 'bool',
        'isConsulted' => 'bool',
        'isConsultTransferred' => 'bool',
        'remoteParticipants' => 'string[]',
        'statusList' => 'string[]',
        'flowIds' => 'string[]',
        'flowOutcomeIds' => 'string[]',
        'flowOutcomeValues' => 'string[]',
        'flowDestinationTypes' => 'string[]',
        'flowDisconnectReasons' => 'string[]',
        'flowTypes' => 'string[]',
        'flowEntryTypes' => 'string[]',
        'flowEntryReasons' => 'string[]',
        'flowVersions' => 'string[]',
        'groupIds' => 'string[]',
        'hasJourneyCustomerId' => 'bool',
        'hasJourneyActionMapId' => 'bool',
        'hasJourneyVisitId' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'mediaTypes' => 'mediaTypes',
        'queueIds' => 'queueIds',
        'skillIds' => 'skillIds',
        'skillGroups' => 'skillGroups',
        'languageIds' => 'languageIds',
        'languageGroups' => 'languageGroups',
        'directions' => 'directions',
        'originatingDirections' => 'originatingDirections',
        'wrapUpCodes' => 'wrapUpCodes',
        'dnisList' => 'dnisList',
        'sessionDnisList' => 'sessionDnisList',
        'filterQueuesByUserIds' => 'filterQueuesByUserIds',
        'filterUsersByQueueIds' => 'filterUsersByQueueIds',
        'userIds' => 'userIds',
        'addressTos' => 'addressTos',
        'addressFroms' => 'addressFroms',
        'outboundCampaignIds' => 'outboundCampaignIds',
        'outboundContactListIds' => 'outboundContactListIds',
        'contactIds' => 'contactIds',
        'aniList' => 'aniList',
        'durationsMilliseconds' => 'durationsMilliseconds',
        'evaluationScore' => 'evaluationScore',
        'evaluationCriticalScore' => 'evaluationCriticalScore',
        'evaluationFormIds' => 'evaluationFormIds',
        'evaluatedAgentIds' => 'evaluatedAgentIds',
        'evaluatorIds' => 'evaluatorIds',
        'transferred' => 'transferred',
        'abandoned' => 'abandoned',
        'messageTypes' => 'messageTypes',
        'divisionIds' => 'divisionIds',
        'surveyFormIds' => 'surveyFormIds',
        'surveyTotalScore' => 'surveyTotalScore',
        'surveyNpsScore' => 'surveyNpsScore',
        'showSecondaryStatus' => 'showSecondaryStatus',
        'agentDurationSortOrder' => 'agentDurationSortOrder',
        'waitingDurationSortOrder' => 'waitingDurationSortOrder',
        'interactingDurationSortOrder' => 'interactingDurationSortOrder',
        'agentName' => 'agentName',
        'skillsList' => 'skillsList',
        'languageList' => 'languageList',
        'mos' => 'mos',
        'surveyQuestionGroupScore' => 'surveyQuestionGroupScore',
        'surveyPromoterScore' => 'surveyPromoterScore',
        'surveyFormContextIds' => 'surveyFormContextIds',
        'conversationIds' => 'conversationIds',
        'sipCallIds' => 'sipCallIds',
        'isEnded' => 'isEnded',
        'isSurveyed' => 'isSurveyed',
        'surveyScores' => 'surveyScores',
        'promoterScores' => 'promoterScores',
        'isCampaign' => 'isCampaign',
        'surveyStatuses' => 'surveyStatuses',
        'conversationProperties' => 'conversationProperties',
        'isBlindTransferred' => 'isBlindTransferred',
        'isConsulted' => 'isConsulted',
        'isConsultTransferred' => 'isConsultTransferred',
        'remoteParticipants' => 'remoteParticipants',
        'statusList' => 'statusList',
        'flowIds' => 'flowIds',
        'flowOutcomeIds' => 'flowOutcomeIds',
        'flowOutcomeValues' => 'flowOutcomeValues',
        'flowDestinationTypes' => 'flowDestinationTypes',
        'flowDisconnectReasons' => 'flowDisconnectReasons',
        'flowTypes' => 'flowTypes',
        'flowEntryTypes' => 'flowEntryTypes',
        'flowEntryReasons' => 'flowEntryReasons',
        'flowVersions' => 'flowVersions',
        'groupIds' => 'groupIds',
        'hasJourneyCustomerId' => 'hasJourneyCustomerId',
        'hasJourneyActionMapId' => 'hasJourneyActionMapId',
        'hasJourneyVisitId' => 'hasJourneyVisitId'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'mediaTypes' => 'setMediaTypes',
        'queueIds' => 'setQueueIds',
        'skillIds' => 'setSkillIds',
        'skillGroups' => 'setSkillGroups',
        'languageIds' => 'setLanguageIds',
        'languageGroups' => 'setLanguageGroups',
        'directions' => 'setDirections',
        'originatingDirections' => 'setOriginatingDirections',
        'wrapUpCodes' => 'setWrapUpCodes',
        'dnisList' => 'setDnisList',
        'sessionDnisList' => 'setSessionDnisList',
        'filterQueuesByUserIds' => 'setFilterQueuesByUserIds',
        'filterUsersByQueueIds' => 'setFilterUsersByQueueIds',
        'userIds' => 'setUserIds',
        'addressTos' => 'setAddressTos',
        'addressFroms' => 'setAddressFroms',
        'outboundCampaignIds' => 'setOutboundCampaignIds',
        'outboundContactListIds' => 'setOutboundContactListIds',
        'contactIds' => 'setContactIds',
        'aniList' => 'setAniList',
        'durationsMilliseconds' => 'setDurationsMilliseconds',
        'evaluationScore' => 'setEvaluationScore',
        'evaluationCriticalScore' => 'setEvaluationCriticalScore',
        'evaluationFormIds' => 'setEvaluationFormIds',
        'evaluatedAgentIds' => 'setEvaluatedAgentIds',
        'evaluatorIds' => 'setEvaluatorIds',
        'transferred' => 'setTransferred',
        'abandoned' => 'setAbandoned',
        'messageTypes' => 'setMessageTypes',
        'divisionIds' => 'setDivisionIds',
        'surveyFormIds' => 'setSurveyFormIds',
        'surveyTotalScore' => 'setSurveyTotalScore',
        'surveyNpsScore' => 'setSurveyNpsScore',
        'showSecondaryStatus' => 'setShowSecondaryStatus',
        'agentDurationSortOrder' => 'setAgentDurationSortOrder',
        'waitingDurationSortOrder' => 'setWaitingDurationSortOrder',
        'interactingDurationSortOrder' => 'setInteractingDurationSortOrder',
        'agentName' => 'setAgentName',
        'skillsList' => 'setSkillsList',
        'languageList' => 'setLanguageList',
        'mos' => 'setMos',
        'surveyQuestionGroupScore' => 'setSurveyQuestionGroupScore',
        'surveyPromoterScore' => 'setSurveyPromoterScore',
        'surveyFormContextIds' => 'setSurveyFormContextIds',
        'conversationIds' => 'setConversationIds',
        'sipCallIds' => 'setSipCallIds',
        'isEnded' => 'setIsEnded',
        'isSurveyed' => 'setIsSurveyed',
        'surveyScores' => 'setSurveyScores',
        'promoterScores' => 'setPromoterScores',
        'isCampaign' => 'setIsCampaign',
        'surveyStatuses' => 'setSurveyStatuses',
        'conversationProperties' => 'setConversationProperties',
        'isBlindTransferred' => 'setIsBlindTransferred',
        'isConsulted' => 'setIsConsulted',
        'isConsultTransferred' => 'setIsConsultTransferred',
        'remoteParticipants' => 'setRemoteParticipants',
        'statusList' => 'setStatusList',
        'flowIds' => 'setFlowIds',
        'flowOutcomeIds' => 'setFlowOutcomeIds',
        'flowOutcomeValues' => 'setFlowOutcomeValues',
        'flowDestinationTypes' => 'setFlowDestinationTypes',
        'flowDisconnectReasons' => 'setFlowDisconnectReasons',
        'flowTypes' => 'setFlowTypes',
        'flowEntryTypes' => 'setFlowEntryTypes',
        'flowEntryReasons' => 'setFlowEntryReasons',
        'flowVersions' => 'setFlowVersions',
        'groupIds' => 'setGroupIds',
        'hasJourneyCustomerId' => 'setHasJourneyCustomerId',
        'hasJourneyActionMapId' => 'setHasJourneyActionMapId',
        'hasJourneyVisitId' => 'setHasJourneyVisitId'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'mediaTypes' => 'getMediaTypes',
        'queueIds' => 'getQueueIds',
        'skillIds' => 'getSkillIds',
        'skillGroups' => 'getSkillGroups',
        'languageIds' => 'getLanguageIds',
        'languageGroups' => 'getLanguageGroups',
        'directions' => 'getDirections',
        'originatingDirections' => 'getOriginatingDirections',
        'wrapUpCodes' => 'getWrapUpCodes',
        'dnisList' => 'getDnisList',
        'sessionDnisList' => 'getSessionDnisList',
        'filterQueuesByUserIds' => 'getFilterQueuesByUserIds',
        'filterUsersByQueueIds' => 'getFilterUsersByQueueIds',
        'userIds' => 'getUserIds',
        'addressTos' => 'getAddressTos',
        'addressFroms' => 'getAddressFroms',
        'outboundCampaignIds' => 'getOutboundCampaignIds',
        'outboundContactListIds' => 'getOutboundContactListIds',
        'contactIds' => 'getContactIds',
        'aniList' => 'getAniList',
        'durationsMilliseconds' => 'getDurationsMilliseconds',
        'evaluationScore' => 'getEvaluationScore',
        'evaluationCriticalScore' => 'getEvaluationCriticalScore',
        'evaluationFormIds' => 'getEvaluationFormIds',
        'evaluatedAgentIds' => 'getEvaluatedAgentIds',
        'evaluatorIds' => 'getEvaluatorIds',
        'transferred' => 'getTransferred',
        'abandoned' => 'getAbandoned',
        'messageTypes' => 'getMessageTypes',
        'divisionIds' => 'getDivisionIds',
        'surveyFormIds' => 'getSurveyFormIds',
        'surveyTotalScore' => 'getSurveyTotalScore',
        'surveyNpsScore' => 'getSurveyNpsScore',
        'showSecondaryStatus' => 'getShowSecondaryStatus',
        'agentDurationSortOrder' => 'getAgentDurationSortOrder',
        'waitingDurationSortOrder' => 'getWaitingDurationSortOrder',
        'interactingDurationSortOrder' => 'getInteractingDurationSortOrder',
        'agentName' => 'getAgentName',
        'skillsList' => 'getSkillsList',
        'languageList' => 'getLanguageList',
        'mos' => 'getMos',
        'surveyQuestionGroupScore' => 'getSurveyQuestionGroupScore',
        'surveyPromoterScore' => 'getSurveyPromoterScore',
        'surveyFormContextIds' => 'getSurveyFormContextIds',
        'conversationIds' => 'getConversationIds',
        'sipCallIds' => 'getSipCallIds',
        'isEnded' => 'getIsEnded',
        'isSurveyed' => 'getIsSurveyed',
        'surveyScores' => 'getSurveyScores',
        'promoterScores' => 'getPromoterScores',
        'isCampaign' => 'getIsCampaign',
        'surveyStatuses' => 'getSurveyStatuses',
        'conversationProperties' => 'getConversationProperties',
        'isBlindTransferred' => 'getIsBlindTransferred',
        'isConsulted' => 'getIsConsulted',
        'isConsultTransferred' => 'getIsConsultTransferred',
        'remoteParticipants' => 'getRemoteParticipants',
        'statusList' => 'getStatusList',
        'flowIds' => 'getFlowIds',
        'flowOutcomeIds' => 'getFlowOutcomeIds',
        'flowOutcomeValues' => 'getFlowOutcomeValues',
        'flowDestinationTypes' => 'getFlowDestinationTypes',
        'flowDisconnectReasons' => 'getFlowDisconnectReasons',
        'flowTypes' => 'getFlowTypes',
        'flowEntryTypes' => 'getFlowEntryTypes',
        'flowEntryReasons' => 'getFlowEntryReasons',
        'flowVersions' => 'getFlowVersions',
        'groupIds' => 'getGroupIds',
        'hasJourneyCustomerId' => 'getHasJourneyCustomerId',
        'hasJourneyActionMapId' => 'getHasJourneyActionMapId',
        'hasJourneyVisitId' => 'getHasJourneyVisitId'
    );

    public static function getters()
    {
        return self::$getters;
    }

    public const MEDIA_TYPES_VOICE = 'voice';
    public const MEDIA_TYPES_CHAT = 'chat';
    public const MEDIA_TYPES_EMAIL = 'email';
    public const MEDIA_TYPES_CALLBACK = 'callback';
    public const MEDIA_TYPES_COBROWSE = 'cobrowse';
    public const MEDIA_TYPES_VIDEO = 'video';
    public const MEDIA_TYPES_SCREENSHARE = 'screenshare';
    public const MEDIA_TYPES_MESSAGE = 'message';
    public const DIRECTIONS_INBOUND = 'inbound';
    public const DIRECTIONS_OUTBOUND = 'outbound';
    public const ORIGINATING_DIRECTIONS_INBOUND = 'inbound';
    public const ORIGINATING_DIRECTIONS_OUTBOUND = 'outbound';
    public const MESSAGE_TYPES_SMS = 'sms';
    public const MESSAGE_TYPES_TWITTER = 'twitter';
    public const MESSAGE_TYPES_LINE = 'line';
    public const MESSAGE_TYPES_FACEBOOK = 'facebook';
    public const MESSAGE_TYPES_WHATSAPP = 'whatsapp';
    public const AGENT_DURATION_SORT_ORDER_ASCENDING = 'ascending';
    public const AGENT_DURATION_SORT_ORDER_DESCENDING = 'descending';
    public const WAITING_DURATION_SORT_ORDER_ASCENDING = 'ascending';
    public const WAITING_DURATION_SORT_ORDER_DESCENDING = 'descending';
    public const INTERACTING_DURATION_SORT_ORDER_ASCENDING = 'ascending';
    public const INTERACTING_DURATION_SORT_ORDER_DESCENDING = 'descending';
    public const FLOW_OUTCOME_VALUES_SUCCESS = 'SUCCESS';
    public const FLOW_OUTCOME_VALUES_FAILURE = 'FAILURE';
    public const FLOW_DESTINATION_TYPES_ACD = 'ACD';
    public const FLOW_DESTINATION_TYPES_USER = 'USER';
    public const FLOW_DESTINATION_TYPES_GROUP = 'GROUP';
    public const FLOW_DESTINATION_TYPES_NUMBER = 'NUMBER';
    public const FLOW_DESTINATION_TYPES_FLOW = 'FLOW';
    public const FLOW_DESTINATION_TYPES_SECURE_FLOW = 'SECURE_FLOW';
    public const FLOW_DESTINATION_TYPES_ACD_VOICEMAIL = 'ACD_VOICEMAIL';
    public const FLOW_DESTINATION_TYPES_USER_VOICEMAIL = 'USER_VOICEMAIL';
    public const FLOW_DESTINATION_TYPES_GROUP_VOICEMAIL = 'GROUP_VOICEMAIL';
    public const FLOW_DISCONNECT_REASONS_FLOW_DISCONNECT = 'FLOW_DISCONNECT';
    public const FLOW_DISCONNECT_REASONS_FLOW_ERROR_DISCONNECT = 'FLOW_ERROR_DISCONNECT';
    public const FLOW_DISCONNECT_REASONS_DISCONNECT = 'DISCONNECT';
    public const FLOW_TYPES_INBOUNDCALL = 'inboundcall';
    public const FLOW_TYPES_INBOUNDCHAT = 'inboundchat';
    public const FLOW_TYPES_INBOUNDEMAIL = 'inboundemail';
    public const FLOW_TYPES_INBOUNDSHORTMESSAGE = 'inboundshortmessage';
    public const FLOW_TYPES_INQUEUECALL = 'inqueuecall';
    public const FLOW_TYPES_OUTBOUNDCALL = 'outboundcall';
    public const FLOW_TYPES_SECURECALL = 'securecall';
    public const FLOW_TYPES_SURVEYINVITE = 'surveyinvite';
    public const FLOW_TYPES_WORKFLOW = 'workflow';
    public const FLOW_ENTRY_TYPES_DNIS = 'dnis';
    public const FLOW_ENTRY_TYPES_DIRECT = 'direct';
    public const FLOW_ENTRY_TYPES_FLOW = 'flow';
    public const FLOW_ENTRY_TYPES_AGENT = 'agent';
    public const FLOW_ENTRY_TYPES_OUTBOUND = 'outbound';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMediaTypesAllowableValues()
    {
        return [
            self::MEDIA_TYPES_VOICE,
            self::MEDIA_TYPES_CHAT,
            self::MEDIA_TYPES_EMAIL,
            self::MEDIA_TYPES_CALLBACK,
            self::MEDIA_TYPES_COBROWSE,
            self::MEDIA_TYPES_VIDEO,
            self::MEDIA_TYPES_SCREENSHARE,
            self::MEDIA_TYPES_MESSAGE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDirectionsAllowableValues()
    {
        return [
            self::DIRECTIONS_INBOUND,
            self::DIRECTIONS_OUTBOUND,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOriginatingDirectionsAllowableValues()
    {
        return [
            self::ORIGINATING_DIRECTIONS_INBOUND,
            self::ORIGINATING_DIRECTIONS_OUTBOUND,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMessageTypesAllowableValues()
    {
        return [
            self::MESSAGE_TYPES_SMS,
            self::MESSAGE_TYPES_TWITTER,
            self::MESSAGE_TYPES_LINE,
            self::MESSAGE_TYPES_FACEBOOK,
            self::MESSAGE_TYPES_WHATSAPP,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getAgentDurationSortOrderAllowableValues()
    {
        return [
            self::AGENT_DURATION_SORT_ORDER_ASCENDING,
            self::AGENT_DURATION_SORT_ORDER_DESCENDING,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getWaitingDurationSortOrderAllowableValues()
    {
        return [
            self::WAITING_DURATION_SORT_ORDER_ASCENDING,
            self::WAITING_DURATION_SORT_ORDER_DESCENDING,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getInteractingDurationSortOrderAllowableValues()
    {
        return [
            self::INTERACTING_DURATION_SORT_ORDER_ASCENDING,
            self::INTERACTING_DURATION_SORT_ORDER_DESCENDING,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getFlowOutcomeValuesAllowableValues()
    {
        return [
            self::FLOW_OUTCOME_VALUES_SUCCESS,
            self::FLOW_OUTCOME_VALUES_FAILURE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getFlowDestinationTypesAllowableValues()
    {
        return [
            self::FLOW_DESTINATION_TYPES_ACD,
            self::FLOW_DESTINATION_TYPES_USER,
            self::FLOW_DESTINATION_TYPES_GROUP,
            self::FLOW_DESTINATION_TYPES_NUMBER,
            self::FLOW_DESTINATION_TYPES_FLOW,
            self::FLOW_DESTINATION_TYPES_SECURE_FLOW,
            self::FLOW_DESTINATION_TYPES_ACD_VOICEMAIL,
            self::FLOW_DESTINATION_TYPES_USER_VOICEMAIL,
            self::FLOW_DESTINATION_TYPES_GROUP_VOICEMAIL,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getFlowDisconnectReasonsAllowableValues()
    {
        return [
            self::FLOW_DISCONNECT_REASONS_FLOW_DISCONNECT,
            self::FLOW_DISCONNECT_REASONS_FLOW_ERROR_DISCONNECT,
            self::FLOW_DISCONNECT_REASONS_DISCONNECT,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getFlowTypesAllowableValues()
    {
        return [
            self::FLOW_TYPES_INBOUNDCALL,
            self::FLOW_TYPES_INBOUNDCHAT,
            self::FLOW_TYPES_INBOUNDEMAIL,
            self::FLOW_TYPES_INBOUNDSHORTMESSAGE,
            self::FLOW_TYPES_INQUEUECALL,
            self::FLOW_TYPES_OUTBOUNDCALL,
            self::FLOW_TYPES_SECURECALL,
            self::FLOW_TYPES_SURVEYINVITE,
            self::FLOW_TYPES_WORKFLOW,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getFlowEntryTypesAllowableValues()
    {
        return [
            self::FLOW_ENTRY_TYPES_DNIS,
            self::FLOW_ENTRY_TYPES_DIRECT,
            self::FLOW_ENTRY_TYPES_FLOW,
            self::FLOW_ENTRY_TYPES_AGENT,
            self::FLOW_ENTRY_TYPES_OUTBOUND,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['mediaTypes'] = isset($data['mediaTypes']) ? $data['mediaTypes'] : null;
        $this->container['queueIds'] = isset($data['queueIds']) ? $data['queueIds'] : null;
        $this->container['skillIds'] = isset($data['skillIds']) ? $data['skillIds'] : null;
        $this->container['skillGroups'] = isset($data['skillGroups']) ? $data['skillGroups'] : null;
        $this->container['languageIds'] = isset($data['languageIds']) ? $data['languageIds'] : null;
        $this->container['languageGroups'] = isset($data['languageGroups']) ? $data['languageGroups'] : null;
        $this->container['directions'] = isset($data['directions']) ? $data['directions'] : null;
        $this->container['originatingDirections'] = isset($data['originatingDirections']) ? $data['originatingDirections'] : null;
        $this->container['wrapUpCodes'] = isset($data['wrapUpCodes']) ? $data['wrapUpCodes'] : null;
        $this->container['dnisList'] = isset($data['dnisList']) ? $data['dnisList'] : null;
        $this->container['sessionDnisList'] = isset($data['sessionDnisList']) ? $data['sessionDnisList'] : null;
        $this->container['filterQueuesByUserIds'] = isset($data['filterQueuesByUserIds']) ? $data['filterQueuesByUserIds'] : null;
        $this->container['filterUsersByQueueIds'] = isset($data['filterUsersByQueueIds']) ? $data['filterUsersByQueueIds'] : null;
        $this->container['userIds'] = isset($data['userIds']) ? $data['userIds'] : null;
        $this->container['addressTos'] = isset($data['addressTos']) ? $data['addressTos'] : null;
        $this->container['addressFroms'] = isset($data['addressFroms']) ? $data['addressFroms'] : null;
        $this->container['outboundCampaignIds'] = isset($data['outboundCampaignIds']) ? $data['outboundCampaignIds'] : null;
        $this->container['outboundContactListIds'] = isset($data['outboundContactListIds']) ? $data['outboundContactListIds'] : null;
        $this->container['contactIds'] = isset($data['contactIds']) ? $data['contactIds'] : null;
        $this->container['aniList'] = isset($data['aniList']) ? $data['aniList'] : null;
        $this->container['durationsMilliseconds'] = isset($data['durationsMilliseconds']) ? $data['durationsMilliseconds'] : null;
        $this->container['evaluationScore'] = isset($data['evaluationScore']) ? $data['evaluationScore'] : null;
        $this->container['evaluationCriticalScore'] = isset($data['evaluationCriticalScore']) ? $data['evaluationCriticalScore'] : null;
        $this->container['evaluationFormIds'] = isset($data['evaluationFormIds']) ? $data['evaluationFormIds'] : null;
        $this->container['evaluatedAgentIds'] = isset($data['evaluatedAgentIds']) ? $data['evaluatedAgentIds'] : null;
        $this->container['evaluatorIds'] = isset($data['evaluatorIds']) ? $data['evaluatorIds'] : null;
        $this->container['transferred'] = isset($data['transferred']) ? $data['transferred'] : null;
        $this->container['abandoned'] = isset($data['abandoned']) ? $data['abandoned'] : null;
        $this->container['messageTypes'] = isset($data['messageTypes']) ? $data['messageTypes'] : null;
        $this->container['divisionIds'] = isset($data['divisionIds']) ? $data['divisionIds'] : null;
        $this->container['surveyFormIds'] = isset($data['surveyFormIds']) ? $data['surveyFormIds'] : null;
        $this->container['surveyTotalScore'] = isset($data['surveyTotalScore']) ? $data['surveyTotalScore'] : null;
        $this->container['surveyNpsScore'] = isset($data['surveyNpsScore']) ? $data['surveyNpsScore'] : null;
        $this->container['showSecondaryStatus'] = isset($data['showSecondaryStatus']) ? $data['showSecondaryStatus'] : null;
        $this->container['agentDurationSortOrder'] = isset($data['agentDurationSortOrder']) ? $data['agentDurationSortOrder'] : null;
        $this->container['waitingDurationSortOrder'] = isset($data['waitingDurationSortOrder']) ? $data['waitingDurationSortOrder'] : null;
        $this->container['interactingDurationSortOrder'] = isset($data['interactingDurationSortOrder']) ? $data['interactingDurationSortOrder'] : null;
        $this->container['agentName'] = isset($data['agentName']) ? $data['agentName'] : null;
        $this->container['skillsList'] = isset($data['skillsList']) ? $data['skillsList'] : null;
        $this->container['languageList'] = isset($data['languageList']) ? $data['languageList'] : null;
        $this->container['mos'] = isset($data['mos']) ? $data['mos'] : null;
        $this->container['surveyQuestionGroupScore'] = isset($data['surveyQuestionGroupScore']) ? $data['surveyQuestionGroupScore'] : null;
        $this->container['surveyPromoterScore'] = isset($data['surveyPromoterScore']) ? $data['surveyPromoterScore'] : null;
        $this->container['surveyFormContextIds'] = isset($data['surveyFormContextIds']) ? $data['surveyFormContextIds'] : null;
        $this->container['conversationIds'] = isset($data['conversationIds']) ? $data['conversationIds'] : null;
        $this->container['sipCallIds'] = isset($data['sipCallIds']) ? $data['sipCallIds'] : null;
        $this->container['isEnded'] = isset($data['isEnded']) ? $data['isEnded'] : null;
        $this->container['isSurveyed'] = isset($data['isSurveyed']) ? $data['isSurveyed'] : null;
        $this->container['surveyScores'] = isset($data['surveyScores']) ? $data['surveyScores'] : null;
        $this->container['promoterScores'] = isset($data['promoterScores']) ? $data['promoterScores'] : null;
        $this->container['isCampaign'] = isset($data['isCampaign']) ? $data['isCampaign'] : null;
        $this->container['surveyStatuses'] = isset($data['surveyStatuses']) ? $data['surveyStatuses'] : null;
        $this->container['conversationProperties'] = isset($data['conversationProperties']) ? $data['conversationProperties'] : null;
        $this->container['isBlindTransferred'] = isset($data['isBlindTransferred']) ? $data['isBlindTransferred'] : null;
        $this->container['isConsulted'] = isset($data['isConsulted']) ? $data['isConsulted'] : null;
        $this->container['isConsultTransferred'] = isset($data['isConsultTransferred']) ? $data['isConsultTransferred'] : null;
        $this->container['remoteParticipants'] = isset($data['remoteParticipants']) ? $data['remoteParticipants'] : null;
        $this->container['statusList'] = isset($data['statusList']) ? $data['statusList'] : null;
        $this->container['flowIds'] = isset($data['flowIds']) ? $data['flowIds'] : null;
        $this->container['flowOutcomeIds'] = isset($data['flowOutcomeIds']) ? $data['flowOutcomeIds'] : null;
        $this->container['flowOutcomeValues'] = isset($data['flowOutcomeValues']) ? $data['flowOutcomeValues'] : null;
        $this->container['flowDestinationTypes'] = isset($data['flowDestinationTypes']) ? $data['flowDestinationTypes'] : null;
        $this->container['flowDisconnectReasons'] = isset($data['flowDisconnectReasons']) ? $data['flowDisconnectReasons'] : null;
        $this->container['flowTypes'] = isset($data['flowTypes']) ? $data['flowTypes'] : null;
        $this->container['flowEntryTypes'] = isset($data['flowEntryTypes']) ? $data['flowEntryTypes'] : null;
        $this->container['flowEntryReasons'] = isset($data['flowEntryReasons']) ? $data['flowEntryReasons'] : null;
        $this->container['flowVersions'] = isset($data['flowVersions']) ? $data['flowVersions'] : null;
        $this->container['groupIds'] = isset($data['groupIds']) ? $data['groupIds'] : null;
        $this->container['hasJourneyCustomerId'] = isset($data['hasJourneyCustomerId']) ? $data['hasJourneyCustomerId'] : null;
        $this->container['hasJourneyActionMapId'] = isset($data['hasJourneyActionMapId']) ? $data['hasJourneyActionMapId'] : null;
        $this->container['hasJourneyVisitId'] = isset($data['hasJourneyVisitId']) ? $data['hasJourneyVisitId'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("ascending", "descending");
        if (!in_array($this->container['agentDurationSortOrder'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'agentDurationSortOrder', must be one of #{allowed_values}.";
        }

        $allowed_values = array("ascending", "descending");
        if (!in_array($this->container['waitingDurationSortOrder'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'waitingDurationSortOrder', must be one of #{allowed_values}.";
        }

        $allowed_values = array("ascending", "descending");
        if (!in_array($this->container['interactingDurationSortOrder'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'interactingDurationSortOrder', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("ascending", "descending");
        if (!in_array($this->container['agentDurationSortOrder'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("ascending", "descending");
        if (!in_array($this->container['waitingDurationSortOrder'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("ascending", "descending");
        if (!in_array($this->container['interactingDurationSortOrder'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets mediaTypes
     * @return string[]
     */
    public function getMediaTypes()
    {
        return $this->container['mediaTypes'];
    }

    /**
     * Sets mediaTypes
     * @param string[] $mediaTypes The media types are used to filter the view
     * @return $this
     */
    public function setMediaTypes($mediaTypes)
    {
        $allowed_values = array('voice', 'chat', 'email', 'callback', 'cobrowse', 'video', 'screenshare', 'message');
        if (!in_array($mediaTypes, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'mediaTypes', must be one of 'voice', 'chat', 'email', 'callback', 'cobrowse', 'video', 'screenshare', 'message'");
        }
        $this->container['mediaTypes'] = $mediaTypes;

        return $this;
    }

    /**
     * Gets queueIds
     * @return string[]
     */
    public function getQueueIds()
    {
        return $this->container['queueIds'];
    }

    /**
     * Sets queueIds
     * @param string[] $queueIds The queue ids are used to filter the view
     * @return $this
     */
    public function setQueueIds($queueIds)
    {
        $this->container['queueIds'] = $queueIds;

        return $this;
    }

    /**
     * Gets skillIds
     * @return string[]
     */
    public function getSkillIds()
    {
        return $this->container['skillIds'];
    }

    /**
     * Sets skillIds
     * @param string[] $skillIds The skill ids are used to filter the view
     * @return $this
     */
    public function setSkillIds($skillIds)
    {
        $this->container['skillIds'] = $skillIds;

        return $this;
    }

    /**
     * Gets skillGroups
     * @return string[]
     */
    public function getSkillGroups()
    {
        return $this->container['skillGroups'];
    }

    /**
     * Sets skillGroups
     * @param string[] $skillGroups The skill groups used to filter the view
     * @return $this
     */
    public function setSkillGroups($skillGroups)
    {
        $this->container['skillGroups'] = $skillGroups;

        return $this;
    }

    /**
     * Gets languageIds
     * @return string[]
     */
    public function getLanguageIds()
    {
        return $this->container['languageIds'];
    }

    /**
     * Sets languageIds
     * @param string[] $languageIds The language ids are used to filter the view
     * @return $this
     */
    public function setLanguageIds($languageIds)
    {
        $this->container['languageIds'] = $languageIds;

        return $this;
    }

    /**
     * Gets languageGroups
     * @return string[]
     */
    public function getLanguageGroups()
    {
        return $this->container['languageGroups'];
    }

    /**
     * Sets languageGroups
     * @param string[] $languageGroups The language groups used to filter the view
     * @return $this
     */
    public function setLanguageGroups($languageGroups)
    {
        $this->container['languageGroups'] = $languageGroups;

        return $this;
    }

    /**
     * Gets directions
     * @return string[]
     */
    public function getDirections()
    {
        return $this->container['directions'];
    }

    /**
     * Sets directions
     * @param string[] $directions The directions are used to filter the view
     * @return $this
     */
    public function setDirections($directions)
    {
        $allowed_values = array('inbound', 'outbound');
        if (!in_array($directions, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'directions', must be one of 'inbound', 'outbound'");
        }
        $this->container['directions'] = $directions;

        return $this;
    }

    /**
     * Gets originatingDirections
     * @return string[]
     */
    public function getOriginatingDirections()
    {
        return $this->container['originatingDirections'];
    }

    /**
     * Sets originatingDirections
     * @param string[] $originatingDirections The list of orginating directions used to filter the view
     * @return $this
     */
    public function setOriginatingDirections($originatingDirections)
    {
        $allowed_values = array('inbound', 'outbound');
        if (!in_array($originatingDirections, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'originatingDirections', must be one of 'inbound', 'outbound'");
        }
        $this->container['originatingDirections'] = $originatingDirections;

        return $this;
    }

    /**
     * Gets wrapUpCodes
     * @return string[]
     */
    public function getWrapUpCodes()
    {
        return $this->container['wrapUpCodes'];
    }

    /**
     * Sets wrapUpCodes
     * @param string[] $wrapUpCodes The wrap up codes are used to filter the view
     * @return $this
     */
    public function setWrapUpCodes($wrapUpCodes)
    {
        $this->container['wrapUpCodes'] = $wrapUpCodes;

        return $this;
    }

    /**
     * Gets dnisList
     * @return string[]
     */
    public function getDnisList()
    {
        return $this->container['dnisList'];
    }

    /**
     * Sets dnisList
     * @param string[] $dnisList The dnis list is used to filter the view
     * @return $this
     */
    public function setDnisList($dnisList)
    {
        $this->container['dnisList'] = $dnisList;

        return $this;
    }

    /**
     * Gets sessionDnisList
     * @return string[]
     */
    public function getSessionDnisList()
    {
        return $this->container['sessionDnisList'];
    }

    /**
     * Sets sessionDnisList
     * @param string[] $sessionDnisList The list of session dnis used to filter the view
     * @return $this
     */
    public function setSessionDnisList($sessionDnisList)
    {
        $this->container['sessionDnisList'] = $sessionDnisList;

        return $this;
    }

    /**
     * Gets filterQueuesByUserIds
     * @return string[]
     */
    public function getFilterQueuesByUserIds()
    {
        return $this->container['filterQueuesByUserIds'];
    }

    /**
     * Sets filterQueuesByUserIds
     * @param string[] $filterQueuesByUserIds The user ids are used to fetch associated queues for the view
     * @return $this
     */
    public function setFilterQueuesByUserIds($filterQueuesByUserIds)
    {
        $this->container['filterQueuesByUserIds'] = $filterQueuesByUserIds;

        return $this;
    }

    /**
     * Gets filterUsersByQueueIds
     * @return string[]
     */
    public function getFilterUsersByQueueIds()
    {
        return $this->container['filterUsersByQueueIds'];
    }

    /**
     * Sets filterUsersByQueueIds
     * @param string[] $filterUsersByQueueIds The queue ids are used to fetch associated users for the view
     * @return $this
     */
    public function setFilterUsersByQueueIds($filterUsersByQueueIds)
    {
        $this->container['filterUsersByQueueIds'] = $filterUsersByQueueIds;

        return $this;
    }

    /**
     * Gets userIds
     * @return string[]
     */
    public function getUserIds()
    {
        return $this->container['userIds'];
    }

    /**
     * Sets userIds
     * @param string[] $userIds The user ids are used to filter the view
     * @return $this
     */
    public function setUserIds($userIds)
    {
        $this->container['userIds'] = $userIds;

        return $this;
    }

    /**
     * Gets addressTos
     * @return string[]
     */
    public function getAddressTos()
    {
        return $this->container['addressTos'];
    }

    /**
     * Sets addressTos
     * @param string[] $addressTos The address To values are used to filter the view
     * @return $this
     */
    public function setAddressTos($addressTos)
    {
        $this->container['addressTos'] = $addressTos;

        return $this;
    }

    /**
     * Gets addressFroms
     * @return string[]
     */
    public function getAddressFroms()
    {
        return $this->container['addressFroms'];
    }

    /**
     * Sets addressFroms
     * @param string[] $addressFroms The address from values are used to filter the view
     * @return $this
     */
    public function setAddressFroms($addressFroms)
    {
        $this->container['addressFroms'] = $addressFroms;

        return $this;
    }

    /**
     * Gets outboundCampaignIds
     * @return string[]
     */
    public function getOutboundCampaignIds()
    {
        return $this->container['outboundCampaignIds'];
    }

    /**
     * Sets outboundCampaignIds
     * @param string[] $outboundCampaignIds The outbound campaign ids are used to filter the view
     * @return $this
     */
    public function setOutboundCampaignIds($outboundCampaignIds)
    {
        $this->container['outboundCampaignIds'] = $outboundCampaignIds;

        return $this;
    }

    /**
     * Gets outboundContactListIds
     * @return string[]
     */
    public function getOutboundContactListIds()
    {
        return $this->container['outboundContactListIds'];
    }

    /**
     * Sets outboundContactListIds
     * @param string[] $outboundContactListIds The outbound contact list ids are used to filter the view
     * @return $this
     */
    public function setOutboundContactListIds($outboundContactListIds)
    {
        $this->container['outboundContactListIds'] = $outboundContactListIds;

        return $this;
    }

    /**
     * Gets contactIds
     * @return string[]
     */
    public function getContactIds()
    {
        return $this->container['contactIds'];
    }

    /**
     * Sets contactIds
     * @param string[] $contactIds The contact ids are used to filter the view
     * @return $this
     */
    public function setContactIds($contactIds)
    {
        $this->container['contactIds'] = $contactIds;

        return $this;
    }

    /**
     * Gets aniList
     * @return string[]
     */
    public function getAniList()
    {
        return $this->container['aniList'];
    }

    /**
     * Sets aniList
     * @param string[] $aniList The ani list ids are used to filter the view
     * @return $this
     */
    public function setAniList($aniList)
    {
        $this->container['aniList'] = $aniList;

        return $this;
    }

    /**
     * Gets durationsMilliseconds
     * @return \PureCloudSDK\NumericRange[]
     */
    public function getDurationsMilliseconds()
    {
        return $this->container['durationsMilliseconds'];
    }

    /**
     * Sets durationsMilliseconds
     * @param \PureCloudSDK\NumericRange[] $durationsMilliseconds The durations in milliseconds used to filter the view
     * @return $this
     */
    public function setDurationsMilliseconds($durationsMilliseconds)
    {
        $this->container['durationsMilliseconds'] = $durationsMilliseconds;

        return $this;
    }

    /**
     * Gets evaluationScore
     * @return \PureCloudSDK\NumericRange
     */
    public function getEvaluationScore()
    {
        return $this->container['evaluationScore'];
    }

    /**
     * Sets evaluationScore
     * @param \PureCloudSDK\NumericRange $evaluationScore The evaluationScore is used to filter the view
     * @return $this
     */
    public function setEvaluationScore($evaluationScore)
    {
        $this->container['evaluationScore'] = $evaluationScore;

        return $this;
    }

    /**
     * Gets evaluationCriticalScore
     * @return \PureCloudSDK\NumericRange
     */
    public function getEvaluationCriticalScore()
    {
        return $this->container['evaluationCriticalScore'];
    }

    /**
     * Sets evaluationCriticalScore
     * @param \PureCloudSDK\NumericRange $evaluationCriticalScore The evaluationCriticalScore is used to filter the view
     * @return $this
     */
    public function setEvaluationCriticalScore($evaluationCriticalScore)
    {
        $this->container['evaluationCriticalScore'] = $evaluationCriticalScore;

        return $this;
    }

    /**
     * Gets evaluationFormIds
     * @return string[]
     */
    public function getEvaluationFormIds()
    {
        return $this->container['evaluationFormIds'];
    }

    /**
     * Sets evaluationFormIds
     * @param string[] $evaluationFormIds The evaluation form ids are used to filter the view
     * @return $this
     */
    public function setEvaluationFormIds($evaluationFormIds)
    {
        $this->container['evaluationFormIds'] = $evaluationFormIds;

        return $this;
    }

    /**
     * Gets evaluatedAgentIds
     * @return string[]
     */
    public function getEvaluatedAgentIds()
    {
        return $this->container['evaluatedAgentIds'];
    }

    /**
     * Sets evaluatedAgentIds
     * @param string[] $evaluatedAgentIds The evaluated agent ids are used to filter the view
     * @return $this
     */
    public function setEvaluatedAgentIds($evaluatedAgentIds)
    {
        $this->container['evaluatedAgentIds'] = $evaluatedAgentIds;

        return $this;
    }

    /**
     * Gets evaluatorIds
     * @return string[]
     */
    public function getEvaluatorIds()
    {
        return $this->container['evaluatorIds'];
    }

    /**
     * Sets evaluatorIds
     * @param string[] $evaluatorIds The evaluator ids are used to filter the view
     * @return $this
     */
    public function setEvaluatorIds($evaluatorIds)
    {
        $this->container['evaluatorIds'] = $evaluatorIds;

        return $this;
    }

    /**
     * Gets transferred
     * @return bool
     */
    public function getTransferred()
    {
        return $this->container['transferred'];
    }

    /**
     * Sets transferred
     * @param bool $transferred Indicates filtering for transfers
     * @return $this
     */
    public function setTransferred($transferred)
    {
        $this->container['transferred'] = $transferred;

        return $this;
    }

    /**
     * Gets abandoned
     * @return bool
     */
    public function getAbandoned()
    {
        return $this->container['abandoned'];
    }

    /**
     * Sets abandoned
     * @param bool $abandoned Indicates filtering for abandons
     * @return $this
     */
    public function setAbandoned($abandoned)
    {
        $this->container['abandoned'] = $abandoned;

        return $this;
    }

    /**
     * Gets messageTypes
     * @return string[]
     */
    public function getMessageTypes()
    {
        return $this->container['messageTypes'];
    }

    /**
     * Sets messageTypes
     * @param string[] $messageTypes The message media types used to filter the view
     * @return $this
     */
    public function setMessageTypes($messageTypes)
    {
        $allowed_values = array('sms', 'twitter', 'line', 'facebook', 'whatsapp');
        if (!in_array($messageTypes, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'messageTypes', must be one of 'sms', 'twitter', 'line', 'facebook', 'whatsapp'");
        }
        $this->container['messageTypes'] = $messageTypes;

        return $this;
    }

    /**
     * Gets divisionIds
     * @return string[]
     */
    public function getDivisionIds()
    {
        return $this->container['divisionIds'];
    }

    /**
     * Sets divisionIds
     * @param string[] $divisionIds The divison Ids used to filter the view
     * @return $this
     */
    public function setDivisionIds($divisionIds)
    {
        $this->container['divisionIds'] = $divisionIds;

        return $this;
    }

    /**
     * Gets surveyFormIds
     * @return string[]
     */
    public function getSurveyFormIds()
    {
        return $this->container['surveyFormIds'];
    }

    /**
     * Sets surveyFormIds
     * @param string[] $surveyFormIds The survey form ids used to filter the view
     * @return $this
     */
    public function setSurveyFormIds($surveyFormIds)
    {
        $this->container['surveyFormIds'] = $surveyFormIds;

        return $this;
    }

    /**
     * Gets surveyTotalScore
     * @return \PureCloudSDK\NumericRange
     */
    public function getSurveyTotalScore()
    {
        return $this->container['surveyTotalScore'];
    }

    /**
     * Sets surveyTotalScore
     * @param \PureCloudSDK\NumericRange $surveyTotalScore The survey total score used to filter the view
     * @return $this
     */
    public function setSurveyTotalScore($surveyTotalScore)
    {
        $this->container['surveyTotalScore'] = $surveyTotalScore;

        return $this;
    }

    /**
     * Gets surveyNpsScore
     * @return \PureCloudSDK\NumericRange
     */
    public function getSurveyNpsScore()
    {
        return $this->container['surveyNpsScore'];
    }

    /**
     * Sets surveyNpsScore
     * @param \PureCloudSDK\NumericRange $surveyNpsScore The survey NPS score used to filter the view
     * @return $this
     */
    public function setSurveyNpsScore($surveyNpsScore)
    {
        $this->container['surveyNpsScore'] = $surveyNpsScore;

        return $this;
    }

    /**
     * Gets showSecondaryStatus
     * @return bool
     */
    public function getShowSecondaryStatus()
    {
        return $this->container['showSecondaryStatus'];
    }

    /**
     * Sets showSecondaryStatus
     * @param bool $showSecondaryStatus Indicates if the Secondary Status should be shown
     * @return $this
     */
    public function setShowSecondaryStatus($showSecondaryStatus)
    {
        $this->container['showSecondaryStatus'] = $showSecondaryStatus;

        return $this;
    }

    /**
     * Gets agentDurationSortOrder
     * @return string
     */
    public function getAgentDurationSortOrder()
    {
        return $this->container['agentDurationSortOrder'];
    }

    /**
     * Sets agentDurationSortOrder
     * @param string $agentDurationSortOrder Provides the agent duration sort order
     * @return $this
     */
    public function setAgentDurationSortOrder($agentDurationSortOrder)
    {
        $allowed_values = array('ascending', 'descending');
        if (!in_array($agentDurationSortOrder, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'agentDurationSortOrder', must be one of 'ascending', 'descending'");
        }
        $this->container['agentDurationSortOrder'] = $agentDurationSortOrder;

        return $this;
    }

    /**
     * Gets waitingDurationSortOrder
     * @return string
     */
    public function getWaitingDurationSortOrder()
    {
        return $this->container['waitingDurationSortOrder'];
    }

    /**
     * Sets waitingDurationSortOrder
     * @param string $waitingDurationSortOrder Provides the waiting duration sort order
     * @return $this
     */
    public function setWaitingDurationSortOrder($waitingDurationSortOrder)
    {
        $allowed_values = array('ascending', 'descending');
        if (!in_array($waitingDurationSortOrder, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'waitingDurationSortOrder', must be one of 'ascending', 'descending'");
        }
        $this->container['waitingDurationSortOrder'] = $waitingDurationSortOrder;

        return $this;
    }

    /**
     * Gets interactingDurationSortOrder
     * @return string
     */
    public function getInteractingDurationSortOrder()
    {
        return $this->container['interactingDurationSortOrder'];
    }

    /**
     * Sets interactingDurationSortOrder
     * @param string $interactingDurationSortOrder Provides the interacting duration sort order
     * @return $this
     */
    public function setInteractingDurationSortOrder($interactingDurationSortOrder)
    {
        $allowed_values = array('ascending', 'descending');
        if (!in_array($interactingDurationSortOrder, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'interactingDurationSortOrder', must be one of 'ascending', 'descending'");
        }
        $this->container['interactingDurationSortOrder'] = $interactingDurationSortOrder;

        return $this;
    }

    /**
     * Gets agentName
     * @return string
     */
    public function getAgentName()
    {
        return $this->container['agentName'];
    }

    /**
     * Sets agentName
     * @param string $agentName Displays the Agent name as provided by the user
     * @return $this
     */
    public function setAgentName($agentName)
    {
        $this->container['agentName'] = $agentName;

        return $this;
    }

    /**
     * Gets skillsList
     * @return string[]
     */
    public function getSkillsList()
    {
        return $this->container['skillsList'];
    }

    /**
     * Sets skillsList
     * @param string[] $skillsList The list of skill strings as free form text
     * @return $this
     */
    public function setSkillsList($skillsList)
    {
        $this->container['skillsList'] = $skillsList;

        return $this;
    }

    /**
     * Gets languageList
     * @return string[]
     */
    public function getLanguageList()
    {
        return $this->container['languageList'];
    }

    /**
     * Sets languageList
     * @param string[] $languageList The list of language strings as free form text
     * @return $this
     */
    public function setLanguageList($languageList)
    {
        $this->container['languageList'] = $languageList;

        return $this;
    }

    /**
     * Gets mos
     * @return \PureCloudSDK\NumericRange
     */
    public function getMos()
    {
        return $this->container['mos'];
    }

    /**
     * Sets mos
     * @param \PureCloudSDK\NumericRange $mos The desired range for mos values
     * @return $this
     */
    public function setMos($mos)
    {
        $this->container['mos'] = $mos;

        return $this;
    }

    /**
     * Gets surveyQuestionGroupScore
     * @return \PureCloudSDK\NumericRange
     */
    public function getSurveyQuestionGroupScore()
    {
        return $this->container['surveyQuestionGroupScore'];
    }

    /**
     * Sets surveyQuestionGroupScore
     * @param \PureCloudSDK\NumericRange $surveyQuestionGroupScore The survey question group score used to filter the view
     * @return $this
     */
    public function setSurveyQuestionGroupScore($surveyQuestionGroupScore)
    {
        $this->container['surveyQuestionGroupScore'] = $surveyQuestionGroupScore;

        return $this;
    }

    /**
     * Gets surveyPromoterScore
     * @return \PureCloudSDK\NumericRange
     */
    public function getSurveyPromoterScore()
    {
        return $this->container['surveyPromoterScore'];
    }

    /**
     * Sets surveyPromoterScore
     * @param \PureCloudSDK\NumericRange $surveyPromoterScore The survey promoter score used to filter the view
     * @return $this
     */
    public function setSurveyPromoterScore($surveyPromoterScore)
    {
        $this->container['surveyPromoterScore'] = $surveyPromoterScore;

        return $this;
    }

    /**
     * Gets surveyFormContextIds
     * @return string[]
     */
    public function getSurveyFormContextIds()
    {
        return $this->container['surveyFormContextIds'];
    }

    /**
     * Sets surveyFormContextIds
     * @param string[] $surveyFormContextIds The list of survey form context ids used to filter the view
     * @return $this
     */
    public function setSurveyFormContextIds($surveyFormContextIds)
    {
        $this->container['surveyFormContextIds'] = $surveyFormContextIds;

        return $this;
    }

    /**
     * Gets conversationIds
     * @return string[]
     */
    public function getConversationIds()
    {
        return $this->container['conversationIds'];
    }

    /**
     * Sets conversationIds
     * @param string[] $conversationIds The list of conversation ids used to filter the view
     * @return $this
     */
    public function setConversationIds($conversationIds)
    {
        $this->container['conversationIds'] = $conversationIds;

        return $this;
    }

    /**
     * Gets sipCallIds
     * @return string[]
     */
    public function getSipCallIds()
    {
        return $this->container['sipCallIds'];
    }

    /**
     * Sets sipCallIds
     * @param string[] $sipCallIds The list of SIP call ids used to filter the view
     * @return $this
     */
    public function setSipCallIds($sipCallIds)
    {
        $this->container['sipCallIds'] = $sipCallIds;

        return $this;
    }

    /**
     * Gets isEnded
     * @return bool
     */
    public function getIsEnded()
    {
        return $this->container['isEnded'];
    }

    /**
     * Sets isEnded
     * @param bool $isEnded Indicates filtering for ended
     * @return $this
     */
    public function setIsEnded($isEnded)
    {
        $this->container['isEnded'] = $isEnded;

        return $this;
    }

    /**
     * Gets isSurveyed
     * @return bool
     */
    public function getIsSurveyed()
    {
        return $this->container['isSurveyed'];
    }

    /**
     * Sets isSurveyed
     * @param bool $isSurveyed Indicates filtering for survey
     * @return $this
     */
    public function setIsSurveyed($isSurveyed)
    {
        $this->container['isSurveyed'] = $isSurveyed;

        return $this;
    }

    /**
     * Gets surveyScores
     * @return \PureCloudSDK\NumericRange[]
     */
    public function getSurveyScores()
    {
        return $this->container['surveyScores'];
    }

    /**
     * Sets surveyScores
     * @param \PureCloudSDK\NumericRange[] $surveyScores The list of survey score ranges used to filter the view
     * @return $this
     */
    public function setSurveyScores($surveyScores)
    {
        $this->container['surveyScores'] = $surveyScores;

        return $this;
    }

    /**
     * Gets promoterScores
     * @return \PureCloudSDK\NumericRange[]
     */
    public function getPromoterScores()
    {
        return $this->container['promoterScores'];
    }

    /**
     * Sets promoterScores
     * @param \PureCloudSDK\NumericRange[] $promoterScores The list of promoter score ranges used to filter the view
     * @return $this
     */
    public function setPromoterScores($promoterScores)
    {
        $this->container['promoterScores'] = $promoterScores;

        return $this;
    }

    /**
     * Gets isCampaign
     * @return bool
     */
    public function getIsCampaign()
    {
        return $this->container['isCampaign'];
    }

    /**
     * Sets isCampaign
     * @param bool $isCampaign Indicates filtering for campaign
     * @return $this
     */
    public function setIsCampaign($isCampaign)
    {
        $this->container['isCampaign'] = $isCampaign;

        return $this;
    }

    /**
     * Gets surveyStatuses
     * @return string[]
     */
    public function getSurveyStatuses()
    {
        return $this->container['surveyStatuses'];
    }

    /**
     * Sets surveyStatuses
     * @param string[] $surveyStatuses The list of survey statuses used to filter the view
     * @return $this
     */
    public function setSurveyStatuses($surveyStatuses)
    {
        $this->container['surveyStatuses'] = $surveyStatuses;

        return $this;
    }

    /**
     * Gets conversationProperties
     * @return \PureCloudSDK\ConversationProperties
     */
    public function getConversationProperties()
    {
        return $this->container['conversationProperties'];
    }

    /**
     * Sets conversationProperties
     * @param \PureCloudSDK\ConversationProperties $conversationProperties A grouping of conversation level filters
     * @return $this
     */
    public function setConversationProperties($conversationProperties)
    {
        $this->container['conversationProperties'] = $conversationProperties;

        return $this;
    }

    /**
     * Gets isBlindTransferred
     * @return bool
     */
    public function getIsBlindTransferred()
    {
        return $this->container['isBlindTransferred'];
    }

    /**
     * Sets isBlindTransferred
     * @param bool $isBlindTransferred Indicates filtering for blind transferred
     * @return $this
     */
    public function setIsBlindTransferred($isBlindTransferred)
    {
        $this->container['isBlindTransferred'] = $isBlindTransferred;

        return $this;
    }

    /**
     * Gets isConsulted
     * @return bool
     */
    public function getIsConsulted()
    {
        return $this->container['isConsulted'];
    }

    /**
     * Sets isConsulted
     * @param bool $isConsulted Indicates filtering for consulted
     * @return $this
     */
    public function setIsConsulted($isConsulted)
    {
        $this->container['isConsulted'] = $isConsulted;

        return $this;
    }

    /**
     * Gets isConsultTransferred
     * @return bool
     */
    public function getIsConsultTransferred()
    {
        return $this->container['isConsultTransferred'];
    }

    /**
     * Sets isConsultTransferred
     * @param bool $isConsultTransferred Indicates filtering for consult transferred
     * @return $this
     */
    public function setIsConsultTransferred($isConsultTransferred)
    {
        $this->container['isConsultTransferred'] = $isConsultTransferred;

        return $this;
    }

    /**
     * Gets remoteParticipants
     * @return string[]
     */
    public function getRemoteParticipants()
    {
        return $this->container['remoteParticipants'];
    }

    /**
     * Sets remoteParticipants
     * @param string[] $remoteParticipants The list of remote participants used to filter the view
     * @return $this
     */
    public function setRemoteParticipants($remoteParticipants)
    {
        $this->container['remoteParticipants'] = $remoteParticipants;

        return $this;
    }

    /**
     * Gets statusList
     * @return string[]
     */
    public function getStatusList()
    {
        return $this->container['statusList'];
    }

    /**
     * Sets statusList
     * @param string[] $statusList A list of status for the configuration view
     * @return $this
     */
    public function setStatusList($statusList)
    {
        $this->container['statusList'] = $statusList;

        return $this;
    }

    /**
     * Gets flowIds
     * @return string[]
     */
    public function getFlowIds()
    {
        return $this->container['flowIds'];
    }

    /**
     * Sets flowIds
     * @param string[] $flowIds The list of flow Ids
     * @return $this
     */
    public function setFlowIds($flowIds)
    {
        $this->container['flowIds'] = $flowIds;

        return $this;
    }

    /**
     * Gets flowOutcomeIds
     * @return string[]
     */
    public function getFlowOutcomeIds()
    {
        return $this->container['flowOutcomeIds'];
    }

    /**
     * Sets flowOutcomeIds
     * @param string[] $flowOutcomeIds A list of outcome ids of the flow
     * @return $this
     */
    public function setFlowOutcomeIds($flowOutcomeIds)
    {
        $this->container['flowOutcomeIds'] = $flowOutcomeIds;

        return $this;
    }

    /**
     * Gets flowOutcomeValues
     * @return string[]
     */
    public function getFlowOutcomeValues()
    {
        return $this->container['flowOutcomeValues'];
    }

    /**
     * Sets flowOutcomeValues
     * @param string[] $flowOutcomeValues A list of outcome values of the flow
     * @return $this
     */
    public function setFlowOutcomeValues($flowOutcomeValues)
    {
        $allowed_values = array('SUCCESS', 'FAILURE');
        if (!in_array($flowOutcomeValues, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'flowOutcomeValues', must be one of 'SUCCESS', 'FAILURE'");
        }
        $this->container['flowOutcomeValues'] = $flowOutcomeValues;

        return $this;
    }

    /**
     * Gets flowDestinationTypes
     * @return string[]
     */
    public function getFlowDestinationTypes()
    {
        return $this->container['flowDestinationTypes'];
    }

    /**
     * Sets flowDestinationTypes
     * @param string[] $flowDestinationTypes The list of destination types of the flow
     * @return $this
     */
    public function setFlowDestinationTypes($flowDestinationTypes)
    {
        $allowed_values = array('ACD', 'USER', 'GROUP', 'NUMBER', 'FLOW', 'SECURE_FLOW', 'ACD_VOICEMAIL', 'USER_VOICEMAIL', 'GROUP_VOICEMAIL');
        if (!in_array($flowDestinationTypes, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'flowDestinationTypes', must be one of 'ACD', 'USER', 'GROUP', 'NUMBER', 'FLOW', 'SECURE_FLOW', 'ACD_VOICEMAIL', 'USER_VOICEMAIL', 'GROUP_VOICEMAIL'");
        }
        $this->container['flowDestinationTypes'] = $flowDestinationTypes;

        return $this;
    }

    /**
     * Gets flowDisconnectReasons
     * @return string[]
     */
    public function getFlowDisconnectReasons()
    {
        return $this->container['flowDisconnectReasons'];
    }

    /**
     * Sets flowDisconnectReasons
     * @param string[] $flowDisconnectReasons The list of reasons for the flow to disconnect
     * @return $this
     */
    public function setFlowDisconnectReasons($flowDisconnectReasons)
    {
        $allowed_values = array('FLOW_DISCONNECT', 'FLOW_ERROR_DISCONNECT', 'DISCONNECT');
        if (!in_array($flowDisconnectReasons, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'flowDisconnectReasons', must be one of 'FLOW_DISCONNECT', 'FLOW_ERROR_DISCONNECT', 'DISCONNECT'");
        }
        $this->container['flowDisconnectReasons'] = $flowDisconnectReasons;

        return $this;
    }

    /**
     * Gets flowTypes
     * @return string[]
     */
    public function getFlowTypes()
    {
        return $this->container['flowTypes'];
    }

    /**
     * Sets flowTypes
     * @param string[] $flowTypes A list of types of the flow
     * @return $this
     */
    public function setFlowTypes($flowTypes)
    {
        $allowed_values = array('inboundcall', 'inboundchat', 'inboundemail', 'inboundshortmessage', 'inqueuecall', 'outboundcall', 'securecall', 'surveyinvite', 'workflow');
        if (!in_array($flowTypes, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'flowTypes', must be one of 'inboundcall', 'inboundchat', 'inboundemail', 'inboundshortmessage', 'inqueuecall', 'outboundcall', 'securecall', 'surveyinvite', 'workflow'");
        }
        $this->container['flowTypes'] = $flowTypes;

        return $this;
    }

    /**
     * Gets flowEntryTypes
     * @return string[]
     */
    public function getFlowEntryTypes()
    {
        return $this->container['flowEntryTypes'];
    }

    /**
     * Sets flowEntryTypes
     * @param string[] $flowEntryTypes A list of types of the flow entry
     * @return $this
     */
    public function setFlowEntryTypes($flowEntryTypes)
    {
        $allowed_values = array('dnis', 'direct', 'flow', 'agent', 'outbound');
        if (!in_array($flowEntryTypes, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'flowEntryTypes', must be one of 'dnis', 'direct', 'flow', 'agent', 'outbound'");
        }
        $this->container['flowEntryTypes'] = $flowEntryTypes;

        return $this;
    }

    /**
     * Gets flowEntryReasons
     * @return string[]
     */
    public function getFlowEntryReasons()
    {
        return $this->container['flowEntryReasons'];
    }

    /**
     * Sets flowEntryReasons
     * @param string[] $flowEntryReasons A list of reasons of flow entry
     * @return $this
     */
    public function setFlowEntryReasons($flowEntryReasons)
    {
        $this->container['flowEntryReasons'] = $flowEntryReasons;

        return $this;
    }

    /**
     * Gets flowVersions
     * @return string[]
     */
    public function getFlowVersions()
    {
        return $this->container['flowVersions'];
    }

    /**
     * Sets flowVersions
     * @param string[] $flowVersions A list of versions of a flow
     * @return $this
     */
    public function setFlowVersions($flowVersions)
    {
        $this->container['flowVersions'] = $flowVersions;

        return $this;
    }

    /**
     * Gets groupIds
     * @return string[]
     */
    public function getGroupIds()
    {
        return $this->container['groupIds'];
    }

    /**
     * Sets groupIds
     * @param string[] $groupIds A list of directory group ids
     * @return $this
     */
    public function setGroupIds($groupIds)
    {
        $this->container['groupIds'] = $groupIds;

        return $this;
    }

    /**
     * Gets hasJourneyCustomerId
     * @return bool
     */
    public function getHasJourneyCustomerId()
    {
        return $this->container['hasJourneyCustomerId'];
    }

    /**
     * Sets hasJourneyCustomerId
     * @param bool $hasJourneyCustomerId Indicates filtering for journey customer id
     * @return $this
     */
    public function setHasJourneyCustomerId($hasJourneyCustomerId)
    {
        $this->container['hasJourneyCustomerId'] = $hasJourneyCustomerId;

        return $this;
    }

    /**
     * Gets hasJourneyActionMapId
     * @return bool
     */
    public function getHasJourneyActionMapId()
    {
        return $this->container['hasJourneyActionMapId'];
    }

    /**
     * Sets hasJourneyActionMapId
     * @param bool $hasJourneyActionMapId Indicates filtering for Journey action map id
     * @return $this
     */
    public function setHasJourneyActionMapId($hasJourneyActionMapId)
    {
        $this->container['hasJourneyActionMapId'] = $hasJourneyActionMapId;

        return $this;
    }

    /**
     * Gets hasJourneyVisitId
     * @return bool
     */
    public function getHasJourneyVisitId()
    {
        return $this->container['hasJourneyVisitId'];
    }

    /**
     * Sets hasJourneyVisitId
     * @param bool $hasJourneyVisitId Indicates filtering for Journey visit id
     * @return $this
     */
    public function setHasJourneyVisitId($hasJourneyVisitId)
    {
        $this->container['hasJourneyVisitId'] = $hasJourneyVisitId;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


