<?php
/**
 * AdherenceSettings
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * AdherenceSettings Class Doc Comment
 *
 * @category    Class */
 // @description Schedule Adherence Configuration
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AdherenceSettings implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AdherenceSettings';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'severeAlertThresholdMinutes' => 'int',
        'adherenceTargetPercent' => 'int',
        'adherenceExceptionThresholdSeconds' => 'int',
        'nonOnQueueActivitiesEquivalent' => 'bool',
        'trackOnQueueActivity' => 'bool',
        'ignoredActivityCategories' => '\PureCloudSDK\IgnoredActivityCategories'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'severeAlertThresholdMinutes' => 'severeAlertThresholdMinutes',
        'adherenceTargetPercent' => 'adherenceTargetPercent',
        'adherenceExceptionThresholdSeconds' => 'adherenceExceptionThresholdSeconds',
        'nonOnQueueActivitiesEquivalent' => 'nonOnQueueActivitiesEquivalent',
        'trackOnQueueActivity' => 'trackOnQueueActivity',
        'ignoredActivityCategories' => 'ignoredActivityCategories'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'severeAlertThresholdMinutes' => 'setSevereAlertThresholdMinutes',
        'adherenceTargetPercent' => 'setAdherenceTargetPercent',
        'adherenceExceptionThresholdSeconds' => 'setAdherenceExceptionThresholdSeconds',
        'nonOnQueueActivitiesEquivalent' => 'setNonOnQueueActivitiesEquivalent',
        'trackOnQueueActivity' => 'setTrackOnQueueActivity',
        'ignoredActivityCategories' => 'setIgnoredActivityCategories'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'severeAlertThresholdMinutes' => 'getSevereAlertThresholdMinutes',
        'adherenceTargetPercent' => 'getAdherenceTargetPercent',
        'adherenceExceptionThresholdSeconds' => 'getAdherenceExceptionThresholdSeconds',
        'nonOnQueueActivitiesEquivalent' => 'getNonOnQueueActivitiesEquivalent',
        'trackOnQueueActivity' => 'getTrackOnQueueActivity',
        'ignoredActivityCategories' => 'getIgnoredActivityCategories'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['severeAlertThresholdMinutes'] = isset($data['severeAlertThresholdMinutes']) ? $data['severeAlertThresholdMinutes'] : null;
        $this->container['adherenceTargetPercent'] = isset($data['adherenceTargetPercent']) ? $data['adherenceTargetPercent'] : null;
        $this->container['adherenceExceptionThresholdSeconds'] = isset($data['adherenceExceptionThresholdSeconds']) ? $data['adherenceExceptionThresholdSeconds'] : null;
        $this->container['nonOnQueueActivitiesEquivalent'] = isset($data['nonOnQueueActivitiesEquivalent']) ? $data['nonOnQueueActivitiesEquivalent'] : null;
        $this->container['trackOnQueueActivity'] = isset($data['trackOnQueueActivity']) ? $data['trackOnQueueActivity'] : null;
        $this->container['ignoredActivityCategories'] = isset($data['ignoredActivityCategories']) ? $data['ignoredActivityCategories'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets severeAlertThresholdMinutes
     * @return int
     */
    public function getSevereAlertThresholdMinutes()
    {
        return $this->container['severeAlertThresholdMinutes'];
    }

    /**
     * Sets severeAlertThresholdMinutes
     * @param int $severeAlertThresholdMinutes The threshold in minutes where an alert will be triggered when an agent is considered severely out of adherence
     * @return $this
     */
    public function setSevereAlertThresholdMinutes($severeAlertThresholdMinutes)
    {
        $this->container['severeAlertThresholdMinutes'] = $severeAlertThresholdMinutes;

        return $this;
    }

    /**
     * Gets adherenceTargetPercent
     * @return int
     */
    public function getAdherenceTargetPercent()
    {
        return $this->container['adherenceTargetPercent'];
    }

    /**
     * Sets adherenceTargetPercent
     * @param int $adherenceTargetPercent Target adherence percentage
     * @return $this
     */
    public function setAdherenceTargetPercent($adherenceTargetPercent)
    {
        $this->container['adherenceTargetPercent'] = $adherenceTargetPercent;

        return $this;
    }

    /**
     * Gets adherenceExceptionThresholdSeconds
     * @return int
     */
    public function getAdherenceExceptionThresholdSeconds()
    {
        return $this->container['adherenceExceptionThresholdSeconds'];
    }

    /**
     * Sets adherenceExceptionThresholdSeconds
     * @param int $adherenceExceptionThresholdSeconds The threshold in seconds for which agents should not be penalized for being momentarily out of adherence
     * @return $this
     */
    public function setAdherenceExceptionThresholdSeconds($adherenceExceptionThresholdSeconds)
    {
        $this->container['adherenceExceptionThresholdSeconds'] = $adherenceExceptionThresholdSeconds;

        return $this;
    }

    /**
     * Gets nonOnQueueActivitiesEquivalent
     * @return bool
     */
    public function getNonOnQueueActivitiesEquivalent()
    {
        return $this->container['nonOnQueueActivitiesEquivalent'];
    }

    /**
     * Sets nonOnQueueActivitiesEquivalent
     * @param bool $nonOnQueueActivitiesEquivalent Whether to treat all non-on-queue activities as equivalent for adherence purposes
     * @return $this
     */
    public function setNonOnQueueActivitiesEquivalent($nonOnQueueActivitiesEquivalent)
    {
        $this->container['nonOnQueueActivitiesEquivalent'] = $nonOnQueueActivitiesEquivalent;

        return $this;
    }

    /**
     * Gets trackOnQueueActivity
     * @return bool
     */
    public function getTrackOnQueueActivity()
    {
        return $this->container['trackOnQueueActivity'];
    }

    /**
     * Sets trackOnQueueActivity
     * @param bool $trackOnQueueActivity Whether to track on-queue activities
     * @return $this
     */
    public function setTrackOnQueueActivity($trackOnQueueActivity)
    {
        $this->container['trackOnQueueActivity'] = $trackOnQueueActivity;

        return $this;
    }

    /**
     * Gets ignoredActivityCategories
     * @return \PureCloudSDK\IgnoredActivityCategories
     */
    public function getIgnoredActivityCategories()
    {
        return $this->container['ignoredActivityCategories'];
    }

    /**
     * Sets ignoredActivityCategories
     * @param \PureCloudSDK\IgnoredActivityCategories $ignoredActivityCategories Activity categories that should be ignored for adherence purposes
     * @return $this
     */
    public function setIgnoredActivityCategories($ignoredActivityCategories)
    {
        $this->container['ignoredActivityCategories'] = $ignoredActivityCategories;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


