<?php
/**
 * AnalyticsMediaEndpointStat
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * AnalyticsMediaEndpointStat Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AnalyticsMediaEndpointStat implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AnalyticsMediaEndpointStat';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'codecs' => 'string[]',
        'minMos' => 'double',
        'minRFactor' => 'double',
        'maxLatencyMs' => 'int',
        'receivedPackets' => 'int',
        'invalidPackets' => 'int',
        'discardedPackets' => 'int',
        'duplicatePackets' => 'int',
        'overrunPackets' => 'int',
        'underrunPackets' => 'int'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'codecs' => 'codecs',
        'minMos' => 'minMos',
        'minRFactor' => 'minRFactor',
        'maxLatencyMs' => 'maxLatencyMs',
        'receivedPackets' => 'receivedPackets',
        'invalidPackets' => 'invalidPackets',
        'discardedPackets' => 'discardedPackets',
        'duplicatePackets' => 'duplicatePackets',
        'overrunPackets' => 'overrunPackets',
        'underrunPackets' => 'underrunPackets'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'codecs' => 'setCodecs',
        'minMos' => 'setMinMos',
        'minRFactor' => 'setMinRFactor',
        'maxLatencyMs' => 'setMaxLatencyMs',
        'receivedPackets' => 'setReceivedPackets',
        'invalidPackets' => 'setInvalidPackets',
        'discardedPackets' => 'setDiscardedPackets',
        'duplicatePackets' => 'setDuplicatePackets',
        'overrunPackets' => 'setOverrunPackets',
        'underrunPackets' => 'setUnderrunPackets'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'codecs' => 'getCodecs',
        'minMos' => 'getMinMos',
        'minRFactor' => 'getMinRFactor',
        'maxLatencyMs' => 'getMaxLatencyMs',
        'receivedPackets' => 'getReceivedPackets',
        'invalidPackets' => 'getInvalidPackets',
        'discardedPackets' => 'getDiscardedPackets',
        'duplicatePackets' => 'getDuplicatePackets',
        'overrunPackets' => 'getOverrunPackets',
        'underrunPackets' => 'getUnderrunPackets'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['codecs'] = isset($data['codecs']) ? $data['codecs'] : null;
        $this->container['minMos'] = isset($data['minMos']) ? $data['minMos'] : null;
        $this->container['minRFactor'] = isset($data['minRFactor']) ? $data['minRFactor'] : null;
        $this->container['maxLatencyMs'] = isset($data['maxLatencyMs']) ? $data['maxLatencyMs'] : null;
        $this->container['receivedPackets'] = isset($data['receivedPackets']) ? $data['receivedPackets'] : null;
        $this->container['invalidPackets'] = isset($data['invalidPackets']) ? $data['invalidPackets'] : null;
        $this->container['discardedPackets'] = isset($data['discardedPackets']) ? $data['discardedPackets'] : null;
        $this->container['duplicatePackets'] = isset($data['duplicatePackets']) ? $data['duplicatePackets'] : null;
        $this->container['overrunPackets'] = isset($data['overrunPackets']) ? $data['overrunPackets'] : null;
        $this->container['underrunPackets'] = isset($data['underrunPackets']) ? $data['underrunPackets'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets codecs
     * @return string[]
     */
    public function getCodecs()
    {
        return $this->container['codecs'];
    }

    /**
     * Sets codecs
     * @param string[] $codecs The MIME types of the audio encodings used by the audio streams belonging to this endpoint
     * @return $this
     */
    public function setCodecs($codecs)
    {
        $this->container['codecs'] = $codecs;

        return $this;
    }

    /**
     * Gets minMos
     * @return double
     */
    public function getMinMos()
    {
        return $this->container['minMos'];
    }

    /**
     * Sets minMos
     * @param double $minMos The lowest estimated average MOS among all the audio streams belonging to this endpoint
     * @return $this
     */
    public function setMinMos($minMos)
    {
        $this->container['minMos'] = $minMos;

        return $this;
    }

    /**
     * Gets minRFactor
     * @return double
     */
    public function getMinRFactor()
    {
        return $this->container['minRFactor'];
    }

    /**
     * Sets minRFactor
     * @param double $minRFactor The lowest R-factor value among all of the audio streams belonging to this endpoint
     * @return $this
     */
    public function setMinRFactor($minRFactor)
    {
        $this->container['minRFactor'] = $minRFactor;

        return $this;
    }

    /**
     * Gets maxLatencyMs
     * @return int
     */
    public function getMaxLatencyMs()
    {
        return $this->container['maxLatencyMs'];
    }

    /**
     * Sets maxLatencyMs
     * @param int $maxLatencyMs The maximum latency experienced by any audio stream belonging to this endpoint, in milliseconds
     * @return $this
     */
    public function setMaxLatencyMs($maxLatencyMs)
    {
        $this->container['maxLatencyMs'] = $maxLatencyMs;

        return $this;
    }

    /**
     * Gets receivedPackets
     * @return int
     */
    public function getReceivedPackets()
    {
        return $this->container['receivedPackets'];
    }

    /**
     * Sets receivedPackets
     * @param int $receivedPackets The total number of packets received for all audio streams belonging to this endpoint (includes invalid, duplicate, and discarded packets)
     * @return $this
     */
    public function setReceivedPackets($receivedPackets)
    {
        $this->container['receivedPackets'] = $receivedPackets;

        return $this;
    }

    /**
     * Gets invalidPackets
     * @return int
     */
    public function getInvalidPackets()
    {
        return $this->container['invalidPackets'];
    }

    /**
     * Sets invalidPackets
     * @param int $invalidPackets The total number of malformed or not RTP packets, unknown payload type, or discarded probation packets for all audio streams belonging to this endpoint
     * @return $this
     */
    public function setInvalidPackets($invalidPackets)
    {
        $this->container['invalidPackets'] = $invalidPackets;

        return $this;
    }

    /**
     * Gets discardedPackets
     * @return int
     */
    public function getDiscardedPackets()
    {
        return $this->container['discardedPackets'];
    }

    /**
     * Sets discardedPackets
     * @param int $discardedPackets The total number of packets received too late or too early, jitter queue overrun or underrun, for all audio streams belonging to this endpoint
     * @return $this
     */
    public function setDiscardedPackets($discardedPackets)
    {
        $this->container['discardedPackets'] = $discardedPackets;

        return $this;
    }

    /**
     * Gets duplicatePackets
     * @return int
     */
    public function getDuplicatePackets()
    {
        return $this->container['duplicatePackets'];
    }

    /**
     * Sets duplicatePackets
     * @param int $duplicatePackets The total number of packets received with the same sequence number as another one recently received (window of 64 packets), for all audio streams belonging to this endpoint
     * @return $this
     */
    public function setDuplicatePackets($duplicatePackets)
    {
        $this->container['duplicatePackets'] = $duplicatePackets;

        return $this;
    }

    /**
     * Gets overrunPackets
     * @return int
     */
    public function getOverrunPackets()
    {
        return $this->container['overrunPackets'];
    }

    /**
     * Sets overrunPackets
     * @param int $overrunPackets The total number of packets for which there was no room in the jitter queue when it was received, for all audio streams belonging to this endpoint (also counted in discarded)
     * @return $this
     */
    public function setOverrunPackets($overrunPackets)
    {
        $this->container['overrunPackets'] = $overrunPackets;

        return $this;
    }

    /**
     * Gets underrunPackets
     * @return int
     */
    public function getUnderrunPackets()
    {
        return $this->container['underrunPackets'];
    }

    /**
     * Sets underrunPackets
     * @param int $underrunPackets The total number of packets received after their timestamp/seqnum has been played out, for all audio streams belonging to this endpoint (also counted in discarded)
     * @return $this
     */
    public function setUnderrunPackets($underrunPackets)
    {
        $this->container['underrunPackets'] = $underrunPackets;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


